/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;

public abstract class AbstractBasicFeature
implements Feature {
    private FeatureSchema schema;
    private int id = FeatureUtil.nextID();

    public void setSchema(FeatureSchema featureSchema) {
        this.schema = featureSchema;
    }

    public AbstractBasicFeature(FeatureSchema featureSchema) {
        this.schema = featureSchema;
    }

    public int getID() {
        return this.id;
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(this.schema.getAttributeIndex(string), object);
    }

    public void setGeometry(Geometry geometry) {
        this.setAttribute(this.schema.getGeometryIndex(), (Object)geometry);
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.schema.getAttributeIndex(string));
    }

    public String getString(int n) {
        Object object = this.getAttribute(n);
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int getInteger(int n) {
        return (Integer)this.getAttribute(n);
    }

    public double getDouble(int n) {
        return (Double)this.getAttribute(n);
    }

    public String getString(String string) {
        return this.getString(this.schema.getAttributeIndex(string));
    }

    public Geometry getGeometry() {
        return (Geometry)this.getAttribute(this.schema.getGeometryIndex());
    }

    public FeatureSchema getSchema() {
        return this.schema;
    }

    public Object clone() {
        return this.clone(true);
    }

    public Feature clone(boolean bl) {
        return AbstractBasicFeature.clone(this, bl);
    }

    public static BasicFeature clone(Feature feature, boolean bl) {
        BasicFeature basicFeature = new BasicFeature(feature.getSchema());
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            if (feature.getSchema().getAttributeType(i) == AttributeType.GEOMETRY) {
                basicFeature.setAttribute(i, bl ? feature.getGeometry().clone() : feature.getGeometry());
                continue;
            }
            basicFeature.setAttribute(i, feature.getAttribute(i));
        }
        return basicFeature;
    }

    public int compareTo(Object object) {
        return AbstractBasicFeature.compare(this, (Feature)object);
    }

    public static int compare(Feature feature, Feature feature2) {
        int n = feature.getGeometry().compareTo(feature2.getGeometry());
        if (n != 0) {
            return n;
        }
        if (feature == feature2) {
            return 0;
        }
        if (feature.getID() != feature2.getID()) {
            return feature.getID() - feature2.getID();
        }
        if (feature.hashCode() != feature2.hashCode()) {
            return feature.hashCode() - feature2.hashCode();
        }
        Assert.shouldNeverReachHere();
        return -1;
    }
}

