/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class QuadtreeNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private Quadtree quadtree;
    private Coordinate nestedPt;

    public QuadtreeNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
        this.totalEnv.expandToInclude(linearRing.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildQuadtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            List list = this.quadtree.query(linearRing.getEnvelopeInternal());
            for (int j = 0; j < list.size(); ++j) {
                LinearRing linearRing2 = (LinearRing)list.get(j);
                Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
                if (linearRing == linearRing2 || !linearRing.getEnvelopeInternal().intersects(linearRing2.getEnvelopeInternal())) continue;
                Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, this.graph);
                Assert.isTrue(coordinate != null, "Unable to find a ring point not a node of the search ring");
                boolean bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2);
                if (!bl) continue;
                this.nestedPt = coordinate;
                return false;
            }
        }
        return true;
    }

    private void buildQuadtree() {
        this.quadtree = new Quadtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Envelope envelope = linearRing.getEnvelopeInternal();
            this.quadtree.insert(envelope, linearRing);
        }
    }
}

