/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.MonotoneChain;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainEdge;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SweepLineEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleMCSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List list, SegmentIntersector segmentIntersector, boolean bl) {
        if (bl) {
            this.add(list, null);
        } else {
            this.add(list);
        }
        this.computeIntersections(segmentIntersector);
    }

    public void computeIntersections(List list, List list2, SegmentIntersector segmentIntersector) {
        this.add(list, (Object)list);
        this.add(list2, (Object)list2);
        this.computeIntersections(segmentIntersector);
    }

    private void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, (Object)edge);
        }
    }

    private void add(List list, Object object) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, object);
        }
    }

    private void add(Edge edge, Object object) {
        MonotoneChainEdge monotoneChainEdge = edge.getMonotoneChainEdge();
        int[] nArray = monotoneChainEdge.getStartIndexes();
        for (int i = 0; i < nArray.length - 1; ++i) {
            MonotoneChain monotoneChain = new MonotoneChain(monotoneChainEdge, i);
            SweepLineEvent sweepLineEvent = new SweepLineEvent(object, monotoneChainEdge.getMinX(i), null, monotoneChain);
            this.events.add(sweepLineEvent);
            this.events.add(new SweepLineEvent(object, monotoneChainEdge.getMaxX(i), sweepLineEvent, monotoneChain));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isDelete()) continue;
            sweepLineEvent.getInsertEvent().setDeleteEventIndex(i);
        }
    }

    private void computeIntersections(SegmentIntersector segmentIntersector) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isInsert()) continue;
            this.processOverlaps(i, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent, segmentIntersector);
        }
    }

    private void processOverlaps(int n, int n2, SweepLineEvent sweepLineEvent, SegmentIntersector segmentIntersector) {
        MonotoneChain monotoneChain = (MonotoneChain)sweepLineEvent.getObject();
        for (int i = n; i < n2; ++i) {
            SweepLineEvent sweepLineEvent2 = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent2.isInsert()) continue;
            MonotoneChain monotoneChain2 = (MonotoneChain)sweepLineEvent2.getObject();
            if (sweepLineEvent.edgeSet != null && sweepLineEvent.edgeSet == sweepLineEvent2.edgeSet) continue;
            monotoneChain.computeIntersections(monotoneChain2, segmentIntersector);
            ++this.nOverlaps;
        }
    }
}

