/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EdgeList {
    private List edges = new ArrayList();
    private SpatialIndex index = new Quadtree();

    public void add(Edge edge) {
        this.edges.add(edge);
        this.index.insert(edge.getEnvelope(), edge);
    }

    public void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((Edge)iterator.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge edge) {
        List list = this.index.query(edge.getEnvelope());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge2 = (Edge)iterator.next();
            if (!edge2.equals(edge)) continue;
            return edge2;
        }
        return null;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int n) {
        return (Edge)this.edges.get(n);
    }

    public int findEdgeIndex(Edge edge) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!((Edge)this.edges.get(i)).equals(edge)) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream printStream) {
        printStream.print("MULTILINESTRING ( ");
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = (Edge)this.edges.get(i);
            if (i > 0) {
                printStream.print(",");
            }
            printStream.print("(");
            Coordinate[] coordinateArray = edge.getCoordinates();
            for (int j = 0; j < coordinateArray.length; ++j) {
                if (j > 0) {
                    printStream.print(",");
                }
                printStream.print(coordinateArray[j].x + " " + coordinateArray[j].y);
            }
            printStream.println(")");
        }
        printStream.print(")  ");
    }
}

