/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Depth;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainEdge;
import java.io.PrintStream;

public class Edge
extends GraphComponent {
    Coordinate[] pts;
    private Envelope env;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private String name;
    private MonotoneChainEdge mce;
    private boolean isIsolated = true;
    private Depth depth = new Depth();
    private int depthDelta = 0;

    public static void updateIM(Label label, IntersectionMatrix intersectionMatrix) {
        intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
        if (label.isArea()) {
            intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
            intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
        }
    }

    public Edge(Coordinate[] coordinateArray, Label label) {
        this.pts = coordinateArray;
        this.label = label;
    }

    public Edge(Coordinate[] coordinateArray) {
        this(coordinateArray, null);
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    public Coordinate getCoordinate() {
        if (this.pts.length > 0) {
            return this.pts[0];
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            for (int i = 0; i < this.pts.length; ++i) {
                this.env.expandToInclude(this.pts[i]);
            }
        }
        return this.env;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int n) {
        this.depthDelta = n;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return this.pts[0].equals(this.pts[2]);
    }

    public Edge getCollapsedEdge() {
        Coordinate[] coordinateArray = new Coordinate[]{this.pts[0], this.pts[1]};
        Edge edge = new Edge(coordinateArray, Label.toLineLabel(this.label));
        return edge;
    }

    public void setIsolated(boolean bl) {
        this.isIsolated = bl;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void addIntersections(LineIntersector lineIntersector, int n, int n2) {
        for (int i = 0; i < lineIntersector.getIntersectionNum(); ++i) {
            this.addIntersection(lineIntersector, n, n2, i);
        }
    }

    public void addIntersection(LineIntersector lineIntersector, int n, int n2, int n3) {
        Comparable comparable;
        Coordinate coordinate = new Coordinate(lineIntersector.getIntersection(n3));
        int n4 = n;
        double d = lineIntersector.getEdgeDistance(n2, n3);
        int n5 = n4 + 1;
        if (n5 < this.pts.length && coordinate.equals2D((Coordinate)(comparable = this.pts[n5]))) {
            n4 = n5;
            d = 0.0;
        }
        comparable = this.eiList.add(coordinate, n4, d);
    }

    public void computeIM(IntersectionMatrix intersectionMatrix) {
        Edge.updateIM(this.label, intersectionMatrix);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)object;
        if (this.pts.length != edge.pts.length) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n = this.pts.length;
        for (int i = 0; i < this.pts.length; ++i) {
            if (!this.pts[i].equals2D(edge.pts[i])) {
                bl = false;
            }
            if (!this.pts[i].equals2D(edge.pts[--n])) {
                bl2 = false;
            }
            if (bl || bl2) continue;
            return false;
        }
        return true;
    }

    public boolean isPointwiseEqual(Edge edge) {
        if (this.pts.length != edge.pts.length) {
            return false;
        }
        for (int i = 0; i < this.pts.length; ++i) {
            if (this.pts[i].equals2D(edge.pts[i])) continue;
            return false;
        }
        return true;
    }

    public void print(PrintStream printStream) {
        printStream.print("edge " + this.name + ": ");
        printStream.print("LINESTRING (");
        for (int i = 0; i < this.pts.length; ++i) {
            if (i > 0) {
                printStream.print(",");
            }
            printStream.print(this.pts[i].x + " " + this.pts[i].y);
        }
        printStream.print(")  " + this.label + " " + this.depthDelta);
    }

    public void printReverse(PrintStream printStream) {
        printStream.print("edge " + this.name + ": ");
        for (int i = this.pts.length - 1; i >= 0; --i) {
            printStream.print(this.pts[i] + " ");
        }
        printStream.println("");
    }
}

