/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.RingVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import genj.gedcom.Gedcom;
import genj.geo.GeoList;
import genj.geo.GeoLocation;
import genj.geo.GeoMap;
import genj.geo.GeoModel;
import genj.geo.GeoModelListener;
import genj.geo.GeoService;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class GeoView
extends JPanel
implements WindowBroadcastListener,
ToolBarSupport {
    static final Logger LOG = Logger.getLogger("genj.geo");
    private static final ImageIcon IMG_MAP = new ImageIcon(GeoView.class, "images/Map.png");
    private static final ImageIcon IMG_ZOOM = new ImageIcon(GeoView.class, "images/Zoom.png");
    private static final ImageIcon IMG_ZOOM_EXTENT = new ImageIcon(GeoView.class, "images/ZoomExtend.png");
    private static final ImageIcon[] STATUS2IMG = new ImageIcon[]{new ImageIcon(GeoView.class, "images/Ok.png"), new ImageIcon(GeoView.class, "images/Warning.png"), new ImageIcon(GeoView.class, "images/Error.png")};
    static final Resources RESOURCES = Resources.get((Object)GeoView.class);
    private Gedcom gedcom;
    private ViewManager viewManager;
    private GeoMap currentMap;
    private JSplitPane split;
    private LayerViewPanel layerPanel;
    private ActionLocate locate;
    private Registry registry;
    private GeoModel model;
    private GeoList locationList;
    private LocationsLayer locationLayer;
    private SelectionLayer selectionLayer;
    private CursorTool currentTool;

    public GeoView(String title, Gedcom gedcom, Registry registry) {
        this.registry = registry;
        this.gedcom = gedcom;
        this.model = new GeoModel();
        this.locationList = new GeoList(this.model, this, this.viewManager);
        this.locationLayer = new LocationsLayer();
        this.selectionLayer = new SelectionLayer();
        this.split = new JSplitPane(1, null, new JScrollPane(this.locationList));
        this.split.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add("Center", this.split);
    }

    public void addNotify() {
        super.addNotify();
        this.model.setGedcom(this.gedcom);
        String map = this.registry.get("map", (String)null);
        GeoMap[] maps = GeoService.getInstance().getMaps();
        for (int i = 0; i < maps.length; ++i) {
            if (map != null && !maps[i].getKey().equals(map)) continue;
            try {
                this.setMap(maps[i]);
            }
            catch (Throwable t) {}
            break;
        }
    }

    public void removeNotify() {
        this.model.setGedcom(null);
        if (this.currentMap != null) {
            this.registry.put("map", this.currentMap.getKey());
        }
        this.registry.put("split", this.split.getDividerLocation());
        super.removeNotify();
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        ContextSelectionEvent cse = ContextSelectionEvent.narrow((WindowBroadcastEvent)event, (Gedcom)this.gedcom);
        if (event.isInbound() && cse != null) {
            this.locationList.setSelectedContext(cse.getContext());
        }
        return true;
    }

    public void populate(JToolBar bar) {
        GeoMap[] maps = GeoService.getInstance().getMaps();
        ArrayList<ChooseMap> actions = new ArrayList<ChooseMap>(maps.length);
        for (int i = 0; i < maps.length; ++i) {
            actions.add(new ChooseMap(maps[i]));
        }
        PopupWidget chooseMap = new PopupWidget(null, (Icon)IMG_MAP, actions);
        chooseMap.setToolTipText(RESOURCES.getString("toolbar.map"));
        chooseMap.setEnabled(!actions.isEmpty());
        bar.add((Component)chooseMap);
        ButtonHelper bh = new ButtonHelper().setInsets(0);
        bh.setContainer((JComponent)bar);
        bh.create((Action)((Object)new ZoomExtent()));
        bh.setButtonType(JToggleButton.class).create((Action)((Object)new ZoomOnOff()));
        this.locate = new ActionLocate();
        bh.setButtonType(JButton.class).create((Action)((Object)this.locate));
    }

    public void setSelection(GeoLocation location) {
        this.setSelection(location != null ? Collections.singletonList(location) : Collections.EMPTY_LIST);
    }

    public void setSelection(Collection locations) {
        this.selectionLayer.setLocations(locations);
    }

    public void setMap(GeoMap map) throws IOException {
        this.currentMap = map;
        LayerManager layerManager = new LayerManager();
        layerManager.addLayer("GenJ", (Layer)this.locationLayer);
        layerManager.addLayer("GenJ", (Layer)this.selectionLayer);
        this.selectionLayer.setLayerManager(layerManager);
        this.locationLayer.setLayerManager(layerManager);
        map.load(layerManager);
        this.layerPanel = new LayerPanel(layerManager);
        this.layerPanel.setBackground(map.getBackground());
        if (this.currentTool != null) {
            this.layerPanel.setCurrentCursorTool(this.currentTool);
        }
        this.split.setLeftComponent((Component)this.layerPanel);
        this.revalidate();
        this.repaint();
        int pos = this.registry.get("split", -1);
        if (pos < 0) {
            this.split.setDividerLocation(0.7);
        } else {
            this.split.setLastDividerLocation(pos);
            this.split.setDividerLocation(pos);
        }
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.layerPanel);
    }

    private class ActionLocate
    extends Action2 {
        private ActionLocate() {
            this.setImage((Icon)STATUS2IMG[0]);
        }

        protected void execute() {
            GeoView.this.model.resolveAll();
        }
    }

    private class LayerPanel
    extends LayerViewPanel
    implements ComponentListener,
    MouseListener {
        public LayerPanel(LayerManager mgr) {
            super(mgr, (LayerViewPanelContext)new ViewContext());
            this.addComponentListener(this);
            this.addMouseListener(this);
        }

        private List getLocations(MouseEvent event) {
            try {
                ArrayList result = new ArrayList(GeoView.this.layerPanel.featuresWithVertex((Point2D)event.getPoint(), 3.0, GeoView.this.model.getLocations()));
                Collections.sort(result);
                return result;
            }
            catch (Throwable t) {
                return Collections.EMPTY_LIST;
            }
        }

        private Coordinate getCoordinate(MouseEvent event) {
            try {
                return this.getViewport().toModelCoordinate((Point2D)event.getPoint());
            }
            catch (Throwable t) {
                return null;
            }
        }

        public String getToolTipText(MouseEvent event) {
            Coordinate coord = this.getCoordinate(event);
            if (coord == null) {
                return null;
            }
            List locations = this.getLocations(event);
            StringBuffer text = new StringBuffer();
            text.append("<html><body>");
            text.append(GeoLocation.getCoordinateAsString(coord));
            Iterator it = locations.iterator();
            while (it.hasNext()) {
                GeoLocation location = (GeoLocation)it.next();
                text.append("<br><b>");
                text.append(location);
                text.append("</b>");
            }
            return text.toString();
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            new ZoomExtent().trigger();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            List locations = this.getLocations(e);
            if (!locations.isEmpty()) {
                GeoView.this.locationList.setSelectedLocations(locations);
                GeoView.this.selectionLayer.setLocations(locations);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class LocationsLayer
    extends Layer
    implements FeatureCollection,
    GeoModelListener,
    ActionListener {
        private List locations = new ArrayList();
        protected Timer updateTimer = new Timer(500, this);

        private LocationsLayer() {
            this.updateTimer.setRepeats(false);
            this.setName(this.getClass().toString());
            this.setFeatureCollection(this);
            GeoView.this.model.addGeoModelListener(this);
            this.initStyles();
        }

        private void reset() {
            Iterator it = GeoView.this.model.getLocations().iterator();
            while (it.hasNext()) {
                GeoLocation location = (GeoLocation)it.next();
                if (!location.isValid()) continue;
                this.locations.add(location);
            }
            this.updateTimer.start();
        }

        protected void initStyles() {
            this.addStyle((Style)new BasicStyle(Color.LIGHT_GRAY));
            SquareVertexStyle vertices = new SquareVertexStyle();
            vertices.setEnabled(true);
            vertices.setSize(5);
            this.addStyle((Style)vertices);
            LabelStyle labels = new LabelStyle();
            labels.setColor(Color.BLACK);
            labels.setEnabled(true);
            labels.setAttribute("PLAC");
            labels.setHidingOverlappingLabels(true);
            this.addStyle((Style)labels);
        }

        public void actionPerformed(ActionEvent e) {
            LayerManager mgr = this.getLayerManager();
            if (mgr != null) {
                mgr.fireFeaturesChanged(new ArrayList(), FeatureEventType.ADDED, (Layer)this);
            }
        }

        public void asyncResolveEnd(int status, String msg) {
            if (GeoView.this.locate != null) {
                GeoView.this.locate.setEnabled(true);
                GeoView.this.locate.setTip(msg + " - " + RESOURCES.getString("resolve.again"));
                GeoView.this.locate.setImage((Icon)STATUS2IMG[status]);
            }
        }

        public void asyncResolveStart() {
            if (GeoView.this.locate != null) {
                GeoView.this.locate.setEnabled(false);
            }
        }

        public void locationAdded(GeoLocation location) {
            if (location.isValid()) {
                this.locations.add(location);
            }
            this.updateTimer.start();
        }

        public void locationUpdated(GeoLocation location) {
            if (location.isValid() && !this.locations.contains(location)) {
                this.locations.add(location);
            }
            this.updateTimer.start();
        }

        public void locationRemoved(GeoLocation location) {
            this.locations.remove(location);
            this.updateTimer.start();
        }

        public FeatureSchema getFeatureSchema() {
            return GeoLocation.SCHEMA;
        }

        public Envelope getEnvelope() {
            return new Envelope();
        }

        public int size() {
            return this.locations.size();
        }

        public List getFeatures() {
            return this.locations;
        }

        public List query(Envelope envelope) {
            List locations = this.getFeatures();
            ArrayList<Feature> result = new ArrayList<Feature>(locations.size());
            Iterator it = locations.iterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                if (!feature.getGeometry().getEnvelopeInternal().intersects(envelope)) continue;
                result.add(feature);
            }
            return result;
        }
    }

    private class SelectionLayer
    extends LocationsLayer {
        private List selection = Collections.EMPTY_LIST;

        private SelectionLayer() {
        }

        protected void initStyles() {
            this.addStyle((Style)new BasicStyle(Color.RED));
            RingVertexStyle vertices = new RingVertexStyle();
            vertices.setEnabled(true);
            vertices.setSize(5);
            this.addStyle((Style)vertices);
            LabelStyle labels = new LabelStyle();
            labels.setEnabled(false);
            this.addStyle((Style)labels);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLocations(Collection set) {
            SelectionLayer selectionLayer = this;
            synchronized (selectionLayer) {
                this.selection = new ArrayList(set);
            }
            LayerManager mgr = this.getLayerManager();
            if (mgr != null) {
                mgr.fireFeaturesChanged(new ArrayList(), FeatureEventType.ADDED, (Layer)this);
            }
        }

        public void locationAdded(GeoLocation location) {
            this.setLocations(Collections.EMPTY_SET);
        }

        public void locationUpdated(GeoLocation location) {
            this.setLocations(Collections.EMPTY_SET);
        }

        public void locationRemoved(GeoLocation location) {
            this.setLocations(Collections.EMPTY_SET);
        }

        public int size() {
            return this.selection.size();
        }

        public List getFeatures() {
            return this.selection;
        }
    }

    private class ChooseMap
    extends Action2 {
        private GeoMap map;

        private ChooseMap(GeoMap map) {
            this.map = map;
            this.setText(map.getName());
        }

        protected void execute() {
            GeoView.this.registry.put("split", GeoView.this.split.getDividerLocation());
            try {
                GeoView.this.setMap(this.map);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public Icon getImage() {
            return GeoView.this.currentMap != this.map ? null : IMG_MAP;
        }
    }

    private class ZoomOnOff
    extends Action2 {
        private ZoomOnOff() {
            this.setImage((Icon)IMG_ZOOM);
            this.setTip(RESOURCES, "toolbar.zoom");
        }

        protected void execute() {
            GeoView.this.currentTool = (CursorTool)(GeoView.this.currentTool instanceof ZoomTool ? new PanTool(null) : new ZoomTool(Cursor.getPredefinedCursor(1)));
            if (GeoView.this.layerPanel != null) {
                GeoView.this.layerPanel.setCurrentCursorTool(GeoView.this.currentTool);
            }
        }
    }

    private class ZoomExtent
    extends Action2 {
        private ZoomExtent() {
            this.setImage((Icon)IMG_ZOOM_EXTENT);
            this.setTip(RESOURCES, "toolbar.extent");
        }

        public void execute() {
            if (GeoView.this.layerPanel != null) {
                try {
                    GeoView.this.layerPanel.getViewport().zoomToFullExtent();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class ViewContext
    implements LayerViewPanelContext {
        private ViewContext() {
        }

        public void warnUser(String warning) {
            LOG.warning("[JUMP]" + warning);
        }

        public void handleThrowable(Throwable t) {
            LOG.log(Level.WARNING, "[JUMP]", t);
        }

        public void setStatusMessage(String message) {
            if (message != null && message.length() > 0) {
                LOG.warning("[JUMP]" + message);
            }
        }
    }
}

