/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import genj.util.Origin;
import genj.util.Resources;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import org.geotools.shapefile.Shapefile;

public class GeoMap {
    private static final String SUFFIX_SHP = ".shp";
    private static final String PROPERTIES = "geo.properties";
    private Origin origin;
    private Resources resources;
    private String name;
    private Color background = Color.WHITE;
    private static final Color[] PALETTE = new Color[]{new Color(16495533), new Color(11717858), new Color(13429701), new Color(14601188), new Color(16701861), new Color(0xFFFFCC), new Color(14997436), new Color(16636652), new Color(0xF2F2F2)};

    GeoMap(File fileOrDir) throws IOException {
        this.origin = Origin.create((URL)fileOrDir.toURL());
        this.loadProperties();
    }

    private void loadProperties() {
        try {
            this.resources = new Resources(this.origin.open(PROPERTIES));
        }
        catch (IOException e) {
            // empty catch block
        }
        this.name = this.translate("name", this.origin.getName());
        try {
            this.background = new Color(Integer.decode(this.translate("color.background", "")));
        }
        catch (Throwable t) {
            this.background = new Color(0xCCFFFF);
        }
    }

    public String getKey() {
        return this.origin.getName();
    }

    private String translate(String key, String fallback) {
        if (this.resources == null) {
            return fallback;
        }
        String result = this.resources.getString(key + "." + Locale.getDefault().getLanguage().toLowerCase(), false);
        if (result == null) {
            result = this.resources.getString(key, false);
        }
        return result != null ? result : fallback;
    }

    public String getName() {
        return this.name;
    }

    public Color getBackground() {
        return this.background;
    }

    void load(LayerManager manager) throws IOException {
        this.loadProperties();
        Object[] shapes = this.origin.list();
        Arrays.sort(shapes);
        for (int i = 0; i < shapes.length; ++i) {
            Object shape = shapes[i];
            if (!((String)shape).endsWith(SUFFIX_SHP)) continue;
            String name = ((String)shape).substring(0, ((String)shape).length() - SUFFIX_SHP.length());
            FeatureCollection fc = this.load(this.origin.open((String)shape));
            Layer layer = manager.addLayer(this.getName(), name, fc);
            if (Character.isDigit(name.charAt(0))) {
                name = name.substring(1);
            }
            String color = this.translate("color." + name, "");
            try {
                Color c = new Color(Integer.decode(color));
                BasicStyle style = layer.getBasicStyle();
                style.setFillColor(c);
                style.setAlpha(255);
                style.setLineColor(Layer.defaultLineColor((Color)c));
                continue;
            }
            catch (NumberFormatException nfe) {
                layer.removeStyle((Style)layer.getBasicStyle());
                layer.addStyle((Style)new BasicStyle(){

                    public void paint(Feature feature, Graphics2D graphics2d, Viewport viewport) throws NoninvertibleTransformException {
                        Color c = PALETTE[feature.getGeometry().getNumPoints() % PALETTE.length];
                        this.setFillColor(c);
                        this.setLineColor(Layer.defaultLineColor((Color)c));
                        super.paint(feature, graphics2d, viewport);
                    }
                });
            }
        }
    }

    private FeatureCollection load(InputStream in) throws IOException {
        GeometryCollection gc;
        try {
            gc = new Shapefile(in).read(new GeometryFactory());
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.getMessage());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset result = new FeatureDataset(schema);
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            BasicFeature feature = new BasicFeature(schema);
            Geometry geo = gc.getGeometryN(i);
            feature.setGeometry(geo);
            result.add((Feature)feature);
        }
        return result;
    }
}

