/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyPlace;
import genj.geo.Country;
import genj.io.Filter;
import genj.util.DirectAccessTokenizer;
import genj.util.WordBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GeoLocation
extends Point
implements Feature,
Comparable {
    private static Map locale2displayCountry2code = new HashMap();
    static final FeatureSchema SCHEMA = new FeatureSchema();
    static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private Coordinate coordinate;
    private String city;
    private Country country;
    private List jurisdictions = new ArrayList(3);
    private int hash;
    protected List properties = new ArrayList();
    private int matches = 0;

    GeoLocation(String city, String jurisdiction, Country country) {
        super(GEOMETRY_FACTORY.getCoordinateSequenceFactory().create(new Coordinate[]{new Coordinate()}), GEOMETRY_FACTORY);
        this.coordinate = super.getCoordinate();
        this.city = city;
        if (jurisdiction != null) {
            this.jurisdictions.add(jurisdiction);
        }
        this.country = country;
    }

    public GeoLocation(Property prop) {
        super(GEOMETRY_FACTORY.getCoordinateSequenceFactory().create(new Coordinate[]{new Coordinate()}), GEOMETRY_FACTORY);
        this.coordinate = super.getCoordinate();
        this.properties.add(prop);
        Property plac = prop.getProperty("PLAC");
        Property addr = prop.getProperty("ADDR");
        if (plac instanceof PropertyPlace) {
            this.parsePlace((PropertyPlace)plac);
        } else if (addr != null) {
            this.parseAddress(addr);
        } else {
            throw new IllegalArgumentException("can't locate " + prop.getTag() + " " + prop);
        }
    }

    public String getJurisdictionsAsString() {
        WordBuffer result = new WordBuffer(", ");
        result.append(this.city);
        for (int i = 0; i < this.jurisdictions.size(); ++i) {
            result.append(this.jurisdictions.get(i));
        }
        result.append((Object)this.country);
        return result.toString();
    }

    public String getCoordinateAsString() {
        return GeoLocation.getCoordinateAsString(this.coordinate);
    }

    public static String getCoordinateAsString(Coordinate coord) {
        return GeoLocation.getCoordinateAsString(coord.y, coord.x);
    }

    public static String getCoordinateAsString(double lat, double lon) {
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            return "n/a";
        }
        char we = 'E';
        char ns = 'N';
        if (lat < 0.0) {
            lat = -lat;
            ns = 'S';
        }
        if (lon < 0.0) {
            lon = -lon;
            we = 'W';
        }
        DecimalFormat format = new DecimalFormat("0.0");
        return ns + format.format(lat) + " " + we + format.format(lon);
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public static Set parseEntities(Collection entities) {
        return GeoLocation.parseEntities(entities, null);
    }

    public static Set parseEntities(Collection entities, Filter filter) {
        ArrayList<Property> props = new ArrayList<Property>(100);
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            for (int p = 0; p < entity.getNoOfProperties(); ++p) {
                Property prop = entity.getProperty(p);
                if (prop.getProperty("PLAC") == null && prop.getProperty("ADDR") == null || filter != null && !filter.checkFilter(prop)) continue;
                props.add(prop);
            }
        }
        return GeoLocation.parseProperties(props);
    }

    public static Set parseProperties(Collection properties) {
        HashMap<GeoLocation, GeoLocation> result = new HashMap<GeoLocation, GeoLocation>(properties.size());
        ArrayList todo = new ArrayList();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            GeoLocation location;
            Property prop = (Property)it.next();
            try {
                location = new GeoLocation(prop);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            GeoLocation other = (GeoLocation)result.get(location);
            if (other != null) {
                other.add(location);
                continue;
            }
            result.put(location, location);
        }
        return result.keySet();
    }

    private void parseAddress(Property addr) {
        String state;
        Property pstate;
        Gedcom ged = addr.getGedcom();
        Property pcity = addr.getProperty("CITY");
        if (pcity == null) {
            throw new IllegalArgumentException("can't determine city from address");
        }
        this.parseJurisdictions(pcity.getDisplayValue(), ged, false);
        Locale locale = addr.getGedcom().getLocale();
        Property pcountry = addr.getProperty("CTRY");
        if (pcountry != null) {
            this.country = Country.get(ged.getLocale(), this.trim(pcountry.getDisplayValue()));
        }
        if ((pstate = addr.getProperty("STAE")) != null && (state = pstate.getDisplayValue()).length() > 0) {
            this.jurisdictions.add(state);
        }
    }

    private void parsePlace(PropertyPlace place) {
        this.parseJurisdictions(place.getValueStartingWithCity(), place.getGedcom(), true);
    }

    private void parseJurisdictions(String jurisdictions, Gedcom gedcom, boolean lookForCountry) {
        DirectAccessTokenizer tokens = new DirectAccessTokenizer(jurisdictions, ",");
        int first = 0;
        int last = tokens.count() - 1;
        do {
            this.city = this.trim(tokens.get(first++));
            if (this.city != null) continue;
            throw new IllegalArgumentException("can't determine jurisdiction's city");
        } while (this.city.length() <= 0);
        if (lookForCountry) {
            Locale locale = gedcom.getLocale();
            if (last >= first) {
                this.country = Country.get(gedcom.getLocale(), this.trim(tokens.get(last)));
                if (this.country != null) {
                    --last;
                }
            }
        }
        for (int i = first; i <= last; ++i) {
            String jurisdiction = this.trim(tokens.get(i));
            if (jurisdiction.length() <= 0) continue;
            this.jurisdictions.add(jurisdiction);
        }
    }

    private String trim(String jurisdiction) {
        if (jurisdiction == null) {
            return null;
        }
        int j = jurisdiction.length();
        for (int i = 0; i < j; ++i) {
            char c = jurisdiction.charAt(i);
            if (c != '(' && c != '[' && c != '/' && c != '\\') continue;
            return jurisdiction.substring(0, i).trim();
        }
        return jurisdiction.trim();
    }

    public void add(GeoLocation other) {
        Iterator it = other.properties.iterator();
        while (it.hasNext()) {
            Object prop = it.next();
            if (this.properties.contains(prop)) continue;
            this.properties.add(prop);
        }
        Collections.sort(this.properties, new PropertyComparator(".:DATE"));
    }

    public void removeEntities(Set entities) {
        ListIterator it = this.properties.listIterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!entities.contains(prop.getEntity())) continue;
            it.remove();
        }
    }

    public void removeEntity(Entity entity) {
        ListIterator it = this.properties.listIterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (entity != prop.getEntity()) continue;
            it.remove();
        }
    }

    public int getMatches() {
        return this.matches;
    }

    public boolean isValid() {
        return this.matches > 0 && !Double.isNaN(this.coordinate.x) && !Double.isNaN(this.coordinate.y);
    }

    public Gedcom getGedcom() {
        return ((Property)this.properties.get(0)).getGedcom();
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.city != null) {
                this.hash += this.city.toLowerCase().hashCode();
            }
            for (int i = 0; i < this.jurisdictions.size(); ++i) {
                this.hash += this.jurisdictions.get(i).toString().toLowerCase().hashCode();
            }
            if (this.country != null) {
                this.hash += this.country.getCode().toLowerCase().hashCode();
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        GeoLocation that = (GeoLocation)obj;
        return GeoLocation.equals(this.city, that.city) && ((Object)this.jurisdictions).equals(that.jurisdictions) && GeoLocation.equals(this.country, that.country);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String getCity() {
        return this.city;
    }

    public List getJurisdictions() {
        return this.jurisdictions;
    }

    GeoLocation addJurisdiction(String j) {
        this.jurisdictions.add(j);
        return this;
    }

    public Country getCountry() {
        return this.country;
    }

    public int getNumProperties() {
        return this.properties.size();
    }

    public Property getProperty(int i) {
        return (Property)this.properties.get(i);
    }

    public int getPropertyIndex(Property prop) {
        return this.properties.indexOf(prop);
    }

    protected void setCoordinate(Coordinate coord) {
        this.setCoordinate(coord.y, coord.x);
    }

    protected void setCoordinate(double lat, double lon) {
        this.coordinate.x = lon;
        this.coordinate.y = lat;
        this.matches = 1;
    }

    protected void setMatches(int set) {
        this.matches = set;
    }

    public String toString() {
        return this.getJurisdictionsAsString();
    }

    public void setAttributes(Object[] arg0) {
        throw new IllegalArgumentException();
    }

    public void setSchema(FeatureSchema arg0) {
        throw new IllegalArgumentException();
    }

    public int getID() {
        throw new IllegalArgumentException();
    }

    public void setAttribute(int arg0, Object arg1) {
        throw new IllegalArgumentException();
    }

    public void setAttribute(String arg0, Object arg1) {
        throw new IllegalArgumentException();
    }

    public void setGeometry(Geometry arg0) {
        throw new IllegalArgumentException();
    }

    public Object getAttribute(int arg0) {
        throw new IllegalArgumentException();
    }

    public Object getAttribute(String arg0) {
        return this.city;
    }

    public String getString(int arg0) {
        throw new IllegalArgumentException();
    }

    public int getInteger(int arg0) {
        throw new IllegalArgumentException();
    }

    public double getDouble(int arg0) {
        throw new IllegalArgumentException();
    }

    public String getString(String arg0) {
        throw new IllegalArgumentException();
    }

    public Geometry getGeometry() {
        return this;
    }

    public FeatureSchema getSchema() {
        return SCHEMA;
    }

    public Object clone() {
        throw new IllegalArgumentException();
    }

    public Feature clone(boolean arg0) {
        throw new IllegalArgumentException();
    }

    public Object[] getAttributes() {
        throw new IllegalArgumentException();
    }

    public int compareTo(Object o) {
        GeoLocation that = (GeoLocation)o;
        return this.city.compareToIgnoreCase(that.city);
    }
}

