/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.grelf.Gaussian;
import net.grelf.Util;
import net.grelf.image.Image;

public class Kernel {
    private int halfWidth = 1;
    private float[][] data;

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public float[][] getData() {
        return this.data;
    }

    public Kernel(int n, float[][] fArray) {
        this.halfWidth = n;
        this.data = fArray;
    }

    public static Kernel load(String string, int n) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList<String> arrayList = new ArrayList<String>();
            while (null != (string2 = bufferedReader.readLine())) {
                arrayList.add(string2);
            }
            bufferedReader.close();
            int n2 = Util.nOccurs((String)arrayList.get(0), ',') + 1;
            int n3 = arrayList.size();
            float[][] fArray = new float[n][n3 * n2];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = ((String)arrayList.get(i)).split(",");
                int n5 = 0;
                while (n5 < stringArray.length) {
                    float f = Float.parseFloat(stringArray[n5]);
                    for (int j = 0; j < n; ++j) {
                        fArray[j][n4] = f;
                    }
                    ++n5;
                    ++n4;
                }
            }
            return new Kernel(n2 / 2, fArray);
        }
        catch (IOException iOException) {
            Util.warning("Error: ", iOException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning("Error", "Invalid float values in file\n{0}", string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Util.warning("Error", "Unequal line lengths in file\n{0}", string);
        }
        return null;
    }

    public boolean askHalfWidth() {
        Object object = JOptionPane.showInputDialog(null, "", "Select kernel half-width", -1, null, new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "15", "20"}, "1");
        if (object instanceof String) {
            this.halfWidth = Integer.parseInt((String)object);
            return true;
        }
        return false;
    }

    public Kernel(Point point, Image image, int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        int n7 = image.getNBands();
        if (n < 0) {
            int n8;
            n = -n;
            n6 = 0;
            n5 = Integer.MAX_VALUE;
            Point point2 = new Point(point.x, point.y);
            nArray = new int[n7];
            for (n4 = point2.y - n; n4 <= point2.y + n; ++n4) {
                for (n3 = point2.x - n; n3 <= point2.x + n; ++n3) {
                    nArray = image.getPixel(n3, n4);
                    n2 = 0;
                    for (n8 = 0; n8 < n7; ++n8) {
                        n2 += nArray[n8];
                    }
                    if (n2 > n6) {
                        n6 = n2;
                        point = new Point(n3, n4);
                    }
                    if (n2 >= n5) continue;
                    n5 = n2;
                }
            }
            n4 = n5 + (n6 - n5) / 10;
            n3 = image.getWidth() - 1;
            n2 = image.getHeight() - 1;
            int n9 = point.x;
            int n10 = point.y;
            int n11 = 1;
            do {
                int n12;
                int n13;
                int n14;
                n8 = 1;
                for (n14 = 0; n14 < n11 && n9 < n3; ++n14) {
                    nArray = image.getPixel(++n9, n10);
                    n13 = 0;
                    for (n12 = 0; n12 < n7; ++n12) {
                        n13 += nArray[n12];
                    }
                    if (n13 <= n4) continue;
                    n8 = 0;
                }
                for (n14 = 0; n14 < n11 && n10 < n2; ++n14) {
                    nArray = image.getPixel(n9, ++n10);
                    n13 = 0;
                    for (n12 = 0; n12 < n7; ++n12) {
                        n13 += nArray[n12];
                    }
                    if (n13 <= n4) continue;
                    n8 = 0;
                }
                ++n11;
                for (n14 = 0; n14 < n11 && n9 > 0; ++n14) {
                    nArray = image.getPixel(--n9, n10);
                    n13 = 0;
                    for (n12 = 0; n12 < n7; ++n12) {
                        n13 += nArray[n12];
                    }
                    if (n13 <= n4) continue;
                    n8 = 0;
                }
                for (n14 = 0; n14 < n11 && n10 > 0; ++n14) {
                    nArray = image.getPixel(n9, --n10);
                    n13 = 0;
                    for (n12 = 0; n12 < n7; ++n12) {
                        n13 += nArray[n12];
                    }
                    if (n13 <= n4) continue;
                    n8 = 0;
                }
                ++n11;
            } while (n8 == 0 && n9 > 0 && n9 < n3 && n10 > 0 && n10 < n2);
            n = n11 / 2;
        }
        this.halfWidth = n;
        n6 = 2 * n + 1;
        n5 = n6 * n6;
        this.data = new float[n7][n5];
        int n15 = 0;
        nArray = new int[n7];
        for (n4 = point.y - n; n4 <= point.y + n; ++n4) {
            for (n3 = point.x - n; n3 <= point.x + n; ++n3) {
                nArray = image.getPixel(n3, n4);
                for (n2 = 0; n2 < n7; ++n2) {
                    this.data[n2][n15] = nArray[n2];
                }
                ++n15;
            }
        }
    }

    public static Kernel createGaussianKernel(Image image, int n) {
        int n2 = 2 * n + 1;
        int n3 = n2 * n2;
        int n4 = image.getNBands();
        float[][] fArray = new float[n4][n3];
        int n5 = n / 2 + 1;
        int n6 = n;
        Gaussian gaussian = new Gaussian(n6, n5);
        float f = (float)image.getRangeDouble().high;
        for (int i = 0; i < n2; ++i) {
            float f2 = gaussian.calc(i);
            for (int j = 0; j < n2; ++j) {
                float f3 = f * gaussian.calc(j) * f2;
                for (int k = 0; k < n4; ++k) {
                    fArray[k][j + i * n2] = f3;
                }
            }
        }
        return new Kernel(n, fArray);
    }
}

