/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.ProgressMonitor;
import net.grelf.Gaussian;
import net.grelf.Interpolator;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.image.ByteMask;
import net.grelf.image.Calibration;
import net.grelf.image.FITS;
import net.grelf.image.FITS_KeywordRecord;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Kernel;
import net.grelf.image.Metadata;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;
import net.grelf.image.Timer;

public class Image64
extends ImageBase
implements Image,
Cloneable {
    protected double[][] data;
    private int width;
    private int height;
    private int widthTimesHeight;
    private int[] zeroPxInt;
    private double[] zeroPxDouble;
    private RangeDouble extremesDouble = new RangeDouble(0.0, 255.0);

    @Override
    public int getBitsPerChannel() {
        return 64;
    }

    @Override
    public int getWidth() {
        if (null == this.data) {
            return 0;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (null == this.data) {
            return 0;
        }
        return this.height;
    }

    @Override
    public String getImageTypeAsString() {
        return "64 bits (floating point) per channel";
    }

    @Override
    public int getNBands() {
        if (null == this.data) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public RangeInt getRange() {
        return new RangeInt((int)this.extremesDouble.low, (int)this.extremesDouble.high);
    }

    @Override
    public RangeDouble getRangeDouble() {
        return this.extremesDouble;
    }

    protected void setRangeDouble(RangeDouble rangeDouble) {
        this.extremesDouble = rangeDouble;
    }

    private double[][] createDataArray(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            Util.warning("Error", "Cannot create an image " + n + "x" + n2 + "x" + n3 + "x64");
            return null;
        }
        long l = ((long)n * (long)n2 * 8L + 12L) * (long)n3 + 12L;
        long l2 = Runtime.getRuntime().freeMemory();
        if (l + 50000L < l2) {
            try {
                int n4 = n * n2;
                double[][] dArray = new double[n3][n4];
                if (null != dArray) {
                    this.width = n;
                    this.height = n2;
                    this.widthTimesHeight = n4;
                    this.zeroPxInt = new int[n3];
                    this.zeroPxDouble = new double[n3];
                    for (int i = 0; i < n3; ++i) {
                        this.zeroPxInt[i] = 0;
                        this.zeroPxDouble[i] = 0.0;
                    }
                }
                return dArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot create image data array because it\nwould require ");
        stringBuffer.append(100L * (l + 50000L) / l2);
        stringBuffer.append("% of available memory.\n");
        stringBuffer.append("You might do one of the following:\n");
        stringBuffer.append(" - Geometry/Crop\n");
        stringBuffer.append(" - Geometry/Scale (down)\n");
        stringBuffer.append(" - Levels/Convert to 16 bits per channel\n");
        stringBuffer.append(" - Levels/Convert to monochrome\n");
        stringBuffer.append("and then try again.");
        Util.message("Not enough memory", stringBuffer.toString());
        return null;
    }

    public Image64(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public Image64(int n, int n2, int n3, boolean bl) {
        this.data = this.createDataArray(n, n2, n3);
        if (null != this.data) {
            this.setCalibration(new Calibration());
            this.setFilePath("New image");
            this.setMetadata(new Metadata());
            if (bl) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = 0;
                    for (int j = 0; j < n2; ++j) {
                        int n5 = 0;
                        while (n5 < n) {
                            this.data[i][n4] = 0.0;
                            ++n5;
                            ++n4;
                        }
                    }
                }
                this.extremesDouble = new RangeDouble(0.0, 1.0);
            } else {
                this.extremesDouble = new RangeDouble(0.0, 255.0);
            }
        }
    }

    public Image64(BufferedImage bufferedImage) throws IncompatibleImageException {
        this.data = this.createDataArray(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getSampleModel().getNumBands());
        if (null != this.data) {
            this.set(bufferedImage);
        }
    }

    protected void checkCompatibility(String string, BufferedImage bufferedImage) throws IncompatibleImageException {
        int n = bufferedImage.getSampleModel().getNumBands();
        if (this.getNBands() < n) {
            throw new IncompatibleImageException("Image has wrong number of bands (" + n + ") for " + string + " to Image64 (" + this.getNBands() + " bands)");
        }
    }

    public void add(double d) {
        int n = this.getNBands();
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            int n3 = 0;
            while (n3 < this.width) {
                for (int j = 0; j < n; ++j) {
                    double[] dArray = this.data[j];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] + d;
                }
                ++n3;
                ++n2;
            }
        }
        this.extremesDouble = new RangeDouble(this.extremesDouble.low + d, this.extremesDouble.high + d);
    }

    @Override
    public void addProportion(Image image, double d, double d2) throws IncompatibleImageException {
        double d3;
        double d4;
        Timer timer;
        if (image instanceof Image64) {
            double d5;
            timer = new Timer("Image64.add (f1, f2)", this);
            int n = this.getNBands();
            double[] dArray = new double[n];
            int n2 = StrictMath.min(this.getWidth(), image.getWidth());
            int n3 = StrictMath.min(this.getHeight(), image.getHeight());
            dArray = image.getPixelDouble(0, 0);
            d3 = d4 = (d5 = this.data[0][0] * d + dArray[0] * d2);
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                while (n5 < n2) {
                    dArray = image.getPixelDouble(n5, i);
                    for (int j = 0; j < n; ++j) {
                        this.data[j][n4] = this.data[j][n4] * d + dArray[j] * d2;
                        d5 = this.data[j][n4];
                        if (d5 < d4) {
                            d4 = d5;
                            continue;
                        }
                        if (!(d5 > d3)) continue;
                        d3 = d5;
                    }
                    ++n5;
                    ++n4;
                }
            }
            if (d3 - d4 < 1.0) {
                d3 = d4 + 1.0;
            }
        } else {
            throw new IncompatibleImageException("Cannot add proportions of images with different bit depths");
        }
        this.extremesDouble = new RangeDouble(d4, d3);
        timer.stop();
    }

    @Override
    public void add(Image image) throws IncompatibleImageException {
        double d;
        double d2;
        Timer timer = new Timer("Image64.add ()", this);
        int n = this.getNBands();
        double[] dArray = new double[n];
        int n2 = StrictMath.min(this.getWidth(), image.getWidth());
        int n3 = StrictMath.min(this.getHeight(), image.getHeight());
        dArray = image.getPixelDouble(0, 0);
        double d3 = d2 = (d = this.data[0][0] + dArray[0]);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = 0;
            while (n5 < n2) {
                dArray = image.getPixelDouble(n5, i);
                for (int j = 0; j < n; ++j) {
                    double[] dArray2 = this.data[j];
                    int n6 = n4;
                    dArray2[n6] = dArray2[n6] + dArray[j];
                    d = this.data[j][n4];
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                ++n5;
                ++n4;
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d3);
        timer.stop();
    }

    @Override
    public void add(BufferedImage bufferedImage) throws IncompatibleImageException {
        double d;
        double d2;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image64.add ()", bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = this.getNBands();
        int[] nArray = new int[n];
        int n2 = StrictMath.min(this.getWidth(), bufferedImage.getWidth());
        int n3 = StrictMath.min(this.getHeight(), bufferedImage.getHeight());
        writableRaster.getPixel(0, 0, nArray);
        double d3 = d2 = (d = this.data[0][0] + (double)nArray[0]);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = 0;
            while (n5 < n2) {
                writableRaster.getPixel(n5, i, nArray);
                for (int j = 0; j < n; ++j) {
                    double[] dArray = this.data[j];
                    int n6 = n4;
                    dArray[n6] = dArray[n6] + (double)nArray[j];
                    d = this.data[j][n4];
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                ++n5;
                ++n4;
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d3);
        timer.stop();
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, int n, int n2) throws IncompatibleImageException {
        double d;
        double d2;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image64.add ()", bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = this.width;
        int n7 = this.height;
        int n8 = n2 < 0 ? -n2 : 0;
        int n9 = n < 0 ? -n : 0;
        writableRaster.getPixel(n9, n8, nArray);
        double d3 = d2 = (d = this.data[0][n9 + n + n6 * (n8 + n2)] + (double)nArray[0]);
        for (int i = n8 + n2; n8 < n5 && i < n7; ++n8, ++i) {
            int n10 = n6 * i;
            n9 = n < 0 ? -n : 0;
            for (int j = n9 + n; n9 < n4 && j < n6; ++n9, ++j) {
                writableRaster.getPixel(n9, n8, nArray);
                for (int k = 0; k < n3; ++k) {
                    int n11 = j + n10;
                    double[] dArray = this.data[k];
                    int n12 = n11;
                    dArray[n12] = dArray[n12] + (double)nArray[k];
                    d = this.data[k][n11];
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d3);
        timer.stop();
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, double d, double d2) throws IncompatibleImageException {
        double d3;
        double d4;
        this.checkCompatibility("add", bufferedImage);
        Timer timer = new Timer("Image64.add ()", bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = this.getNBands();
        int[] nArray = new int[n];
        double d5 = bufferedImage.getWidth();
        double d6 = bufferedImage.getHeight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        double d7 = d2 < 0.0 ? -d2 : 0.0;
        int n4 = (int)StrictMath.round(d7 + d2);
        double d8 = d < 0.0 ? -d : 0.0;
        int n5 = (int)StrictMath.round(d8 + d);
        writableRaster.getPixel((int)d8, (int)d7, nArray);
        double d9 = d4 = (d3 = this.data[0][n5 + n2 * n4] + (double)nArray[0]);
        for (int i = n4; d7 < d6 && i < n3; d7 += 1.0, ++i) {
            int n6 = n2 * i;
            d8 = d < 0.0 ? -d : 0.0;
            for (int j = n5 = (int)StrictMath.round(d8 + d); d8 < d5 && j < n2; d8 += 1.0, ++j) {
                nArray = Interpolator.getPixel(writableRaster, d8, d7);
                for (int k = 0; k < n; ++k) {
                    int n7 = j + n6;
                    double[] dArray = this.data[k];
                    int n8 = n7;
                    dArray[n8] = dArray[n8] + (double)nArray[k];
                    d3 = this.data[k][n7];
                    if (d3 < d4) {
                        d4 = d3;
                        continue;
                    }
                    if (!(d3 > d9)) continue;
                    d9 = d3;
                }
            }
        }
        if (d9 - d4 < 1.0) {
            d9 = d4 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d4, d9);
        timer.stop();
    }

    @Override
    public void applyCurve(RangeInt rangeInt, List<Point> list, BufferedImage bufferedImage) throws IncompatibleImageException {
        if (1 < list.size()) {
            Object object;
            int n;
            Timer timer = new Timer("Image64.applyCurve ()", bufferedImage);
            int n2 = this.getNBands();
            if (Image8or16Base.getNBands(bufferedImage) != n2) {
                throw new IncompatibleImageException("Target image does not have same number of channels as source");
            }
            int n3 = Image8or16Base.getMaxLevel(bufferedImage);
            int[] nArray = new int[rangeInt.high + 1];
            double d = (double)(rangeInt.high + 1 - rangeInt.low) / 255.0;
            double d2 = 1.0 / d;
            double d3 = (double)n3 / 255.0;
            for (n = 0; n < rangeInt.low; ++n) {
                nArray[n] = 0;
            }
            Object object2 = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                object = list.get(i);
                double d4 = ((Point)object2).y;
                double d5 = d2 * (double)(((Point)object).y - ((Point)object2).y) / (double)(((Point)object).x - ((Point)object2).x);
                while (n <= rangeInt.low + (int)((double)((Point)object).x * d) && n < nArray.length) {
                    nArray[n] = (int)(d4 * d3);
                    ++n;
                    d4 += d5;
                }
                object2 = object;
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            object = new int[n2];
            int n4 = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                int n5 = 0;
                while (n5 < this.getWidth()) {
                    for (int j = 0; j < n2; ++j) {
                        object[j] = nArray[(int)this.data[j][n4]];
                    }
                    writableRaster.setPixel(n5, i, (int[])object);
                    ++n5;
                    ++n4;
                }
            }
            timer.stop();
        }
    }

    public void applyCurveDouble(List<Point> list) {
        int n = list.size();
        if (1 < n) {
            Timer timer = new Timer("Image64.applyCurve (64 -> 64)", this);
            int n2 = this.getNBands();
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (Point point : list) {
                nArray[n3] = point.x;
                nArray2[n3] = point.y;
                ++n3;
            }
            double[] dArray = new double[n - 1];
            int n4 = 0;
            int n5 = 1;
            while (n4 < n - 1) {
                dArray[n4] = (double)(nArray2[n5] - nArray2[n4]) / (double)(nArray[n5] - nArray[n4]);
                ++n4;
                ++n5;
            }
            double d = this.extremesDouble.high;
            double d2 = 255.0 / d;
            double d3 = d / 255.0;
            double d4 = this.extremesDouble.high;
            double d5 = this.data[0][0] * d2;
            int n6 = 1;
            int n7 = 0;
            while (n6 < n) {
                if ((double)nArray[n6] > d5) {
                    d4 = d3 * ((double)nArray2[n7] + (d5 - (double)nArray[n7]) * dArray[n7]);
                    break;
                }
                ++n6;
                ++n7;
            }
            double d6 = d4;
            double d7 = d4;
            int n8 = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                int n9 = 0;
                while (n9 < this.getWidth()) {
                    for (int j = 0; j < n2; ++j) {
                        d5 = this.data[j][n8] * d2;
                        d4 = this.extremesDouble.high;
                        int n10 = 1;
                        int n11 = 0;
                        while (n10 < n) {
                            if ((double)nArray[n10] > d5) {
                                d4 = d3 * ((double)nArray2[n11] + (d5 - (double)nArray[n11]) * dArray[n11]);
                                break;
                            }
                            ++n10;
                            ++n11;
                        }
                        this.data[j][n8] = d4;
                        if (d4 < d6) {
                            d6 = d4;
                            continue;
                        }
                        if (!(d4 > d7)) continue;
                        d7 = d4;
                    }
                    ++n9;
                    ++n8;
                }
            }
            this.extremesDouble = new RangeDouble(d6, d7);
            timer.stop();
        }
    }

    @Override
    public void autoCrop() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Timer timer = new Timer("Image64.autoCrop", this);
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        int n8 = this.getNBands();
        Point point = new Point(0, 0);
        Point point2 = new Point(n6 - 1, n7 - 1);
        boolean bl = false;
        for (n5 = 0; n5 < n7 && !bl; ++n5) {
            n4 = this.width * n5;
            block1: for (n3 = 0; n3 < n6 && !bl; ++n3) {
                n2 = n3 + n4;
                for (n = 0; n < n8; ++n) {
                    if (0.0 == this.data[n][n2]) continue;
                    bl = true;
                    point.y = n5;
                    continue block1;
                }
            }
        }
        bl = false;
        for (n5 = n7 - 1; n5 >= 0 && !bl; --n5) {
            n4 = this.width * n5;
            block4: for (n3 = 0; n3 < n6 && !bl; ++n3) {
                n2 = n3 + n4;
                for (n = 0; n < n8; ++n) {
                    if (0.0 == this.data[n][n2]) continue;
                    bl = true;
                    point2.y = n5;
                    continue block4;
                }
            }
        }
        bl = false;
        for (n5 = 0; n5 < n6 && !bl; ++n5) {
            block7: for (n3 = 0; n3 < n7 && !bl; ++n3) {
                n2 = n5 + this.width * n3;
                for (n = 0; n < n8; ++n) {
                    if (0.0 == this.data[n][n2]) continue;
                    bl = true;
                    point.x = n5;
                    continue block7;
                }
            }
        }
        bl = false;
        for (n5 = n6 - 1; n5 >= 0 && !bl; --n5) {
            block10: for (n3 = 0; n3 < n7 && !bl; ++n3) {
                n2 = n5 + this.width * n3;
                for (n = 0; n < n8; ++n) {
                    if (0.0 == this.data[n][n2]) continue;
                    bl = true;
                    point2.x = n5;
                    continue block10;
                }
            }
        }
        this.crop(point, point2);
        timer.stop();
    }

    @Override
    public void autoStretch(boolean bl) {
        this.autoStretch(bl, new Point(0, 0), new Point(this.getWidth() - 1, this.getHeight() - 1));
    }

    @Override
    public void autoStretch(boolean bl, Point point, Point point2) {
        Timer timer = new Timer("Image64.autoStretch", this);
        int n = this.getNBands();
        double[] dArray = new double[n];
        double d = this.getRangeDouble().high;
        if (bl) {
            double d2 = this.getRangeDouble().low;
            double d3 = this.getRangeDouble().high;
            double d4 = d / (d3 - d2);
            for (int i = point.y; i <= point2.y; ++i) {
                for (int j = point.x; j <= point2.x; ++j) {
                    dArray = this.getPixelDouble(j, i);
                    for (int k = 0; k < n; ++k) {
                        dArray[k] = (int)((dArray[k] - d2) * d4);
                    }
                    this.setPixelDouble(j, i, dArray);
                }
            }
        } else {
            int n2;
            int n3;
            int n4;
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            for (n4 = 0; n4 < n; ++n4) {
                dArray2[n4] = d;
                dArray3[n4] = 0.0;
            }
            for (n4 = point.y; n4 <= point2.y; ++n4) {
                for (n3 = point.x; n3 <= point2.x; ++n3) {
                    dArray = this.getPixelDouble(n3, n4);
                    for (n2 = 0; n2 < n; ++n2) {
                        if (dArray[n2] > dArray3[n2]) {
                            dArray3[n2] = dArray[n2];
                            continue;
                        }
                        if (!(dArray[n2] < dArray2[n2])) continue;
                        dArray2[n2] = dArray[n2];
                    }
                }
            }
            double[] dArray4 = new double[n];
            for (n3 = 0; n3 < n; ++n3) {
                dArray4[n3] = d / (dArray3[n3] - dArray2[n3]);
            }
            for (n3 = point.y; n3 <= point2.y; ++n3) {
                for (n2 = point.x; n2 <= point2.x; ++n2) {
                    dArray = this.getPixelDouble(n2, n3);
                    for (int i = 0; i < n; ++i) {
                        dArray[i] = (int)((dArray[i] - dArray2[i]) * dArray4[i]);
                    }
                    this.setPixelDouble(n2, n3, dArray);
                }
            }
        }
        this.extremesDouble.low = 0.0;
        timer.stop();
    }

    @Override
    public ByteMask autoThreshold() {
        Timer timer = new Timer("Image64.autoThreshold", this);
        int n = this.getNBands();
        int n2 = this.getRange().high;
        int n3 = n2 / 2;
        ByteMask byteMask = null;
        try {
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics(0, n2);
            Threshold threshold = new Threshold(n);
            for (int i = 0; i < n; ++i) {
                if (statisticsArray[i].mean < (double)n3) {
                    threshold.th[i].low = n3;
                    threshold.th[i].high = n2;
                    continue;
                }
                threshold.th[i].low = 0;
                threshold.th[i].high = n3;
            }
            Util.logInfo("Auto-threshold levels: {0}", threshold.toString());
            byteMask = this.threshold(threshold);
        }
        catch (ArithmeticException arithmeticException) {
            Util.warning("Sorry", "You cannot do automatic thresholding on this kind of image");
        }
        timer.stop();
        return byteMask;
    }

    @Override
    public void averageVertically() {
        this.averageVertically(0, this.height - 1);
    }

    @Override
    public void averageVertically(int n, int n2) {
        Timer timer = new Timer("Image64.averageVertically", this);
        int n3 = this.width;
        int n4 = n2 - n + 1;
        int n5 = this.getNBands();
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        for (int i = 0; i < n3; ++i) {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                dArray2[n6] = 0.0;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                dArray = this.getPixelDouble(i, n6);
                for (int j = 0; j < n5; ++j) {
                    int n7 = j;
                    dArray2[n7] = dArray2[n7] + dArray[j];
                }
            }
            n6 = 0;
            while (n6 < n5) {
                int n8 = n6++;
                dArray2[n8] = dArray2[n8] / (double)n4;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                this.setPixelDouble(i, n6, dArray2);
            }
        }
        timer.stop();
    }

    @Override
    public void blurGaussian(int n, int n2, ProgressMonitor progressMonitor) {
        double d = this.getRangeDouble().high;
        double[] dArray = Gaussian.getProfileAsArray(n, d);
        double[] dArray2 = Gaussian.getProfileAsArray(n2, d);
        this.convolve(dArray, dArray2, progressMonitor);
    }

    @Override
    public Image clone() {
        int n;
        int n2;
        int n3 = this.getWidth();
        Image64 image64 = new Image64(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != image64 && null != image64.data) {
            for (int i = 0; i < n; ++i) {
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n5 = 0;
                    while (n5 < n3) {
                        image64.data[i][n4] = this.data[i][n4];
                        ++n5;
                        ++n4;
                    }
                }
            }
            image64.extremesDouble = new RangeDouble(this.extremesDouble.low, this.extremesDouble.high);
            return image64;
        }
        return null;
    }

    @Override
    public Image8 convertToImage8() {
        return this.convertToImage16().convertToImage8();
    }

    @Override
    public Image16 convertToImage16() {
        return this.convertToImage32().convertToImage16();
    }

    @Override
    public Image32 convertToImage32() {
        int n;
        int n2;
        int n3 = this.getWidth();
        Image32 image32 = new Image32(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != image32) {
            int n4;
            int n5;
            double d = StrictMath.pow(2.0, 30.0);
            double d2 = StrictMath.min(this.extremesDouble.high, d);
            double d3 = this.extremesDouble.low;
            double d4 = d2 / (this.extremesDouble.high - this.extremesDouble.low);
            int[] nArray = new int[n];
            int n6 = n5 = (n4 = (int)((this.data[0][0] - d3) * d4 + 0.5));
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                int n8 = 0;
                while (n8 < n3) {
                    for (int j = 0; j < n; ++j) {
                        nArray[j] = n4 = (int)((this.data[j][n7] - d3) * d4 + 0.5);
                        if (n4 < n5) {
                            n5 = n4;
                            continue;
                        }
                        if (n4 <= n6) continue;
                        n6 = n4;
                    }
                    image32.setPixel(n8, i, nArray);
                    ++n8;
                    ++n7;
                }
            }
            if (n6 - n5 < 1) {
                n6 = n5 + 1;
            }
            image32.setRange(new RangeInt(n5, n6));
            image32.setCalibration(this.getCalibration());
            image32.setFilePath(this.getFilePath());
            image32.setMetadata(this.getMetadata());
        }
        return image32;
    }

    @Override
    public Image64 convertToImage64() {
        return this;
    }

    @Override
    public void convertToMonochrome() {
        this.convertToMonochrome(0.325, 0.5, 0.175);
    }

    @Override
    public void convertToMonochrome(double ... dArray) {
        int n = this.getNBands();
        if (n > dArray.length) {
            Util.warning("Error", "Number of factors does not equal number of image bands.");
        } else {
            int n2;
            int n3 = this.getWidth();
            double[][] dArray2 = this.createDataArray(n3, n2 = this.getHeight(), 1);
            if (null != dArray2) {
                double d;
                double d2;
                Timer timer = new Timer("Image64.convertToMonochrome", this);
                double d3 = 0.0;
                double d4 = 0.0;
                for (int i = 0; i < n; ++i) {
                    d3 += dArray[i];
                    d4 += dArray[i] * this.data[i][0];
                }
                double d5 = 1.0 / d3;
                double d6 = d2 = (d = d4 * d5);
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n5 = 0;
                    while (n5 < n3) {
                        d4 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            d4 += dArray[j] * this.data[j][n4];
                        }
                        dArray2[0][n4] = d = d4 * d5;
                        if (d < d2) {
                            d2 = d;
                        } else if (d > d6) {
                            d6 = d;
                        }
                        ++n5;
                        ++n4;
                    }
                }
                this.data = dArray2;
                if (d6 - d2 < 1.0) {
                    d6 = d2 + 1.0;
                }
                this.extremesDouble = new RangeDouble(d2, d6);
                timer.stop();
            }
        }
    }

    @Override
    public void convolve(Kernel kernel, ProgressMonitor progressMonitor) {
        int n;
        int n2;
        int n3 = this.getWidth();
        double[][] dArray = this.createDataArray(n3, n2 = this.getHeight(), n = this.getNBands());
        if (null != dArray) {
            double d;
            Timer timer = new Timer("Image64.convolve", this);
            int n4 = 2 * kernel.getHalfWidth() + 1;
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = 0.0;
            }
            float[][] fArray = kernel.getData();
            float[][] fArray2 = new float[n][fArray[0].length];
            if (fArray2.length == 1) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < fArray2[0].length; ++j) {
                        fArray2[i][j] = fArray[0][j];
                    }
                }
            } else {
                fArray2 = fArray;
            }
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n * n2);
            }
            double d2 = d = this.data[0][0];
            double d3 = d;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < fArray2[i].length; ++j) {
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] + (double)fArray2[i][j];
                }
                dArray3[i] = dArray2[i] != 0.0 ? 1.0 / dArray2[i] : 1.0;
                int n6 = 0;
                int n7 = kernel.getHalfWidth();
                while (n6 < n2 - n4) {
                    if (null != progressMonitor) {
                        progressMonitor.setProgress(i * n2 + n6);
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            return;
                        }
                    }
                    int n8 = 0;
                    int n9 = kernel.getHalfWidth();
                    int n10 = n7 * n3 + n9;
                    while (n8 < n3 - n4) {
                        double d4 = 0.0;
                        int n11 = 0;
                        for (int j = n6; j < n6 + n4; ++j) {
                            int n12 = n8;
                            int n13 = j * n3 + n8;
                            while (n12 < n8 + n4) {
                                d4 += this.data[i][n13] * (double)fArray2[i][n11];
                                ++n12;
                                ++n11;
                                ++n13;
                            }
                        }
                        dArray[i][n10] = d = d4 * dArray3[i];
                        if (d < d2) {
                            d2 = d;
                        } else if (d > d3) {
                            d3 = d;
                        }
                        ++n8;
                        ++n9;
                        ++n10;
                    }
                    ++n6;
                    ++n7;
                }
            }
            if (d3 - d2 < 1.0) {
                d3 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d3);
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void convolve(double[] dArray, double[] dArray2, ProgressMonitor progressMonitor) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        double[] dArray3;
        double[] dArray4;
        double d2;
        int n8;
        int n9;
        Timer timer = new Timer("Image64.convolve", this);
        int n10 = this.getRange().high;
        int n11 = this.getNBands();
        int n12 = this.getWidth();
        int n13 = n12 - 1;
        int n14 = this.getHeight();
        int n15 = (n14 - 1) * n12;
        int n16 = 0;
        if (null != progressMonitor) {
            int n17 = 0;
            if (null != dArray) {
                n17 += n14;
            }
            if (null != dArray2) {
                n17 += n12;
            }
            progressMonitor.setMaximum(n17);
        }
        if (null != dArray) {
            double[][] dArray5 = this.createDataArray(n12, n14, n11);
            if (null == dArray5) {
                return;
            }
            n9 = dArray.length;
            n8 = n9 / 2;
            d2 = 0.0;
            for (int i = 0; i < n9; ++i) {
                d2 += dArray[i];
            }
            double d3 = 1.0 / d2;
            dArray4 = new double[n11];
            dArray3 = new double[n11];
            for (n7 = 0; n7 < n14; ++n7) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n16);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    n5 = n7 * n12;
                    dArray4[n6] = this.data[n6][n5];
                    dArray3[n6] = this.data[n6][n5 + n13];
                }
                n6 = 0;
                n5 = n7 * n12;
                n4 = n5 - n8;
                while (n6 < n12) {
                    for (n3 = 0; n3 < n11; ++n3) {
                        d = 0.0;
                        n2 = n6 - n8;
                        for (n = 0; n < n9; ++n) {
                            d = n2 < 0 ? (d += dArray4[n3] * dArray[n]) : (n2 >= n12 ? (d += dArray3[n3] * dArray[n]) : (d += this.data[n3][n4 + n] * dArray[n]));
                            ++n2;
                        }
                        dArray5[n3][n5] = (d *= d3) > (double)n10 ? (double)n10 : (d < 0.0 ? 0.0 : (double)((int)d));
                    }
                    ++n6;
                    ++n4;
                    ++n5;
                }
            }
            this.data = dArray5;
        }
        if (null != dArray2) {
            double[][] dArray6 = this.createDataArray(n12, n14, n11);
            if (null == dArray6) {
                return;
            }
            n9 = dArray2.length;
            n8 = n9 / 2;
            d2 = 0.0;
            for (int i = 0; i < n9; ++i) {
                d2 += dArray2[i];
            }
            double d4 = 1.0 / d2;
            dArray4 = new double[n11];
            dArray3 = new double[n11];
            for (n7 = 0; n7 < n12; ++n7) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n16);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    n5 = n7;
                    dArray4[n6] = this.data[n6][n5];
                    dArray3[n6] = this.data[n6][n5 + n15];
                }
                n6 = 0;
                n5 = n7;
                n4 = n5 - n8 * n12;
                while (n6 < n14) {
                    for (n3 = 0; n3 < n11; ++n3) {
                        d = 0.0;
                        n2 = n6 - n8;
                        n = 0;
                        int n18 = 0;
                        while (n < n9) {
                            d = n2 < 0 ? (d += dArray4[n3] * dArray2[n]) : (n2 >= n14 ? (d += dArray3[n3] * dArray2[n]) : (d += this.data[n3][n4 + n18] * dArray2[n]));
                            ++n2;
                            ++n;
                            n18 += n12;
                        }
                        dArray6[n3][n5] = (d *= d4) > (double)n10 ? (double)n10 : (d < 0.0 ? 0.0 : (double)((int)d));
                    }
                    ++n6;
                    n4 += n12;
                    n5 += n12;
                }
            }
            this.data = dArray6;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.getRangeByRescanning();
    }

    @Override
    public void correctBackground(double d, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Timer timer = new Timer("Image64.correctBackground", this);
        int n9 = this.getWidth();
        int n10 = this.getHeight();
        int n11 = this.getNBands();
        int n12 = n9 / n;
        int n13 = n10 / n;
        int n14 = this.getRange().high + 1;
        int n15 = n12 / 2;
        int n16 = n13 / 2;
        int n17 = n9 / n12;
        int n18 = n10 / n13;
        int[] nArray = new int[n11];
        int[][][] nArray2 = new int[n17][n18][n11];
        int[][] nArray3 = new int[n14][n11];
        for (n8 = 0; n8 < n18; ++n8) {
            for (n7 = 0; n7 < n17; ++n7) {
                int n19;
                for (n6 = 0; n6 < n11; ++n6) {
                    for (n19 = 0; n19 < n14; ++n19) {
                        nArray3[n19][n6] = 0;
                    }
                }
                for (n6 = n8 * n13; n6 < (n8 + 1) * n13; ++n6) {
                    for (n19 = n7 * n12; n19 < (n7 + 1) * n12; ++n19) {
                        nArray = this.getPixel(n19, n6);
                        for (n5 = 0; n5 < n11; ++n5) {
                            n4 = nArray[n5];
                            if (0 > n4 || n4 >= n14) continue;
                            int[] nArray4 = nArray3[n4];
                            int n20 = n5;
                            nArray4[n20] = nArray4[n20] + 1;
                        }
                    }
                }
                for (n6 = 0; n6 < n11; ++n6) {
                    nArray2[n7][n8][n6] = 0;
                    n19 = nArray3[0][n6];
                    n5 = nArray3[0][n6];
                    n4 = 0;
                    n3 = 0;
                    for (n2 = 1; n2 < n14 - 1; ++n2) {
                        if (nArray3[n2][n6] <= n19) continue;
                        n19 = nArray3[n2][n6];
                        n4 = n2;
                    }
                    for (n2 = n14 - 2; n2 >= 0; --n2) {
                        if (nArray3[n2][n6] <= n5) continue;
                        n5 = nArray3[n2][n6];
                        n3 = n2;
                    }
                    nArray2[n7][n8][n6] = (n4 + n3) / 2;
                }
            }
        }
        for (n8 = 0; n8 < n18; ++n8) {
            for (n7 = 0; n7 < n17; ++n7) {
                for (n6 = 0; n6 < n11; ++n6) {
                    nArray2[n7][n8][n6] = (int)(d * (double)nArray2[n7][n8][n6]);
                }
            }
        }
        for (n3 = 0; n3 < n18; ++n3) {
            for (n2 = 0; n2 < n17; ++n2) {
                int n21 = n3 * n13;
                int n22 = 0;
                while (n21 < (n3 + 1) * n13) {
                    float f;
                    if (n22 < n16) {
                        f = (float)(n16 + n22) / (float)n13;
                        n4 = n3 - 1;
                    } else {
                        f = (float)(n22 - n16) / (float)n13;
                        n4 = n3;
                    }
                    float f2 = 1.0f - f;
                    int n23 = n2 * n12;
                    int n24 = 0;
                    while (n23 < (n2 + 1) * n12) {
                        float f3;
                        nArray = this.getPixel(n23, n21);
                        if (n24 < n15) {
                            f3 = (float)(n15 + n24) / (float)n12;
                            n5 = n2 - 1;
                        } else {
                            f3 = (float)(n24 - n15) / (float)n12;
                            n5 = n2;
                        }
                        float f4 = 1.0f - f3;
                        for (int i = 0; i < n11; ++i) {
                            if (n4 < 0 || n4 + 1 >= n18 || n5 < 0 || n5 + 1 >= n17) {
                                if (n4 < 0 || n4 + 1 >= n18) {
                                    if (n5 < 0 || n5 + 1 >= n17) {
                                        int n25 = i;
                                        nArray[n25] = nArray[n25] - nArray2[n2][n3][i];
                                    } else {
                                        int n26 = i;
                                        nArray[n26] = nArray[n26] - (int)(0.5f + f3 * (float)nArray2[n5 + 1][n3][i] + f4 * (float)nArray2[n5][n3][i]);
                                    }
                                } else if (n5 < 0 || n5 + 1 >= n17) {
                                    if (n4 < 0 || n4 + 1 >= n18) {
                                        int n27 = i;
                                        nArray[n27] = nArray[n27] - nArray2[n2][n3][i];
                                    } else {
                                        int n28 = i;
                                        nArray[n28] = nArray[n28] - (int)(0.5f + f * (float)nArray2[n2][n4 + 1][i] + f2 * (float)nArray2[n2][n4][i]);
                                    }
                                }
                            } else {
                                int n29 = i;
                                nArray[n29] = nArray[n29] - (int)(0.5f + f * (f3 * (float)nArray2[n5 + 1][n4 + 1][i] + f4 * (float)nArray2[n5][n4 + 1][i]) + f2 * (f3 * (float)nArray2[n5 + 1][n4][i] + f4 * (float)nArray2[n5][n4][i]));
                            }
                            if (nArray[i] >= 0) continue;
                            nArray[i] = 0;
                        }
                        this.setPixel(n23, n21, nArray);
                        ++n23;
                        ++n24;
                    }
                    ++n21;
                    ++n22;
                }
            }
        }
        timer.stop();
    }

    @Override
    public void crop(Point point, Point point2) {
        Point point3 = new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
        Point point4 = new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
        int n = point4.x - point3.x + 1;
        int n2 = point4.y - point3.y + 1;
        int n3 = n;
        int n4 = n2;
        int n5 = this.getNBands();
        int n6 = this.width;
        double[][] dArray = this.createDataArray(n3, n4, n5);
        if (null != dArray) {
            double d;
            double d2;
            Timer timer = new Timer("Image64.crop", this);
            double d3 = d2 = (d = this.data[0][point3.x + n6 * point3.y]);
            int n7 = point3.y;
            for (int i = 0; i < n4; ++i) {
                int n8 = n6 * n7;
                int n9 = this.width * i;
                int n10 = point3.x;
                for (int j = 0; j < n3; ++j) {
                    int n11 = n10 + n8;
                    int n12 = j + n9;
                    for (int k = 0; k < n5; ++k) {
                        dArray[k][n12] = d = this.data[k][n11];
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d3)) continue;
                        d3 = d;
                    }
                    ++n10;
                }
                ++n7;
            }
            this.data = dArray;
            if (d3 - d2 < 1.0) {
                d3 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d3);
            timer.stop();
        }
    }

    @Override
    public void deconvolve(Kernel kernel, int n, double d, ProgressMonitor progressMonitor) {
        int n2;
        Timer timer = new Timer("Image64.deconvolve", this);
        int n3 = this.getNBands();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        double[][] dArray = this.data;
        double[][] dArray2 = this.createDataArray(n4, n5, n3);
        if (null == dArray2) {
            return;
        }
        double[][] dArray3 = this.createDataArray(n4, n5, n3);
        if (null == dArray3) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.widthTimesHeight; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        double d2 = this.getRangeDouble().high;
        int n6 = kernel.getHalfWidth();
        int n7 = 2 * n6 + 1;
        int n8 = n7 * n7;
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[i] = 0.0f;
        }
        float[][] fArray2 = kernel.getData();
        int n9 = 0;
        if (fArray2.length == n3) {
            n9 = 1;
        }
        int n10 = 0;
        int n11 = 0;
        while (n10 < n3) {
            for (n2 = 0; n2 < fArray2[n11].length; ++n2) {
                int n12 = n10;
                fArray[n12] = fArray[n12] + fArray2[n11][n2];
            }
            ++n10;
            n11 += n9;
        }
        float[] fArray3 = new float[n3];
        for (n11 = 0; n11 < n3; ++n11) {
            fArray3[n11] = fArray[n11] != 0.0f ? 1.0f / fArray[n11] : 1.0f;
        }
        n2 = 0;
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n * n3 * n5);
        }
        for (int i = 0; i < n; ++i) {
            int n13 = 0;
            int n14 = 0;
            while (n13 < n3) {
                float[] fArray4 = fArray2[n14];
                int n15 = 0;
                int n16 = n6;
                while (n15 < n5 - n7) {
                    if (null != progressMonitor) {
                        progressMonitor.setProgress(++n2);
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            return;
                        }
                    }
                    int n17 = 0;
                    int n18 = n6;
                    int n19 = n16 * n4 + n18;
                    while (n17 < n4 - n7) {
                        float f = 0.0f;
                        int n20 = 0;
                        for (int j = n15; j < n15 + n7; ++j) {
                            int n21 = n17;
                            int n22 = j * n4;
                            while (n21 < n17 + n7) {
                                f = (float)((double)f + this.data[n13][n22] * (double)fArray2[n13][n20]);
                                ++n21;
                                ++n20;
                                ++n22;
                            }
                        }
                        f *= fArray3[n13];
                        double d3 = dArray[n13][n19];
                        double d4 = dArray2[n13][n19];
                        if ((d4 += d * (d3 - (double)f)) > d2) {
                            d4 = d2;
                        } else if (d4 < 0.0) {
                            d4 = 0.0;
                        }
                        dArray2[n13][n19] = d4;
                        ++n17;
                        ++n18;
                        ++n19;
                    }
                    ++n15;
                    ++n16;
                }
                ++n13;
                n14 += n9;
            }
            double[][] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        this.data = dArray2;
        this.getRangeByRescanningDouble();
        timer.stop();
    }

    @Override
    public void dispose() {
        this.data = null;
        this.zeroPxInt = null;
        this.zeroPxDouble = null;
    }

    @Override
    public void divide(int n) {
        Timer timer = new Timer("Image64.divide ()", this);
        int n2 = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            int n3 = 0;
            while (n3 < this.getWidth()) {
                for (int j = 0; j < this.getNBands(); ++j) {
                    double[] dArray = this.data[j];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] / (double)n;
                }
                ++n3;
                ++n2;
            }
        }
        this.extremesDouble.low /= (double)n;
        this.extremesDouble.high /= (double)n;
        if (this.extremesDouble.high - this.extremesDouble.low < 1.0) {
            this.extremesDouble.high = this.extremesDouble.low + 1.0;
        }
        timer.stop();
    }

    @Override
    public void divideByFlatField(Image image) {
        Timer timer = new Timer("Image64.divideByFlatField", this);
        int n = this.getNBands();
        double d = this.extremesDouble.high;
        RangeDouble[] rangeDoubleArray = image.getChannelRangesDouble();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = rangeDoubleArray[i].high;
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                dArray2 = this.getPixelDouble(j, i);
                dArray3 = image.getPixelDouble(j, i);
                for (int k = 0; k < n; ++k) {
                    dArray2[k] = Math.min(d, dArray2[k] * dArray[k] / dArray3[k]);
                    if (!Double.isInfinite(dArray2[k])) continue;
                    dArray2[k] = d;
                }
                this.setPixelDouble(j, i, dArray2);
            }
        }
        this.getRangeByRescanningDouble();
        timer.stop();
    }

    @Override
    public void drawRim(int n, Color color) {
        int n2 = Math.min(3, this.getNBands());
        double d = (double)this.getRange().high / 255.0;
        double[] dArray = new double[n2];
        dArray[0] = (double)color.getRed() * d;
        if (n2 > 1) {
            dArray[1] = (double)color.getGreen() * d;
        }
        if (n2 > 2) {
            dArray[2] = (double)color.getBlue() * d;
        }
        int n3 = this.width;
        int n4 = n3 - 1;
        int n5 = this.height;
        int n6 = n5 - 1;
        int n7 = n3 * n6;
        for (int i = 0; i < n2; ++i) {
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                this.data[i][n8] = dArray[i];
                this.data[i][n8 + n7] = dArray[i];
            }
            n8 = 0;
            int n9 = 0;
            while (n8 < n5) {
                this.data[i][n9] = dArray[i];
                this.data[i][n4 + n9] = dArray[i];
                ++n8;
                n9 += n3;
            }
        }
    }

    @Override
    public void fit(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        double d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
        int n5 = (int)((double)n3 * d);
        int n6 = (int)((double)n4 * d);
        int n7 = this.getNBands();
        double[][] dArray = this.createDataArray(n5, n6, n7);
        this.widthTimesHeight = n3 * n4;
        this.width = n3;
        this.height = n4;
        if (null != dArray) {
            double d2;
            double d3;
            Timer timer = new Timer("Image64.fit", this);
            double d4 = 1.0 / d;
            double[] dArray2 = new double[n7];
            double d5 = d3 = (d2 = this.data[0][0]);
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                int n9 = 0;
                while (n9 < n5) {
                    dArray2 = this.getPixelDoubleInterpolated((double)n9 * d4, (double)i * d4);
                    for (int j = 0; j < n7; ++j) {
                        dArray[j][n8] = d2 = dArray2[j];
                        if (d2 < d3) {
                            d3 = d2;
                            continue;
                        }
                        if (!(d2 > d5)) continue;
                        d5 = d2;
                    }
                    ++n9;
                    ++n8;
                }
            }
            if (d5 - d3 < 1.0) {
                d5 = d3 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d3, d5);
            this.data = dArray;
            this.widthTimesHeight = n5 * n6;
            this.width = n5;
            this.height = n6;
            timer.stop();
        }
    }

    @Override
    public void flipHorizontal() {
        Timer timer = new Timer("Image64.flipHorizontal", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = 0;
        for (int i = n - 1; n4 < i; ++n4, --i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double d;
                    int n5 = this.width * j;
                    int n6 = n4 + n5;
                    int n7 = i + n5;
                    double d2 = this.data[k][n6];
                    this.data[k][n6] = d = this.data[k][n7];
                    this.data[k][n7] = d2;
                }
            }
        }
        timer.stop();
    }

    @Override
    public void flipVertical() {
        Timer timer = new Timer("Image64.flipVertical", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = 0;
        for (int i = n2 - 1; n4 < i; ++n4, --i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5 = j + this.width * n4;
                    int n6 = j + this.width * i;
                    double d = this.data[k][n5];
                    double d2 = this.data[k][n6];
                    this.data[k][n6] = d;
                    this.data[k][n5] = d2;
                }
            }
        }
        timer.stop();
    }

    @Override
    public RangeInt[] getChannelRanges() {
        int n;
        Util.warning("Warning", "Attempt to get integer range for 64-bit image.");
        Timer timer = new Timer("Image64.getChannelRanges ()", this);
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = nArray2[i] = (int)this.data[i][0];
            for (n = 0; n < this.widthTimesHeight; ++n) {
                int n3 = (int)this.data[i][n];
                if (n3 <= nArray2[i]) continue;
                nArray2[i] = n3;
            }
        }
        RangeInt[] rangeIntArray = new RangeInt[n2];
        for (n = 0; n < n2; ++n) {
            rangeIntArray[n] = new RangeInt(nArray[n], nArray2[n]);
        }
        timer.stop();
        return rangeIntArray;
    }

    @Override
    public RangeDouble[] getChannelRangesDouble() {
        int n;
        Timer timer = new Timer("Image64.getChannelRangesDouble ()", this);
        int n2 = this.getNBands();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = dArray2[i] = this.data[i][0];
            for (n = 0; n < this.widthTimesHeight; ++n) {
                double d = this.data[i][n];
                if (!(d > dArray2[i])) continue;
                dArray2[i] = d;
            }
        }
        RangeDouble[] rangeDoubleArray = new RangeDouble[n2];
        for (n = 0; n < n2; ++n) {
            rangeDoubleArray[n] = new RangeDouble(dArray[n], dArray2[n]);
        }
        timer.stop();
        return rangeDoubleArray;
    }

    @Override
    public RangeInt getRangeByRescanning() {
        int n;
        Util.warning("Warning", "Attempt to get integer range for 64-bit image.");
        int n2 = n = (int)this.data[0][0];
        for (int i = 0; i < this.getNBands(); ++i) {
            for (int j = 0; j < this.widthTimesHeight; ++j) {
                int n3 = (int)this.data[i][j];
                if (n3 < n) {
                    n = n3;
                    continue;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        RangeInt rangeInt = new RangeInt(n, n2);
        Util.logInfo(rangeInt.toString());
        return rangeInt;
    }

    @Override
    public RangeDouble getRangeByRescanningDouble() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.getNBands(); ++i) {
            for (int j = 0; j < this.widthTimesHeight; ++j) {
                double d3 = this.data[i][j];
                if (Double.isNaN(d3)) continue;
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
        }
        if (d2 - d < 1.0) {
            d2 = d + 1.0;
        }
        this.extremesDouble = new RangeDouble(d, d2);
        Util.logInfo(this.extremesDouble.toString());
        return this.extremesDouble;
    }

    @Override
    public int[] getPixel(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return this.zeroPxInt;
        }
        int n3 = n + this.width * n2;
        if (n3 >= this.widthTimesHeight) {
            return this.zeroPxInt;
        }
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = (int)this.data[i][n3];
        }
        return nArray;
    }

    @Override
    public double[] getPixelDouble(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return this.zeroPxDouble;
        }
        int n3 = n + this.width * n2;
        if (n3 >= this.widthTimesHeight) {
            return this.zeroPxDouble;
        }
        int n4 = this.getNBands();
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = this.data[i][n3];
        }
        return dArray;
    }

    @Override
    public int[] getPixelInterpolated(double d, double d2) {
        if (d < 0.0 || d >= (double)this.width || d2 < 0.0 || d2 >= (double)this.height) {
            return this.zeroPxInt;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n2;
        double d6 = 1.0 - d5;
        int[] nArray = this.getPixel(n, n2);
        int[] nArray2 = this.getPixel(n + 1, n2);
        int[] nArray3 = this.getPixel(n, n2 + 1);
        int[] nArray4 = this.getPixel(n + 1, n2 + 1);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(d3 * (d5 * (double)nArray4[i] + d6 * (double)nArray2[i]) + d4 * (d5 * (double)nArray3[i] + d6 * (double)nArray[i]));
        }
        return nArray;
    }

    @Override
    public double[] getPixelDoubleInterpolated(double d, double d2) {
        if (d < 0.0 || d >= (double)this.width || d2 < 0.0 || d2 >= (double)this.height) {
            return this.zeroPxDouble;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n2;
        double d6 = 1.0 - d5;
        double[] dArray = this.getPixelDouble(n, n2);
        double[] dArray2 = this.getPixelDouble(n + 1, n2);
        double[] dArray3 = this.getPixelDouble(n, n2 + 1);
        double[] dArray4 = this.getPixelDouble(n + 1, n2 + 1);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d3 * (d5 * dArray4[i] + d6 * dArray2[i]) + d4 * (d5 * dArray3[i] + d6 * dArray[i]);
        }
        return dArray;
    }

    public double[] getHorizontalSamplesDouble(int n, int n2, int n3, int n4) {
        double[] dArray = new double[n4];
        int n5 = 0;
        int n6 = n + this.width * n2;
        while (n5 < n4) {
            dArray[n5] = this.data[n3][n6];
            ++n5;
            ++n6;
        }
        return dArray;
    }

    public double[] getVerticalSamplesDouble(int n, int n2, int n3, int n4) {
        double[] dArray = new double[n4];
        int n5 = 0;
        int n6 = n + this.width * n2;
        while (n5 < n4) {
            dArray[n5] = this.data[n3][n6];
            ++n5;
            n6 += this.width;
        }
        return dArray;
    }

    @Override
    public Image gnomonicProjection(int n, double d, double d2) {
        if (0 < n) {
            int n2;
            int n3;
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            double d3 = 2.0 * (double)n;
            double d4 = Math.atan2(d, d3);
            double d5 = d / d3;
            double d6 = (double)n4 * 0.5 / d4;
            double d7 = d6 * d5;
            double d8 = 1.0 / d6;
            double d9 = Math.sqrt(n4 * n4 + n5 * n5) * 0.5;
            double d10 = Math.atan2(n5, n4);
            double d11 = d6 * Math.tan(d8 * d9);
            int n6 = (int)Math.floor(d11 * Math.cos(d10));
            Image64 image64 = new Image64(2 * n6, 2 * (n3 = (int)Math.floor(d11 * Math.sin(d10))), n2 = this.getNBands());
            if (null != image64) {
                Timer timer = new Timer("Image64.gnomonicProjection", this);
                int[] nArray = new int[n2];
                int n7 = n4 / 2;
                int n8 = n5 / 2;
                int n9 = 0;
                int n10 = -n3;
                while (n9 < image64.getHeight()) {
                    double d12 = n10 * n10;
                    int n11 = 0;
                    int n12 = -n6;
                    while (n11 < image64.getWidth()) {
                        double d13 = Math.sqrt((double)(n12 * n12) + d12);
                        double d14 = d6 * Math.atan2(d13 * d5, d7);
                        double d15 = d14 / d13;
                        double d16 = (double)n12 * d15 + (double)n7;
                        double d17 = (double)n10 * d15 + (double)n8;
                        nArray = this.getPixelInterpolated(d16, d17);
                        image64.setPixel(n11, n9, nArray);
                        ++n11;
                        ++n12;
                    }
                    ++n9;
                    ++n10;
                }
                image64.extremesDouble = new RangeDouble(this.extremesDouble.low, this.extremesDouble.high);
                timer.stop();
            }
            return image64;
        }
        return this;
    }

    @Override
    public Image inverseGnomonicProjection(int n, double d, double d2) {
        if (0 < n) {
            int n2;
            int n3;
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            double d3 = (double)n4 * 0.5;
            double d4 = (double)n5 * 0.5;
            double d5 = 2.0 * (double)n;
            double d6 = Math.atan2(d, d5);
            double d7 = Math.atan2(d2, d5);
            double d8 = d / d5;
            double d9 = d2 / d5;
            double d10 = d3 / d8;
            double d11 = d4 / d9;
            double d12 = d8 / d3;
            int n6 = (int)Math.floor(d6 * d10);
            Image64 image64 = new Image64(2 * n6, 2 * (n3 = (int)Math.floor(d7 * d11)), n2 = this.getNBands());
            if (null != image64) {
                Timer timer = new Timer("Image64.inverseGnomonicProjection", this);
                int[] nArray = new int[n2];
                int n7 = n4 / 2;
                int n8 = n5 / 2;
                int n9 = 0;
                int n10 = -n3;
                while (n9 < image64.getHeight()) {
                    double d13 = n10 * n10;
                    int n11 = 0;
                    int n12 = -n6;
                    while (n11 < image64.getWidth()) {
                        double d14 = Math.sqrt((double)(n12 * n12) + d13);
                        double d15 = d10 * Math.tan(d12 * d14);
                        double d16 = d15 / d14;
                        double d17 = (double)n12 * d16 + (double)n7;
                        double d18 = (double)n10 * d16 + (double)n8;
                        nArray = this.getPixelInterpolated(d17, d18);
                        image64.setPixel(n11, n9, nArray);
                        ++n11;
                        ++n12;
                    }
                    ++n9;
                    ++n10;
                }
                timer.stop();
                image64.extremesDouble = new RangeDouble(this.extremesDouble.low, this.extremesDouble.high);
            }
            return image64;
        }
        return this;
    }

    @Override
    public void invert() {
        Timer timer = new Timer("Image64.invert", this);
        int n = this.getNBands();
        double d = this.extremesDouble.high;
        int n2 = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            int n3 = 0;
            while (n3 < this.getWidth()) {
                for (int j = 0; j < n; ++j) {
                    this.data[j][n2] = d - this.data[j][n2];
                }
                ++n3;
                ++n2;
            }
        }
        double d2 = d - this.extremesDouble.low;
        double d3 = d - this.extremesDouble.high;
        if (d2 - d3 < 1.0) {
            d2 = d3 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d3, d2);
        timer.stop();
    }

    @Override
    public boolean isRaw() {
        return false;
    }

    @Override
    public void meanFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3 = this.getNBands();
        int n4 = this.getWidth();
        double[][] dArray = this.createDataArray(n4, n2 = this.getHeight(), n3);
        if (null != dArray) {
            double d;
            double d2;
            Timer timer = new Timer("Image64.meanFilter", this);
            int n5 = 2 * n + 1;
            int n6 = n5 * n5;
            double[] dArray2 = new double[n3];
            double d3 = d2 = (d = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n2 - n);
            }
            for (int i = n; i < n2 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n7 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n8;
                    int n9 = j + n7;
                    for (n8 = 0; n8 < n3; ++n8) {
                        dArray2[n8] = 0.0;
                    }
                    for (n8 = i - n; n8 <= i + n; ++n8) {
                        int n10 = n4 * n8;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n3; ++i2) {
                                int n11 = i2;
                                dArray2[n11] = dArray2[n11] + this.data[i2][k + n10];
                            }
                        }
                    }
                    for (n8 = 0; n8 < n3; ++n8) {
                        dArray[n8][n9] = d = dArray2[n8] / (double)n6;
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d3)) continue;
                        d3 = d;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (d3 - d2 < 1.0) {
                d3 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d3);
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void medianFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3 = this.getNBands();
        int n4 = this.getWidth();
        double[][] dArray = this.createDataArray(n4, n2 = this.getHeight(), n3);
        if (null != dArray) {
            double d;
            double d2;
            Timer timer = new Timer("Image64.medianFilter", this);
            int n5 = 2 * n + 1;
            int n6 = n5 * n5;
            int n7 = n6 / 2;
            double[][] dArray2 = new double[n3][n6];
            double d3 = d2 = (d = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n2 - n);
            }
            for (int i = n; i < n2 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n8 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n9;
                    int n10 = j + n8;
                    int n11 = 0;
                    for (n9 = i - n; n9 <= i + n; ++n9) {
                        int n12 = n4 * n9;
                        int n13 = j - n;
                        while (n13 <= j + n) {
                            for (int k = 0; k < n3; ++k) {
                                dArray2[k][n11] = this.data[k][n13 + n12];
                            }
                            ++n13;
                            ++n11;
                        }
                    }
                    for (n9 = 0; n9 < n3; ++n9) {
                        Arrays.sort(dArray2[n9]);
                        dArray[n9][n10] = d = dArray2[n9][n7];
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d3)) continue;
                        d3 = d;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (d3 - d2 < 1.0) {
                d3 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d3);
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void multiply(double d) {
        Timer timer = new Timer("Image64.multiply ()", this);
        int n = this.getNBands();
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            int n3 = this.width * i;
            for (int j = 0; j < this.width; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray = this.data[k];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] * d;
                }
            }
        }
        this.extremesDouble = new RangeDouble(this.extremesDouble.low * d, this.extremesDouble.high * d);
        timer.stop();
    }

    @Override
    public void multiply(Image image) {
        double d;
        double d2;
        Timer timer = new Timer("Image64.multiply", this);
        int n = this.getNBands();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d3 = image.getRangeDouble().high;
        double d4 = 1.0 / d3;
        double d5 = d2 = (d = this.data[0][0] * image.getPixelDouble(0, 0)[0] * d4);
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                dArray = this.getPixelDouble(j, i);
                dArray2 = image.getPixelDouble(j, i);
                for (int k = 0; k < n; ++k) {
                    dArray[k] = d = (double)((int)(dArray[k] * dArray2[k] * d4));
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d5)) continue;
                    d5 = d;
                }
                this.setPixelDouble(j, i, dArray);
            }
        }
        if (d5 - d2 < 1.0) {
            d5 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d5);
        timer.stop();
    }

    @Override
    public void multiply(Image image, double d, double d2) {
        double d3;
        double d4;
        Timer timer = new Timer("Image64.multiply", this);
        int n = this.getNBands();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d5 = this.extremesDouble.high;
        double d6 = image.getRangeDouble().high;
        double d7 = d5 / Math.sqrt(d5 * (d * d5 + d2 * d6));
        double d8 = this.data[0][0];
        double d9 = image.getPixelDouble(0, 0)[0];
        double d10 = d4 = (d3 = d7 * Math.sqrt(d8 * (d * d8 + d2 * d9)));
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                dArray = this.getPixelDouble(j, i);
                dArray2 = image.getPixelDouble(j, i);
                for (int k = 0; k < n; ++k) {
                    dArray[k] = d3 = d7 * Math.sqrt(dArray[k] * (d * dArray[k] + d2 * dArray2[k]));
                    if (d3 < d4) {
                        d4 = d3;
                        continue;
                    }
                    if (!(d3 > d10)) continue;
                    d10 = d3;
                }
                this.setPixelDouble(j, i, dArray);
            }
        }
        if (d10 - d4 < 1.0) {
            d10 = d4 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d4, d10);
        timer.stop();
    }

    @Override
    public void nearestExtremeFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        double[][] dArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != dArray) {
            double d;
            double d2;
            Timer timer = new Timer("Image64.nearestExtremeFilter", this);
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            double d3 = this.extremesDouble.high;
            double d4 = d2 = (d = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n5 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    double d5;
                    int n6;
                    int n7 = j + n5;
                    for (n6 = 0; n6 < n2; ++n6) {
                        dArray2[n6] = d3;
                        dArray3[n6] = 0.0;
                    }
                    for (n6 = i - n; n6 <= i + n; ++n6) {
                        int n8 = n4 * n6;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n2; ++i2) {
                                d5 = this.data[i2][k + n8];
                                if (d5 < dArray2[i2]) {
                                    dArray2[i2] = d5;
                                    continue;
                                }
                                if (!(d5 > dArray3[i2])) continue;
                                dArray3[i2] = d5;
                            }
                        }
                    }
                    for (n6 = 0; n6 < n2; ++n6) {
                        d5 = this.data[n6][n7];
                        d = d5 - dArray2[n6] < dArray3[n6] - d5 ? dArray2[n6] : dArray3[n6];
                        dArray[n6][n7] = d;
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d4)) continue;
                        d4 = d;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            timer.stop();
            if (d4 - d2 < 1.0) {
                d4 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d4);
            this.data = dArray;
        }
    }

    @Override
    public void neutraliseBackground() {
        int n = this.getNBands();
        if (1 == n) {
            Util.message("Information", "Background neutralisation is not\nrelevant for monochrome (1-channel) images");
        } else {
            int n2;
            Timer timer = new Timer("Image64.neutraliseBackground", this);
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            double d = this.extremesDouble.high;
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics(1, (int)Math.min(2.147483647E9, d * 0.8));
            int n5 = statisticsArray[0].mode;
            int n6 = 0;
            for (int i = 1; i < n; ++i) {
                if (statisticsArray[i].mode >= n5) continue;
                n5 = statisticsArray[i].mode;
                n6 = i;
            }
            double[] dArray = new double[n];
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = (d - (double)n5) / (d - (double)statisticsArray[n2].mode);
            }
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                int n8 = 0;
                while (n8 < n3) {
                    for (int i = 0; i < n; ++i) {
                        if (i == n6) continue;
                        this.data[i][n7] = Math.max(0.0, d - (d - this.data[i][n7]) * dArray[i]);
                    }
                    ++n8;
                    ++n7;
                }
            }
            timer.stop();
        }
    }

    @Override
    public void rankFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        double[][] dArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != dArray) {
            double d;
            double d2;
            Timer timer = new Timer("Image64.rankFilter", this);
            double[] dArray2 = new double[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            double d3 = this.extremesDouble.high;
            float f = 2 * n + 1;
            double d4 = d3 / (double)(f * f);
            double d5 = d2 = (d = this.data[0][0]);
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n5 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    int n6;
                    int n7 = j + n5;
                    for (n6 = 0; n6 < n2; ++n6) {
                        nArray[n6] = 0;
                        nArray2[n6] = 0;
                    }
                    dArray2 = this.getPixelDouble(j, i);
                    for (n6 = i - n; n6 <= i + n; ++n6) {
                        int n8 = n4 * n6;
                        for (int k = j - n; k <= j + n; ++k) {
                            for (int i2 = 0; i2 < n2; ++i2) {
                                double d6 = this.data[i2][k + n8];
                                if (d6 < dArray2[i2]) {
                                    int n9 = i2;
                                    nArray[n9] = nArray[n9] + 1;
                                    continue;
                                }
                                if (d6 != dArray2[i2]) continue;
                                int n10 = i2;
                                nArray2[n10] = nArray2[n10] + 1;
                            }
                        }
                    }
                    for (n6 = 0; n6 < n2; ++n6) {
                        dArray[n6][n7] = d = d4 * (double)(nArray[n6] + nArray2[n6] / 2);
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d5)) continue;
                        d5 = d;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (d5 - d2 < 1.0) {
                d5 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d5);
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void reapplyColour(Image image, Image image2) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = image2.getNBands();
        int n4 = image2.getRange().high;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = image.getPixel(j, i)[0];
                int[] nArray = image2.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = (int)Math.round((double)n5 * (double)nArray[k] / (double)n4);
                }
                this.setPixel(j, i, nArray);
            }
        }
        this.setRangeDouble(this.getRangeByRescanningDouble());
    }

    @Override
    public void rotate(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = (int)Math.floor(Math.abs((double)n * d4) + Math.abs((double)n2 * d3));
        int n6 = (int)Math.floor(Math.abs((double)n * d3) + Math.abs((double)n2 * d4));
        int n7 = this.getNBands();
        double[][] dArray = this.createDataArray(n5, n6, n7);
        this.widthTimesHeight = n * n2;
        this.width = n;
        this.height = n2;
        if (null != dArray) {
            double d5;
            Timer timer = new Timer("Image64.rotate", this);
            double[] dArray2 = new double[n7];
            double d6 = d5 = this.data[0][0];
            int n8 = 0;
            int n9 = 0;
            int n10 = -n6 / 2;
            while (n8 < n6) {
                int n11 = 0;
                int n12 = -n5 / 2;
                while (n11 < n5) {
                    double d7 = (double)n12 * d4 - (double)n10 * d3;
                    double d8 = (double)n12 * d3 + (double)n10 * d4;
                    dArray2 = this.getPixelDoubleInterpolated(d7 + (double)n3, d8 + (double)n4);
                    for (int i = 0; i < n7; ++i) {
                        dArray[i][n9] = dArray2[i];
                        if (dArray2[i] < d5) {
                            d5 = dArray2[i];
                            continue;
                        }
                        if (!(dArray2[i] > d6)) continue;
                        d6 = dArray2[i];
                    }
                    ++n11;
                    ++n12;
                    ++n9;
                }
                ++n8;
                ++n10;
            }
            if (d6 - d5 < 1.0) {
                d6 = d5 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d5, d6);
            this.data = dArray;
            this.widthTimesHeight = n5 * n6;
            this.width = n5;
            this.height = n6;
            timer.stop();
        }
    }

    @Override
    public void save(String string) {
        this.save(string, this.extremesDouble);
    }

    @Override
    public void save(String string, RangeInt rangeInt) {
        this.save(string, this.extremesDouble);
    }

    @Override
    public void save(String string, RangeDouble rangeDouble) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".fits")) {
            this.saveAsFITS(string);
        } else {
            Util.warning("Image not saved", "Path " + string + "\ndoes not end in \".fits\"");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveAsFITS(String string) {
        Timer timer = new Timer("Image64.saveAsFITS", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        try {
            void var9_17;
            int n4;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FITS.padTo(80, "SIMPLE  =                    T / GRIP (www.grelf.net)"));
            stringBuffer.append(FITS.padTo(80, "BITPIX  =                  -64"));
            stringBuffer.append(FITS.padTo(80, "BZERO   =                  0.0"));
            stringBuffer.append(FITS.padTo(80, "BSCALE  =                  1.0"));
            stringBuffer.append(FITS.padTo(80, "NAXIS   =                    3"));
            stringBuffer.append(FITS.padTo(80, "NAXIS1  = " + FITS.rJustified20(n)));
            stringBuffer.append(FITS.padTo(80, "NAXIS2  = " + FITS.rJustified20(n2)));
            stringBuffer.append(FITS.padTo(80, "NAXIS3  = " + FITS.rJustified20(n3)));
            stringBuffer.append(FITS.padTo(80, "DATE    = " + Util.format_yyyyMMddTHHmmss(new Date())));
            if (null != this.metadata) {
                if (null != this.metadata.getMap()) {
                    for (String object : this.metadata.getMap().keySet()) {
                        String string2 = Metadata.FITS_KEYWORDS.get(object);
                        String string3 = this.metadata.getMap().get(object);
                        if (null == string2 || null == string3 || -1 != stringBuffer.indexOf(string2)) continue;
                        stringBuffer.append(FITS.padTo(80, string2 + "= " + string3));
                    }
                }
                if (null != this.metadata.getList()) {
                    for (FITS_KeywordRecord i : this.metadata.getList()) {
                        if (-1 != stringBuffer.indexOf(i.getKeyword())) continue;
                        stringBuffer.append(i.getRecord());
                    }
                }
            }
            stringBuffer.append(FITS.padTo(80, "END"));
            stringBuffer = FITS.padTo((1 + stringBuffer.length() / 2880) * 2880, stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = 0;
                    while (n6 < n) {
                        dataOutputStream.writeDouble(this.data[n4][n5]);
                        ++n6;
                        ++n5;
                    }
                }
            }
            n4 = (int)(8L * (long)n3 * (long)n * (long)n2 % 2880L);
            boolean bl = false;
            while (var9_17 < 2880 - n4) {
                dataOutputStream.writeByte(32);
                ++var9_17;
            }
            dataOutputStream.close();
            this.setFilePath(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.warning("Error", fileNotFoundException);
        }
        catch (IOException iOException) {
            Util.warning("Error", iOException);
        }
        timer.stop();
    }

    @Override
    public void scale(double d, boolean bl) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (int)Math.floor((double)n * d);
        int n4 = (int)Math.floor((double)n2 * d);
        int n5 = this.getNBands();
        double[][] dArray = this.createDataArray(n3, n4, n5);
        this.widthTimesHeight = n * n2;
        this.width = n;
        this.height = n2;
        if (null != dArray) {
            Timer timer = new Timer("Image64.scale", this);
            int n6 = n / 2;
            int n7 = n2 / 2;
            double[] dArray2 = new double[n5];
            double d2 = 1.0 / d;
            if (bl) {
                int n8 = 0;
                int n9 = -n4 / 2;
                int n10 = 0;
                while (n8 < n4) {
                    int n11 = 0;
                    int n12 = -n3 / 2;
                    while (n11 < n3) {
                        double d3 = (double)n12 * d2;
                        double d4 = (double)n9 * d2;
                        dArray2 = this.getPixelDoubleInterpolated(d3 + (double)n6, d4 + (double)n7);
                        for (int i = 0; i < n5; ++i) {
                            dArray[i][n10] = dArray2[i];
                        }
                        ++n11;
                        ++n12;
                        ++n10;
                    }
                    ++n8;
                    ++n9;
                }
            } else {
                int n13 = 0;
                int n14 = -n4 / 2;
                int n15 = 0;
                while (n13 < n4) {
                    int n16 = 0;
                    int n17 = -n3 / 2;
                    while (n16 < n3) {
                        double d5 = (double)n17 * d2;
                        double d6 = (double)n14 * d2;
                        int n18 = (int)(d5 + (double)n6) + n3 * (int)(d6 + (double)n7);
                        for (int i = 0; i < n5; ++i) {
                            dArray[i][n15] = this.data[i][n18];
                        }
                        ++n16;
                        ++n17;
                        ++n15;
                    }
                    ++n13;
                    ++n14;
                }
            }
            this.data = dArray;
            this.widthTimesHeight = n3 * n4;
            this.width = n3;
            this.height = n4;
            timer.stop();
        }
    }

    @Override
    public BufferedImage scaleDownForDisplay(int n) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this.getNBands();
        double d = this.getRangeDouble().high;
        int n5 = n2 / n;
        int n6 = n3 / n;
        BufferedImage bufferedImage = Image64.getGraphicsConfiguration().createCompatibleImage(n5, n6);
        int n7 = Image8or16Base.getNBands(bufferedImage);
        double d2 = Image8or16Base.getMaxLevel(bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        for (int i = 0; i < n7; ++i) {
            nArray[i] = 0;
        }
        double d3 = d2 / d;
        if (1 == n4) {
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                int n9 = 0;
                int n10 = n8 * this.width;
                while (n9 < n5) {
                    int n11 = (int)(this.data[0][n10] * d3);
                    for (int j = 0; j < n7; ++j) {
                        nArray[j] = n11;
                    }
                    writableRaster.setPixel(n9, i, nArray);
                    ++n9;
                    n10 += n;
                }
                n8 += n;
            }
        } else {
            int n12 = Math.min(n4, n7);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14 = 0;
                int n15 = n13 * this.width;
                while (n14 < n5) {
                    for (int j = 0; j < n12; ++j) {
                        nArray[j] = (int)(this.data[j][n15] * d3);
                    }
                    writableRaster.setPixel(n14, i, nArray);
                    ++n14;
                    n15 += n;
                }
                n13 += n;
            }
        }
        return bufferedImage;
    }

    @Override
    public final void set(BufferedImage bufferedImage) throws IncompatibleImageException {
        double d;
        double d2;
        this.checkCompatibility("set", bufferedImage);
        Timer timer = new Timer("Image64.set ()", this);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = this.getNBands();
        double[] dArray = new double[n];
        int n2 = StrictMath.min(this.width, bufferedImage.getWidth());
        int n3 = StrictMath.min(this.height, bufferedImage.getHeight());
        writableRaster.getPixel(0, 0, dArray);
        double d3 = d2 = (d = dArray[0]);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = 0;
            while (n5 < n2) {
                writableRaster.getPixel(n5, i, dArray);
                for (int j = 0; j < n; ++j) {
                    this.data[j][n4] = d = dArray[j];
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                ++n5;
                ++n4;
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d3);
        timer.stop();
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n + this.width * n2;
            for (int i = 0; i < this.getNBands(); ++i) {
                this.data[i][n3] = nArray[i];
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int n3, int n4) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n5 = n + this.width * n2;
            this.data[n3][n5] = n4;
        }
    }

    @Override
    public void setPixelDouble(int n, int n2, double[] dArray) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n + this.width * n2;
            for (int i = 0; i < this.getNBands(); ++i) {
                this.data[i][n3] = dArray[i];
            }
        }
    }

    @Override
    public void setPixelDouble(int n, int n2, int n3, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n4 = n + this.width * n2;
            this.data[n3][n4] = d;
        }
    }

    @Override
    public void showInfo() {
        this.showInfo(this);
    }

    @Override
    public Image[] splitChannels() {
        Timer timer = new Timer("Image64.splitChannels", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image[] imageArray = new Image64[n3];
        for (int i = 0; i < n3; ++i) {
            imageArray[i] = new Image64(n, n2, 1);
            imageArray[i].extremesDouble = new RangeDouble(this.extremesDouble.low, this.extremesDouble.high);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray = this.getPixelDouble(j, i);
                for (int k = 0; k < n3; ++k) {
                    dArray2[0] = dArray[k];
                    ((Image64)imageArray[k]).setPixelDouble(j, i, dArray2);
                }
            }
        }
        timer.stop();
        return imageArray;
    }

    @Override
    public Image[] splitIntensity() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = this.getBitsPerChannel();
        double d = this.getRangeDouble().high;
        Image image = ImageBase.createImage(n, n2, 1, n4);
        if (null == image) {
            Util.warning("Error", "Unable to create intensity image");
            return null;
        }
        Image image2 = ImageBase.createImage(n, n2, n3, n4);
        if (null == image2) {
            Util.warning("Error", "Unable to create colour image");
            return null;
        }
        Timer timer = new Timer("Image.splitIntensity", this);
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5;
                double[] dArray = this.getPixelDouble(j, i);
                double d3 = 0.0;
                for (n5 = 0; n5 < n3; ++n5) {
                    d3 += dArray[n5];
                }
                image.setPixelDouble(j, i, 0, d3);
                if (d3 > d2) {
                    d2 = d3;
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    dArray[n5] = d * dArray[n5] / d3;
                }
                image2.setPixelDouble(j, i, dArray);
            }
        }
        image.getRangeByRescanningDouble();
        image2.getRangeByRescanningDouble();
        Image[] imageArray = new Image64[]{image, image2};
        timer.stop();
        return imageArray;
    }

    @Override
    public void subtract(Image image) throws IncompatibleImageException {
        double d;
        double d2;
        if (!ImageBase.sameBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        Timer timer = new Timer("Image32.subtract ()", this);
        int n = Math.min(this.getWidth(), image.getWidth());
        int n2 = Math.min(this.getHeight(), image.getHeight());
        int n3 = this.getNBands();
        double[] dArray = new double[n3];
        double d3 = this.extremesDouble.low - image.getRangeDouble().high;
        double d4 = d2 = (d = this.data[0][0] - image.getPixelDouble(0, 0)[0] - d3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                dArray = image.getPixelDouble(n5, i);
                for (int j = 0; j < n3; ++j) {
                    this.data[j][n4] = d = this.data[j][n4] - dArray[j] - d3;
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d4)) continue;
                    d4 = d;
                }
                ++n5;
                ++n4;
            }
        }
        if (d4 - d2 < 1.0) {
            d4 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d4 * 2.0);
        timer.stop();
    }

    @Override
    public void subtractToZero(Image image) throws IncompatibleImageException {
        double d;
        double d2;
        if (!ImageBase.sameBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        Timer timer = new Timer("Image32.subtract ()", this);
        int n = Math.min(this.getWidth(), image.getWidth());
        int n2 = Math.min(this.getHeight(), image.getHeight());
        int n3 = this.getNBands();
        double[] dArray = new double[n3];
        double d3 = d2 = (d = this.data[0][0] - image.getPixelDouble(0, 0)[0]);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                dArray = image.getPixelDouble(n5, i);
                for (int j = 0; j < n3; ++j) {
                    d = this.data[j][n4] - dArray[j];
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    this.data[j][n4] = d;
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                ++n5;
                ++n4;
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.extremesDouble = new RangeDouble(d2, d3);
        timer.stop();
    }

    @Override
    public ByteMask threshold(Threshold threshold) {
        Timer timer = new Timer("Image64.threshold", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        double[] dArray = new double[n3];
        byte[][] byArray = new byte[n][n2];
        if (threshold.anding) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray = this.getPixelDouble(j, i);
                    int n4 = 3;
                    for (int k = 0; k < n3; ++k) {
                        if (!(dArray[k] < (double)threshold.th[k].low) && !(dArray[k] > (double)threshold.th[k].high)) continue;
                        n4 = 0;
                        break;
                    }
                    byArray[j][i] = n4;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray = this.getPixelDouble(j, i);
                    int n5 = 0;
                    for (int k = 0; k < n3; ++k) {
                        if (!(dArray[k] >= (double)threshold.th[k].low) || !(dArray[k] <= (double)threshold.th[k].high)) continue;
                        n5 = 3;
                        break;
                    }
                    byArray[j][i] = n5;
                }
            }
        }
        timer.stop();
        return new ByteMask(byArray);
    }

    @Override
    public String toString() {
        if (null == this.data) {
            return "Image64 is null";
        }
        return "Image64 " + this.getWidth() + " x " + this.getHeight() + " pixels x " + this.getNBands() + " channels";
    }

    @Override
    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFilePath());
        stringBuffer.append(string);
        if (this.isRaw()) {
            stringBuffer.append("RAW");
            stringBuffer.append(string);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        stringBuffer.append("Size: ");
        stringBuffer.append(n);
        stringBuffer.append(" x ");
        stringBuffer.append(n2);
        stringBuffer.append(" pixels");
        stringBuffer.append(string);
        stringBuffer.append("Channels: ");
        stringBuffer.append(this.getNBands());
        stringBuffer.append(string);
        stringBuffer.append("Bits per channel: ");
        stringBuffer.append(this.getBitsPerChannel());
        stringBuffer.append(" [levels ");
        stringBuffer.append(this.getRangeDouble().low);
        stringBuffer.append("..");
        stringBuffer.append(this.getRangeDouble().high);
        stringBuffer.append("]");
        stringBuffer.append(string);
        stringBuffer.append("Calibration: ");
        stringBuffer.append(this.getCalibration().getValue());
        stringBuffer.append(string);
        Metadata metadata = this.getMetadata();
        if (null != metadata) {
            stringBuffer.append(metadata.toFoldedString(string));
        }
        return stringBuffer.toString();
    }

    @Override
    public void translate(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.getWidth();
        int n7 = n6;
        double[][] dArray = this.createDataArray(n7, n5 = (n4 = this.getHeight()), n3 = this.getNBands());
        if (null != dArray) {
            Timer timer = new Timer("Image64.translate", this);
            int n8 = 0;
            int n9 = n2;
            int n10 = 0;
            while (n8 < n4) {
                if (n9 >= 0 && n9 < n4) {
                    int n11 = n9 * n7;
                    int n12 = 0;
                    int n13 = n;
                    int n14 = n11 + n;
                    while (n12 < n6) {
                        if (n13 >= 0 && n13 < n6) {
                            for (int i = 0; i < n3; ++i) {
                                dArray[i][n14] = this.data[i][n10];
                            }
                        }
                        ++n12;
                        ++n13;
                        ++n10;
                        ++n14;
                    }
                }
                ++n8;
                ++n9;
            }
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void translate(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4 = this.getWidth();
        int n5 = n4;
        double[][] dArray = this.createDataArray(n5, n3 = (n2 = this.getHeight()), n = this.getNBands());
        if (null != dArray) {
            Timer timer = new Timer("Image64.translate", this);
            double[] dArray2 = new double[n];
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                double d3 = (double)i - d2;
                int n7 = 0;
                while (n7 < n5) {
                    double d4 = (double)n7 - d;
                    dArray2 = this.getPixelDoubleInterpolated(d4, d3);
                    for (int j = 0; j < n; ++j) {
                        dArray[j][n6] = dArray2[j];
                    }
                    ++n7;
                    ++n6;
                }
            }
            this.data = dArray;
            timer.stop();
        }
    }

    @Override
    public void varianceFilter(int n, ProgressMonitor progressMonitor) {
        int n2;
        int n3;
        int n4 = this.getWidth();
        double[][] dArray = this.createDataArray(n4, n3 = this.getHeight(), n2 = this.getNBands());
        if (null != dArray) {
            double d;
            double d2;
            int n5;
            int n6;
            int n7;
            Timer timer = new Timer("Image64.varianceFilter", this);
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            int n8 = 2 * n + 1;
            int n9 = n8 * n8;
            double d3 = 1.0 / (double)n9;
            double d4 = 0.0;
            if (null != progressMonitor) {
                progressMonitor.setMaximum(n3 - n);
            }
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                n7 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    double d5;
                    int n10;
                    n6 = j + n7;
                    for (n10 = 0; n10 < n2; ++n10) {
                        dArray2[n10] = 0.0;
                        dArray3[n10] = 0.0;
                    }
                    for (n10 = i - n; n10 <= i + n; ++n10) {
                        n5 = n4 * n10;
                        for (int k = j - n; k <= j + n; ++k) {
                            int n11 = 0;
                            while (n11 < n2) {
                                d5 = this.data[n11][k + n5];
                                int n12 = n11;
                                dArray2[n12] = dArray2[n12] + d5;
                                int n13 = n11++;
                                dArray3[n13] = dArray3[n13] + d5 * d5;
                            }
                        }
                    }
                    for (n10 = 0; n10 < n2; ++n10) {
                        d5 = d3 * dArray3[n10];
                        double d6 = d3 * dArray2[n10];
                        double d7 = d5 - d6 * d6;
                        if (!(d7 > d4)) continue;
                        d4 = d7;
                    }
                }
            }
            double d8 = 1000000.0;
            double d9 = d8 / d4;
            double d10 = d2 = (d = d9 * d4);
            for (int i = n; i < n3 - n; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(i);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                n7 = n4 * i;
                for (int j = n; j < n4 - n; ++j) {
                    double d11;
                    int n14;
                    n6 = j + n7;
                    for (n14 = 0; n14 < n2; ++n14) {
                        dArray2[n14] = 0.0;
                        dArray3[n14] = 0.0;
                    }
                    for (n14 = i - n; n14 <= i + n; ++n14) {
                        n5 = n4 * n14;
                        for (int k = j - n; k <= j + n; ++k) {
                            int n15 = 0;
                            while (n15 < n2) {
                                d11 = this.data[n15][k + n5];
                                int n16 = n15;
                                dArray2[n16] = dArray2[n16] + d11;
                                int n17 = n15++;
                                dArray3[n17] = dArray3[n17] + d11 * d11;
                            }
                        }
                    }
                    for (n14 = 0; n14 < n2; ++n14) {
                        d11 = d3 * dArray3[n14];
                        double d12 = d3 * dArray2[n14];
                        double d13 = d11 - d12 * d12;
                        d = d9 * d13;
                        if (d >= d8) {
                            d = d8;
                        } else if (d13 < 0.0) {
                            d = 0.0;
                        }
                        dArray[n14][n6] = d;
                        if (d < d2) {
                            d2 = d;
                            continue;
                        }
                        if (!(d > d10)) continue;
                        d10 = d;
                    }
                }
            }
            if (null != progressMonitor) {
                progressMonitor.close();
            }
            if (d10 - d2 < 1.0) {
                d10 = d2 + 1.0;
            }
            this.extremesDouble = new RangeDouble(d2, d10);
            this.data = dArray;
            timer.stop();
        }
    }
}

