/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import net.grelf.Interpolator;
import net.grelf.PointFloat;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.ControlPointsDialogue;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.MatchPair;
import net.grelf.grip.PointList;
import net.grelf.image.Image;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;

public class Warp {
    private static final double EPSILON = 1.0E-10;

    private Warp() {
    }

    private static double sign(double d, double d2) {
        return d2 >= 0.0 ? StrictMath.abs(d) : -StrictMath.abs(d);
    }

    private static double pythag(double d, double d2) {
        double d3;
        double d4 = StrictMath.abs(d);
        if (d4 > (d3 = StrictMath.abs(d2))) {
            double d5 = d3 / d4;
            return d4 * StrictMath.sqrt(1.0 + d5 * d5);
        }
        if (0.0 == d3) {
            return 0.0;
        }
        double d6 = d4 / d3;
        return d3 * StrictMath.sqrt(1.0 + d6 * d6);
    }

    private static double[] backSubstitute(double[][] dArray, double[] dArray2, double[][] dArray3, int n, int n2, double[] dArray4) {
        int n3;
        double d;
        int n4;
        double[] dArray5 = new double[n2 + 1];
        double[] dArray6 = new double[n2 + 1];
        for (n4 = 1; n4 <= n2; ++n4) {
            d = 0.0;
            if (dArray2[n4] != 0.0) {
                for (n3 = 1; n3 <= n; ++n3) {
                    d += dArray[n3][n4] * dArray4[n3];
                }
                d /= dArray2[n4];
            }
            dArray5[n4] = d;
        }
        for (n4 = 1; n4 <= n2; ++n4) {
            d = 0.0;
            for (n3 = 1; n3 <= n2; ++n3) {
                d += dArray3[n4][n3] * dArray5[n3];
            }
            dArray6[n4] = d;
        }
        return dArray6;
    }

    private static void decompose(double[][] dArray, int n, int n2, double[] dArray2, double[][] dArray3) {
        int n3;
        double d;
        double d2;
        int n4;
        double d3;
        int n5;
        int n6 = 0;
        int n7 = 0;
        double[] dArray4 = new double[n2 + 1];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n5 = 1; n5 <= n2; ++n5) {
            n6 = n5 + 1;
            dArray4[n5] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n5 <= n) {
                for (n4 = n5; n4 <= n; ++n4) {
                    d5 += StrictMath.abs(dArray[n4][n5]);
                }
                if (d5 != 0.0) {
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray5 = dArray[n4];
                        int n8 = n5;
                        dArray5[n8] = dArray5[n8] / d5;
                        d3 += dArray[n4][n5] * dArray[n4][n5];
                    }
                    d2 = dArray[n5][n5];
                    d6 = -Warp.sign(StrictMath.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    dArray[n5][n5] = d2 - d6;
                    for (n3 = n6; n3 <= n2; ++n3) {
                        d3 = 0.0;
                        for (n4 = n5; n4 <= n; ++n4) {
                            d3 += dArray[n4][n5] * dArray[n4][n3];
                        }
                        d2 = d3 / d;
                        for (n4 = n5; n4 <= n; ++n4) {
                            double[] dArray6 = dArray[n4];
                            int n9 = n3;
                            dArray6[n9] = dArray6[n9] + d2 * dArray[n4][n5];
                        }
                    }
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray7 = dArray[n4];
                        int n10 = n5;
                        dArray7[n10] = dArray7[n10] * d5;
                    }
                }
            }
            dArray2[n5] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n5 <= n && n5 != n2) {
                for (n4 = n6; n4 <= n2; ++n4) {
                    d5 += StrictMath.abs(dArray[n5][n4]);
                }
                if (d5 != 0.0) {
                    for (n4 = n6; n4 <= n2; ++n4) {
                        double[] dArray8 = dArray[n5];
                        int n11 = n4;
                        dArray8[n11] = dArray8[n11] / d5;
                        d3 += dArray[n5][n4] * dArray[n5][n4];
                    }
                    d2 = dArray[n5][n6];
                    d6 = -Warp.sign(StrictMath.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    dArray[n5][n6] = d2 - d6;
                    for (n4 = n6; n4 <= n2; ++n4) {
                        dArray4[n4] = dArray[n5][n4] / d;
                    }
                    for (n3 = n6; n3 <= n; ++n3) {
                        d3 = 0.0;
                        for (n4 = n6; n4 <= n2; ++n4) {
                            d3 += dArray[n3][n4] * dArray[n5][n4];
                        }
                        for (n4 = n6; n4 <= n2; ++n4) {
                            double[] dArray9 = dArray[n3];
                            int n12 = n4;
                            dArray9[n12] = dArray9[n12] + d3 * dArray4[n4];
                        }
                    }
                    n4 = n6;
                    while (n4 <= n2) {
                        double[] dArray10 = dArray[n5];
                        int n13 = n4++;
                        dArray10[n13] = dArray10[n13] * d5;
                    }
                }
            }
            d4 = StrictMath.max(d4, StrictMath.abs(dArray2[n5]) + StrictMath.abs(dArray4[n5]));
        }
        n5 = n2;
        while (n5 >= 1) {
            if (n5 < n2) {
                if (d6 != 0.0) {
                    for (n3 = n6; n3 <= n2; ++n3) {
                        dArray3[n3][n5] = dArray[n5][n3] / dArray[n5][n6] / d6;
                    }
                    for (n3 = n6; n3 <= n2; ++n3) {
                        d3 = 0.0;
                        for (n4 = n6; n4 <= n2; ++n4) {
                            d3 += dArray[n5][n4] * dArray3[n4][n3];
                        }
                        for (n4 = n6; n4 <= n2; ++n4) {
                            double[] dArray11 = dArray3[n4];
                            int n14 = n3;
                            dArray11[n14] = dArray11[n14] + d3 * dArray3[n4][n5];
                        }
                    }
                }
                for (n3 = n6; n3 <= n2; ++n3) {
                    dArray3[n3][n5] = 0.0;
                    dArray3[n5][n3] = 0.0;
                }
            }
            dArray3[n5][n5] = 1.0;
            d6 = dArray4[n5];
            n6 = n5--;
        }
        n5 = StrictMath.min(n, n2);
        while (n5 >= 1) {
            n6 = n5 + 1;
            d6 = dArray2[n5];
            for (n3 = n6; n3 <= n2; ++n3) {
                dArray[n5][n3] = 0.0;
            }
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                for (n3 = n6; n3 <= n2; ++n3) {
                    d3 = 0.0;
                    for (n4 = n6; n4 <= n; ++n4) {
                        d3 += dArray[n4][n5] * dArray[n4][n3];
                    }
                    d2 = d3 / dArray[n5][n5] * d6;
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray12 = dArray[n4];
                        int n15 = n3;
                        dArray12[n15] = dArray12[n15] + d2 * dArray[n4][n5];
                    }
                }
                for (n3 = n5; n3 <= n; ++n3) {
                    double[] dArray13 = dArray[n3];
                    int n16 = n5;
                    dArray13[n16] = dArray13[n16] * d6;
                }
            } else {
                for (n3 = n5; n3 <= n; ++n3) {
                    dArray[n3][n5] = 0.0;
                }
            }
            double[] dArray14 = dArray[n5];
            int n17 = n5--;
            dArray14[n17] = dArray14[n17] + 1.0;
        }
        block27: for (n4 = n2; n4 >= 1; --n4) {
            for (int i = 0; i < 30; ++i) {
                double d7;
                double d8;
                double d9;
                boolean bl = true;
                for (n6 = n4; n6 >= 1; --n6) {
                    n7 = n6 - 1;
                    if (StrictMath.abs(dArray4[n6]) + d4 == d4) {
                        bl = false;
                        break;
                    }
                    if (StrictMath.abs(dArray2[n7]) + d4 == d4) break;
                }
                if (bl) {
                    d9 = 0.0;
                    d3 = 1.0;
                    for (n5 = n6; n5 <= n4; ++n5) {
                        d2 = d3 * dArray4[n5];
                        dArray4[n5] = d9 * dArray4[n5];
                        if (StrictMath.abs(d2) + d4 == d4) break;
                        d6 = dArray2[n5];
                        dArray2[n5] = d = Warp.pythag(d2, d6);
                        d = 1.0 / d;
                        d9 = d6 * d;
                        d3 = -d2 * d;
                        for (n3 = 0; n3 < n; ++n3) {
                            d8 = dArray[n3][n7];
                            d7 = dArray[n3][n5];
                            dArray[n3][n7] = d8 * d9 + d7 * d3;
                            dArray[n3][n5] = d7 * d9 - d8 * d3;
                        }
                    }
                }
                d7 = dArray2[n4];
                if (n6 == n4) {
                    if (!(d7 < 0.0)) continue block27;
                    dArray2[n4] = -d7;
                    for (n3 = 1; n3 <= n2; ++n3) {
                        dArray3[n3][n4] = -dArray3[n3][n4];
                    }
                    continue block27;
                }
                if (i >= 30) {
                    Util.warning("Error", "Did not converge in 30 iterations");
                }
                double d10 = dArray2[n6];
                n7 = n4 - 1;
                d8 = dArray2[n7];
                d6 = dArray4[n7];
                d = dArray4[n4];
                d2 = ((d8 - d7) * (d8 + d7) + (d6 - d) * (d6 + d)) / (2.0 * d * d8);
                d6 = Warp.pythag(d2, 1.0);
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + Warp.sign(d6, d2)) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                for (n3 = n6; n3 <= n7; ++n3) {
                    int n18;
                    n5 = n3 + 1;
                    d6 = dArray4[n5];
                    d8 = dArray2[n5];
                    d = d3 * d6;
                    d6 = d9 * d6;
                    dArray4[n3] = d7 = Warp.pythag(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d6 * d3;
                    d6 = d6 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    for (n18 = 1; n18 <= n2; ++n18) {
                        d10 = dArray3[n18][n3];
                        d7 = dArray3[n18][n5];
                        dArray3[n18][n3] = d10 * d9 + d7 * d3;
                        dArray3[n18][n5] = d7 * d9 - d10 * d3;
                    }
                    dArray2[n3] = d7 = Warp.pythag(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d6 + d3 * d8;
                    d10 = d9 * d8 - d3 * d6;
                    for (n18 = 1; n18 <= n; ++n18) {
                        d8 = dArray[n18][n3];
                        d7 = dArray[n18][n5];
                        dArray[n18][n3] = d8 * d9 + d7 * d3;
                        dArray[n18][n5] = d7 * d9 - d8 * d3;
                    }
                }
                dArray4[n6] = 0.0;
                dArray4[n4] = d2;
                dArray2[n4] = d10;
            }
        }
    }

    public static void warp(BufferedImage bufferedImage, PointFloat[] pointFloatArray, BufferedImage bufferedImage2, PointFloat[] pointFloatArray2) {
        int n = pointFloatArray.length;
        double[][] dArray = new double[n + 1][10];
        double[] dArray2 = new double[10];
        double[][] dArray3 = new double[10][10];
        double[] dArray4 = new double[n + 1];
        double[] dArray5 = new double[n + 1];
        for (int i = 1; i <= n; ++i) {
            dArray[i][1] = 1.0;
            dArray[i][2] = pointFloatArray2[i - 1].y;
            dArray[i][3] = dArray[i][2] * dArray[i][2];
            dArray[i][4] = pointFloatArray2[i - 1].x;
            dArray[i][5] = dArray[i][4] * dArray[i][2];
            dArray[i][6] = dArray[i][4] * dArray[i][3];
            dArray[i][7] = dArray[i][4] * dArray[i][4];
            dArray[i][8] = dArray[i][7] * dArray[i][2];
            dArray[i][9] = dArray[i][7] * dArray[i][3];
            dArray4[i] = pointFloatArray[i - 1].x;
            dArray5[i] = pointFloatArray[i - 1].y;
        }
        Warp.decompose(dArray, n, 9, dArray2, dArray3);
        double d = 9.0E-10;
        for (int i = 1; i <= 9; ++i) {
            if (!(dArray2[i] < d)) continue;
            dArray2[i] = 0.0;
        }
        double[] dArray6 = Warp.backSubstitute(dArray, dArray2, dArray3, n, 9, dArray4);
        double[] dArray7 = Warp.backSubstitute(dArray, dArray2, dArray3, n, 9, dArray5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n2 = writableRaster2.getWidth();
        int n3 = writableRaster2.getHeight();
        for (int i = 0; i < n3; ++i) {
            double d2 = i;
            double d3 = d2 * d2;
            double d4 = dArray6[1] + dArray6[2] * d2 + dArray6[3] * d3;
            double d5 = dArray7[1] + dArray7[2] * d2 + dArray7[3] * d3;
            for (int j = 0; j < n2; ++j) {
                double d6 = j;
                double d7 = d6 * d2;
                double d8 = d6 * d3;
                double d9 = d6 * d6;
                double d10 = d9 * d2;
                double d11 = d9 * d3;
                double d12 = d4 + dArray6[4] * d6 + dArray6[5] * d7 + dArray6[6] * d8 + dArray6[7] * d9 + dArray6[8] * d10 + dArray6[9] * d11;
                double d13 = d5 + dArray7[4] * d6 + dArray7[5] * d7 + dArray7[6] * d8 + dArray7[7] * d9 + dArray7[8] * d10 + dArray7[9] * d11;
                writableRaster2.setPixel(j, i, Interpolator.getPixel(writableRaster, d12, d13));
            }
        }
    }

    public static void warp(Image image, PointFloat[] pointFloatArray, Image image2, PointFloat[] pointFloatArray2) {
        boolean bl = image2 instanceof Image64;
        int n = pointFloatArray.length;
        double[][] dArray = new double[n + 1][10];
        double[] dArray2 = new double[10];
        double[][] dArray3 = new double[10][10];
        double[] dArray4 = new double[n + 1];
        double[] dArray5 = new double[n + 1];
        for (int i = 1; i <= n; ++i) {
            dArray[i][1] = 1.0;
            dArray[i][2] = pointFloatArray2[i - 1].y;
            dArray[i][3] = dArray[i][2] * dArray[i][2];
            dArray[i][4] = pointFloatArray2[i - 1].x;
            dArray[i][5] = dArray[i][4] * dArray[i][2];
            dArray[i][6] = dArray[i][4] * dArray[i][3];
            dArray[i][7] = dArray[i][4] * dArray[i][4];
            dArray[i][8] = dArray[i][7] * dArray[i][2];
            dArray[i][9] = dArray[i][7] * dArray[i][3];
            dArray4[i] = pointFloatArray[i - 1].x;
            dArray5[i] = pointFloatArray[i - 1].y;
        }
        Warp.decompose(dArray, n, 9, dArray2, dArray3);
        double d = 9.0E-10;
        for (int i = 1; i <= 9; ++i) {
            if (!(dArray2[i] < d)) continue;
            dArray2[i] = 0.0;
        }
        double[] dArray6 = Warp.backSubstitute(dArray, dArray2, dArray3, n, 9, dArray4);
        double[] dArray7 = Warp.backSubstitute(dArray, dArray2, dArray3, n, 9, dArray5);
        int n2 = image2.getWidth();
        int n3 = image2.getHeight();
        for (int i = 0; i < n3; ++i) {
            double d2 = i;
            double d3 = d2 * d2;
            double d4 = dArray6[1] + dArray6[2] * d2 + dArray6[3] * d3;
            double d5 = dArray7[1] + dArray7[2] * d2 + dArray7[3] * d3;
            for (int j = 0; j < n2; ++j) {
                double d6 = j;
                double d7 = d6 * d2;
                double d8 = d6 * d3;
                double d9 = d6 * d6;
                double d10 = d9 * d2;
                double d11 = d9 * d3;
                double d12 = d4 + dArray6[4] * d6 + dArray6[5] * d7 + dArray6[6] * d8 + dArray6[7] * d9 + dArray6[8] * d10 + dArray6[9] * d11;
                double d13 = d5 + dArray7[4] * d6 + dArray7[5] * d7 + dArray7[6] * d8 + dArray7[7] * d9 + dArray7[8] * d10 + dArray7[9] * d11;
                if (bl) {
                    image2.setPixelDouble(j, i, image.getPixelDoubleInterpolated(d12, d13));
                    continue;
                }
                image2.setPixel(j, i, image.getPixelInterpolated(d12, d13));
            }
        }
    }

    public static BufferedImage warp(BufferedImage bufferedImage, int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) {
        int n4;
        Timer timer = new Timer("Warp.warp", bufferedImage);
        BufferedImage bufferedImage2 = null;
        ArrayList<MatchPair> arrayList = new ArrayList<MatchPair>();
        for (MatchPair pointFloatArray2 : list) {
            int n5;
            MatchPair matchPair;
            if (pointFloatArray2.blobNo1 >= n3 || pointFloatArray2.blobNo2 >= n3) continue;
            if (pointFloatArray2.imNo2 == n && null != (matchPair = MatchPair.findBlobInMiddleImage(n, n5 = pointFloatArray2.blobNo2, n2))) {
                arrayList.add(matchPair);
            }
            if (pointFloatArray2.imNo1 != n || null == (matchPair = MatchPair.findBlobInMiddleImage(n, n5 = pointFloatArray2.blobNo1, n2))) continue;
            arrayList.add(matchPair);
        }
        int n6 = arrayList.size();
        if (n6 == 0) {
            Util.warning("Error", "No relevant matches found for warping image " + (n + 1));
            arrayList = null;
            return null;
        }
        PointFloat[] pointFloatArray = new PointFloat[n6];
        PointFloat[] pointFloatArray2 = new PointFloat[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            MatchPair matchPair = (MatchPair)arrayList.get(n4);
            PointFloat pointFloat = blobMeasArray[matchPair.imNo1][matchPair.blobNo1].centre;
            PointFloat pointFloat2 = blobMeasArray[matchPair.imNo2][matchPair.blobNo2].centre;
            int n7 = (int)pointFloat.x;
            int n8 = (int)pointFloat.y;
            int n9 = (int)pointFloat2.x;
            int n10 = (int)pointFloat2.y;
            pointFloatArray[n4] = new PointFloat(n9, n10);
            pointFloatArray2[n4] = new PointFloat(n7, n8);
        }
        n4 = bufferedImage.getWidth();
        int n11 = bufferedImage.getHeight();
        bufferedImage2 = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster().createCompatibleWritableRaster(n4, n11), bufferedImage.isAlphaPremultiplied(), null);
        Warp.warp(bufferedImage, pointFloatArray, bufferedImage2, pointFloatArray2);
        Object var10_13 = null;
        pointFloatArray2 = null;
        arrayList = null;
        timer.stop();
        return bufferedImage2;
    }

    public static void interactiveWarp(ImFrame imFrame, ImFrame imFrame2) {
        Image image = imFrame.getImPane().getImage();
        Image image2 = imFrame2.getImPane().getImage();
        if (!(image instanceof Image8or16Base) || !(image2 instanceof Image8or16Base)) {
            Util.warning(imFrame, "Sorry", (Object)"Not available for images having more than 16 bits per channel");
            return;
        }
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        GlassPane glassPane2 = imFrame2.getImPane().getGlassPane();
        PointList pointList = glassPane.getPoints();
        PointList pointList2 = glassPane2.getPoints();
        if (pointList.size() != pointList2.size()) {
            Util.warning("Sorry", "You must have the same number of control points in both images. Cannot proceed.");
        } else {
            Object object;
            int n = pointList.size();
            if (n < 9) {
                Util.warning("Advice", "You should really have at least 9 pairs of control points, for accurate warping.");
            }
            for (int i = 0; i < n; ++i) {
                object = ControlPointsDialogue.askControl(i, imFrame, pointList.get(i), imFrame2, pointList2.get(i));
                if (null == object) continue;
                pointList.get((int)i).x = ((Point)object.get((int)0)).x;
                pointList.get((int)i).y = ((Point)object.get((int)0)).y;
                pointList2.get((int)i).x = ((Point)object.get((int)1)).x;
                pointList2.get((int)i).y = ((Point)object.get((int)1)).y;
            }
            if (Util.confirm("Confirm", "Proceed to do the warping?")) {
                PointFloat[] pointFloatArray = new PointFloat[n];
                object = new PointFloat[n];
                for (int i = 0; i < n; ++i) {
                    pointFloatArray[i] = new PointFloat(pointList2.get(i));
                    object[i] = new PointFloat(pointList.get(i));
                }
                Warp.warp(((Image8or16Base)image).getBufferedImage(), pointFloatArray, ((Image8or16Base)image2).getBufferedImage(), (PointFloat[])object);
                glassPane.setPoints(new PointList(glassPane2.getPoints()));
            }
        }
    }
}

