/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.BlobFrame;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Config;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.StarMeasFrame;
import net.grelf.grip.StarSegmenter;

public class StarMeasProcessor
implements Runnable {
    private File[] files;
    private int imNo = 0;
    private int dParam = -1;
    private int rParam = -1;
    private BlobMeasList starMeases;
    private ImFrame frame;
    private BlobMeasList blobMeasesThisFrame;
    private PrintWriter out;
    private boolean auto = true;
    private List<PointFloat> points;

    public void addPoint(PointFloat pointFloat) {
        this.points.add(pointFloat);
    }

    public StarMeasProcessor() {
        try {
            this.dParam = Integer.parseInt(Config.getValue("StarSegmentDifference.value"));
            this.rParam = Integer.parseInt(Config.getValue("StarSegmentRadius.value"));
        }
        catch (NumberFormatException numberFormatException) {
            String string = "Config values missing for StarSegmenter parameters.\nTry deleting file grip.properties and re-running GRIP.";
            Util.warning("Error", string);
        }
    }

    @Override
    public void run() {
        if (this.dParam > 0 && this.rParam > 0) {
            String string;
            this.files = FileIO.selectInputFiles("Images to process");
            if (null != this.files && this.files.length > 0 && null != (string = FileIO.selectOutputFile("Output CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "measured.csv"))) {
                this.auto = Util.confirm("Automatic or manual", "Automatic?");
                this.points = Collections.synchronizedList(new ArrayList());
                try {
                    this.out = new PrintWriter(string);
                    this.imNo = 0;
                    this.processNext();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Util.warning("Error", fileNotFoundException.toString());
                }
            }
        }
    }

    protected void process() {
        Serializable serializable;
        int n;
        if (this.imNo == 0) {
            this.out.print("Image");
            for (n = 1; n <= this.points.size(); ++n) {
                serializable = new StringBuffer(",x");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",y");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",Npx");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",R");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",G");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",B");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",SN_R");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",SN_G");
                ((StringBuffer)serializable).append(n);
                ((StringBuffer)serializable).append(",SN_B");
                ((StringBuffer)serializable).append(n);
                this.out.print(((StringBuffer)serializable).toString());
            }
            this.out.println();
        }
        if (this.imNo >= 0 && null != this.frame) {
            this.out.print(this.files[this.imNo].getName());
            for (n = 0; n < this.points.size(); ++n) {
                serializable = this.points.get(n);
                if (this.blobMeasesThisFrame.size() == 0) {
                    System.out.println("Empty blobMeasesThisFrame");
                }
                BlobMeas blobMeas = this.blobMeasesThisFrame.getNearestBlob(Math.round(((PointFloat)serializable).x), Math.round(((PointFloat)serializable).y));
                BlobFrame blobFrame = blobMeas.blob.display(this.frame, blobMeas);
                blobMeas.blob.measureAccurately(blobMeas, this.frame);
                this.starMeases.add(blobMeas);
                this.fileMeasurements(blobMeas);
                blobFrame.dispose();
            }
            this.out.println();
            this.blobMeasesThisFrame.clear();
            if (this.frame instanceof StarMeasFrame) {
                ((StarMeasFrame)this.frame).disposeFrame();
            } else {
                this.frame.dispose();
            }
            System.out.println("Memory:" + Runtime.getRuntime().freeMemory());
            ++this.imNo;
            if (this.imNo < this.files.length) {
                this.processNext();
            } else {
                this.out.close();
                this.displayResult();
            }
        }
    }

    private void processNext() {
        File file = this.files[this.imNo];
        this.frame = this.imNo == 0 ? new StarMeasFrame(this, file) : new ImFrame(file.getPath(), new DefaultMeasurementHandler());
        StarSegmenter.segment(this.frame, this.dParam, this.rParam);
        this.frame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        boolean bl = false;
        this.blobMeasesThisFrame = this.frame.detectBlobs(bl);
        if (null != this.blobMeasesThisFrame && this.blobMeasesThisFrame.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.imNo + 1);
            stringBuffer.append('/');
            stringBuffer.append(this.files.length);
            stringBuffer.append(']');
            if (0 == this.imNo || !this.auto) {
                this.starMeases = new BlobMeasList(this.frame);
                stringBuffer.append(" Click on star(s) to measure. Close window to proceed");
                this.frame.setTitle(stringBuffer.toString());
                this.frame.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
                this.frame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            } else {
                this.frame.setTitle(stringBuffer.toString());
                this.process();
            }
        } else {
            Util.warning(this.frame, "Error", (Object)"No stars detected");
            this.imNo = -1;
            this.frame.dispose();
        }
    }

    private void fileMeasurements(BlobMeas blobMeas) {
        int n;
        this.out.print(",");
        this.out.print(blobMeas.centre.x);
        this.out.print(",");
        this.out.print(blobMeas.centre.y);
        this.out.print(",");
        this.out.print(blobMeas.nPixelsMeasured);
        for (n = 0; n < blobMeas.accurateBrightnesses.length; ++n) {
            this.out.print(",");
            this.out.print(blobMeas.accurateBrightnesses[n]);
        }
        for (n = 0; n < blobMeas.snRatios.length; ++n) {
            this.out.print(",");
            this.out.print(blobMeas.snRatios[n]);
        }
        this.out.flush();
    }

    private void displayResult() {
        Util.message("DONE", this.files.length + " images processed");
    }
}

