/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.Histogram;
import net.grelf.grip.ImFrame;
import net.grelf.grip.PointList;
import net.grelf.image.Image;
import net.grelf.image.ImageBase;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;
import net.grelf.image.Timer;

public class Spectrum {
    public void analyse(ImFrame imFrame, PointList pointList) {
        boolean bl;
        int n;
        int n2;
        imFrame.popCaption();
        Image image = imFrame.getImPane().getImage();
        Timer timer = new Timer("Spectrum.analyse", image);
        image.crop(pointList.get(0), pointList.get(1));
        Histogram histogram = new Histogram(image);
        Statistics[] statisticsArray = histogram.getStatistics();
        int n3 = image.getNBands();
        int n4 = image.getRange().high;
        RangeInt[] rangeIntArray = new RangeInt[n3];
        for (int i = 0; i < n3; ++i) {
            int n5 = n4 - (int)(0.9 * ((double)n4 - statisticsArray[i].mean));
            rangeIntArray[i] = new RangeInt(n5, n4);
        }
        Threshold threshold = new Threshold(n3);
        threshold.th = rangeIntArray;
        threshold.anding = false;
        imFrame.threshold(threshold);
        if (!Util.confirm(imFrame, "Auto-thresholded", "OK so far?")) {
            return;
        }
        BlobMeasList blobMeasList = imFrame.detectBlobs(false);
        imFrame.setBlobMeases(blobMeasList);
        imFrame.getGP().setDrawingMode(DrawingMode.UNDEFINED);
        double d = ((BlobMeas)blobMeasList.get((int)1)).centre.x - ((BlobMeas)blobMeasList.get((int)0)).centre.x;
        double d2 = ((BlobMeas)blobMeasList.get((int)1)).centre.y - ((BlobMeas)blobMeasList.get((int)0)).centre.y;
        double d3 = Math.toDegrees(Math.atan2(d2, d));
        imFrame.rotate(d3);
        if (!Util.confirm(imFrame, "Rotated by " + d3 + " degrees", "OK so far?")) {
            return;
        }
        imFrame.threshold(threshold);
        if (!Util.confirm(imFrame, "Re-thresholded", "OK so far?")) {
            return;
        }
        blobMeasList = imFrame.detectBlobs(false);
        imFrame.setBlobMeases(blobMeasList);
        imFrame.getGP().setDrawingMode(DrawingMode.UNDEFINED);
        if (((BlobMeas)blobMeasList.get((int)0)).area < ((BlobMeas)blobMeasList.get((int)1)).area) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 1;
            n = 0;
        }
        BlobMeas blobMeas = (BlobMeas)blobMeasList.get(n2);
        BlobMeas blobMeas2 = (BlobMeas)blobMeasList.get(n);
        boolean bl2 = bl = blobMeas.centre.x < blobMeas2.centre.x;
        if (!bl) {
            imFrame.flipHorizontal();
        }
        if (!Util.confirm(imFrame, "Star is on the left", "OK so far?")) {
            return;
        }
        int n6 = blobMeas.minY;
        int n7 = blobMeas.maxY;
        Util.logInfo("yMin=" + n6);
        Util.logInfo("yMax=" + n7);
        image = this.realign(image, n6, n7);
        imFrame.getImPane().setImage(image);
        imFrame.redisplay();
        if (!Util.confirm(imFrame, "Spectrum realigned", "OK so far?")) {
            return;
        }
        image.averageVertically(n6, n7);
        imFrame.redisplay();
        if (!Util.confirm(imFrame, "Averaged vertically", "OK so far?")) {
            return;
        }
        image.autoStretch(true);
        imFrame.redisplay();
        if (!Util.confirm(imFrame, "Spectrum contrast stretched", "OK so far?")) {
            return;
        }
        PointList pointList2 = new PointList(new DefaultMeasurementHandler());
        int n8 = (n6 + n7) / 2;
        pointList2.add(new Point(10, n8));
        pointList2.add(new Point(image.getWidth() - 1, n8));
        pointList2.measureLine(imFrame);
        timer.stop();
    }

    private Image realign(Image image, int n, int n2) {
        Timer timer = new Timer("Spectrum.realign", image);
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int n5 = image.getNBands();
        Image image2 = ImageBase.createImage(n3, n4, n5, image.getBitsPerChannel());
        int[] nArray = new int[n5];
        for (int i = n; i <= n2; ++i) {
            int n6;
            int n7;
            int n8 = 0;
            int n9 = 0;
            for (n7 = 0; n7 < n3; ++n7) {
                nArray = image.getPixel(n7, i);
                n6 = 0;
                for (int j = 0; j < n5; ++j) {
                    n6 += nArray[j];
                }
                if (n6 <= n8) continue;
                n8 = n6;
                n9 = n7;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                n6 = n7 - n9 + 10;
                if (n6 < 0 || n6 >= n3) continue;
                nArray = image.getPixel(n7, i);
                image2.setPixel(n6, i, nArray);
            }
        }
        timer.stop();
        return image2;
    }
}

