/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.grelf.grip.Config;
import net.grelf.grip.ImFrame;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;

public class MagnifiedFrame
extends ImFrame {
    private static final int PIXEL_SIZE = 5;

    private MagnifiedFrame(String string, int n, int n2, boolean bl) {
        super(string, n, n2, bl);
    }

    public static MagnifiedFrame create(int n, int n2, ImFrame imFrame) {
        int n3;
        try {
            n3 = Math.abs(Integer.parseInt(Config.getValue("Magnifier.px.value")));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 50;
        }
        int n4 = n3;
        int n5 = n3 * 5;
        int n6 = n4 * 5;
        StringBuffer stringBuffer = new StringBuffer("@(");
        stringBuffer.append(n);
        stringBuffer.append(", ");
        stringBuffer.append(n2);
        stringBuffer.append("), pixels x");
        stringBuffer.append(5);
        MagnifiedFrame magnifiedFrame = new MagnifiedFrame(stringBuffer.toString(), n5, n6, true);
        magnifiedFrame.parentFrame = imFrame;
        Image image = imFrame.getImPane().getImage();
        int n7 = image.getNBands();
        Image image2 = ImageBase.createImage(n5, n6, n7, 16);
        BufferedImage bufferedImage = ((Image8or16Base)image2).getBufferedImage();
        magnifiedFrame.getImPane().setImage(image2);
        int n8 = image.getWidth();
        int n9 = image.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        double d = (double)Image8or16Base.getMaxLevel(bufferedImage) / image.getRangeDouble().high;
        int n10 = 0;
        int n11 = n2 - n4 / 2;
        int n12 = 0;
        while (n12 < n4 && n10 < n6) {
            int n13 = 0;
            int n14 = n - n3 / 2;
            int n15 = 0;
            while (n15 < n3 && n13 < n5) {
                if (n14 >= 0 && n14 < n8 && n11 >= 0 && n11 < n9) {
                    int n16;
                    nArray = image.getPixel(n14, n11);
                    for (n16 = 0; n16 < n7; ++n16) {
                        nArray[n16] = (int)((double)nArray[n16] * d);
                    }
                    for (n16 = 0; n16 < 5; ++n16) {
                        for (int i = 0; i < 5; ++i) {
                            writableRaster.setPixel(n13 + i, n10 + n16, nArray);
                        }
                    }
                }
                ++n15;
                ++n14;
                n13 += 5;
            }
            ++n12;
            ++n11;
            n10 += 5;
        }
        magnifiedFrame.redisplay();
        return magnifiedFrame;
    }
}

