/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.Util;
import net.grelf.grip.BlobFrame;
import net.grelf.grip.BlobGraph;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.ColourGraph;
import net.grelf.grip.Config;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.HistogramBlobs;
import net.grelf.grip.ImColourDialogue;
import net.grelf.grip.ImContourDialogue;
import net.grelf.grip.ImCurveDialogue;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.ImSaturateDialogue;
import net.grelf.grip.Pseudocolour;
import net.grelf.grip.Raw;
import net.grelf.grip.StarSegmenter;
import net.grelf.grip.WarpingGrid;
import net.grelf.image.Image;

public class LevelsMenu
extends JMenu
implements ActionListener,
MenuListener {
    private ImFrame imframe;
    private JMenuItem itemRaw;
    private JMenuItem itemDefect;
    private JMenuItem item8bpc;
    private JMenuItem item16bpc;
    private JMenuItem item32bpc;
    private JMenuItem item64bpc;
    private JMenuItem itemMono;
    private JMenuItem itemSplitIntensity;
    private JMenuItem itemSplitChannels;
    private JMenuItem itemMultiply;
    private JMenuItem itemBlobMeas;
    private JMenuItem itemBlobBright;
    private JMenuItem itemBlobDrawB;
    private JMenuItem itemBlobDrawR;
    private JMenuItem itemBackgr;
    private JMenuItem itemBlobHover;
    private JMenuItem itemBlobSave;
    private JMenuItem itemPseudo;
    private JMenuItem itemSaturate;
    private JMenuItem itemAuto;
    private JMenuItem itemEqualise;
    private JMenuItem itemWarping;
    private JMenuItem itemClearOverlay;
    private JMenuItem itemDrawOverlay;
    private BlobMeasList blobMeases = null;
    private Pseudocolour lut = null;

    public void setBlobMeases(BlobMeasList blobMeasList) {
        this.blobMeases = blobMeasList;
    }

    public void reviseSettings() {
        Image image = this.imframe.getImPane().getImage();
        int n = image.getBitsPerChannel();
        int n2 = image.getNBands();
        if (image.isRaw()) {
            this.itemDefect.setEnabled(true);
            this.itemRaw.setEnabled(true);
            this.itemEqualise.setEnabled(false);
        } else {
            this.itemDefect.setEnabled(false);
            this.itemRaw.setEnabled(false);
            this.itemEqualise.setEnabled(true);
        }
        switch (n) {
            case 8: {
                this.item8bpc.setEnabled(false);
                this.item16bpc.setEnabled(true);
                this.item32bpc.setEnabled(false);
                this.item64bpc.setEnabled(false);
                break;
            }
            case 16: {
                this.item8bpc.setEnabled(true);
                this.item16bpc.setEnabled(false);
                this.item32bpc.setEnabled(true);
                this.item64bpc.setEnabled(false);
                break;
            }
            case 32: {
                this.item8bpc.setEnabled(false);
                this.item16bpc.setEnabled(true);
                this.item32bpc.setEnabled(false);
                this.item64bpc.setEnabled(true);
                break;
            }
            case 64: {
                this.item8bpc.setEnabled(false);
                this.item16bpc.setEnabled(false);
                this.item32bpc.setEnabled(true);
                this.item64bpc.setEnabled(false);
                this.itemEqualise.setEnabled(false);
            }
        }
        if (n2 == 1) {
            this.itemSaturate.setEnabled(false);
            this.itemSplitChannels.setEnabled(false);
            this.itemSplitIntensity.setEnabled(false);
        } else {
            this.itemSaturate.setEnabled(true);
            this.itemSplitChannels.setEnabled(true);
            this.itemSplitIntensity.setEnabled(true);
        }
        if (n2 == 3) {
            this.itemMono.setEnabled(true);
        } else {
            this.itemMono.setEnabled(false);
        }
        if (null == this.blobMeases) {
            this.itemBlobMeas.setEnabled(false);
            this.itemBlobBright.setEnabled(false);
            this.itemBlobDrawB.setEnabled(false);
            this.itemBlobDrawR.setEnabled(false);
            this.itemBlobHover.setEnabled(false);
            this.itemBlobSave.setEnabled(false);
            this.itemWarping.setEnabled(false);
            this.itemClearOverlay.setEnabled(false);
            this.itemDrawOverlay.setEnabled(false);
        } else {
            this.itemBlobMeas.setEnabled(true);
            this.itemBlobBright.setEnabled(true);
            this.itemBlobDrawB.setEnabled(true);
            this.itemBlobDrawR.setEnabled(true);
            this.itemBlobHover.setEnabled(true);
            this.itemBlobSave.setEnabled(true);
            this.itemWarping.setEnabled(true);
            this.itemClearOverlay.setEnabled(true);
            this.itemDrawOverlay.setEnabled(true);
        }
    }

    public LevelsMenu(ImFrame imFrame) {
        super("Levels");
        this.imframe = imFrame;
        this.setMnemonic('L');
        this.itemDefect = Util.menuItem(this, "Detect defective pixels...", "defects", 70, 0);
        this.add(this.itemDefect);
        this.itemRaw = Util.menuItem(this, "Interpret RAW", "raw", 87, 0);
        this.add(this.itemRaw);
        this.addSeparator();
        JMenu jMenu = new JMenu("Change bit depth");
        this.item8bpc = Util.menuItem(this, "Convert to 8 bits per channel", "8bpc", 56, 0);
        jMenu.add(this.item8bpc);
        this.item16bpc = Util.menuItem(this, "Convert to 16 bits per channel", "16bpc", 49, 0);
        jMenu.add(this.item16bpc);
        this.item32bpc = Util.menuItem(this, "Convert to 32 bits per channel", "32bpc", 51, 0);
        jMenu.add(this.item32bpc);
        this.item64bpc = Util.menuItem(this, "Convert to 64 bits per channel", "64bpc", 54, 0);
        jMenu.add(this.item64bpc);
        this.add(jMenu);
        this.itemMono = Util.menuItem(this, "Convert to monochrome", "mono", 77, 0);
        this.add(this.itemMono);
        this.itemSplitIntensity = Util.menuItem(this, "Split intensity", "splitI", 0, 0);
        this.add(this.itemSplitIntensity);
        this.itemSplitIntensity.setToolTipText("Make mono intensity image plus colour image for later reapplying");
        this.itemSplitChannels = Util.menuItem(this, "Split channels", "split", 80, 0);
        this.add(this.itemSplitChannels);
        this.itemSplitChannels.setToolTipText("Make a separate image for each channel");
        this.addSeparator();
        this.add(Util.menuItem(this, "Invert", "invert", 73, 73));
        this.add(Util.menuItem(this, "Auto-stretch", "autostretch", 65, 76));
        this.add(Util.menuItem(this, "Multiply", "multiply", 0, 0));
        this.itemBackgr = Util.menuItem(this, "Correct background", "background", 71, 0);
        this.add(this.itemBackgr);
        this.itemBackgr.setToolTipText("Assumes background darker than foreground");
        this.add(Util.menuItem(this, "Curves", "curves", 67, 77));
        this.itemEqualise = Util.menuItem(this, "Equalise histogram", "equalise", 81, 0);
        this.add(this.itemEqualise);
        this.addSeparator();
        this.itemSaturate = Util.menuItem(this, "Saturation", "saturation", 83, 85);
        this.add(this.itemSaturate);
        this.add(Util.menuItem(this, "Colour balance", "balance", 76, 0));
        this.add(Util.menuItem(this, "Neutralise background", "neutralise", 78, 0));
        this.itemPseudo = Util.menuItem(this, "Pseudocolour", "pseudo", 69, 0);
        this.add(this.itemPseudo);
        this.itemPseudo.setToolTipText("Changes the image levels, not just the display");
        this.addSeparator();
        JMenu jMenu2 = new JMenu("Segment blobs/stars");
        jMenu2.add(Util.menuItem(this, "Threshold", "threshold", 84, 0));
        jMenu2.add(Util.menuItem(this, "Detect blobs", "blobs", 68, 0));
        this.itemAuto = Util.menuItem(this, "Auto-segment (stars)", "autosegment", 85, 0);
        jMenu2.add(this.itemAuto);
        this.itemAuto.setToolTipText("Assumes bright stars on dark background");
        this.itemBlobMeas = Util.menuItem(this, "Blob/star measurements", "blobmeas", 66, 0);
        jMenu2.add(this.itemBlobMeas);
        this.itemBlobBright = Util.menuItem(this, "Show brightest", "blobbright", 82, 0);
        jMenu2.add(this.itemBlobBright);
        this.itemBlobDrawB = Util.menuItem(this, "Overlay boundaries", "blobdrawB", 0, 0);
        jMenu2.add(this.itemBlobDrawB);
        this.itemBlobDrawR = Util.menuItem(this, "Overlay regions", "blobdrawR", 89, 0);
        jMenu2.add(this.itemBlobDrawR);
        this.itemClearOverlay = Util.menuItem(this, "Clear overlay", "clear", 86, 0);
        jMenu2.add(this.itemClearOverlay);
        this.itemDrawOverlay = Util.menuItem(this, "Draw overlay into new image", "drawoverlay", 0, 0);
        jMenu2.add(this.itemDrawOverlay);
        this.itemBlobHover = Util.menuItem(this, "Hover to view blobs/stars", "blobhover", 72, 0);
        jMenu2.add(this.itemBlobHover);
        this.itemBlobSave = Util.menuItem(this, "Save all blob/star data", "blobsave", 79, 0);
        jMenu2.add(this.itemBlobSave);
        this.itemWarping = Util.menuItem(this, "Make warping grid", "warping", 75, 0);
        jMenu2.add(this.itemWarping);
        this.add(jMenu2);
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 0, 0));
        this.reviseSettings();
        this.addMenuListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        WarpingGrid warpingGrid;
        String string = actionEvent.getActionCommand();
        if (string.equals("16bpc")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            ImPane imPane = this.imframe.getImPane();
            Image image = imPane.getImage();
            imPane.setImage(image.convertToImage16());
            this.imframe.redisplay();
            this.imframe.addHistory("Convert to 16 bits per channel");
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.reviseSettings();
        } else if (string.equals("32bpc")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            ImPane imPane = this.imframe.getImPane();
            Image image = imPane.getImage();
            imPane.setImage(image.convertToImage32());
            this.imframe.redisplay();
            this.imframe.addHistory("Convert to 32 bits per channel");
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.reviseSettings();
        } else if (string.equals("64bpc")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            ImPane imPane = this.imframe.getImPane();
            Image image = imPane.getImage();
            imPane.setImage(image.convertToImage64());
            this.imframe.redisplay();
            this.imframe.addHistory("Convert to 64 bits per channel");
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.reviseSettings();
        } else if (string.equals("8bpc")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            ImPane imPane = this.imframe.getImPane();
            Image image = imPane.getImage();
            imPane.setImage(image.convertToImage8());
            this.imframe.redisplay();
            this.imframe.addHistory("Convert to 8 bits per channel");
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.reviseSettings();
        } else if (string.equals("autostretch")) {
            this.imframe.addHistory("Stretch levels automatically");
            this.imframe.autoStretch();
        } else if (string.equals("autosegment")) {
            try {
                StarSegmenter.segment(this.imframe, Integer.parseInt(Config.getValue("StarSegmentDifference.value")), Integer.parseInt(Config.getValue("StarSegmentRadius.value")));
                this.imframe.addHistory("Segment stars automatically");
                boolean bl = false;
                this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
                this.blobMeases = this.imframe.detectBlobs(bl);
                if (null != this.blobMeases && this.blobMeases.size() > 0) {
                    this.imframe.setBlobMeases(this.blobMeases);
                    this.reviseSettings();
                    this.imframe.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
                } else {
                    Util.message("Sorry", "No stars detected.\nParameters may need adjusting.");
                }
                this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Config values missing for StarSegmenter parameters.\nTry deleting file grip.properties and re-running GRIP.";
                Util.warning(this, "Error", (Object)string2);
            }
        } else if (string.equals("background")) {
            this.imframe.addHistory("Correct background");
            this.imframe.correctBackground();
        } else if (string.equals("balance")) {
            ImColourDialogue.askSettings(this.imframe);
        } else if (string.equals("blobs")) {
            this.imframe.addHistory("Detect blobs");
            boolean bl = !Util.confirm(this.imframe, "Detect blobs", "Ignore 1-pixel blobs?");
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.blobMeases = this.imframe.detectBlobs(bl);
            this.reviseSettings();
            if (null != this.blobMeases) {
                this.imframe.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
            }
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        } else if (string.equals("blobbright")) {
            if (null == this.blobMeases) {
                Util.warning("Sorry", "Blob measurements not available. Detect again.");
            } else {
                this.imframe.addHistory("Show brightest blobs");
                this.blobMeases.showBrightestBlobs(this.imframe);
            }
        } else if (string.equals("blobdrawB")) {
            if (null == this.blobMeases) {
                Util.warning("Sorry", "Blob measurements not available. Detect again.");
            } else {
                this.imframe.addHistory("Draw blob boundaries");
                this.blobMeases.drawBoundaries(this.imframe);
            }
        } else if (string.equals("blobdrawR")) {
            if (null == this.blobMeases) {
                Util.warning("Sorry", "Blob measurements not available. Detect again.");
            } else {
                this.imframe.addHistory("Draw blob regions");
                this.blobMeases.drawRegions(this.imframe);
            }
        } else if (string.equals("blobhover")) {
            if (null == this.blobMeases) {
                Util.warning("Sorry", "Blob measurements not available. Detect again.");
            } else {
                this.imframe.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
            }
        } else if (string.equals("blobmeas")) {
            if (null == this.blobMeases) {
                Util.warning("Sorry", "Blob measurements not available. Detect again.");
            } else if (this.blobMeases.size() == 0) {
                Util.warning("Sorry", "No blobs detected");
            } else {
                this.imframe.addHistory("View blob measurements");
                String string3 = (String)JOptionPane.showInputDialog(this.imframe, "Measurement type?", "Select measurements to show", 3, null, new String[]{"Area & brightness histograms", "Colours (R/G v B/G)", "Brightness v colour index", "Brightness v mean radius", "Most uncircular"}, "Colours (R/G v B/G)");
                if (string3.equals("Area & brightness histograms")) {
                    HistogramBlobs.display(this.imframe, this.blobMeases);
                } else if (string3.equals("Brightness v colour index")) {
                    new ColourGraph(this.blobMeases, ColourGraph.GraphKind.BRIGHTNESS);
                } else if (string3.equals("Colours (R/G v B/G)")) {
                    new ColourGraph(this.blobMeases, ColourGraph.GraphKind.COLOUR);
                } else if (string3.equals("Brightness v mean radius")) {
                    new BlobGraph(this.blobMeases, BlobGraph.GraphKind.RADIUS);
                } else if (string3.equals("Most uncircular")) {
                    this.showUncircular(this.imframe, this.blobMeases);
                }
            }
        } else if (string.equals("blobsave")) {
            this.imframe.saveBlobMeasList();
        } else if (string.equals("clear")) {
            this.imframe.addHistory("Clear overlay");
            this.imframe.getGP().setDrawingMode(DrawingMode.UNDEFINED);
        } else if (string.equals("contour")) {
            ImContourDialogue.interact(this.imframe);
        } else if (string.equals("curves")) {
            ImCurveDialogue.askCurve(this.imframe);
        } else if (string.equals("defects")) {
            Config.defects = Raw.detectDefectivePixels(this.imframe);
        } else if (string.equals("drawoverlay")) {
            this.imframe.drawOverlay(true);
        } else if (string.equals("equalise")) {
            this.imframe.equaliseHistogram();
        } else if (string.equals("help")) {
            HelpMenu.help("pages/level_menu.html");
        } else if (string.equals("invert")) {
            this.imframe.addHistory("Invert");
            this.imframe.invert();
        } else if (string.equals("mono")) {
            this.imframe.addHistory("Convert to monochrome");
            int n = this.imframe.getImPane().getImage().getNBands();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0;
            }
            this.imframe.convertToMonochrome(dArray);
        } else if (string.equals("multiply")) {
            double d = Util.askDouble("Factor by which to multiply levels?", 1.0, 0.001, 1000.0);
            if (!Double.isNaN(d)) {
                this.imframe.multiply(d);
            }
        } else if (string.equals("neutralise")) {
            this.imframe.addHistory("Neutralise background");
            this.imframe.neutraliseBackground();
        } else if (string.equals("pseudo")) {
            this.imframe.addHistory("Pseudocolour");
            Image image = this.imframe.getImPane().getImage();
            this.lut = new Pseudocolour(image);
            this.lut.apply(this.imframe);
        } else if (string.equals("saturation")) {
            ImSaturateDialogue.askSaturate(this.imframe);
        } else if (string.equals("split")) {
            this.imframe.addHistory("Split channels");
            this.imframe.splitChannels();
        } else if (string.equals("splitI")) {
            this.imframe.addHistory("Split intensity");
            this.imframe.splitIntensity();
        } else if (string.equals("raw")) {
            this.imframe.addHistory("Interpret raw");
            Raw.interpret(this.imframe);
            this.itemRaw.setEnabled(false);
            this.itemDefect.setEnabled(false);
        } else if (string.equals("threshold")) {
            this.imframe.addHistory("Threshold");
            this.imframe.threshold();
        } else if (string.equals("warping") && (warpingGrid = new WarpingGrid()).make(this.blobMeases)) {
            warpingGrid.save();
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.reviseSettings();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    private void showUncircular(ImFrame imFrame, BlobMeasList blobMeasList) {
        LinkedList<FormBlob> linkedList = new LinkedList<FormBlob>();
        for (Object object : blobMeasList) {
            double d = ((BlobMeas)object).calculateCircularity();
            FormBlob formBlob = new FormBlob();
            formBlob.formFactor = d;
            formBlob.meas = object;
            if (linkedList.size() == 0) {
                linkedList.add(formBlob);
                continue;
            }
            ListIterator<FormBlob> listIterator = linkedList.listIterator();
            FormBlob formBlob2 = (FormBlob)listIterator.next();
            while (formBlob2.formFactor > formBlob.formFactor && listIterator.hasNext()) {
                formBlob2 = (FormBlob)listIterator.next();
            }
            if (listIterator.hasNext()) {
                listIterator.previous();
            }
            listIterator.add(formBlob);
        }
        boolean bl = true;
        for (FormBlob formBlob : linkedList) {
            if (!bl) continue;
            BlobFrame blobFrame = formBlob.meas.blob.display(imFrame, formBlob.meas);
            bl = Util.confirm("More?", "Form factor = " + formBlob.formFactor + "\nShow next?");
            if (!bl) continue;
            blobFrame.dispose();
        }
    }

    private static class FormBlob {
        double formFactor;
        BlobMeas meas;

        private FormBlob() {
        }
    }
}

