/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import net.grelf.PointFloat;
import net.grelf.astro.Star;
import net.grelf.grip.AssociatedPane;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.CometFrame;
import net.grelf.grip.ConvolutionMenu;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImGraphic;
import net.grelf.grip.MatchPair;
import net.grelf.grip.PointList;
import net.grelf.grip.Prof3D_Pane;
import net.grelf.grip.Pseudocolour;
import net.grelf.grip.Spectrum;
import net.grelf.grip.StarChartFrame;
import net.grelf.grip.StarMeasFrame;
import net.grelf.image.Image16;
import net.grelf.image.ImageLoader;
import net.grelf.image.Kernel;

public class ImPane
extends JComponent
implements Scrollable,
MouseListener,
MouseMotionListener {
    private static final int MIN_SCALE = 1;
    private static final int MAX_SCALE = 10;
    private static final float SCREEN_FRACTION = 0.8f;
    private static final Color BACKGROUND_COLOUR = Color.white;
    private static final Color FOREGROUND_COLOUR = Color.black;
    private static Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    private int scale = 1;
    static final String[] zoomPercents = new String[]{"[100%]", "[50%]", "[33.33%]", "[25%]", "[20%]", "[16.67%]", "[14.29%]", "[12.5%]", "[11.11%]", "[10%]"};
    private net.grelf.image.Image image;
    private BufferedImage scaledImage = null;
    private int ipWidth;
    private int ipHeight;
    private ImFrame parent;
    private GlassPane gp;
    private Pseudocolour ps = null;
    private AssociatedPane ap = null;

    public int getScale() {
        return this.scale;
    }

    public void setInitialScale() {
        this.scale = Math.round(Math.max((float)this.image.getWidth() / ((float)ImPane.screen.width * 0.8f), (float)this.image.getHeight() / ((float)ImPane.screen.height * 0.8f)));
        if (this.scale < 1) {
            this.scale = 1;
        } else if (this.scale > 10) {
            this.scale = 10;
        }
    }

    public net.grelf.image.Image getImage() {
        return this.image;
    }

    protected void setImage(net.grelf.image.Image image) {
        this.image = image;
    }

    public BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    public Point getOrigin() {
        JScrollPane jScrollPane = this.parent.getScrollPane();
        Point point = jScrollPane.getViewport().getViewPosition();
        return point;
    }

    public int getIpWidth() {
        return this.ipWidth;
    }

    public void setIpWidth(int n) {
        this.ipWidth = n;
        this.setPreferredSize(new Dimension(this.ipWidth, this.ipHeight));
        this.revalidate();
    }

    public int getIpHeight() {
        return this.ipHeight;
    }

    public void setIpHeight(int n) {
        this.ipHeight = n;
        this.setPreferredSize(new Dimension(this.ipWidth, this.ipHeight));
        this.revalidate();
    }

    public void setIpSize(int n, int n2) {
        this.ipWidth = n;
        this.ipHeight = n2;
        this.setPreferredSize(new Dimension(this.ipWidth, this.ipHeight));
        this.revalidate();
    }

    public ImFrame getImFrame() {
        return this.parent;
    }

    public GlassPane getGlassPane() {
        return this.gp;
    }

    public boolean isPseudocolour() {
        return null != this.ps;
    }

    protected void setPseudocolour(Pseudocolour pseudocolour) {
        this.ps = pseudocolour;
    }

    public void clearAssociatedPane() {
        this.ap = null;
    }

    public void setAssociatedPane(AssociatedPane associatedPane) {
        this.ap = associatedPane;
    }

    public void dispose() {
        if (null != this.scaledImage) {
            this.scaledImage.flush();
        }
        this.scaledImage = null;
        this.gp = null;
        this.parent = null;
        if (null != this.image) {
            this.image.dispose();
            this.image = null;
        }
        this.image = null;
        this.ap = null;
    }

    public ImPane(ImFrame imFrame, int n, int n2, GlassPane glassPane) {
        this(imFrame, null, n, n2, glassPane);
    }

    public ImPane(ImFrame imFrame, String string, GlassPane glassPane) {
        this(imFrame, string, 0, 0, glassPane);
    }

    public ImPane(ImFrame imFrame, String string, int n, int n2, GlassPane glassPane) {
        this(imFrame, string, n, n2, glassPane, null);
    }

    public ImPane(ImFrame imFrame, String string, int n, int n2, GlassPane glassPane, net.grelf.image.Image image) {
        this.parent = imFrame;
        this.gp = glassPane;
        glassPane.setImPane(this);
        if (null != string) {
            List<net.grelf.image.Image> list = ImageLoader.loadAll(string);
            if (null != list && 0 < list.size()) {
                this.image = list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    net.grelf.image.Image image2 = list.get(i);
                    ImFrame imFrame2 = new ImFrame(string + "(" + i + ")", image2.getWidth(), image2.getHeight(), true);
                    imFrame2.getImPane().setImage(image2);
                    imFrame2.redisplay();
                }
            }
        } else {
            this.image = null != image ? image : new Image16(n, n2, 3);
        }
        if (this.image != null) {
            this.setInitialScale();
            this.scaledImage = this.image.scaleDownForDisplay(this.scale);
            this.setIpSize(this.scaledImage.getWidth(), this.scaledImage.getHeight());
            if (null != imFrame) {
                imFrame.setTitle(imFrame.getCaption() + " " + zoomPercents[this.scale - 1]);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public void reScale() {
        this.scaledImage = this.image.scaleDownForDisplay(this.scale);
        if (null != this.ps) {
            this.ps.apply(this.scaledImage);
        }
        this.setIpSize(this.scaledImage.getWidth(), this.scaledImage.getHeight());
        this.parent.setTitle(this.parent.getCaption() + " " + zoomPercents[this.scale - 1]);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Rectangle rectangle = new Rectangle(0, 0, n - 1, n2 - 1);
        graphics2D.setPaint(BACKGROUND_COLOUR);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(FOREGROUND_COLOUR);
        graphics2D.draw(rectangle);
        if (null != this.scaledImage) {
            graphics2D.drawImage((Image)this.scaledImage, 0, 0, this);
        }
    }

    public void zoomUp() {
        if (this.scale > 1) {
            --this.scale;
            this.scaledImage = this.image.scaleDownForDisplay(this.scale);
            if (null != this.ps) {
                this.ps.apply(this.scaledImage);
            }
            this.setIpSize(this.scaledImage.getWidth(), this.scaledImage.getHeight());
            this.parent.setTitle(this.parent.getCaption() + " " + zoomPercents[this.scale - 1]);
            this.repaint();
            this.gp.repaint();
        }
    }

    public void zoomDown() {
        if (this.scale < 10) {
            ++this.scale;
            this.scaledImage = this.image.scaleDownForDisplay(this.scale);
            if (null != this.ps) {
                this.ps.apply(this.scaledImage);
            }
            this.setIpSize(this.scaledImage.getWidth(), this.scaledImage.getHeight());
            this.parent.setTitle(this.parent.getCaption() + " " + zoomPercents[this.scale - 1]);
            this.repaint();
            this.gp.repaint();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 512;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        ImPane imPane = (ImPane)mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = imPane.getOrigin();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = imPane.getIpWidth();
        int n6 = imPane.getIpHeight();
        int n7 = imPane.getScale();
        if (n >= n3 && n < n3 + n5 && n2 >= n4 && n2 < n4 + n6) {
            switch (imPane.gp.getDrawingMode()) {
                case BLOB_PAIR: {
                    object = this.getImFrame().getBlobMeases().getNearestBlob(n * n7, n2 * n7);
                    Point point2 = new Point((int)object.centre.x, (int)object.centre.y);
                    if (null == imPane.gp.getPoints()) {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(point2);
                        imPane.gp.setMeasured(false);
                    } else if (1 == imPane.gp.getPoints().size()) {
                        imPane.gp.getPoints().add(point2);
                    } else {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(point2);
                        imPane.gp.setMeasured(false);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case STAR_PAIR: {
                    object = imPane.getImFrame();
                    if (!(object instanceof StarChartFrame)) break;
                    StarChartFrame starChartFrame = (StarChartFrame)object;
                    Star star = starChartFrame.getStarChart().findNearestStar(n * n7, n2 * n7);
                    Point point3 = star.getPlotPoint();
                    Point point4 = new Point(point3.x, point3.y);
                    if (null == imPane.gp.getPoints()) {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(point4);
                        imPane.gp.setMeasured(false);
                    } else if (1 == imPane.gp.getPoints().size()) {
                        imPane.gp.getPoints().add(point4);
                    } else {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(point4);
                        imPane.gp.setMeasured(false);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CALIBRATE: 
                case CROP: 
                case DELETE_MATCHES: 
                case ENCLOSE_SPECTRUM: 
                case POINT_PAIR: 
                case RECTANGLE: 
                case PROFILE2D: {
                    if (null == imPane.gp.getPoints()) {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                        imPane.gp.setMeasured(false);
                    } else if (1 == imPane.gp.getPoints().size()) {
                        if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                            object = imPane.gp.getPoints().get(0);
                            int n8 = Math.abs(n * n7 - object.x);
                            int n9 = Math.abs(n2 * n7 - object.y);
                            n8 = n9 = Math.min(n8, n9);
                            imPane.gp.getPoints().add(new Point(object.x + n8, object.y + n9));
                        } else {
                            imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                        }
                    } else {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                        imPane.gp.setMeasured(false);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CONTROL_POINTS: {
                    if (null == imPane.gp.getPoints()) {
                        imPane.gp.clearPoints();
                        imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                        imPane.gp.setMeasured(false);
                    } else {
                        imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CLOSED_CURVE: 
                case KERNEL: 
                case OPEN_CURVE: 
                case POINT: 
                case ZOOM_POINT_M: {
                    imPane.gp.clearPoints();
                    imPane.gp.getPoints().add(new Point(n * n7, n2 * n7));
                    imPane.gp.setMeasured(false);
                    imPane.gp.repaint();
                }
            }
        }
        if (null != this.ap && null != (object = imPane.samplePoint(n * n7, n2 * n7))) {
            this.ap.pressAction(n, n2, (int[])object);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        ImPane imPane = (ImPane)mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = imPane.getOrigin();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = imPane.getIpWidth();
        int n6 = imPane.getIpHeight();
        int n7 = imPane.getScale();
        if (n >= n3 && n < n3 + n5 && n2 >= n4 && n2 < n4 + n6) {
            object = imPane.gp.getPoints();
            int n8 = ((PointList)object).size();
            switch (imPane.gp.getDrawingMode()) {
                case BLOB_HOVER: {
                    ImFrame imFrame = this.getImFrame();
                    if (null == imFrame.getBlobMeases()) break;
                    BlobMeas blobMeas = imFrame.getBlobMeases().getNearestBlob(n * n7, n2 * n7);
                    if (imFrame instanceof CometFrame) {
                        ((CometFrame)imFrame).setCometCentre(blobMeas.centre);
                    } else if (imFrame instanceof StarMeasFrame) {
                        ((StarMeasFrame)imFrame).getProcessor().addPoint(blobMeas.centre);
                    }
                    blobMeas.blob.display(imFrame, blobMeas);
                    break;
                }
                case BLOB_PAIR: {
                    BlobMeas blobMeas = this.getImFrame().getBlobMeases().getNearestBlob(n * n7, n2 * n7);
                    Point point2 = new Point((int)blobMeas.centre.x, (int)blobMeas.centre.y);
                    Point point3 = ((PointList)object).get(n8 - 1);
                    point3.setLocation(point2.x, point2.y);
                    if (n8 == 2) {
                        imPane.getImFrame().popCaption();
                        ((PointList)object).measureBlobLine(imPane.getImFrame());
                        imPane.gp.setMeasured(true);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CALIBRATE: {
                    Point point4 = ((PointList)object).get(n8 - 1);
                    point4.setLocation(n * n7, n2 * n7);
                    if (n8 == 2) {
                        imPane.getImFrame().popCaption();
                        ((PointList)object).calibrate(imPane.getImFrame());
                        imPane.gp.setMeasured(true);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CLOSED_CURVE: {
                    ((PointList)object).add(new Point(n * n7, n2 * n7));
                    Point point5 = ((PointList)object).get(0);
                    ((PointList)object).add(new Point(point5.x, point5.y));
                    imPane.gp.repaint();
                    imPane.getImFrame().popCaption();
                    ((PointList)object).measureArea(imPane.getImFrame());
                    imPane.gp.setMeasured(true);
                    break;
                }
                case CONTROL_POINTS: {
                    Point point6 = ((PointList)object).get(((PointList)object).size() - 1);
                    point6.setLocation(n * n7, n2 * n7);
                    imPane.gp.repaint();
                    break;
                }
                case CROP: {
                    Serializable serializable;
                    Point point7 = ((PointList)object).get(n8 - 1);
                    if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                        serializable = ((PointList)object).get(0);
                        int n9 = Math.abs(n * n7 - ((Point)serializable).x);
                        int n10 = Math.abs(n2 * n7 - ((Point)serializable).y);
                        n9 = n10 = Math.min(n9, n10);
                        point7.setLocation(((Point)serializable).x + n9, ((Point)serializable).y + n10);
                    } else {
                        point7.setLocation(n * n7, n2 * n7);
                    }
                    if (n8 != 2) break;
                    this.normaliseRectangle((PointList)object);
                    serializable = imPane.getImFrame();
                    ((ImFrame)serializable).popCaption();
                    ((ImFrame)serializable).crop(((PointList)object).get(0), ((PointList)object).get(1));
                    break;
                }
                case DELETE_MATCHES: {
                    if (n8 != 2) break;
                    this.normaliseRectangle((PointList)object);
                    MatchPair.deleteMatches(((PointList)object).get(0), ((PointList)object).get(1), imPane.getImFrame());
                    break;
                }
                case ENCLOSE_SPECTRUM: {
                    if (n8 != 2) break;
                    this.normaliseRectangle((PointList)object);
                    new Spectrum().analyse(this.getImFrame(), (PointList)object);
                    break;
                }
                case HOVER: {
                    int n11 = n * n7;
                    int n12 = n2 * n7;
                    ImFrame imFrame = this.getImFrame();
                    if (imFrame instanceof CometFrame) {
                        ((CometFrame)imFrame).setCometCentre(new PointFloat(n11, n12));
                    } else if (imFrame instanceof StarMeasFrame) {
                        ((StarMeasFrame)imFrame).getProcessor().addPoint(new PointFloat(n11, n12));
                    }
                    imFrame.magnifier(n11, n12);
                    break;
                }
                case KERNEL: {
                    Point point8 = ((PointList)object).get(0);
                    point8.setLocation(n * n7, n2 * n7);
                    imPane.gp.repaint();
                    imPane.getImFrame().popCaption();
                    if (null == this.image) break;
                    ConvolutionMenu.setKernel(new Kernel(point8, this.image, ConvolutionMenu.getInitialHalfWidth()));
                    break;
                }
                case MOVE: {
                    imPane.gp.popDrawingMode();
                    imPane.getImFrame().popCaption();
                    switch (imPane.gp.getDrawingMode()) {
                        case CLOSED_CURVE: {
                            ((PointList)object).measureArea(imPane.getImFrame());
                            break;
                        }
                        case OPEN_CURVE: {
                            ((PointList)object).measureCurve(imPane.getImFrame());
                            break;
                        }
                        case POINT: {
                            ((PointList)object).measurePoint(imPane.getImFrame());
                            break;
                        }
                        case POINT_PAIR: {
                            ((PointList)object).measureLine(imPane.getImFrame());
                            break;
                        }
                        case RECTANGLE: {
                            ((PointList)object).measureRectangle(imPane.getImFrame());
                            break;
                        }
                        case PROFILE2D: {
                            Prof3D_Pane.display(imPane.getImFrame(), ((PointList)object).get(0), ((PointList)object).get(1));
                        }
                    }
                    imPane.gp.setMeasured(true);
                    break;
                }
                case OPEN_CURVE: {
                    ((PointList)object).add(new Point(n * n7, n2 * n7));
                    imPane.gp.repaint();
                    imPane.getImFrame().popCaption();
                    ((PointList)object).measureCurve(imPane.getImFrame());
                    imPane.gp.setMeasured(true);
                    break;
                }
                case POINT: {
                    Point point9 = ((PointList)object).get(0);
                    point9.setLocation(n * n7, n2 * n7);
                    imPane.gp.repaint();
                    imPane.getImFrame().popCaption();
                    ((PointList)object).measurePoint(imPane.getImFrame());
                    imPane.gp.setMeasured(true);
                    break;
                }
                case POINT_PAIR: {
                    if (n8 <= 0) break;
                    Point point10 = ((PointList)object).get(n8 - 1);
                    point10.setLocation(n * n7, n2 * n7);
                    if (n8 == 2) {
                        imPane.getImFrame().popCaption();
                        ((PointList)object).measureLine(imPane.getImFrame());
                        imPane.gp.setMeasured(true);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case RECTANGLE: 
                case PROFILE2D: {
                    if (n8 <= 0) break;
                    Point point11 = ((PointList)object).get(n8 - 1);
                    if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                        Point point12 = ((PointList)object).get(0);
                        int n13 = Math.abs(n * n7 - point12.x);
                        int n14 = Math.abs(n2 * n7 - point12.y);
                        n13 = n14 = Math.min(n13, n14);
                        point11.setLocation(point12.x + n13, point12.y + n14);
                    } else {
                        point11.setLocation(n * n7, n2 * n7);
                    }
                    if (n8 == 2) {
                        this.normaliseRectangle((PointList)object);
                        imPane.getImFrame().popCaption();
                        if (imPane.gp.getDrawingMode() == DrawingMode.PROFILE2D) {
                            Prof3D_Pane.display(imPane.getImFrame(), ((PointList)object).get(0), ((PointList)object).get(1));
                        } else {
                            ((PointList)object).measureRectangle(imPane.getImFrame());
                            imPane.gp.setMeasured(true);
                        }
                    }
                    imPane.gp.repaint();
                    break;
                }
                case STAR_CHART: {
                    ImFrame imFrame = this.parent;
                    if (!(imFrame instanceof StarChartFrame)) break;
                    ((StarChartFrame)imFrame).getStarChart().showNearestStarData(n * n7, n2 * n7);
                    break;
                }
                case STAR_PAIR: {
                    ImFrame imFrame = imPane.getImFrame();
                    if (imFrame instanceof StarChartFrame) {
                        Star star = ((StarChartFrame)imFrame).getStarChart().findNearestStar(n * n7, n2 * n7);
                        Point point13 = star.getPlotPoint();
                        Point point14 = new Point(point13.x, point13.y);
                        Point point15 = ((PointList)object).get(n8 - 1);
                        point15.setLocation(point14.x, point14.y);
                    }
                    if (n8 == 2) {
                        imPane.getImFrame().popCaption();
                        ((PointList)object).measureStarLine(imPane.getImFrame());
                        imPane.gp.setMeasured(true);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case ZOOM_POINT_M: {
                    Point point16 = ((PointList)object).get(0);
                    point16.setLocation(n * n7, n2 * n7);
                    new ImGraphic().drawMandelbrot(imPane.getImFrame(), point16, 2.0);
                }
            }
        }
        if (null != this.ap && null != (object = imPane.samplePoint(n * n7, n2 * n7))) {
            this.ap.releaseAction(n, n2, (int[])object);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        ImPane imPane = (ImPane)mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = imPane.getOrigin();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = imPane.getIpWidth();
        int n6 = imPane.getIpHeight();
        int n7 = imPane.getScale();
        if (n >= n3 && n < n3 + n5 && n2 >= n4 && n2 < n4 + n6) {
            object = imPane.gp.getPoints();
            int n8 = ((PointList)object).size();
            switch (imPane.gp.getDrawingMode()) {
                case BLOB_PAIR: {
                    BlobMeas blobMeas = this.getImFrame().getBlobMeases().getNearestBlob(n * n7, n2 * n7);
                    Point point2 = new Point((int)blobMeas.centre.x, (int)blobMeas.centre.y);
                    Point point3 = ((PointList)object).get(n8 - 1);
                    point3.setLocation(point2.x, point2.y);
                    imPane.gp.repaint();
                    break;
                }
                case CALIBRATE: 
                case CROP: 
                case DELETE_MATCHES: 
                case ENCLOSE_SPECTRUM: 
                case POINT_PAIR: 
                case RECTANGLE: 
                case PROFILE2D: 
                case CONTROL_POINTS: {
                    if (0 >= n8) break;
                    Point point4 = ((PointList)object).get(n8 - 1);
                    if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                        Point point5 = ((PointList)object).get(0);
                        int n9 = Math.abs(n * n7 - point5.x);
                        int n10 = Math.abs(n2 * n7 - point5.y);
                        n9 = n10 = Math.min(n9, n10);
                        point4.setLocation(point5.x + n9, point5.y + n10);
                    } else {
                        point4.setLocation(n * n7, n2 * n7);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case CLOSED_CURVE: 
                case OPEN_CURVE: {
                    ((PointList)object).add(new Point(n * n7, n2 * n7));
                    imPane.gp.repaint();
                    break;
                }
                case KERNEL: 
                case POINT: {
                    Point point6 = ((PointList)object).get(0);
                    point6.setLocation(n * n7, n2 * n7);
                    imPane.gp.repaint();
                    break;
                }
                case MOVE: {
                    Point point7 = ((PointList)object).get(0);
                    int n11 = n * n7 - point7.x;
                    int n12 = n2 * n7 - point7.y;
                    for (int i = 0; i < n8; ++i) {
                        ((PointList)object).get(i).translate(n11, n12);
                    }
                    imPane.gp.repaint();
                    break;
                }
                case STAR_PAIR: {
                    ImFrame imFrame = imPane.getImFrame();
                    if (!(imFrame instanceof StarChartFrame)) break;
                    Star star = ((StarChartFrame)imFrame).getStarChart().findNearestStar(n * n7, n2 * n7);
                    Point point8 = star.getPlotPoint();
                    Point point9 = new Point(point8.x, point8.y);
                    Point point10 = ((PointList)object).get(n8 - 1);
                    point10.setLocation(point9.x, point9.y);
                    imPane.gp.repaint();
                }
            }
        }
        if (null != this.ap && null != (object = imPane.samplePoint(n * n7, n2 * n7))) {
            this.ap.dragAction(n, n2, (int[])object);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ImPane imPane = (ImPane)mouseEvent.getSource();
        DrawingMode drawingMode = imPane.gp.getDrawingMode();
        if (DrawingMode.HOVER == drawingMode || DrawingMode.BLOB_HOVER == drawingMode || DrawingMode.STAR_CHART == drawingMode) {
            object = imPane.gp.getPoints().get(0);
            ((Point)object).setLocation(n, n2);
            imPane.gp.repaint();
        }
        if (null != this.ap && null != (object = (Object)imPane.samplePoint(n * this.scale, n2 * this.scale))) {
            this.ap.moveAction(n, n2, (int[])object);
        }
    }

    private void normaliseRectangle(PointList pointList) {
        Point point = pointList.get(0);
        Point point2 = pointList.get(1);
        int n = Math.min(point.y, point2.y);
        int n2 = Math.max(point.y, point2.y);
        int n3 = Math.min(point.x, point2.x);
        int n4 = Math.max(point.x, point2.x);
        point.x = n3;
        point.y = n;
        point2.x = n4;
        point2.y = n2;
    }

    private int[] samplePoint(int n, int n2) {
        if (0 <= n && n < this.image.getWidth() && 0 <= n2 && n2 < this.image.getHeight()) {
            return this.image.getPixel(n, n2);
        }
        return null;
    }
}

