/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Point;
import javax.swing.ProgressMonitor;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.ImageSizeAction;
import net.grelf.grip.ImageSizeDialogue;
import net.grelf.image.Image;
import net.grelf.image.ImageBase;

public class ImGraphic
implements ImageSizeAction {
    private int imHt;
    private int imWd;
    private static ProgressMonitor monitor = null;
    private static double centreX = 0.0;
    private static double centreY = 0.0;
    private static double scale = 1.0;

    @Override
    public void process(ImageSizeDialogue imageSizeDialogue) {
        this.imWd = imageSizeDialogue.getWidth();
        this.imHt = imageSizeDialogue.getHeight();
        imageSizeDialogue.dispose();
    }

    public void drawMandelbrot() {
        new ImageSizeDialogue(1024, 768, "New image size", this);
        ImFrame imFrame = new ImFrame("Mandelbrot curve", this.imWd, this.imHt);
        Image image = ImageBase.createImage(imFrame.getWidth(), imFrame.getHeight(), 1, 8);
        imFrame.getImPane().setImage(image);
        this.imWd = image.getWidth();
        this.imHt = image.getHeight();
        centreX = 0.0;
        centreY = 0.0;
        scale = 4.0 / (double)this.imHt;
        this.drawMandelbrot(imFrame, new Point(this.imWd / 2, this.imHt / 2), 1.0);
    }

    public void drawMandelbrot(ImFrame imFrame, Point point, double d) {
        Image image = imFrame.getImPane().getImage();
        this.imWd = image.getWidth();
        this.imHt = image.getHeight();
        centreX += (double)(point.x - this.imWd / 2) * scale;
        centreY += (double)(point.y - this.imHt / 2) * scale;
        scale /= d;
        new mandelbrotThread(imFrame).start();
    }

    private void drawMandelbrotInBackground(ImFrame imFrame) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = imFrame.getImPane().getImage();
        this.imWd = image.getWidth();
        this.imHt = image.getHeight();
        int n = image.getNBands();
        int n2 = image.getRange().high;
        int n3 = this.imWd / 2;
        int n4 = this.imHt / 2;
        int[] nArray = new int[n];
        int n5 = 0;
        int n6 = -n4;
        while (n5 < this.imHt) {
            if (null != monitor && n5 % 50 == 0) {
                monitor.setProgress(n5);
                monitor.setNote("Row " + n5 + " of " + this.imHt);
                if (monitor.isCanceled()) {
                    monitor.close();
                    return;
                }
            }
            double d = scale * (double)n6;
            int n7 = 0;
            int n8 = -n3;
            while (n7 < this.imWd) {
                double d2 = scale * (double)n8;
                int n9 = this.mandelbrot(d2 + centreX, d + centreY, n2);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = n9;
                }
                image.setPixel(n7, n5, nArray);
                ++n7;
                ++n8;
            }
            ++n5;
            ++n6;
        }
        imFrame.redisplay();
        if (null != monitor) {
            monitor.close();
        }
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        imFrame.setCaption("Point to zoom in");
        imFrame.getGP().setDrawingMode(DrawingMode.ZOOM_POINT_M);
    }

    private int mandelbrot(double d, double d2, int n) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = d3 * d3;
            double d6 = d4 * d4;
            if (d5 + d6 > 100.0) {
                return i;
            }
            d4 = 2.0 * d3 * d4 + d2;
            d3 = d5 - d6 + d;
        }
        return n;
    }

    public void drawGrid() {
        int n;
        int n2;
        new ImageSizeDialogue(1024, 768, "New image size", this);
        ImFrame imFrame = new ImFrame("Grid of squares", this.imWd, this.imHt, true);
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        ImPane imPane = imFrame.getImPane();
        Image image = imPane.getImage();
        this.imWd = image.getWidth();
        this.imHt = image.getHeight();
        int n3 = image.getNBands();
        int n4 = image.getRange().high;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
            nArray2[n2] = n4;
        }
        for (n2 = 0; n2 < this.imHt; ++n2) {
            for (n = 0; n < this.imWd; ++n) {
                image.setPixel(n, n2, nArray2);
            }
        }
        for (n2 = 50; n2 < this.imHt; n2 += 100) {
            for (n = 50; n < this.imWd; n += 100) {
                for (int i = 0; i < 20; ++i) {
                    for (int j = 0; j < 20; ++j) {
                        if (n + j >= this.imWd || n2 + i >= this.imHt) continue;
                        image.setPixel(n + j, n2 + i, nArray);
                    }
                }
            }
        }
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void drawRim(ImFrame imFrame, int n, Color color) {
        Image image = imFrame.getImPane().getImage();
        image.drawRim(n, color);
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    private static class mandelbrotThread
    extends Thread {
        private ImFrame frame;

        public mandelbrotThread(ImFrame imFrame) {
            this.frame = imFrame;
            monitor = new ProgressMonitor(this.frame, "Drawing", "", 0, this.frame.getHeight());
        }

        @Override
        public void run() {
            new ImGraphic().drawMandelbrotInBackground(this.frame);
        }
    }
}

