/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.grelf.AbstractDialogue;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;

public class ControlPointsDialogue
extends AbstractDialogue
implements ActionListener,
ImPreviewActor {
    private Image im1 = null;
    private Image im2 = null;
    private ImPreview imPreview1;
    private ImPreview imPreview2;
    private Point controlPt1;
    private Point controlPt2;
    private int controlNo;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel imagePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private boolean accepted = false;

    public boolean isAccepted() {
        return this.accepted;
    }

    public ControlPointsDialogue(int n, ImFrame imFrame, Point point, ImFrame imFrame2, Point point2) {
        super((Frame)GRIP.getInstance(), "Control point pair [" + n + "]");
        this.controlNo = n;
        this.controlPt1 = new Point(point.x, point.y);
        this.controlPt2 = new Point(point2.x, point2.y);
        this.im1 = imFrame.getImPane().getImage();
        this.im2 = imFrame2.getImPane().getImage();
        this.imPreview1 = new ImPreview(this.im1, this);
        this.imagePanel.add((Component)this.imPreview1, "West");
        this.imPreview2 = new ImPreview(this.im2, this);
        this.imagePanel.add((Component)this.imPreview2, "East");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.imagePanel, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        int n3 = image2.getRange().high;
        int n4 = image.getNBands();
        int[] nArray = new int[n4];
        int n5 = n2 / 2;
        int n6 = n / 2;
        int n7 = point.y - n5;
        for (int i = 0; i < n2; ++i) {
            int n8 = point.x - n6;
            for (int j = 0; j < n; ++j) {
                nArray = image.getPixel(n8, n7);
                image2.setPixel(j, i, nArray);
                ++n8;
            }
            ++n7;
        }
        this.drawCrossAt(n6, n5, image2, n3, n4);
        if (image2 == this.im1) {
            this.controlPt1 = point;
        } else {
            this.controlPt2 = point;
        }
    }

    private void drawCrossAt(int n, int n2, Image image, int n3, int n4) {
        int n5;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = n3;
            nArray2[n5] = 0;
        }
        for (n5 = n2 - 10; n5 == n2 - 2; ++n5) {
            image.setPixel(n - 1, n5, nArray2);
            image.setPixel(n, n5, nArray);
            image.setPixel(n + 1, n5, nArray2);
        }
        for (n5 = n2 + 10; n5 == n2 + 2; --n5) {
            image.setPixel(n - 1, n5, nArray2);
            image.setPixel(n, n5, nArray);
            image.setPixel(n + 1, n5, nArray2);
        }
        for (n5 = n - 10; n5 == n - 2; ++n5) {
            image.setPixel(n5, n2 - 1, nArray2);
            image.setPixel(n5, n2, nArray);
            image.setPixel(n5, n2 + 1, nArray2);
        }
        for (n5 = n + 10; n5 == n + 2; --n5) {
            image.setPixel(n5, n2 - 1, nArray2);
            image.setPixel(n5, n2, nArray);
            image.setPixel(n5, n2 + 1, nArray2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    private List<Point> getPoints() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(this.controlPt1);
        arrayList.add(this.controlPt2);
        return arrayList;
    }

    public static List<Point> askControl(int n, ImFrame imFrame, Point point, ImFrame imFrame2, Point point2) {
        ControlPointsDialogue controlPointsDialogue = new ControlPointsDialogue(n, imFrame, point, imFrame2, point2);
        List<Point> list = null;
        if (controlPointsDialogue.isAccepted()) {
            list = controlPointsDialogue.getPoints();
        }
        controlPointsDialogue.dispose();
        return list;
    }
}

