/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import net.grelf.PointFloat;
import net.grelf.grip.CometPanel;
import net.grelf.grip.CometProcessor;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.ImFrame;
import net.grelf.image.Image8or16Base;

public class CometFrame
extends ImFrame {
    private CometProcessor processor;
    private CometPanel cometPanel;
    private PointFloat cometCentre;

    public void setCometCentre(PointFloat pointFloat) {
        this.cometCentre = pointFloat;
    }

    public CometFrame(CometProcessor cometProcessor, File file) {
        super(file.getPath(), DrawingMode.UNDEFINED, file.getPath(), -1, -1, -1, new DefaultMeasurementHandler(), true);
        this.processor = cometProcessor;
        this.cometPanel = new CometPanel(this);
        this.getContentPane().add((Component)this.cometPanel, "East");
        this.setSize(this.getWidth() + this.cometPanel.getWidth() + 50, this.getHeight());
    }

    public void next() {
        BufferedImage bufferedImage = ((Image8or16Base)this.getImPane().getImage()).getBufferedImage();
        super.dispose();
        this.processor.process(this.cometCentre, bufferedImage);
    }

    public void skip() {
        super.dispose();
        this.processor.process(null, null);
    }

    public void updatePanel(int n, int n2, int n3) {
        this.cometPanel.updateSummary(n, n2, n3);
    }
}

