/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.grelf.Util;
import net.grelf.grip.Blob;
import net.grelf.grip.Blob_;
import net.grelf.image.ByteMask;

public class BlobMask
extends ByteMask {
    private static final int BLOBS_LIST_CAPACITY = 15000;
    private static final int BOUNDARY_LIST_CAPACITY = 1000;
    private static final int MAX_BOUNDARY = 10000;

    public BlobMask(int n, int n2) {
        super(n, n2);
    }

    public BlobMask(byte[][] byArray) {
        super(byArray);
    }

    public List<Blob> detectBlobs() {
        return this.detectBlobs(true);
    }

    public List<Blob> detectBlobs(boolean bl) {
        ArrayList<Blob> arrayList = new ArrayList<Blob>(15000);
        int n = this.data.length;
        int n2 = this.data[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.data[j][i] <= 0) continue;
                Blob blob = null;
                if (this.gotNeighbours(j, i, this.data)) {
                    blob = this.traceBlob(j, i);
                } else if (bl) {
                    blob = new Blob_(j, i);
                }
                if (null == blob || !blob.hasRows()) continue;
                arrayList.add(blob);
                blob.erase(this.data);
            }
        }
        return arrayList;
    }

    private boolean gotNeighbours(int n, int n2, byte[][] byArray) {
        int n3 = byArray.length - 1;
        int n4 = byArray[0].length - 1;
        if (n < n3) {
            if (byArray[n + 1][n2] > 0) {
                return true;
            }
            if (n2 > 0 && byArray[n + 1][n2 - 1] > 0) {
                return true;
            }
            if (n2 < n4 && byArray[n + 1][n2 + 1] > 0) {
                return true;
            }
        }
        if (n2 < n4 && byArray[n][n2 + 1] > 0) {
            return true;
        }
        if (n > 0) {
            if (byArray[n - 1][n2] > 0) {
                return true;
            }
            if (n2 < n4 && byArray[n - 1][n2 + 1] > 0) {
                return true;
            }
            if (n2 > 0 && byArray[n - 1][n2 - 1] > 0) {
                return true;
            }
        }
        return n2 > 0 && byArray[n][n2 - 1] > 0;
    }

    private Blob traceBlob(int n, int n2) {
        ArrayList<Point> arrayList = new ArrayList<Point>(1000);
        Point point = new Point(n, n2);
        int n3 = 1;
        arrayList.add(point);
        n3 = this.findNextDirection(n, n2, this.data, n3);
        boolean bl = false;
        Point point2 = new Point(point.x, point.y);
        int n4 = 0;
        do {
            point2 = this.offset(point2, n3);
            arrayList.add(point2);
            n3 = this.findNextDirection(point2.x, point2.y, this.data, n3);
        } while (!(bl = point2.y == point.y && point2.x == point.x) && ++n4 < 10000);
        if (bl) {
            return new Blob_(arrayList, this.data);
        }
        return null;
    }

    private int findNextDirection(int n, int n2, byte[][] byArray, int n3) {
        Point point = new Point(n, n2);
        boolean bl = false;
        int n4 = byArray.length - 1;
        int n5 = byArray[0].length - 1;
        int n6 = n3 - 2;
        if (n6 < 1) {
            n6 += 8;
        }
        do {
            Point point2 = this.offset(point, n6);
            if (point2.x >= 0 && point2.x <= n4 && point2.y >= 0 && point2.y <= n5) {
                if (byArray[point2.x][point2.y] > 0) {
                    bl = true;
                    continue;
                }
                if (++n6 <= 8) continue;
                n6 = 1;
                continue;
            }
            if (++n6 <= 8) continue;
            n6 = 1;
        } while (!bl);
        return n6;
    }

    private Point offset(Point point, int n) {
        Point point2 = new Point(point.x, point.y);
        switch (n) {
            case 1: {
                ++point2.x;
                break;
            }
            case 2: {
                ++point2.x;
                ++point2.y;
                break;
            }
            case 3: {
                ++point2.y;
                break;
            }
            case 4: {
                --point2.x;
                ++point2.y;
                break;
            }
            case 5: {
                --point2.x;
                break;
            }
            case 6: {
                --point2.x;
                --point2.y;
                break;
            }
            case 7: {
                --point2.y;
                break;
            }
            case 8: {
                ++point2.x;
                --point2.y;
                break;
            }
            default: {
                Util.logWarning("Blob tracing: attempt to offset by direction {0}", n);
                return this.offset(point, n % 8 + 1);
            }
        }
        return point2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                stringBuffer.append(this.data[j][i]);
                stringBuffer.append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

