/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.grelf.AbstractDialogue;
import net.grelf.FileIO;
import net.grelf.Util;
import net.grelf.VectorFloat;
import net.grelf.grip.AstroProcessKind;
import net.grelf.grip.AstroProcessMethod;
import net.grelf.grip.BatchProcessor;
import net.grelf.grip.CometProcessor;
import net.grelf.grip.Config;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Raw;

public class AstroProcessDialogue
extends AbstractDialogue
implements ActionListener {
    private File[] files = null;
    private JLabel filesLabel = new JLabel(" Files to process  ");
    private JTextArea filesList = new JTextArea();
    private JButton viewFirstButton = new JButton("View first");
    private JLabel padding1 = new JLabel(" ");
    private JButton filesBrowseButton = new JButton("Browse...");
    private JLabel padding2 = new JLabel(" ");
    private JButton viewLastButton = new JButton("View last");
    private JLabel methodLabel = new JLabel(" Method: ");
    private ButtonGroup methodGroup = new ButtonGroup();
    private JRadioButton warpButton;
    private JRadioButton shiftAverageButton = new JRadioButton("Shift by average", false);
    private JRadioButton shiftBrightestButton = new JRadioButton("Shift by brightest only", false);
    private JRadioButton cometButton;
    private JLabel darkLabel = new JLabel(" Dark frame image  ");
    private JTextField darkPath = new JTextField("");
    private JButton darkBrowseButton = new JButton("Browse...");
    private JButton darkViewButton = new JButton("View dark");
    private JLabel flatLabel = new JLabel(" Flat field image  ");
    private JTextField flatPath = new JTextField("");
    private JButton flatBrowseButton = new JButton("Browse...");
    private JButton flatViewButton = new JButton("View flat");
    private JCheckBox neutraliseCheck = new JCheckBox("Neutralise background");
    private JCheckBox backgroundCheck = new JCheckBox("Correct background from histogram (camera only)");
    private JCheckBox gnomonicCheck = new JCheckBox("Do inverse gnomonic projection (wide angle only)");
    private JLabel lensLabel = new JLabel(" Lens focal length, for gnomonic (mm)  ");
    private JTextField lensText = new JTextField("");
    private JLabel tuningLabel = new JLabel(" Tuning parameters:");
    private JLabel nBrightestLabel = new JLabel(" No of brightest stars to match ");
    private JTextField nBrightestField = new JTextField(Config.getValue("NBrightest.value"));
    private JLabel radiusToleranceLabel = new JLabel(" Radius tolerance for matching (px) ");
    private JTextField radiusToleranceField = new JTextField("" + VectorFloat.getRadiusTolerance());
    private JLabel angleToleranceLabel = new JLabel(" Angle tolerance for matching (radians) ");
    private JTextField angleToleranceField = new JTextField("" + VectorFloat.getAngleTolerance());
    private JCheckBox fullAutoCheck = new JCheckBox("Run with no pauses, save results");
    private JLabel pausesLabel1 = new JLabel("(otherwise pause after pass 1 to show matches");
    private JLabel pausesLabel2 = new JLabel(" and prompt for saving results)");
    private JCheckBox showBlobsOnEachImageCheck = new JCheckBox("Show blobs detected in each image (diagnostic)");
    private JButton processButton = new JButton("Process");
    private JButton cancelButton = new JButton("Cancel");
    private JButton helpButton = new JButton("Help");
    private AstroProcessKind processKind;
    private boolean experiment;

    public AstroProcessDialogue(Frame frame, AstroProcessKind astroProcessKind) {
        this(frame, astroProcessKind, false);
    }

    public AstroProcessDialogue(Frame frame, AstroProcessKind astroProcessKind, boolean bl) {
        super(frame, "Astro " + astroProcessKind.toString(), false);
        this.processKind = astroProcessKind;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.filesLabel.setHorizontalAlignment(4);
        this.placeControl(container, this.filesLabel, 0, 3, 1, 1);
        this.filesList.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.filesList);
        this.placeControl(container, jScrollPane, 1, 1, 3, 5, 1);
        this.viewFirstButton.setActionCommand("viewFirst");
        this.viewFirstButton.addActionListener(this);
        this.viewFirstButton.setSize(new Dimension(80, 24));
        this.viewFirstButton.setPreferredSize(new Dimension(80, 24));
        this.placeControl(container, this.viewFirstButton, 4, 1, 1, 1);
        this.placeControl(container, this.padding1, 4, 2, 1, 1);
        this.filesBrowseButton.setActionCommand("filesBrowse");
        this.filesBrowseButton.addActionListener(this);
        this.filesBrowseButton.setSize(new Dimension(80, 24));
        this.filesBrowseButton.setPreferredSize(new Dimension(80, 24));
        this.placeControl(container, this.filesBrowseButton, 4, 3, 1, 1);
        this.placeControl(container, this.padding2, 4, 4, 1, 1);
        this.viewLastButton.setActionCommand("viewLast");
        this.viewLastButton.addActionListener(this);
        this.viewLastButton.setSize(new Dimension(80, 24));
        this.viewLastButton.setPreferredSize(new Dimension(80, 24));
        this.placeControl(container, this.viewLastButton, 4, 5, 1, 1);
        this.methodLabel.setHorizontalAlignment(4);
        this.placeControl(container, this.methodLabel, 0, 6, 1, 1);
        if (bl) {
            this.warpButton = new JRadioButton("Warp", false);
            this.cometButton = new JRadioButton("Comet", true);
            this.warpButton.setEnabled(false);
            this.shiftAverageButton.setEnabled(false);
            this.shiftBrightestButton.setEnabled(false);
        } else {
            this.warpButton = new JRadioButton("Warp", true);
            this.cometButton = new JRadioButton("Comet", false);
            this.cometButton.setEnabled(false);
        }
        this.methodGroup.add(this.warpButton);
        this.placeControl(container, this.warpButton, 1, 6, 1, 1);
        this.methodGroup.add(this.shiftAverageButton);
        this.placeControl(container, this.shiftAverageButton, 2, 6, 1, 1);
        if (astroProcessKind == AstroProcessKind.COMBINE) {
            this.methodGroup.add(this.shiftBrightestButton);
            this.placeControl(container, this.shiftBrightestButton, 3, 6, 1, 1);
        }
        this.methodGroup.add(this.cometButton);
        this.placeControl(container, this.cometButton, 4, 6, 1, 1);
        this.darkLabel.setHorizontalAlignment(4);
        this.placeControl(container, this.darkLabel, 0, 7, 1, 1);
        this.placeControl(container, this.darkPath, 1, 7, 3, 1);
        this.darkBrowseButton.setActionCommand("darkBrowse");
        this.darkBrowseButton.addActionListener(this);
        this.placeControl(container, this.darkBrowseButton, 4, 7, 1, 1);
        this.darkViewButton.setActionCommand("viewDark");
        this.darkViewButton.addActionListener(this);
        this.placeControl(container, this.darkViewButton, 4, 8, 1, 1);
        this.flatLabel.setHorizontalAlignment(4);
        this.placeControl(container, this.flatLabel, 0, 9, 1, 1);
        this.placeControl(container, this.flatPath, 1, 9, 3, 1);
        this.flatBrowseButton.setActionCommand("flatBrowse");
        this.flatBrowseButton.addActionListener(this);
        this.placeControl(container, this.flatBrowseButton, 4, 9, 1, 1);
        this.flatViewButton.setActionCommand("viewFlat");
        this.flatViewButton.addActionListener(this);
        this.placeControl(container, this.flatViewButton, 4, 10, 1, 1);
        this.placeControl(container, this.neutraliseCheck, 1, 11, 3, 1);
        this.placeControl(container, this.backgroundCheck, 1, 12, 3, 1);
        this.placeControl(container, this.gnomonicCheck, 1, 13, 3, 1);
        this.lensLabel.setHorizontalAlignment(4);
        this.placeControl(container, this.lensLabel, 0, 14, 1, 1);
        this.placeControl(container, this.lensText, 1, 14, 1, 1);
        if (!bl) {
            this.placeControl(container, this.tuningLabel, 0, 15, 1, 1);
            this.placeControl(container, this.nBrightestLabel, 0, 16, 1, 1);
            this.placeControl(container, this.nBrightestField, 1, 16, 1, 1);
            VectorFloat.resetDefaultTolerances();
            this.radiusToleranceField.setText("" + VectorFloat.getRadiusTolerance());
            this.angleToleranceField.setText("" + VectorFloat.getAngleTolerance());
            this.placeControl(container, this.radiusToleranceLabel, 0, 17, 1, 1);
            this.placeControl(container, this.radiusToleranceField, 1, 17, 1, 1);
            this.placeControl(container, this.angleToleranceLabel, 0, 18, 1, 1);
            this.placeControl(container, this.angleToleranceField, 1, 18, 1, 1);
            this.placeControl(container, this.showBlobsOnEachImageCheck, 1, 19, 3, 1);
            this.showBlobsOnEachImageCheck.addActionListener(this);
            this.placeControl(container, this.fullAutoCheck, 1, 20, 3, 1);
            this.fullAutoCheck.addActionListener(this);
            this.placeControl(container, this.pausesLabel1, 1, 21, 3, 1);
            this.placeControl(container, this.pausesLabel2, 1, 22, 3, 1);
        }
        this.processButton.setActionCommand("process");
        this.processButton.addActionListener(this);
        this.placeControl(container, this.processButton, 1, 23, 1, 1);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.placeControl(container, this.cancelButton, 2, 23, 1, 1);
        this.helpButton.setActionCommand("help");
        this.helpButton.addActionListener(this);
        this.placeControl(container, this.helpButton, 3, 23, 1, 1);
        this.pack();
        this.neutraliseCheck.setSelected(false);
        this.showBlobsOnEachImageCheck.setSelected(false);
        this.fullAutoCheck.setSelected(false);
        this.filesBrowseButton.requestFocusInWindow();
        this.viewFirstButton.setEnabled(false);
        this.viewLastButton.setEnabled(false);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocation(200, 0);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.showBlobsOnEachImageCheck) {
            if (this.showBlobsOnEachImageCheck.isSelected()) {
                this.fullAutoCheck.setSelected(false);
            }
        } else if (object == this.fullAutoCheck) {
            if (this.fullAutoCheck.isSelected()) {
                this.showBlobsOnEachImageCheck.setSelected(false);
            }
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel")) {
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("darkBrowse")) {
                this.darkPath.setText(FileIO.selectInputFile("Dark frame image"));
            } else if (string.equals("filesBrowse")) {
                this.files = FileIO.selectInputFiles("Images to process");
                if (null != this.files) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.files.length; ++i) {
                        stringBuffer.append(this.files[i].getName());
                        stringBuffer.append("\n");
                    }
                    this.filesList.setText(stringBuffer.toString());
                }
            } else if (string.equals("flatBrowse")) {
                this.flatPath.setText(FileIO.selectInputFile("Flat field image"));
            } else if (string.equals("lens")) {
                if (null != this.files) {
                    this.lensText.setText("");
                }
            } else if (string.equals("help")) {
                HelpMenu.help("pages/astro_process.html");
            } else if (string.equals("process")) {
                try {
                    if (this.cometButton.isSelected()) {
                        this.setVisible(false);
                        this.dispose();
                        new CometProcessor(this.files, this.darkPath.getText(), this.flatPath.getText(), this.neutraliseCheck.isSelected(), this.backgroundCheck.isSelected(), this.gnomonicCheck.isSelected(), this.lensText.getText()).run();
                        return;
                    }
                    int n = Integer.parseInt(this.nBrightestField.getText());
                    float f = Float.parseFloat(this.radiusToleranceField.getText());
                    float f2 = Float.parseFloat(this.angleToleranceField.getText());
                    VectorFloat.setRadiusTolerance(f);
                    VectorFloat.setAngleTolerance(f2);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("processKind", (Object)this.processKind);
                    hashMap.put("nBrightest", n);
                    if (this.experiment) {
                        hashMap.put("experiment", "true");
                    }
                    if (this.warpButton.isSelected()) {
                        hashMap.put("method", (Object)AstroProcessMethod.WARP);
                    } else if (this.shiftAverageButton.isSelected()) {
                        hashMap.put("method", (Object)AstroProcessMethod.SHIFT_AVERAGE);
                    } else if (this.shiftBrightestButton.isSelected()) {
                        hashMap.put("method", (Object)AstroProcessMethod.SHIFT_BRIGHTEST);
                    }
                    hashMap.put("focalLength", this.lensText.getText());
                    hashMap.put("darkPath", this.darkPath.getText());
                    hashMap.put("flatPath", this.flatPath.getText());
                    hashMap.put("doNeutralise", Boolean.toString(this.neutraliseCheck.isSelected()));
                    hashMap.put("doBackground", Boolean.toString(this.backgroundCheck.isSelected()));
                    hashMap.put("doGnomonic", Boolean.toString(this.gnomonicCheck.isSelected()));
                    hashMap.put("doFullAuto", Boolean.toString(this.fullAutoCheck.isSelected()));
                    hashMap.put("showBlobsOnEachImage", Boolean.toString(this.showBlobsOnEachImageCheck.isSelected()));
                    this.setVisible(false);
                    this.dispose();
                    new BatchProcessor().doOpInBackground(this.files, "astro", "_temp", hashMap, this.files.length);
                }
                catch (NumberFormatException numberFormatException) {
                    Util.warning(this, "Sorry", (Object)"Invalid character in a\ntuning parameters field");
                }
            } else if (string.equals("viewDark")) {
                String string2 = this.darkPath.getText();
                if (string2.length() == 0) {
                    Util.warning("Sorry", "Dark image not selected");
                } else {
                    ImFrame imFrame = new ImFrame(string2, new DefaultMeasurementHandler());
                    this.interpretIfRaw(imFrame);
                }
            } else if (string.equals("viewFirst")) {
                if (null == this.files || this.files.length == 0) {
                    Util.warning("Sorry", "No files selected");
                } else {
                    ImFrame imFrame = new ImFrame(this.files[0].getPath(), new DefaultMeasurementHandler());
                    this.interpretIfRaw(imFrame);
                }
            } else if (string.equals("viewFlat")) {
                String string3 = this.flatPath.getText();
                if (string3.length() == 0) {
                    Util.warning("Sorry", "Flat image not selected");
                } else {
                    ImFrame imFrame = new ImFrame(string3, new DefaultMeasurementHandler());
                    this.interpretIfRaw(imFrame);
                }
            } else if (string.equals("viewLast")) {
                if (null == this.files || this.files.length == 0) {
                    Util.warning("Sorry", "No files selected");
                } else {
                    ImFrame imFrame = new ImFrame(this.files[this.files.length - 1].getPath(), new DefaultMeasurementHandler());
                    this.interpretIfRaw(imFrame);
                }
            }
        }
        if (null == this.files || 0 == this.files.length) {
            this.viewFirstButton.setEnabled(false);
            this.viewLastButton.setText("View last");
            this.viewLastButton.setEnabled(false);
        } else {
            this.viewFirstButton.setEnabled(true);
            this.viewLastButton.setText("View no " + this.files.length);
            this.viewLastButton.setEnabled(true);
        }
    }

    private void interpretIfRaw(ImFrame imFrame) {
        if (imFrame.getImPane().getImage().isRaw()) {
            Raw.interpret(imFrame);
            Raw.removeMargin(imFrame);
        }
    }
}

