/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.Accumulator;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.Config;
import net.grelf.grip.MatchList;
import net.grelf.grip.MatchPair;
import net.grelf.grip.StarSegmenter;
import net.grelf.grip.Warp;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.Image8or16Base;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.RangeInt;
import net.grelf.image.Timer;

public class Accumulator32
extends Image32
implements Accumulator {
    public Accumulator32(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public Accumulator32(int n, int n2, int n3, boolean bl) {
        super(n, n2, n3, bl);
    }

    public Accumulator32(BufferedImage bufferedImage) throws IncompatibleImageException {
        super(bufferedImage);
    }

    @Override
    public void addWithStarBoost(Image8or16Base image8or16Base, int n) throws IncompatibleImageException {
        int n2;
        int n3;
        this.checkCompatibility("add with star boost", image8or16Base.getBufferedImage());
        Timer timer = new Timer("Accumulator32.addWithStarBoost ()", image8or16Base);
        BlobMask blobMask = StarSegmenter.segment((Image)image8or16Base, Integer.parseInt(Config.getValue("StarSegmentDifference.value")), Integer.parseInt(Config.getValue("StarSegmentRadius.value")));
        byte[][] byArray = blobMask.getData();
        WritableRaster writableRaster = image8or16Base.getBufferedImage().getRaster();
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        int n5 = StrictMath.min(this.getWidth(), image8or16Base.getWidth());
        int n6 = StrictMath.min(this.getHeight(), image8or16Base.getHeight());
        writableRaster.getPixel(0, 0, nArray);
        int n7 = n3 = (n2 = this.data[0][0] + nArray[0]);
        int n8 = 1;
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            int n10 = 0;
            while (n10 < n5) {
                n8 = 3 == byArray[n10][i] ? n : 1;
                writableRaster.getPixel(n10, i, nArray);
                for (int j = 0; j < n4; ++j) {
                    this.data[j][n9] = n2 = this.data[j][n9] + nArray[j] * n8;
                    if (n2 < n3) {
                        n3 = n2;
                        continue;
                    }
                    if (n2 <= n7) continue;
                    n7 = n2;
                }
                ++n10;
                ++n9;
            }
        }
        if (n3 == n7) {
            ++n7;
        }
        this.setRange(new RangeInt(n3, n7));
        timer.stop();
    }

    @Override
    public boolean brightestShiftAccumulate(Image8or16Base image8or16Base, int n, int n2, List<PointFloat> list) throws IncompatibleImageException {
        Timer timer = new Timer("Accumulator32.brightestShiftAccumulate", image8or16Base);
        boolean bl = true;
        PointFloat pointFloat = list.get(n);
        PointFloat pointFloat2 = list.get(n2);
        if (null == pointFloat) {
            Util.warning("Error", "No centre found for shifting image " + (n + 1));
            bl = false;
        } else if (null == pointFloat2) {
            Util.warning("Error", "No centre found in middle image for shifting image " + (n + 1));
            bl = false;
        } else {
            double d = pointFloat2.x - pointFloat.x;
            double d2 = pointFloat2.y - pointFloat.y;
            this.addTranslated(image8or16Base.getBufferedImage(), d, d2);
        }
        timer.stop();
        return bl;
    }

    @Override
    public boolean averageShiftAccumulate(Image8or16Base image8or16Base, int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) throws IncompatibleImageException {
        boolean bl = true;
        double[] dArray = MatchList.getAverageShift(n, n2, list, blobMeasArray, n3);
        if (null == dArray || 2 > dArray.length) {
            bl = false;
        } else {
            this.addTranslated(image8or16Base.getBufferedImage(), dArray[0], dArray[1]);
        }
        return bl;
    }

    @Override
    public boolean warpAccumulate(Image8or16Base image8or16Base, int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) throws IncompatibleImageException {
        BufferedImage bufferedImage = Warp.warp(image8or16Base.getBufferedImage(), n, n2, list, blobMeasArray, n3);
        if (null == bufferedImage) {
            return false;
        }
        this.add(bufferedImage);
        bufferedImage.flush();
        bufferedImage = null;
        return true;
    }
}

