/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.grelf.Angle;
import net.grelf.Util;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.JulianDate;
import net.grelf.astro.Magnitude;
import net.grelf.astro.ProperMotion;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.StarChartLoader;
import net.grelf.astro.Variability;
import net.grelf.grip.Config;

public class Tycho
extends StarChartLoader {
    private static final Epoch tychoEpoch = new Epoch('J', 1991.25f);

    public void load(List<Star> list, Map<String, Star> map, SkyPoint skyPoint, JulianDate julianDate, double d) {
        Util.logInfo("Loading Tycho data");
        this.equinox = skyPoint.getEquinox();
        this.epoch = julianDate;
        this.initialiseChartCoordinates(skyPoint, d);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Config.getValue("PathTycho.value")));
            while (null != (string = bufferedReader.readLine())) {
                Star star = this.convertLineToStar(string, map);
                if (null == star) continue;
                list.add(star);
            }
            bufferedReader.close();
            Util.logInfo("{0} stars loaded", list.size());
        }
        catch (IOException iOException) {
            Util.warning("Error", "Could not load Tycho data.\nHave you downloaded tyc_main.dat from\nhttp://cdsarc.u-strasbg.fr/viz-bin/Cat?I/239?\nHave you set the path to it in the Config menu of GRIP?");
        }
    }

    private Star convertLineToStar(String string, Map<String, Star> map) {
        try {
            Cloneable cloneable;
            String string2;
            String string3 = string.substring(2, 14);
            String string4 = string.substring(210, 216);
            Star star = map.get(string4);
            if (null != star) {
                star.setTychoId(string3);
                return null;
            }
            double d = 0.0;
            double d2 = 0.0;
            Magnitude magnitude = null;
            Magnitude magnitude2 = null;
            String string5 = string.substring(51, 63);
            if (string5.trim().length() > 0) {
                d = Double.parseDouble(string5);
            }
            if ((string2 = string.substring(64, 76)).trim().length() > 0) {
                d2 = Double.parseDouble(string2);
            }
            Star star2 = new Star("", "", "", new RA(d), new Dec(d2), this.equinox, null, null);
            String string6 = string.substring(87, 95);
            double d3 = 0.0;
            if (string6.trim().length() > 0) {
                d3 = Double.parseDouble(string6);
            }
            String string7 = string.substring(96, 104);
            double d4 = 0.0;
            if (string7.trim().length() > 0) {
                d4 = Double.parseDouble(string7);
            }
            if (d3 != 0.0 || d4 != 0.0) {
                cloneable = new ProperMotion(d3 * 0.001, d4 * 0.001);
                star2.setProperMotion((ProperMotion)cloneable);
            }
            star2.changeEpoch(this.equinox, this.epoch);
            cloneable = star2.getPosition().getRA();
            Dec dec = star2.getPosition().getDec();
            double d5 = dec.cos();
            double d6 = ((Angle)cloneable).cos() * d5;
            double d7 = ((Angle)cloneable).sin() * d5;
            double d8 = dec.sin();
            double d9 = this.cosdp * this.sin90ap * d6 + this.cosdp * this.cos90ap * d7 - this.sindp * d8;
            if (d9 > 0.0) {
                double d10 = this.cos90ap * d6 - this.sin90ap * d7;
                if (-this.sinFieldRadius < d10 && d10 < this.sinFieldRadius) {
                    double d11 = this.sindp * this.sin90ap * d6 + this.sindp * this.cos90ap * d7 + this.cosdp * d8;
                    if (-this.sinFieldRadius < d11 && d11 < this.sinFieldRadius) {
                        star2.xdd = d10;
                        star2.zdd = d11;
                        star2.setTychoId(string3);
                        String string8 = string.substring(41, 46);
                        if (string8.trim().length() > 0) {
                            float f = Float.parseFloat(string8);
                            magnitude = new Magnitude(f, "V");
                            star2.setMagnitude(magnitude);
                            String string9 = string.substring(245, 251);
                            if (string9.trim().length() > 0) {
                                float f2 = Float.parseFloat(string9);
                                magnitude2 = new Magnitude(f2 + f, "B");
                                star2.addMagnitude(magnitude2);
                            }
                        }
                        Variability variability = Variability.NONE;
                        star2.setVariability(variability);
                        return star2;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            Util.logWarning("Number format error loading Tycho, line {0}", string);
            return null;
        }
    }
}

