/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.Util;
import net.grelf.astro.Magnitude;
import net.grelf.astro.Star;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;

public class MagnitudeTable
extends JTable {
    private static final String[] COLUMN_NAMES = new String[]{"Id", "Magnitude(s)", "Area", "Brightness", "Red", "Green", "Blue", "Accurate", "Red", "Green", "Blue"};
    private static final String UNKNOWN = "unknown";
    private static final String NOT_MEASURED = "not measured";
    private String title = "";
    private ImFrame parentFrame = null;
    private DefaultTableModel model;

    public MagnitudeTable(ImFrame imFrame, String string, BlobMeasList blobMeasList) {
        Object object;
        Object object22;
        this.parentFrame = imFrame;
        this.title = string;
        this.model = new DefaultTableModel(COLUMN_NAMES, 0);
        this.setModel(this.model);
        this.model.addRow(COLUMN_NAMES);
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        for (Object object22 : blobMeasList) {
            int n;
            String string2;
            object = ((BlobMeas)object22).getStar();
            if (null == object || 0 >= (string2 = ((Star)object).getId()).length()) continue;
            String[] stringArray = new String[COLUMN_NAMES.length];
            stringArray[0] = string2;
            List<Magnitude> list = ((Star)object).getMagnitudes();
            if (null != list && 0 < list.size()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Magnitude magnitude : list) {
                    stringBuffer.append(magnitude.toString());
                    stringBuffer.append(" ");
                }
                stringArray[1] = stringBuffer.toString();
            } else {
                stringArray[1] = UNKNOWN;
            }
            stringArray[2] = ((BlobMeas)object22).area + " pixels";
            stringArray[3] = "" + (int)StrictMath.round(((BlobMeas)object22).brightness);
            int n2 = ((BlobMeas)object22).channelBrightnesses.length;
            for (n = 0; n < n2; ++n) {
                stringArray[4 + n] = "" + ((BlobMeas)object22).channelBrightnesses[n];
            }
            if (null == ((BlobMeas)object22).accurateBrightnesses) {
                stringArray[4 + n2] = NOT_MEASURED;
                for (n = 0; n < n2; ++n) {
                    stringArray[4 + n2 + 1 + n] = "";
                }
            } else {
                stringArray[4 + n2] = "" + Util.rootSumOfSquares(((BlobMeas)object22).accurateBrightnesses);
                for (n = 0; n < n2; ++n) {
                    stringArray[4 + n2 + 1 + n] = "" + ((BlobMeas)object22).accurateBrightnesses[n];
                }
            }
            treeMap.put(string2, stringArray);
        }
        Set set = treeMap.keySet();
        object22 = set.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            this.model.addRow((Object[])treeMap.get(object));
        }
    }

    public void showTable() {
        Object[] objectArray = new String[]{"Save as CSV", "Close"};
        int n = objectArray.length - 1;
        int n2 = -1;
        do {
            String string;
            if ((n2 = JOptionPane.showOptionDialog(this.parentFrame, this, this.title, 2, -1, GRIP.getIcon(), objectArray, objectArray[n])) != n - 1 || null == (string = FileIO.selectOutputFile("Save as CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv"))) continue;
            Util.saveJTableAsCSV(null, this, string);
        } while (n2 < n);
    }
}

