/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import net.grelf.FileIO;
import net.grelf.FileIOImageFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Fitter_;
import net.grelf.InadequateDataException;
import net.grelf.TimeInterval;
import net.grelf.Util;
import net.grelf.astro.JulianDate;
import net.grelf.astro.Magnitude;
import net.grelf.astro.MagnitudeBands;
import net.grelf.astro.Star;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;

public class MagnitudeGraph
extends JComponent
implements Printable {
    private static final int GRAPH_WIDTH = 580;
    private static final int KEY_WIDTH = 140;
    private static final int GRAPH_HEIGHT = 600;
    private static final DecimalFormat FIXED2 = new DecimalFormat("0.00");
    private static final DecimalFormat FIXED3 = new DecimalFormat("0.000");
    private static final Color BACKGROUND = new Color(212, 208, 200);
    private static final Color RED = new Color(255, 0, 0);
    private static final Color GREEN = new Color(0, 128, 0);
    private static final Color BLUE = new Color(0, 0, 255);
    private static final Color BLACK = new Color(0, 0, 0);
    private int nBands;
    private String[] ids = null;
    private String[][] bandsUsed = null;
    private double[][] logBrightnesses = null;
    private double[][] sigmaLB = null;
    private double[][] magnitudes = null;
    private double minMagnitude = 100.0;
    private double maxMagnitude = -100.0;
    private double minLogBrightness = 100.0;
    private double maxLogBrightness = -100.0;
    private double[] gradientM;
    private double[] offsetC;
    private double[] chiSq;
    private double[] q;
    private BlobMeasList estimated = new BlobMeasList(null);
    private ImFrame imf;
    private TimeInterval timeSpan;
    private String title;
    private String filePath;
    private boolean accurate;
    private static final int CROSS_ARM = 3;
    private static HashPrintRequestAttributeSet atts = new HashPrintRequestAttributeSet();

    public boolean isAccurate() {
        return this.accurate;
    }

    public MagnitudeGraph(ImFrame imFrame, String string, BlobMeasList blobMeasList, MagnitudeBands magnitudeBands, String string2, TimeInterval timeInterval) throws InadequateDataException {
        double d;
        Object object;
        Object object2;
        Object object3;
        this.imf = imFrame;
        this.title = string;
        this.timeSpan = timeInterval;
        this.filePath = string2;
        this.setSize(720, 600);
        this.setPreferredSize(new Dimension(720, 600));
        if (0 == blobMeasList.size()) {
            throw new InadequateDataException("No blob measurements are available");
        }
        this.nBands = ((BlobMeas)blobMeasList.get((int)0)).channelBrightnesses.length;
        if (this.nBands != 3 && this.nBands != 1) {
            throw new InadequateDataException("Magnitude estimation can only be done on mono or RGB images at present.");
        }
        int n = 0;
        for (BlobMeas blobMeas : blobMeasList) {
            object3 = blobMeas.getStar();
            if (null == object3 || null == ((Star)object3).getMagnitude()) continue;
            ++n;
        }
        if (2 > n) {
            throw new InadequateDataException("There are fewer than 2 reference stars. Enter more identifiers and known magnitudes.");
        }
        this.ids = new String[n];
        this.logBrightnesses = new double[this.nBands + 1][n];
        this.sigmaLB = new double[this.nBands + 1][n];
        this.magnitudes = new double[this.nBands + 1][n];
        this.bandsUsed = new String[this.nBands + 1][n];
        n = 0;
        this.accurate = false;
        int n2 = 0;
        boolean bl = true;
        for (Cloneable cloneable : blobMeasList) {
            object2 = ((BlobMeas)cloneable).getStar();
            if (null != object2 && ((String)(object = ((Star)object2).getId())).length() > 0 && null == ((Star)object2).getMagnitude() && null == ((BlobMeas)cloneable).accurateBrightnesses) {
                bl = false;
                break;
            }
            if (null == ((BlobMeas)cloneable).accurateBrightnesses || null == object2 || null == ((Star)object2).getMagnitude()) continue;
            ++n2;
        }
        if (bl && n2 > 1) {
            this.accurate = true;
        }
        for (BlobMeas blobMeas : blobMeasList) {
            double d2;
            double d3;
            double d4;
            Cloneable cloneable;
            object3 = blobMeas.getStar();
            if (null == object3 || null == ((Star)object3).getMagnitude()) continue;
            this.ids[n] = ((Star)object3).getId();
            for (int i = 0; i < this.nBands; ++i) {
                object2 = magnitudeBands.getBand(i);
                object = ((Star)object3).getMagnitude((String)object2);
                if (null == object) {
                    object = ((Star)object3).getMagnitude("V");
                    if (null == object) {
                        this.bandsUsed[i][n] = "";
                        object = ((Star)object3).getMagnitude();
                    } else {
                        this.bandsUsed[i][n] = "V";
                    }
                } else {
                    this.bandsUsed[i][n] = object2;
                }
                this.magnitudes[i][n] = d4 = (double)((Magnitude)object).getValue();
                if (d4 < this.minMagnitude) {
                    this.minMagnitude = d4;
                }
                if (!(d4 > this.maxMagnitude)) continue;
                this.maxMagnitude = d4;
            }
            cloneable = ((Star)object3).getMagnitude();
            this.magnitudes[this.nBands][n] = d3 = (double)((Magnitude)cloneable).getValue();
            this.bandsUsed[this.nBands][n] = ((Magnitude)cloneable).getBandId();
            if (d3 < this.minMagnitude) {
                this.minMagnitude = d3;
            }
            if (d3 > this.maxMagnitude) {
                this.maxMagnitude = d3;
            }
            if (this.accurate) {
                if (null == blobMeas.accurateBrightnesses) {
                    Util.logWarning("{0} does not have accurate brightness", blobMeas.getStar().getId());
                    break;
                }
                double d5 = Util.rootSumOfSquares(blobMeas.accurateBrightnesses);
                d4 = StrictMath.log10(d5);
                double d6 = 0.0;
                for (int i = 0; i < this.nBands; ++i) {
                    d6 += blobMeas.backgroundStatistics[i].stdDev;
                }
                double d7 = d6 / (double)this.nBands;
                double d8 = 1.414 * d7 / StrictMath.sqrt(blobMeas.backgroundStatistics[0].n);
                double d9 = 0.5 * (StrictMath.log10(d5 + d8) - StrictMath.log10(d5 - d8));
                this.sigmaLB[this.nBands][n] = d9 * StrictMath.sqrt(blobMeas.nPixelsMeasured);
            } else {
                d4 = StrictMath.log10(blobMeas.brightness);
            }
            this.logBrightnesses[this.nBands][n] = d4;
            if (d4 < this.minLogBrightness) {
                this.minLogBrightness = d4;
            }
            if (d4 > this.maxLogBrightness) {
                this.maxLogBrightness = d4;
            }
            if (this.nBands == 1) {
                this.logBrightnesses[0][n] = this.logBrightnesses[1][n];
            } else if (this.accurate && null != blobMeas.accurateBrightnesses) {
                for (int i = 0; i < this.nBands; ++i) {
                    this.logBrightnesses[i][n] = d2 = StrictMath.log10(blobMeas.accurateBrightnesses[i]);
                    if (d2 < this.minLogBrightness) {
                        this.minLogBrightness = d2;
                    }
                    if (d2 > this.maxLogBrightness) {
                        this.maxLogBrightness = d2;
                    }
                    d = StrictMath.sqrt(blobMeas.nPixelsMeasured);
                    double d10 = 1.414 * d * blobMeas.backgroundStatistics[i].stdDev / StrictMath.sqrt(blobMeas.backgroundStatistics[i].n);
                    double d11 = 0.5 * (StrictMath.log10((double)blobMeas.accurateBrightnesses[i] + d10) - StrictMath.log10((double)blobMeas.accurateBrightnesses[i] - d10));
                    this.sigmaLB[i][n] = d11 * d;
                }
            } else {
                for (int i = 0; i < this.nBands; ++i) {
                    this.logBrightnesses[i][n] = d2 = StrictMath.log10(blobMeas.channelBrightnesses[i]);
                    if (d2 < this.minLogBrightness) {
                        this.minLogBrightness = d2;
                    }
                    if (!(d2 > this.maxLogBrightness)) continue;
                    this.maxLogBrightness = d2;
                }
            }
            ++n;
        }
        this.gradientM = new double[this.nBands + 1];
        this.offsetC = new double[this.nBands + 1];
        this.chiSq = new double[this.nBands + 1];
        this.q = new double[this.nBands + 1];
        for (n = 0; n < this.nBands + 1; ++n) {
            this.gradientM[n] = 0.0;
            this.offsetC[n] = 0.0;
            this.chiSq[n] = 0.0;
            this.q[n] = 0.0;
        }
        for (n = 0; n < this.nBands + 1; ++n) {
            Fitter_ fitter_ = new Fitter_();
            if (this.accurate) {
                fitter_.leastSquaresStraightLine(this.magnitudes[n], this.logBrightnesses[n], this.sigmaLB[n]);
            } else {
                fitter_.leastSquaresStraightLine(this.magnitudes[n], this.logBrightnesses[n], null);
            }
            this.gradientM[n] = fitter_.getM();
            this.offsetC[n] = fitter_.getC();
            this.chiSq[n] = fitter_.getChiSq();
            this.q[n] = fitter_.getQ();
            double d12 = fitter_.getSigmaM();
            double d13 = fitter_.getSigmaC();
            for (BlobMeas blobMeas : blobMeasList) {
                String string3;
                Star star = blobMeas.getStar();
                if (null == star || (string3 = star.getId()).length() <= 0 || null != star.getMagnitude()) continue;
                BlobMeas blobMeas2 = new BlobMeas();
                Star star2 = star.clone();
                blobMeas2.setStar(star2);
                if (this.nBands == 1) {
                    star2.setOtherId(string3);
                    blobMeas2.brightness = this.accurate ? StrictMath.sqrt(Util.rootSumOfSquares(blobMeas.accurateBrightnesses)) : blobMeas.brightness;
                } else if (this.nBands == 3) {
                    switch (n) {
                        case 0: {
                            star2.setOtherId(string3 + " (red)");
                            if (this.accurate) {
                                blobMeas2.brightness = blobMeas.accurateBrightnesses[0];
                                break;
                            }
                            blobMeas2.brightness = blobMeas.channelBrightnesses[0];
                            break;
                        }
                        case 1: {
                            star2.setOtherId(string3 + " (green)");
                            if (this.accurate) {
                                blobMeas2.brightness = blobMeas.accurateBrightnesses[1];
                                break;
                            }
                            blobMeas2.brightness = blobMeas.channelBrightnesses[1];
                            break;
                        }
                        case 2: {
                            star2.setOtherId(string3 + " (blue)");
                            if (this.accurate) {
                                blobMeas2.brightness = blobMeas.accurateBrightnesses[2];
                                break;
                            }
                            blobMeas2.brightness = blobMeas.channelBrightnesses[2];
                            break;
                        }
                        case 3: {
                            star2.setOtherId(string3 + " (overall)");
                            blobMeas2.brightness = this.accurate ? (double)Util.rootSumOfSquares(blobMeas.accurateBrightnesses) : blobMeas.brightness;
                        }
                    }
                }
                d = StrictMath.log10(blobMeas2.brightness);
                float f = (float)fitter_.x(d);
                star2.setMagnitude(new Magnitude(f));
                if ((double)f < this.minMagnitude) {
                    this.minMagnitude = f;
                } else if ((double)f > this.maxMagnitude) {
                    this.maxMagnitude = f;
                }
                if (d < this.minLogBrightness) {
                    this.minLogBrightness = d;
                } else if (d > this.maxLogBrightness) {
                    this.maxLogBrightness = d;
                }
                float[] fArray = new float[]{(float)((d - this.offsetC[n] - d13) / (this.gradientM[n] - d12)), (float)((d - this.offsetC[n] - d13) / (this.gradientM[n] + d12)), (float)((d - this.offsetC[n] + d13) / (this.gradientM[n] - d12)), (float)((d - this.offsetC[n] + d13) / (this.gradientM[n] + d12))};
                Arrays.sort(fArray);
                float f2 = fArray[3] - fArray[0];
                star2.addMagnitude(new Magnitude(f2, "CI"));
                this.estimated.add(blobMeas2);
            }
        }
        this.minLogBrightness = StrictMath.floor(this.minLogBrightness);
        this.maxLogBrightness = StrictMath.ceil(this.maxLogBrightness);
        this.minMagnitude = StrictMath.floor(this.minMagnitude);
        this.maxMagnitude = StrictMath.ceil(this.maxMagnitude);
    }

    protected void draw(Graphics2D graphics2D, int n, int n2) {
        Object object;
        Object object2;
        int n3;
        int n4;
        int n5;
        Font font = graphics2D.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), font.getSize() - 2);
        int n6 = n + 50;
        int n7 = n2 + 600 - 50;
        double d = 480.0 / (this.maxMagnitude - this.minMagnitude);
        double d2 = 500.0 / (this.maxLogBrightness - this.minLogBrightness);
        graphics2D.setPaint(BACKGROUND);
        graphics2D.fillRect(n, n2, n + 580 + 140, n2 + 600);
        graphics2D.setPaint(BLACK);
        graphics2D.drawLine(n6, n7, n6 + 580 - 100, n7);
        graphics2D.drawString("known magnitude", n6 + 240, n7 + 25);
        graphics2D.drawString("" + FIXED2.format(this.minMagnitude), n6 - 8, n7 + 25);
        graphics2D.drawString("" + FIXED2.format(this.maxMagnitude), n6 - 8 + 580 - 100, n7 + 25);
        for (n5 = (int)this.minMagnitude; n5 <= (int)this.maxMagnitude; ++n5) {
            n4 = n6 + (int)StrictMath.round(d * ((double)n5 - this.minMagnitude));
            graphics2D.drawLine(n4, n7, n4, n7 + 5);
        }
        graphics2D.drawLine(n6, n7, n6, n7 - 600 + 100);
        n5 = n6 - 25;
        n4 = n7 - 600 + 75;
        graphics2D.drawString("log10 brightness", n5, n4);
        if (this.accurate) {
            graphics2D.drawString("measured in image", n5, n4 + 16);
        } else {
            graphics2D.drawString("detected in image", n5, n4 + 16);
        }
        int n8 = n6 - 50 + 15;
        graphics2D.drawString("" + FIXED2.format(this.minLogBrightness), n8, n7 + 8);
        graphics2D.drawString("" + FIXED2.format(this.maxLogBrightness), n8, n7 - 600 + 100 + 8);
        for (n3 = (int)this.minLogBrightness; n3 <= (int)this.maxLogBrightness; ++n3) {
            int n9 = n7 - (int)StrictMath.round(d2 * ((double)n3 - this.minLogBrightness));
            graphics2D.drawLine(n6, n9, n6 - 5, n9);
        }
        for (n5 = 0; n5 < this.nBands + 1; ++n5) {
            if (this.nBands == 1) {
                n5 = 1;
            }
            if (n5 == this.nBands) {
                graphics2D.setPaint(BLACK);
            } else if (n5 == this.nBands - 1) {
                graphics2D.setPaint(BLUE);
            } else if (n5 == this.nBands - 2) {
                graphics2D.setPaint(GREEN);
            } else {
                graphics2D.setPaint(RED);
            }
            graphics2D.drawLine(n6, n7 - (int)StrictMath.round(d2 * (this.gradientM[n5] * this.minMagnitude + this.offsetC[n5] - this.minLogBrightness)), n6 + 580 - 100, n7 - (int)StrictMath.round(d2 * (this.gradientM[n5] * this.maxMagnitude + this.offsetC[n5] - this.minLogBrightness)));
            graphics2D.setFont(font2);
            for (n4 = 0; n4 < this.ids.length; ++n4) {
                n8 = n6 + (int)StrictMath.round(d * (this.magnitudes[n5][n4] - this.minMagnitude));
                n3 = n7 - (int)StrictMath.round(d2 * (this.logBrightnesses[n5][n4] - this.minLogBrightness));
                this.drawCross(graphics2D, n8, n3);
                graphics2D.drawString("" + (n4 + 1), n8 + 6, n3 + 5);
            }
            graphics2D.setFont(font);
        }
        graphics2D.setPaint(BLACK);
        n5 = 1;
        n4 = n6 + 160;
        n8 = n7 - 550 + 16;
        for (BlobMeas blobMeas : this.estimated) {
            object2 = blobMeas.getStar();
            object = ((Star)object2).getId();
            float f = ((Star)object2).getMagnitude().getValue();
            float f2 = ((Star)object2).getMagnitude("CI").getValue();
            int n10 = n6 + (int)StrictMath.round(d * ((double)f - this.minMagnitude));
            int n11 = n7 - (int)StrictMath.round(d2 * (StrictMath.log10(blobMeas.brightness) - this.minLogBrightness));
            this.drawCross(graphics2D, n10, n11);
            graphics2D.setFont(font2);
            graphics2D.drawString((String)object, n10 + 6, n11 + 5);
            graphics2D.setFont(font);
            graphics2D.drawString((String)object + " magnitude = " + FIXED2.format(f) + " \u00b1 " + FIXED3.format(f2), n4, n8);
            n8 += 16;
            if (1 == this.nBands) break;
            ++n5;
        }
        graphics2D.drawString("(95% confidence intervals)", n4, n8);
        n8 += 16;
        int n12 = 480;
        int n13 = 80;
        if (null != this.filePath) {
            object2 = new File(this.filePath).getName();
            graphics2D.drawString("Image measured:", n12, n13);
            graphics2D.drawString((String)object2, n12, n13 += 16);
            n13 += 16;
        }
        if (null != this.timeSpan) {
            object2 = new JulianDate(this.timeSpan.getStart());
            object = new JulianDate(this.timeSpan.getEnd());
            graphics2D.drawString("Exposed from: " + ((JulianDate)object2).toImageTimestampFormat(), n12, n13);
            graphics2D.drawString("(JD " + ((JulianDate)object2).toString() + ")", n12, n13 += 16);
            graphics2D.drawString("to: " + ((JulianDate)object).toImageTimestampFormat(), n12, n13 += 16);
            graphics2D.drawString("(JD " + ((JulianDate)object).toString() + ")", n12, n13 += 16);
            n13 += 16;
        }
        n12 = 580;
        graphics2D.drawString("Ref. stars & bands used", n12, n13);
        n13 += 16;
        for (int i = 0; i < this.ids.length; ++i) {
            object = new StringBuffer();
            ((StringBuffer)object).append(i + 1);
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append(this.ids[i]);
            ((StringBuffer)object).append(" ");
            for (int j = 0; j <= this.nBands; ++j) {
                String string = this.bandsUsed[j][i];
                if (null == string || 0 == string.length()) {
                    ((StringBuffer)object).append("_");
                    continue;
                }
                ((StringBuffer)object).append(string);
            }
            graphics2D.drawString(((StringBuffer)object).toString(), n12, n13);
            n13 += 16;
        }
    }

    private void drawCross(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawLine(n - 3, n2, n + 3, n2);
        graphics2D.drawLine(n, n2 - 3, n, n2 + 3);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public static HashPrintRequestAttributeSet getAtts() {
        return atts;
    }

    public void showGraph() {
        Object[] objectArray = new String[]{"Save data as XML", "Print", "Save as image", "Close"};
        int n = objectArray.length - 1;
        int n2 = -1;
        do {
            Object object;
            if ((n2 = JOptionPane.showOptionDialog(this.imf, this, this.title, 2, -1, GRIP.getIcon(), objectArray, objectArray[n])) == n - 3) {
                this.saveDataAsXML();
                continue;
            }
            if (n2 == n - 2) {
                object = PrinterJob.getPrinterJob();
                ((PrinterJob)object).setPrintable(this);
                if (!((PrinterJob)object).printDialog(atts)) continue;
                try {
                    ((PrinterJob)object).print();
                }
                catch (PrinterException printerException) {
                    Util.logWarning(printerException.getMessage());
                }
                continue;
            }
            if (n2 != n - 1 || (object = FileIO.selectOutputFile("Save graph as image", null, new FileIOImageFilter[]{new FileIOImageFilter(3), new FileIOImageFilter(5), new FileIOImageFilter(4)}, "MagnitudeGraph.png")) == null) continue;
            Image image = ImageBase.createImage(580, 600, 3, 8);
            BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
            if (null != bufferedImage) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.draw(graphics2D, 0, 0);
                image.save((String)object);
                continue;
            }
            Util.message(this, "Sorry", "Could not create image");
        } while (n2 < n);
    }

    public void saveDataAsXML() {
        String string = FileIO.selectOutputFile("Create XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Magnitudes>");
                printWriter.println("\t<Software>GRIP v12.6.24</Software>");
                printWriter.println("\t<Chart id=\"?c\">");
                for (String string2 : this.ids) {
                    printWriter.println("\t\t<RefStar>" + string2 + "</RefStar>");
                }
                printWriter.println("\t</Chart>");
                printWriter.println("\t<Observation equipment=\"?e\" chart=\"?c\">");
                for (BlobMeas blobMeas : this.estimated) {
                    Star star = blobMeas.getStar();
                    if (null == star) continue;
                    printWriter.println("\t\t<Measured>");
                    printWriter.println("\t\t\t<Star>" + star.getId() + "</Star>");
                    float f = star.getMagnitude().getValue();
                    float f2 = star.getMagnitude("CI").getValue();
                    printWriter.println("\t\t\t<Magnitude ci95=\"" + FIXED2.format(f2) + "\">" + FIXED2.format(f) + "</Magnitude>");
                    printWriter.println("\t\t</Measured>");
                }
                printWriter.println("\t\t<Image>");
                if (null != this.filePath || null != this.timeSpan) {
                    if (null != this.filePath) {
                        printWriter.println("\t\t\t<File>" + new File(this.filePath).getName() + "</File>");
                    }
                    if (null != this.timeSpan) {
                        JulianDate julianDate = new JulianDate(this.timeSpan.getStart());
                        JulianDate julianDate2 = new JulianDate(this.timeSpan.getEnd());
                        printWriter.println("\t\t\t<ExposureStart>" + julianDate.toXmlDateTime() + "</ExposureStart>");
                        printWriter.println("\t\t\t<ExposureEnd>" + julianDate2.toXmlDateTime() + "</ExposureEnd>");
                        printWriter.println("\t\t\t<ExposureStartJD>" + julianDate.toString() + "</ExposureStartJD>");
                        printWriter.println("\t\t\t<ExposureEndJD>" + julianDate2.toString() + "</ExposureEndJD>");
                    }
                }
                for (int i = 0; i < this.nBands; ++i) {
                    printWriter.println("\t\t\t<Channel no=\"" + i + "\" refBandUsed=\"" + this.bandsUsed[i][0] + "\"/>");
                }
                printWriter.println("\t\t\t<Overall refBandUsed=\"" + this.bandsUsed[this.nBands][0] + "\"/>");
                printWriter.println("\t\t</Image>");
                printWriter.println("\t</Observation>");
                printWriter.println("</Magnitudes>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }
}

