/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.grelf.MeasuredValue;
import net.grelf.NoUnits;

public class Magnitude
implements Cloneable,
Serializable {
    private MeasuredValue mv;
    private String bandId = "";
    private static final DecimalFormat DF = new DecimalFormat("0.00");

    public float getValue() {
        return (float)this.mv.getValue();
    }

    public float getSigma() {
        return (float)this.mv.getStdErr();
    }

    public String getBandId() {
        return this.bandId;
    }

    public Magnitude(float f) {
        this.mv = new MeasuredValue(f, 0.0, NoUnits.NONE);
    }

    public Magnitude(float f, float f2) {
        this.mv = new MeasuredValue(f, f2, NoUnits.NONE);
    }

    public Magnitude(float f, String string) {
        this(f);
        this.bandId = string;
    }

    public Magnitude(float f, float f2, String string) {
        this(f, f2);
        this.bandId = string;
    }

    public Magnitude(MeasuredValue measuredValue, String string) {
        this.mv = measuredValue;
        this.bandId = string;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Magnitude magnitude = (Magnitude)object;
        if (!magnitude.mv.equals(this.mv)) {
            return false;
        }
        return magnitude.bandId.equals(this.bandId);
    }

    public int hashCode() {
        return this.mv.hashCode() * 7654321 + this.bandId.hashCode();
    }

    public Magnitude clone() {
        return new Magnitude(this.mv, this.bandId);
    }

    public String toString() {
        if (this.bandId.length() > 0) {
            return "(" + this.bandId + ")" + this.mv.toString(DF);
        }
        return this.mv.toString(DF);
    }

    public StringBuffer toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bandId.length() == 0) {
            stringBuffer.append("<Mag>");
            stringBuffer.append(this.mv.getValue());
            stringBuffer.append("</Mag>");
        } else {
            stringBuffer.append("<Mag>");
            stringBuffer.append("<Band>");
            stringBuffer.append(this.bandId);
            stringBuffer.append("</Band>");
            stringBuffer.append("<Value>");
            stringBuffer.append(this.mv.getValue());
            stringBuffer.append("</Value>");
            stringBuffer.append("</Mag>");
        }
        return stringBuffer;
    }
}

