/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.grelf.NamespaceContext;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.XmlUtil;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.Magnitude;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.StarChartLoader;
import org.astrogrid.acr.ACRException;
import org.astrogrid.acr.Finder;
import org.astrogrid.acr.NotFoundException;
import org.astrogrid.acr.ServiceException;
import org.astrogrid.acr.builtin.ACR;
import org.astrogrid.acr.cds.Sesame;
import org.astrogrid.acr.cds.SesamePositionBean;
import org.astrogrid.acr.ivoa.Cone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AstroGridGateway
extends StarChartLoader {
    private static AstroGridGateway instance = null;
    private ACR ar;
    private static final Epoch J2000 = new Epoch(2000.0f);
    private static final String USNOB = "ivo://fs.usno/cat/usnob";
    private static final String TYCHO2 = "ivo://CDS.VizieR/I/259";
    private static final String[] CONE_SERVICE_URIS = new String[]{"ivo://CDS.VizieR/I/259", "ivo://fs.usno/cat/usnob"};
    private String coneServiceURI = "ivo://CDS.VizieR/I/259";
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final XPath XPATH = XPATH_FACTORY.newXPath();

    public static synchronized AstroGridGateway getInstance() {
        if (null == instance) {
            instance = new AstroGridGateway();
        }
        return instance;
    }

    private AstroGridGateway() {
        this.equinox = new Epoch(2000.0f);
    }

    public boolean isAvailable() {
        try {
            Class<?> clazz = Class.forName("org.astrogrid.acr.Finder");
            Timer timer = new Timer("Connecting to AstroGrid RunTime", null);
            Finder finder = new Finder();
            this.ar = finder.find();
            timer.stop();
            return null != this.ar;
        }
        catch (ACRException aCRException) {
            Util.logWarning("Could not connect to AstroGrid");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Util.logWarning("AstroGrid JAR files not on classpath");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Util.logWarning("AstroGrid JAR files not on classpath");
        }
        catch (Exception exception) {
            Util.logWarning("Could not connect to AstroGrid");
        }
        return false;
    }

    public SkyPoint getPositionOfNamedObject(String string) {
        if (this.isAvailable()) {
            try {
                Sesame sesame = (Sesame)this.ar.getService(Sesame.class);
                Timer timer = new Timer("Sesame service", null);
                SesamePositionBean sesamePositionBean = sesame.resolve(string);
                timer.stop();
                if (null != sesamePositionBean) {
                    return new SkyPoint(new RA(sesamePositionBean.getRa()), new Dec(sesamePositionBean.getDec()), new Epoch(2000.0f));
                }
            }
            catch (NotFoundException notFoundException) {
                Util.logWarning("Object {0} not found", string);
            }
            catch (ServiceException serviceException) {
                Util.logWarning("Sesame service failure");
            }
            catch (ACRException aCRException) {
                Util.logWarning("Could not connect to Sesame service");
            }
        }
        return null;
    }

    public String[] getAcceptableConeServiceURIs() {
        return CONE_SERVICE_URIS;
    }

    public String getConeServiceURI() {
        return this.coneServiceURI;
    }

    public boolean assignConeServiceURI(String string) {
        for (String string2 : CONE_SERVICE_URIS) {
            if (!string2.equals(string)) continue;
            this.coneServiceURI = string;
            return true;
        }
        return false;
    }

    public List<Star> searchCone(SkyPoint skyPoint, double d) {
        if (this.isAvailable()) {
            try {
                Timer timer = new Timer("Cone service", null);
                Cone cone = (Cone)this.ar.getService(Cone.class);
                URI uRI = new URI(this.coneServiceURI);
                if (skyPoint.getEquinox().getYear() != 2000.0f) {
                    skyPoint.changeEquinox(J2000);
                }
                URL uRL = cone.constructQuery(uRI, skyPoint.getRA().toDegrees(), skyPoint.getDec().toDegrees(), d);
                Util.logInfo("Invoking {0}", this.coneServiceURI);
                Document document = cone.executeVotable(uRL);
                timer.stop();
                if (null != document) {
                    this.initialiseChartCoordinates(skyPoint, d);
                    return this.analyseCone(document);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Util.logWarning("Cone service URI has invalid syntax");
            }
            catch (ServiceException serviceException) {
                Util.logWarning("Cone service failure");
            }
            catch (ACRException aCRException) {
                Util.logWarning("Could not connect to Cone service");
            }
            catch (Exception exception) {
                Util.logWarning("Cone service failure");
            }
            catch (StackOverflowError stackOverflowError) {
                Util.logWarning("Cone service response caused stack overflow");
            }
        }
        return null;
    }

    private List<Star> analyseCone(Document document) {
        Object object;
        try {
            object = new PrintWriter("votable.xml");
            XmlUtil.outputDocument((PrintWriter)object, document);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
        object = document.getDocumentElement();
        if (!object.getTagName().equals("VOTABLE")) {
            Util.logWarning("Root element of cone result is not VOTABLE");
            return null;
        }
        String string = "/vot:VOTABLE/vot:RESOURCE/vot:TABLE/vot:DATA/vot:TABLEDATA/vot:TR";
        try {
            NamespaceContext namespaceContext = new NamespaceContext("vot", "http://www.ivoa.net/xml/VOTable/v1.1");
            XPATH.setNamespaceContext(namespaceContext);
            XPathExpression xPathExpression = XPATH.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            ArrayList<Star> arrayList = new ArrayList<Star>();
            Util.logInfo("{0} TR elements found", nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    if (element.getTagName().equals("TR")) {
                        arrayList.add(this.analyseTR(element));
                        continue;
                    }
                    Util.logWarning("Non-TR element found by XPath: {0}", string);
                    continue;
                }
                Util.logWarning("Non-element node found by XPath: {0}", string);
            }
            return arrayList;
        }
        catch (XPathExpressionException xPathExpressionException) {
            Util.logWarning("Could not evaluate XPath: {0}", string);
            return null;
        }
    }

    private Star analyseTR(Element element) {
        NodeList nodeList;
        Star star = new Star();
        StringBuffer stringBuffer = new StringBuffer();
        RA rA = null;
        Dec dec = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.coneServiceURI.equals(TYCHO2)) {
            this.equinox = J2000;
        }
        if (null == (nodeList = element.getChildNodes())) {
            Util.logWarning("TR element of cone result has no children");
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(string = (element2 = (Element)node).getTagName()).equals("TD")) continue;
            String string2 = element2.getTextContent();
            try {
                if (this.coneServiceURI.equals(TYCHO2)) {
                    switch (i) {
                        case 1: {
                            rA = new RA(Double.parseDouble(string2));
                            break;
                        }
                        case 2: {
                            dec = new Dec(Double.parseDouble(string2));
                            break;
                        }
                        case 3: 
                        case 4: {
                            stringBuffer.append(string2);
                            stringBuffer.append(" ");
                            break;
                        }
                        case 5: {
                            stringBuffer.append(string2);
                            star.setTychoId(stringBuffer.toString());
                            break;
                        }
                        case 8: {
                            star.addMagnitude(new Magnitude(Float.parseFloat(string2), "B"));
                            break;
                        }
                        case 9: {
                            star.addMagnitude(new Magnitude(Float.parseFloat(string2), "V"));
                            break;
                        }
                        case 10: {
                            star.setHipparcosId(string2);
                        }
                    }
                    continue;
                }
                if (!this.coneServiceURI.equals(USNOB)) continue;
                switch (i) {
                    case 0: {
                        star.setOtherId(string2);
                        break;
                    }
                    case 1: {
                        rA = new RA(Double.parseDouble(string2));
                        break;
                    }
                    case 2: {
                        dec = new Dec(Double.parseDouble(string2));
                        break;
                    }
                    case 7: {
                        this.equinox = new Epoch(Float.parseFloat(string2));
                        break;
                    }
                    case 17: {
                        f = Float.parseFloat(string2);
                        break;
                    }
                    case 24: {
                        f2 = Float.parseFloat(string2);
                        break;
                    }
                    case 31: {
                        f3 = Float.parseFloat(string2);
                        break;
                    }
                    case 38: {
                        f4 = Float.parseFloat(string2);
                    }
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                Util.logWarning("TD element content{0} cannot be parsed as a number", string2);
            }
        }
        if (this.coneServiceURI.equals(USNOB)) {
            if (f2 > 0.0f) {
                star.addMagnitude(new Magnitude(f2, "R"));
            } else if (f4 > 0.0f) {
                star.addMagnitude(new Magnitude(f4, "R"));
            }
            if (f > 0.0f) {
                star.addMagnitude(new Magnitude(f, "B"));
            } else if (f3 > 0.0f) {
                star.addMagnitude(new Magnitude(f3, "B"));
            }
        }
        star.setPosition(new SkyPoint(rA, dec, this.equinox));
        this.calculateChartCoordinates(star);
        return star;
    }
}

