/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.Serializable;
import net.grelf.Maths;
import net.grelf.PointFloat;

public class VectorFloat
implements Serializable,
Cloneable,
Comparable<VectorFloat> {
    public float r;
    public float theta;
    private static final float DEFAULT_RADIUS_TOLERANCE = 10.0f;
    private static float radiusTolerance = 10.0f;
    private static final float DEFAULT_ANGLE_TOLERANCE = 0.2f;
    private static float angleTolerance = 0.2f;

    public float getDx() {
        return (float)Math.sin(this.theta) * this.r;
    }

    public float getDy() {
        return (float)Math.cos(this.theta) * this.r;
    }

    public static float getRadiusTolerance() {
        return radiusTolerance;
    }

    public static void setRadiusTolerance(float f) {
        radiusTolerance = f;
    }

    public static float getAngleTolerance() {
        return angleTolerance;
    }

    public static void setAngleTolerance(float f) {
        angleTolerance = f;
    }

    public static void resetDefaultTolerances() {
        radiusTolerance = 10.0f;
        angleTolerance = 0.2f;
    }

    public VectorFloat(float f, float f2) {
        this.r = f;
        this.theta = f2;
    }

    public VectorFloat(PointFloat pointFloat, PointFloat pointFloat2) {
        float f = pointFloat2.x - pointFloat.x;
        float f2 = pointFloat2.y - pointFloat.y;
        this.r = (float)Math.sqrt(f * f + f2 * f2);
        this.theta = (float)Math.atan2(f2, f);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && Math.abs(((VectorFloat)object).r - this.r) < radiusTolerance && Math.abs(((VectorFloat)object).theta - this.theta) < angleTolerance;
    }

    public int hashCode() {
        int n = 3;
        n = 29 * n + Float.floatToIntBits(this.r);
        n = 13 * n + Float.floatToIntBits(this.theta);
        return n;
    }

    @Override
    public int compareTo(VectorFloat vectorFloat) {
        double d;
        double d2 = Maths.toDegrees(this.theta);
        double d3 = Maths.angleDifference(d2, d = Maths.toDegrees(vectorFloat.theta));
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 > 0.0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "VectorFloat: r = " + this.r + " px, theta = " + 180.0 * (double)this.theta / Math.PI + " degrees";
    }

    public VectorFloat clone() {
        return new VectorFloat(this.r, this.theta);
    }
}

