/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class Util {
    public static final boolean DEBUG = false;
    private static Component owningApp = null;
    private static ImageIcon ownerIcon = null;
    private static final SimpleDateFormat SDF_yyyyMMddTHHmmss = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static boolean showErrors = true;

    private Util() {
    }

    public static void setOwningApp(Component component, ImageIcon imageIcon) {
        owningApp = component;
        ownerIcon = imageIcon;
    }

    public static double askDouble(String string, double d, double d2, double d3) {
        return Util.askDouble(owningApp, string, d, d2, d3);
    }

    public static double askDouble(Component component, String string, double d, double d2, double d3) {
        while (true) {
            try {
                String string2;
                double d4;
                do {
                    if (null != (string2 = JOptionPane.showInputDialog(component, string, "" + d)) && 0 != string2.length()) continue;
                    return Double.NaN;
                } while (!((d4 = Double.parseDouble(string2)) >= d2) || !(d4 <= d3));
                return d4;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    public static int askInteger(String string, int n, int n2, int n3) {
        return Util.askInteger(owningApp, string, n, n2, n3);
    }

    public static int askInteger(Component component, String string, int n, int n2, int n3) {
        while (true) {
            try {
                String string2;
                int n4;
                do {
                    if (null != (string2 = JOptionPane.showInputDialog(component, string, "" + n)) && 0 != string2.length()) continue;
                    return Integer.MIN_VALUE;
                } while ((n4 = Integer.parseInt(string2)) < n2 || n4 > n3);
                return n4;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    public static String askString(String string, String string2) {
        return Util.askString(owningApp, string, string2);
    }

    public static String askString(Component component, String string, String string2) {
        return JOptionPane.showInputDialog(component, string, string2);
    }

    public static boolean confirm(String string, Object object) {
        return Util.confirm(owningApp, string, object);
    }

    public static boolean confirm(Component component, String string, Object object) {
        return 0 == JOptionPane.showConfirmDialog(component, object, string, 0, 3, ownerIcon);
    }

    public static String format_yyyyMMddTHHmmss(Date date) {
        return SDF_yyyyMMddTHHmmss.format(date);
    }

    public static String format(double d) {
        if (d == 0.0) {
            return "0";
        }
        DecimalFormat decimalFormat = d < 1000.0 && d >= 1.0 ? new DecimalFormat("##0.####") : (d < 1.0 && d >= 0.01 ? new DecimalFormat("'0'.0000") : new DecimalFormat("0.0000E0"));
        return decimalFormat.format(d);
    }

    public static String formatHTML(double d) {
        String string = Util.format(d);
        int n = string.indexOf("E");
        if (-1 != n && n < string.length() - 1) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            if (!string2.equals("0")) {
                string = string + " x 10<sup>" + string2 + "</sup>";
            }
        }
        return string;
    }

    public static long getMilliseconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            Date date = simpleDateFormat.parse(string);
            return date.getTime();
        }
        catch (ParseException parseException) {
            Util.logWarning("Cannot parse date/time: {0}", string);
            return 0L;
        }
    }

    public static boolean isRoomForTemporaryTiffImages(File file, int n, long l, long l2, int n2, int n3) {
        long l3;
        long l4 = (long)n * (1000000L + l * l2 * (long)n2 * (long)n3 / 8L);
        File file2 = file.getAbsoluteFile();
        while (null != file2.getParent()) {
            file2 = file2.getParentFile();
        }
        do {
            if (l4 >= (l3 = file2.getUsableSpace())) continue;
            return true;
        } while (Util.confirm(null, "Disc space requirements", "Approx " + l4 + " bytes will be needed for temporary files\n" + "but there are only about " + l3 + " bytes available.\n" + "Try to free some space. Click \"Yes\" when enough has been cleared.\n" + "Otherwise click \"No\" to abort processing."));
        return false;
    }

    public static void logInfo(String string, Object ... objectArray) {
        Logger.getLogger("net.grelf").log(Level.INFO, string, objectArray);
    }

    public static void logInfo(String string) {
        Logger.getLogger("net.grelf").log(Level.INFO, string);
    }

    public static void logWarning(String string, Object ... objectArray) {
        Logger.getLogger("net.grelf").log(Level.WARNING, string, objectArray);
    }

    public static void logWarning(String string) {
        Logger.getLogger("net.grelf").log(Level.WARNING, string);
    }

    public static JMenuItem menuItem(ActionListener actionListener, String string, String string2, int n, int n2) {
        return Util.menuItem(actionListener, string, string2, n, n2, true);
    }

    public static JMenuItem menuItem(ActionListener actionListener, String string, String string2, int n, int n2, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setActionCommand(string2);
        if (n != 0) {
            jMenuItem.setMnemonic((char)n);
        }
        if (n2 != 0) {
            if (bl) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 2));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 0));
            }
        }
        return jMenuItem;
    }

    public static void message(String string, Object object) {
        Util.message(owningApp, string, object);
    }

    public static void message(Component component, String string, Object object) {
        JOptionPane.showMessageDialog(component, object, string, -1, ownerIcon);
    }

    public static int nOccurs(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static void notYet() {
        Util.notYet(owningApp);
    }

    public static void notYet(Component component) {
        Util.message(component, "Sorry", "This option is not yet available");
    }

    public static String rational(String string) {
        int n = string.indexOf(47);
        if (-1 == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (!Character.isDigit(string3.charAt(0))) {
            return string;
        }
        for (int i = 1; i < string3.length(); ++i) {
            if (Character.isDigit(string3.charAt(i))) continue;
            string3 = string3.substring(0, i);
            break;
        }
        try {
            return Float.toString(Float.parseFloat(string2) / Float.parseFloat(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public static float rationalFloat(String string) {
        try {
            int n = string.indexOf(47);
            if (-1 == n) {
                return Float.parseFloat(string);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (!Character.isDigit(string3.charAt(0))) {
                Util.warning("Error", "Could not parse the metadata as a rational float.");
                return -1.0f;
            }
            for (int i = 1; i < string3.length(); ++i) {
                if (Character.isDigit(string3.charAt(i))) continue;
                string3 = string3.substring(0, i);
                break;
            }
            return Float.parseFloat(string2) / Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning("Error", "Could not parse the metadata as a rational float.");
            return -1.0f;
        }
    }

    public static String removeSubString(String string, String string2) {
        int n = string.indexOf(string2);
        if (-1 == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(n, n + string2.length());
        return stringBuffer.toString();
    }

    public static double rootSumOfSquares(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public static long rootSumOfSquares(long[] lArray) {
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i] * lArray[i];
        }
        return (long)Math.sqrt(l);
    }

    public static void saveJTableAsCSV(String[] stringArray, JTable jTable, String string) {
        try {
            int n;
            PrintWriter printWriter = new PrintWriter(string);
            if (null != stringArray) {
                for (n = 0; n < stringArray.length; ++n) {
                    printWriter.print(stringArray[n] + ",");
                }
                printWriter.println();
            }
            for (n = 0; n < jTable.getModel().getRowCount(); ++n) {
                for (int i = 0; i < jTable.getModel().getColumnCount(); ++i) {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer((String)jTable.getModel().getValueAt(n, i));
                    do {
                        if ((n2 = stringBuffer.indexOf("<")) == -1) continue;
                        int n3 = stringBuffer.indexOf(">", n2);
                        if (n3 != -1) {
                            // empty if block
                        }
                        stringBuffer.delete(n2, n3 + 1);
                    } while (n2 != -1);
                    if (-1 != stringBuffer.indexOf(",")) {
                        printWriter.print("\"" + stringBuffer.toString() + "\",");
                        continue;
                    }
                    printWriter.print(stringBuffer.toString() + ",");
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
            Util.warning("Sorry", "Could not open\n{0}", string);
        }
    }

    public static void showMemory(String string) {
        System.out.println(string);
        long l = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("JVM memory=" + runtime.totalMemory() / l + "Mb" + "; free=" + runtime.freeMemory() / l + "Mb" + "; used=" + (runtime.totalMemory() - runtime.freeMemory()) / l + "Mb" + "; max=" + runtime.maxMemory() / l + "Mb");
    }

    public static String[] splitPath(String string) {
        String string2 = -1 != string.indexOf("\\") ? "\\\\" : "/";
        return string.split(string2);
    }

    public static void warning(String string, Object object) {
        Util.warning(owningApp, string, object);
    }

    public static void warning(Component component, String string, Object object) {
        if (showErrors) {
            JOptionPane.showMessageDialog(component, object, string, 2, ownerIcon);
        }
        if (object instanceof String) {
            Util.logWarning((String)object);
        }
    }

    public static void warning(String string, String string2, Object ... objectArray) {
        Util.warning(owningApp, string, string2, objectArray);
    }

    public static void warning(Component component, String string, String string2, Object ... objectArray) {
        if (showErrors) {
            JOptionPane.showMessageDialog(component, string2, string, 2, ownerIcon);
        }
        Util.logWarning(string2, objectArray);
    }

    public static void setShowErrors(boolean bl) {
        showErrors = bl;
    }
}

