/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.grelf.MeasuredValue;

public class Length
implements Cloneable,
Comparable<Length>,
Serializable {
    protected MeasuredValue mv;
    protected Units units;

    public MeasuredValue getValue() {
        return this.mv;
    }

    public Units getUnits() {
        return this.units;
    }

    private Length(MeasuredValue measuredValue, Units units) {
        this.mv = measuredValue;
        this.units = units;
    }

    public Length(double d, Units units) {
        this(new MeasuredValue(d, 0.0, units), units);
    }

    public double getValue(Units units) {
        double d = this.mv.getValue() * this.units.valueInMetres;
        return d / units.valueInMetres;
    }

    public boolean equals(Object object, Length length) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Length length2 = (Length)object;
        double d = this.getValue(this.units);
        double d2 = length2.getValue(this.units);
        double d3 = length.getValue(this.units);
        return !(Math.abs(d - d2) > d3);
    }

    public boolean equals(Object object) {
        Length length = new Length(this.getValue(this.units) * 1.0E-15, this.units);
        return this.equals(object, length);
    }

    @Override
    public int compareTo(Length length) {
        double d;
        double d2 = this.getValue(this.units);
        double d3 = d2 - (d = length.getValue(this.units));
        if (d3 > 0.0) {
            return 1;
        }
        if (d3 < 0.0) {
            return -1;
        }
        return 0;
    }

    public Length clone() {
        return new Length(this.mv, this.units);
    }

    public String toString() {
        return this.mv.toString() + this.units.toString();
    }

    public int hashCode() {
        return 17 * this.mv.hashCode() + 7 * this.units.hashCode();
    }

    public static enum Units implements net.grelf.Units,
    Serializable
    {
        PARSEC("pc", 3.085678E16),
        LIGHT_YEAR("ly", 9.4607304725808E15),
        ASTRONOMICAL_UNIT("au", 1.495978707E11),
        KILOMETRE("km", 1000.0),
        METRE("m", 1.0),
        CENTIMETRE("cm", 0.01),
        MILLIMETRE("mm", 0.001),
        MICRON("\u03bcm", 1.0E-6),
        NANOMETRE("nm", 1.0E-9),
        ANGSTROM("\u212b", 1.0E-10),
        MILE("mi", 1609.3439999999998),
        YARD("yd", 0.9144),
        FOOT("'", 0.30479999999999996),
        INCH("\"", 0.0254),
        PIXEL("px", 0.0);

        private double valueInMetres;
        private String symbol;

        private Units(String string2, double d) {
            this.symbol = string2;
            this.valueInMetres = d;
        }

        @Override
        public Units createUnitsFromName(String string) {
            for (Units units : Units.values()) {
                if (!units.toString().equalsIgnoreCase(string)) continue;
                return units;
            }
            return null;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public List<String> getNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Units units : Units.values()) {
                arrayList.add(units.toString());
            }
            return arrayList;
        }
    }
}

