/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileIOImageFilter
extends FileFilter {
    public static final int ANY = 0;
    public static final int BMP = 1;
    public static final int GIF = 2;
    public static final int JPG = 3;
    public static final int PNG = 4;
    public static final int TIF = 5;
    public static final int RAW = 6;
    public static final int FITS = 7;
    public static final int ACCUM = 8;
    public static final FileIOImageFilter BMP_FILTER = new FileIOImageFilter(1);
    public static final FileIOImageFilter GIF_FILTER = new FileIOImageFilter(2);
    public static final FileIOImageFilter JPG_FILTER = new FileIOImageFilter(3);
    public static final FileIOImageFilter PNG_FILTER = new FileIOImageFilter(4);
    public static final FileIOImageFilter TIF_FILTER = new FileIOImageFilter(5);
    public static final FileIOImageFilter RAW_FILTER = new FileIOImageFilter(6);
    public static final FileIOImageFilter FITS_FILTER = new FileIOImageFilter(7);
    public static final FileIOImageFilter ACCUM_FILTER = new FileIOImageFilter(8);
    private int kind;

    public FileIOImageFilter() {
        this.kind = 0;
    }

    public FileIOImageFilter(int n) {
        this.kind = n;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        switch (this.kind) {
            case 8: {
                return string.endsWith(".accum");
            }
            case 1: {
                return string.endsWith(".bmp");
            }
            case 2: {
                return string.endsWith(".gif");
            }
            case 3: {
                return string.endsWith(".jpg");
            }
            case 4: {
                return string.endsWith(".png");
            }
            case 6: {
                return string.endsWith(".crw") || string.endsWith(".cr2") || string.endsWith(".dng") || string.endsWith(".mrw") || string.endsWith(".nef") || string.endsWith(".pef") || string.endsWith(".srf");
            }
            case 5: {
                return string.endsWith(".tif");
            }
            case 7: {
                return string.endsWith(".fits");
            }
        }
        return string.endsWith(".accum") || string.endsWith(".fits") || string.endsWith(".bmp") || string.endsWith(".crw") || string.endsWith(".cr2") || string.endsWith(".dng") || string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".mrw") || string.endsWith(".nef") || string.endsWith(".pef") || string.endsWith(".png") || string.endsWith(".srf") || string.endsWith(".tif");
    }

    @Override
    public String getDescription() {
        switch (this.kind) {
            case 1: {
                return "BMP image (*.bmp)";
            }
            case 2: {
                return "GIF image (*.gif)";
            }
            case 3: {
                return "JPEG image (*.jpg)";
            }
            case 4: {
                return "PNG image (*.png)";
            }
            case 6: {
                return "RAW image (*.crw, *.cr2, *.dng, *.mrw, *.nef, *.pef, *.srf)";
            }
            case 5: {
                return "TIFF image (*.tif)";
            }
            case 7: {
                return "FITS image (*.fits)";
            }
            case 8: {
                return "Accumulator image (*.accum)";
            }
        }
        return "Image (*.accum, *.bmp, *.crw, *.cr2, *.dng, *.gif, *.jpg, *.mrw, *.nef, *.pef, *.png, *.srf, *.tif)";
    }

    public static String[] getAllKnownExtensions() {
        return new String[]{".accum", ".bmp", ".gif", ".jpg", ".png", ".tif", ".fits", ".crw", ".cr2", ".dng", ".mrw", ".nef", ".pef", ".srf"};
    }
}

