/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class Logger {
    @Nonnull
    private final java.util.logging.Logger logger;
    private static final Map<String, Logger> loggerMapByName = new HashMap<String, Logger>();

    Logger(@Nonnull java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Nonnull
    public static synchronized Logger getLogger(@Nonnull String name) {
        Logger logger = loggerMapByName.get(name);
        if (logger == null) {
            logger = new Logger(java.util.logging.Logger.getLogger(name));
            loggerMapByName.put(name, logger);
        }
        return logger;
    }

    public void warning(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(String.format(string, args));
        }
    }

    public void throwing(String arg0, String arg1, Throwable arg2) {
        this.logger.throwing(arg0, arg1, arg2);
    }

    public void severe(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe(String.format(string, args));
        }
    }

    public void info(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(String.format(string, args));
        }
    }

    public void finest(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(String.format(string, args));
        }
    }

    public void finer(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(String.format(string, args));
        }
    }

    public void fine(@Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format(string, args));
        }
    }

    public void setLevel(Level arg0) throws SecurityException {
        this.logger.setLevel(arg0);
    }

    public boolean isLoggable(Level arg0) {
        return this.logger.isLoggable(arg0);
    }

    public String getName() {
        return this.logger.getName();
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public synchronized Handler[] getHandlers() {
        return this.logger.getHandlers();
    }
}

