/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.util.Logger;
import java.awt.color.ICC_Profile;
import java.io.IOException;

public class IFD
extends IFDGenerated {
    private static final String CLASS = IFD.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = -4451964246159369585L;
    public static final String EXIF_NAME = "EXIF";
    public static final String MAKER_NOTE_NAME = "MakerNote";
    public static final String INTEROPERABILITY_NAME = "INTEROPERABILITY";
    public static final String GPS_NAME = "GPS";

    public void loadAll(RAWImageInputStream iis, long offset) throws IOException {
        logger.fine("loadAll(%s, %d)", iis, offset);
        IFD currentIFD = this;
        while (offset > 0L) {
            offset = currentIFD.load(iis, offset);
            currentIFD.loadSubDirectories(iis);
            if (offset <= 0L) continue;
            currentIFD.nextDirectory = new IFD();
            currentIFD = (IFD)currentIFD.nextDirectory;
        }
        logger.fine(">>>> loadAll() completed ok", new Object[0]);
    }

    protected void loadSubDirectories(RAWImageInputStream iis) throws IOException {
        int[] subIFDOffsetsList = this.getSubIFDs();
        if (subIFDOffsetsList != null) {
            for (int i = 0; i < subIFDOffsetsList.length; ++i) {
                logger.finer(">>>> Processing subIFD #%d", i);
                IFD subIFD = new IFD();
                this.addDirectory(subIFD);
                subIFD.loadAll(iis, subIFDOffsetsList[i]);
                logger.finer(">>>>>>>> Completed processing subIFD #%d", i);
            }
        }
    }

    public ICC_Profile getAsShotICCProfile2() {
        return IFD.getProfile(this.getAsShotICCProfile());
    }

    public ICC_Profile getCurrentICCProfile2() {
        return IFD.getProfile(this.getCurrentICCProfile());
    }

    public int getMakerNoteOffset() {
        return this.getMakerNote();
    }

    private static ICC_Profile getProfile(byte[] bytes) {
        return bytes == null ? null : ICC_Profile.getInstance(bytes);
    }
}

