/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.srf.SRFImageInputStream;
import it.tidalwave.imageio.srf.SRFMetadata;
import it.tidalwave.imageio.srf.SRFRasterReader;
import it.tidalwave.imageio.srf.SonyMakerNote;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class SRFImageReader
extends TIFFImageReaderSupport {
    private static final Logger logger = Logger.getLogger(SRFImageReader.class.getName());

    protected SRFImageReader(ImageReaderSpi originatingProvider, Object extension) {
        super(originatingProvider, SonyMakerNote.class, SRFMetadata.class);
    }

    protected Object wrapInput(Object input) {
        return new SRFImageInputStream((ImageInputStream)input);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        SRFRasterReader rasterReader = new SRFRasterReader();
        this.initializeRasterReader(rasterReader);
        SonyMakerNote sonyMakerNote = (SonyMakerNote)this.makerNote;
        rasterReader.setRasterKey(sonyMakerNote.getSRF1().getRasterKey());
        rasterReader.setRasterOffset(sonyMakerNote.getSRF2().getRasterOffset());
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(RasterReader rasterReader) {
        IFD primaryIFD = (IFD)this.primaryDirectory;
        int bitsPerSample = primaryIFD.getBitsPerSample()[0];
        int width = primaryIFD.getImageWidth();
        int height = primaryIFD.getImageLength();
        rasterReader.setWidth(width);
        rasterReader.setHeight(height);
        rasterReader.setBitsPerSample(bitsPerSample);
        rasterReader.setCFAPattern(new byte[]{0, 1, 1, 2});
        rasterReader.setCompression(primaryIFD.getCompression().intValue());
        if (primaryIFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(primaryIFD.getStripByteCounts());
        }
        if (primaryIFD.isTileWidthAvailable()) {
            int tileWidth = primaryIFD.getTileWidth();
            int tileLength = primaryIFD.getTileLength();
            rasterReader.setTileWidth(tileWidth);
            rasterReader.setTileHeight(tileLength);
            rasterReader.setTilesAcross((width + tileWidth - 1) / tileWidth);
            rasterReader.setTilesDown((height + tileLength - 1) / tileLength);
            rasterReader.setTileOffsets(primaryIFD.getTileOffsets());
        }
        if (primaryIFD.isLinearizationTableAvailable()) {
            rasterReader.setLinearizationTable(primaryIFD.getLinearizationTable());
        }
    }
}

