/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonCaptureEditorMetadata;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.annotation.Nonnull;

public class NEFSizeOperation
extends SizeOperation {
    private static final Logger logger = NEFSizeOperation.getLogger(NEFSizeOperation.class);
    @Nonnull
    private Insets crop;
    @Nonnull
    private Dimension size;

    public void init(@Nonnull PipelineArtifact artifact) {
        logger.fine("init(%s)", artifact);
        this.size = super.getSize(artifact);
        this.crop = super.getCrop(artifact);
        int rotation = this.normalizedAngle(artifact.getRotation());
        this.crop = NEFSizeOperation.rotate(this.crop, rotation);
        logger.finer(">>>> size: %s, rotation: %d, crop: %s", this.size, rotation, this.crop);
        NEFMetadata metadata = (NEFMetadata)artifact.getRAWMetadata();
        NikonCaptureEditorMetadata nceMetadata = (NikonCaptureEditorMetadata)metadata.getCaptureEditorMetadata();
        if (nceMetadata == null) {
            this.size = NEFSizeOperation.rotate(this.size, rotation);
        } else {
            Rectangle nceCrop = nceMetadata.getCropObject().getCrop();
            if (nceCrop == null) {
                logger.fine(">>>> no NCE crop", new Object[0]);
            } else {
                if (metadata.getPrimaryIFD().getModel().trim().equals("NIKON D1X")) {
                    nceCrop.height /= 2;
                }
                logger.fine(">>>> NCE crop: %s", nceCrop);
                boolean shouldRotateNCECrop = true;
                if (shouldRotateNCECrop) {
                    Rectangle save = (Rectangle)nceCrop.clone();
                    nceCrop = NEFSizeOperation.rotate(nceCrop, this.size, rotation);
                    if (nceCrop.x < 0 || nceCrop.y < 0) {
                        logger.warning("Bad crop, NCE crop hadn't to be rotated", new Object[0]);
                        nceCrop = save;
                    }
                }
                this.size = NEFSizeOperation.rotate(this.size, rotation);
                logger.fine(">>>> size: %s, NCE crop: %s", this.size, nceCrop);
                this.crop.left += nceCrop.x;
                this.crop.top += nceCrop.y;
                this.crop.right += this.size.width - nceCrop.width - nceCrop.x;
                this.crop.bottom += this.size.height - nceCrop.height - nceCrop.y;
                this.size.width = nceCrop.width;
                this.size.height = nceCrop.height;
            }
        }
        logger.fine(">>>> computed crop: %s, size: %s", this.crop, this.size);
    }

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        return this.crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        return this.size;
    }
}

