/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

import it.tidalwave.imageio.arw.ARWImageReaderSpi;
import it.tidalwave.imageio.cr2.CR2ImageReaderSpi;
import it.tidalwave.imageio.crw.CRWImageReaderSpi;
import it.tidalwave.imageio.dng.DNGImageReaderSpi;
import it.tidalwave.imageio.mrw.MRWImageReaderSpi;
import it.tidalwave.imageio.nef.NEFImageReaderSpi;
import it.tidalwave.imageio.orf.ORFImageReaderSpi;
import it.tidalwave.imageio.pef.PEFImageReaderSpi;
import it.tidalwave.imageio.raf.RAFImageReaderSpi;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.raw.Version;
import it.tidalwave.imageio.rawprocessor.arw.ARWProcessor;
import it.tidalwave.imageio.rawprocessor.cr2.CR2Processor;
import it.tidalwave.imageio.rawprocessor.crw.CRWProcessor;
import it.tidalwave.imageio.rawprocessor.dng.DNGProcessor;
import it.tidalwave.imageio.rawprocessor.mrw.MRWProcessor;
import it.tidalwave.imageio.rawprocessor.nef.NEFProcessor;
import it.tidalwave.imageio.rawprocessor.orf.ORFProcessor;
import it.tidalwave.imageio.rawprocessor.pef.PEFProcessor;
import it.tidalwave.imageio.rawprocessor.raf.RAFProcessor;
import it.tidalwave.imageio.rawprocessor.srf.SRFProcessor;
import it.tidalwave.imageio.srf.SRFImageReaderSpi;
import it.tidalwave.imageio.util.Logger;

public class RAWProcessorInstaller {
    private static final String CLASS = RAWProcessorInstaller.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    static {
        String jrawioVersion = Version.TAG;
        if (jrawioVersion.startsWith(it.tidalwave.imageio.rawprocessor.Version.REQUIRED_JRAWIO_TAG)) {
            logger.info("Installing RAWProcessor...", new Object[0]);
            RAWImageReaderSpiSupport.installPostProcessor(ARWImageReaderSpi.class, new ARWProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(CR2ImageReaderSpi.class, new CR2Processor());
            RAWImageReaderSpiSupport.installPostProcessor(CRWImageReaderSpi.class, new CRWProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(DNGImageReaderSpi.class, new DNGProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(MRWImageReaderSpi.class, new MRWProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(NEFImageReaderSpi.class, new NEFProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(ORFImageReaderSpi.class, new ORFProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(PEFImageReaderSpi.class, new PEFProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(RAFImageReaderSpi.class, new RAFProcessor());
            RAWImageReaderSpiSupport.installPostProcessor(SRFImageReaderSpi.class, new SRFProcessor());
            logger.info("Installed RAWProcessor", new Object[0]);
        } else {
            logger.warning("This RAWProcessor cannot be installed!", new Object[0]);
            logger.warning(">>>> Found jrawio version: " + jrawioVersion + ", required: " + it.tidalwave.imageio.rawprocessor.Version.REQUIRED_JRAWIO_TAG, new Object[0]);
        }
    }
}

