/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

import it.tidalwave.imageio.raw.PostProcessor;
import it.tidalwave.imageio.raw.RAWImageReadParam;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.Operation;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAWProcessor
implements PostProcessor {
    private static final String CLASS = RAWProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private final List<OperationSupport> operationList = new ArrayList<OperationSupport>();

    public RAWProcessor() {
        this.buildPipeline(this.operationList);
    }

    protected abstract void buildPipeline(@Nonnull List<OperationSupport> var1);

    @Override
    @Nonnull
    public final BufferedImage process(@Nonnull BufferedImage image, @Nonnull RAWMetadataSupport metadata, @Nonnull RAWImageReadParam readParam) {
        logger.fine("process(%s, %s, %s)", image, metadata, readParam);
        PipelineArtifact rawImage = new PipelineArtifact(image, metadata, readParam);
        this.init(rawImage);
        this.process(rawImage);
        return rawImage.getImage();
    }

    @Override
    public final void processMetadata(@Nonnull RAWMetadataSupport metadata, @Nonnull RAWImageReadParam readParam) {
        logger.fine("processMetadata(%s, %s)", metadata, readParam);
        PipelineArtifact rawImage = new PipelineArtifact(null, metadata, readParam);
        this.init(rawImage);
        this.processMetadata(rawImage);
    }

    private final void init(PipelineArtifact rawImage) {
        for (Operation operation : this.operationList) {
            logger.fine(">>> Initializing: %s", operation.getClass());
            try {
                operation.init(rawImage);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final void process(@Nonnull PipelineArtifact pipelineArtifact) {
        for (OperationSupport operation : this.operationList) {
            String operationName = operation.getClass().getName();
            try {
                Source.Type type = pipelineArtifact.lookup(Source.class).getType();
                if (!operation.supportsType(type)) {
                    logger.fine(">>>> skipping %s because doesn't support %s\n", new Object[]{operationName, type});
                    continue;
                }
                long time = System.currentTimeMillis();
                logger.fine("Executing: %s", operationName);
                operation.process(pipelineArtifact);
                time = System.currentTimeMillis() - time;
                logger.finer(">>>> %s completed ok in %d msec", operationName, time);
            }
            catch (Exception e) {
                logger.warning("%s FAILED", operationName);
                throw new RuntimeException(e);
            }
        }
    }

    private final void processMetadata(@Nonnull PipelineArtifact rawImage) {
        for (OperationSupport operation : this.operationList) {
            String operationName = operation.getClass().getName();
            try {
                long time = System.currentTimeMillis();
                logger.fine("Executing: %s", operationName);
                operation.processMetadata(rawImage);
                time = System.currentTimeMillis() - time;
                logger.finer(">>>> %s completed ok in %d msec", operationName, time);
            }
            catch (Exception e) {
                logger.warning("%s FAILED", operationName);
                throw new RuntimeException(e);
            }
        }
    }
}

