/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raf.RAFImageReader;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.imageio.ImageReader;

public class RAFImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = RAFImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public RAFImageReaderSpi() {
        super("RAF", "raf", "image/x-fuji-raf", RAFImageReader.class);
    }

    @Nonnull
    public String getDescription(Locale locale) {
        return "Standard RAF Image Reader";
    }

    @Nonnull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new RAFImageReader(this, extension);
    }

    public boolean canDecodeInput(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        byte[] buffer = new byte[48];
        iis.readFully(buffer);
        String s = new String(buffer);
        return s.startsWith("FUJIFILMCCD-RAW");
    }
}

