/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raf.FujiTable1;
import java.io.IOException;
import java.nio.ByteOrder;

public class FujiRawData {
    private String header;
    private byte[] b1 = new byte[16];
    private String version;
    private byte[] b2 = new byte[16];
    private int jpegImageOffset;
    private int jpegImageLength;
    private int table1Offset;
    private int table1Length;
    private int cfaOffset;
    private int cfaLength;
    private int unused1;
    private int unused2;
    private int unused3;
    private int unused4;
    private int unused5;
    private int unused6;
    private int unused7;
    private int unused8;
    private int unused9;
    private int unused10;
    private FujiTable1 fujiTable1;

    public int getBaseOffset() {
        return this.jpegImageOffset + 12;
    }

    public void load(RAWImageInputStream iis, int i, ByteOrder byteOrder) throws IOException {
        byte[] buffer1 = new byte[48];
        iis.readFully(buffer1);
        this.header = new String(buffer1);
        iis.readFully(this.b1);
        byte[] buffer2 = new byte[4];
        iis.readFully(buffer2);
        this.version = new String(buffer2);
        iis.readFully(this.b2);
        this.jpegImageOffset = iis.readInt();
        this.jpegImageLength = iis.readInt();
        this.table1Offset = iis.readInt();
        this.table1Length = iis.readInt();
        this.cfaOffset = iis.readInt();
        this.cfaLength = iis.readInt();
        this.unused1 = iis.readInt();
        this.unused2 = iis.readInt();
        this.unused3 = iis.readInt();
        this.unused4 = iis.readInt();
        this.unused5 = iis.readInt();
        this.unused6 = iis.readInt();
        this.unused7 = iis.readInt();
        this.unused8 = iis.readInt();
        this.unused9 = iis.readInt();
        this.unused10 = iis.readInt();
        if (this.table1Offset > 0) {
            this.fujiTable1 = new FujiTable1();
            long baseOffsetSave = iis.getBaseOffset();
            iis.setBaseOffset(0L);
            this.fujiTable1.load(iis, this.table1Offset, this.table1Length);
            iis.setBaseOffset(baseOffsetSave);
        }
    }

    public FujiTable1 getFujiTable1() {
        return this.fujiTable1;
    }

    public byte[] getB1() {
        return this.b1;
    }

    public byte[] getB2() {
        return this.b2;
    }

    public int getCFALength() {
        return this.cfaLength;
    }

    public int getCFAOffset() {
        return this.cfaOffset;
    }

    public String getHeader() {
        return this.header;
    }

    public int getJPEGImageLength() {
        return this.jpegImageLength;
    }

    public int getJPEGImageOffset() {
        return this.jpegImageOffset;
    }

    public int getTable1Length() {
        return this.table1Length;
    }

    public int getTable1Offset() {
        return this.table1Offset;
    }

    public int getUnused1() {
        return this.unused1;
    }

    public int getUnused10() {
        return this.unused10;
    }

    public int getUnused2() {
        return this.unused2;
    }

    public int getUnused3() {
        return this.unused3;
    }

    public int getUnused4() {
        return this.unused4;
    }

    public int getUnused5() {
        return this.unused5;
    }

    public int getUnused6() {
        return this.unused6;
    }

    public int getUnused7() {
        return this.unused7;
    }

    public int getUnused8() {
        return this.unused8;
    }

    public int getUnused9() {
        return this.unused9;
    }

    public String getVersion() {
        return this.version;
    }
}

