/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.pef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.pef.PEFDecoder;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PEFRasterReader
extends RasterReader {
    private static final String CLASS = PEFRasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @CheckForNull
    private PEFDecoder decoder;

    protected boolean isCompressedRaster() {
        return this.decoder != null;
    }

    public void setDecoder(@Nonnull PEFDecoder decoder) {
        this.decoder = decoder;
    }

    protected void loadCompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        iis.seek(this.rasterOffset);
        short[][] vPredictor = new short[2][2];
        short[] hPredictor = new short[2];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bitCount = this.decoder.decode(12, true, iis, false);
                int diff = this.decoder.decode(bitCount, false, iis, false);
                if ((diff & 1 << bitCount - 1) == 0) {
                    diff -= (1 << bitCount) - 1;
                }
                if (x < 2) {
                    short[] sArray = vPredictor[y & 1];
                    int n = x;
                    short s = (short)(sArray[n] + diff);
                    sArray[n] = s;
                    hPredictor[x] = s;
                } else {
                    int n = x & 1;
                    hPredictor[n] = (short)(hPredictor[n] + diff);
                }
                if (x < width) {
                    int cfaIndex = 2 * (y & 1) + (x & 1);
                    data[i + this.cfaOffsets[cfaIndex]] = hPredictor[x & 1];
                }
                i += 3;
                assert (hPredictor[x & 1] >>> 12 == 0);
            }
        }
    }
}

