/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.pef;

import it.tidalwave.imageio.pef.PEFMetadata;
import it.tidalwave.imageio.pef.PEFRasterReader;
import it.tidalwave.imageio.pef.PentaxMakerNote;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class PEFImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = PEFImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PEFImageReader(@Nonnull ImageReaderSpi originatingProvider, @CheckForNull Object extension) {
        super(originatingProvider, PentaxMakerNote.class, PEFMetadata.class);
    }

    @Nonnull
    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        PEFRasterReader rasterReader = new PEFRasterReader();
        this.initializeRasterReader(rasterReader);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        IFD primaryIFD = (IFD)this.primaryDirectory;
        this.iis.seek(primaryIFD.getStripOffsets());
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec.", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(@Nonnull RasterReader rasterReader) {
        IFD primaryIFD = (IFD)this.primaryDirectory;
        IFD exifIFD = (IFD)primaryIFD.getNamedDirectory("EXIF");
        int bitsPerSample = primaryIFD.getCompression().intValue() == 1 ? 16 : 12;
        int width = primaryIFD.getImageWidth();
        int height = primaryIFD.getImageLength();
        rasterReader.setWidth(width);
        rasterReader.setHeight(height);
        rasterReader.setBitsPerSample(bitsPerSample);
        rasterReader.setCFAPattern(exifIFD.getEXIFCFAPattern());
        rasterReader.setCompression(primaryIFD.getCompression().intValue());
        if (primaryIFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(primaryIFD.getStripByteCounts());
        }
        if (primaryIFD.isTileWidthAvailable()) {
            int tileWidth = primaryIFD.getTileWidth();
            int tileLength = primaryIFD.getTileLength();
            rasterReader.setTileWidth(tileWidth);
            rasterReader.setTileHeight(tileLength);
            rasterReader.setTilesAcross((width + tileWidth - 1) / tileWidth);
            rasterReader.setTilesDown((height + tileLength - 1) / tileLength);
            rasterReader.setTileOffsets(primaryIFD.getTileOffsets());
        }
        rasterReader.setRasterOffset(primaryIFD.getStripOffsets());
        ((PEFRasterReader)rasterReader).setDecoder(((PentaxMakerNote)this.makerNote).getDecoder());
        if (primaryIFD.isLinearizationTableAvailable()) {
            rasterReader.setLinearizationTable(primaryIFD.getLinearizationTable());
        }
    }
}

