/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class E300RasterReader
extends RasterReader {
    private static final String CLASS = E300RasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected void loadUncompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        logger.fine("loadUncompressedRaster(%s, %s, %s)", iis, raster, ir);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * 3;
        this.setBitsPerSample(12);
        this.selectBitReader(iis, raster, -1);
        for (int y = 0; y < height; ++y) {
            int row = this.getRow(y, height);
            int k = row % 2 * 2;
            int i = row * scanStride;
            for (int x = 0; x < width; ++x) {
                int b0 = iis.readByte() & 0xFF;
                int b1 = iis.readByte() & 0xFF;
                int b2 = iis.readByte() & 0xFF;
                int sample1 = (b1 << 8 | b0) & 0xFFF;
                int sample2 = (b2 << 4 | b1 >>> 4) & 0xFFF;
                if (this.linearizationTable != null) {
                    sample1 = this.linearizationTable[sample1];
                    sample2 = this.linearizationTable[sample2];
                }
                int j = x % 2;
                data[i + this.cfaOffsets[j + k]] = (short)sample1;
                this.endOfColumn(x, iis);
                j = ++x % 2;
                data[(i += 3) + this.cfaOffsets[j + k]] = (short)sample2;
                this.endOfColumn(x, iis);
                i += 3;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
    }

    protected void endOfColumn(@Nonnegative int x, @Nonnull RAWImageInputStream iis) throws IOException {
        if ((x + 1) % 10 == 0) {
            iis.readByte();
        }
    }

    @Nonnull
    public String toString() {
        return String.format("E300RasterReader@%x", System.identityHashCode(this));
    }
}

