/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.HeaderProcessor;
import java.io.IOException;
import javax.annotation.Nonnull;

public class NEFHeaderProcessor
extends HeaderProcessor {
    public static final int NDF_OFFSET = 12;
    private boolean isNDF;

    public void process(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.mark();
        byte[] buffer = new byte[12];
        iis.seek(0L);
        iis.readFully(buffer);
        this.isNDF = new String(buffer, 0, 3).equals("NDF");
        iis.reset();
    }

    public int getOffset() {
        return this.isNDF ? 12 : 0;
    }
}

