/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.dcr;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DCRRasterReader
extends RasterReader {
    protected boolean isCompressedRaster() {
        return true;
    }

    protected void loadCompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        short[] buf = new short[256];
        int[] pred = new int[2];
        int width = raster.getWidth();
        int height = raster.getHeight();
        iis.seek(561664L);
        for (int row = 0; row < 1; ++row) {
            for (int col = 0; col < width; col += 256) {
                int i;
                int cfaIndex = 2 * (row & 1) + (col & 1);
                pred[1] = 0;
                pred[0] = 0;
                int len = Math.min(256, width - col);
                boolean ret = this.kodak_65000_decode(iis, buf, len);
                for (i = 0; i < len; ++i) {
                    System.err.print(Integer.toHexString(buf[i] & 0xFFFF) + " ");
                }
                System.err.println();
                for (i = 0; i < len; ++i) {
                    int n;
                    if (ret) {
                        n = buf[i];
                    } else {
                        int n2 = i & 1;
                        n = pred[n2] = pred[n2] + buf[i];
                    }
                    int sample = n;
                    data[(row * width + col + i) * 3 + this.cfaOffsets[cfaIndex]] = (short)(sample * 16);
                }
            }
        }
    }

    private boolean kodak_65000_decode(ImageInputStream iis, short[] out, int bsize) throws IOException {
        int[] blen = new int[768];
        short[] raw = new short[6];
        long save = iis.getStreamPosition();
        bsize = bsize + 3 & 0xFFFFFFFC;
        for (int i = 0; i < bsize; i += 2) {
            int c = iis.readByte() & 0xFF;
            int a = blen[i] = c & 0xF;
            int n = c >>> 4;
            blen[i + 1] = n;
            int b = n;
            if (a <= 12 && b <= 12) continue;
            iis.seek(save);
            for (i = 0; i < bsize; i += 8) {
                raw[0] = iis.readShort();
                raw[1] = iis.readShort();
                raw[2] = iis.readShort();
                raw[3] = iis.readShort();
                raw[4] = iis.readShort();
                raw[5] = iis.readShort();
                out[i] = (short)(raw[0] >>> 12 << 8 | raw[2] >>> 12 << 4 | raw[4] >>> 12);
                out[i + 1] = (short)(raw[1] >>> 12 << 8 | raw[3] >>> 12 << 4 | raw[5] >>> 12);
                for (int j = 0; j < 6; ++j) {
                    out[i + 2 + j] = (short)(raw[j] & 0xFFF);
                }
            }
            return true;
        }
        long bitbuf = 0L;
        int bits = 0;
        if ((bsize & 7) == 4) {
            bitbuf = (iis.readByte() & 0xFF) << 8;
            bitbuf += (long)(iis.readByte() & 0xFF);
            bits = 16;
        }
        for (int i = 0; i < bsize; ++i) {
            int len = blen[i];
            if (bits < len) {
                for (int j = 0; j < 32; j += 8) {
                    int g = iis.readByte() & 0xFF;
                    bitbuf += (long)(g << bits + (j ^ 8));
                }
                bits += 32;
            }
            int diff = (int)(bitbuf & (long)(65535 >>> 16 - len));
            bitbuf >>>= len;
            bits -= len;
            if ((diff & 1 << len - 1) == 0) {
                diff -= (1 << len) - 1;
            }
            out[i] = (short)diff;
        }
        return false;
    }
}

