/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 1 "parse.y"

/* Parser for gpasm
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005
   James Bowman, Craig Franklin

This file is part of gputils.

gputils is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gputils is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gputils; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "libgputils.h"
#include "gpasm.h"
#include "evaluate.h"
#include "gperror.h"
#include "directive.h"
#include "lst.h"
#include "macro.h"
#include "coff.h"
#include "scan.h"

/* #define DEBUG */

#ifdef DEBUG
/* enable debugging */
#include "parse.h"

int yydebug = 1;

#define YYPRINT(file, type, value)   yyprint (file, type, value)

static void
yyprint (FILE *file, int type, YYSTYPE value)
{
  switch (type) {
  case LABEL:
  case IDENTIFIER:
  case IDENT_BRACKET:
  case DEBUG_LINE:
  case ERRORLEVEL:
  case FILL:
  case LIST:
  case PROCESSOR:
  case DEFINE:
    fprintf (file, "%s", value.s);
    break;

  case STRING:
    fprintf (file, "\"%s\"", value.s);
    break;

  case NUMBER:
  case UPPER:
  case HIGH:
  case LOW:
  case LSH:
  case RSH:
  case GREATER_EQUAL:
  case LESS_EQUAL:
  case EQUAL:
  case NOT_EQUAL:
  case '<':
  case '>':
  case '&':
  case '|':
  case '^':
  case LOGICAL_AND:
  case LOGICAL_OR:
  case '=':
  case ASSIGN_PLUS:
  case ASSIGN_MINUS:
  case ASSIGN_MULTIPLY:
  case ASSIGN_DIVIDE:
  case ASSIGN_MODULUS:
  case ASSIGN_LSH:
  case ASSIGN_RSH:
  case ASSIGN_AND:
  case ASSIGN_OR:
  case ASSIGN_XOR:
  case INCREMENT:
  case DECREMENT:
  case POSTINCREMENT:
  case POSTDECREMENT:
  case INDFOFFSET:
  case TBL_NO_CHANGE:
  case TBL_POST_INC:
  case TBL_POST_DEC:
  case TBL_PRE_INC:
  case '[':
  case ']':
    fprintf (file, "%d", value.i);
    break;

  case CBLOCK:
  case ENDC:
  default:
    break;
  }
}
#endif

int yylex(void);

/************************************************************************/

/* Some simple functions for building parse trees */

static struct pnode *mk_pnode(enum pnode_tag tag)
{
  struct pnode *new = malloc(sizeof(*new));
  new->tag = tag;
  return new;
}

struct pnode *mk_constant(int value)
{
  struct pnode *new = mk_pnode(constant);
  new->value.constant = value;
  return new;
}

struct pnode *mk_offset(struct pnode *p)
{
  struct pnode *new = mk_pnode(offset);
  new->value.offset = p;
  return new;
}

struct pnode *mk_symbol(char *value)
{
  struct pnode *new = mk_pnode(symbol);
  new->value.symbol = value;
  return new;
}

struct pnode *mk_string(char *value)
{
  struct pnode *new = mk_pnode(string);
  new->value.string = value;
  return new;
}

struct pnode *mk_list(struct pnode *head, struct pnode *tail)
{
  struct pnode *new = mk_pnode(list);
  new->value.list.head = head;
  new->value.list.tail = tail;
  return new;
}

struct pnode *mk_2op(int op, struct pnode *p0, struct pnode *p1)
{
  struct pnode *new = mk_pnode(binop);
  new->value.binop.op = op;
  new->value.binop.p0 = p0;
  new->value.binop.p1 = p1;
  return new;
}

struct pnode *mk_1op(int op, struct pnode *p0)
{
  struct pnode *new = mk_pnode(unop);  new->value.unop.op = op;
  new->value.unop.p0 = p0;
  return new;
}

/************************************************************************/
/* shared functions */

gpasmVal set_label(char *label, struct pnode *parms)
{
  gpasmVal value = 0;

  if (asm_enabled()) {
    if (relocatable == state.mode && !IN_MACRO_WHILE_DEFINITION &&
      !(SECTION_FLAGS & (STYP_TEXT | STYP_DATA | STYP_BPACK | STYP_BSS)))
      gpverror(GPE_LABEL_IN_SECTION);

    value = do_or_append_insn("set", parms);
    if (!IN_MACRO_WHILE_DEFINITION) {
      set_global(label, value, TEMPORARY, gvt_constant);
    }
  }

  return value;
}

int return_op(int operation);

void next_line(int value)
{
  if (state.pass == 2 && dolist_dir == state.lst.line.linetype) {
    state.lst.line.linetype = none;
    lst_format_line(state.src->curr_src_line.line, value);
  }

  if (IN_WHILE_EXPANSION || IN_MACRO_EXPANSION) {
    if (!IN_WHILE_DEFINITION && state.lst.expand &&
        state.pass == 2 &&
        dolist_dir != state.lst.line.linetype &&
        nolist_dir != state.lst.line.linetype) {
      lst_format_line(state.src->curr_src_line.line, value);
      preproc_emit();
    }

    /* while loops can be defined inside a macro or nested */
    if (IN_MACRO_WHILE_DEFINITION) {
      state.lst.line.linetype = none;
      if (state.mac_body)
        state.mac_body->src_line = strdup(state.src->m->src_line);
    }

    state.src->m = state.src->m->next;
  } else if (IN_FILE_EXPANSION) {
    if (!IN_WHILE_DEFINITION && state.pass == 2 &&
      dolist_dir != state.lst.line.linetype &&
      nolist_dir != state.lst.line.linetype) {
      lst_format_line(state.src->curr_src_line.line, value);
      if (!IN_MACRO_WHILE_DEFINITION)
        preproc_emit();
    }

    if (IN_MACRO_WHILE_DEFINITION) {
      state.lst.line.linetype = none;
      if (state.mac_body)
        state.mac_body->src_line = strdup(state.src->curr_src_line.line);
    }

   if (state_include == state.next_state) {
      /* includes have to be evaluated here and not in the following
       * switch statetems so that the errors are reported correctly */
      state.src->line_number++;
      open_src(state.next_buffer.file, 1);
      free(state.next_buffer.file);
    }
  }

  switch (state.next_state) {
    case state_exitmacro:
      state.src->line_number++;
      execute_exitm();
      break;

    case state_macro:
      state.src->line_number++;
      /* push the label for local directive */
      state.stTop = push_macro_symbol_table(state.stTop);
      execute_macro(state.next_buffer.macro, 0);
      break;

    case state_section:
      state.src->line_number++;
      /* create a new coff section */
      coff_new_section(state.obj.new_sec_name,
                       state.obj.new_sec_addr,
                       state.obj.new_sec_flags);
      break;

    case state_while:
      state.src->line_number++;
      execute_macro(state.next_buffer.macro, 1);
      break;

    case state_include:
      /* already evaluated */
      break;

    default:
      state.src->line_number++;
      break;
  }
}

void yyerror(char *message)
{
  if (!IN_MACRO_WHILE_DEFINITION) {
    /* throw error if not in macro definition */
    gpverror(GPE_PARSER, message);
  }
}

/************************************************************************/



/* Line 268 of yacc.c  */
#line 370 "parse.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     LABEL = 258,
     IDENTIFIER = 259,
     IDENT_BRACKET = 260,
     CBLOCK = 261,
     DEBUG_LINE = 262,
     ENDC = 263,
     ERRORLEVEL = 264,
     FILL = 265,
     LIST = 266,
     NUMBER = 267,
     PROCESSOR = 268,
     STRING = 269,
     DEFINE = 270,
     UPPER = 271,
     HIGH = 272,
     LOW = 273,
     LSH = 274,
     RSH = 275,
     GREATER_EQUAL = 276,
     LESS_EQUAL = 277,
     EQUAL = 278,
     NOT_EQUAL = 279,
     LOGICAL_AND = 280,
     LOGICAL_OR = 281,
     ASSIGN_PLUS = 282,
     ASSIGN_MINUS = 283,
     ASSIGN_MULTIPLY = 284,
     ASSIGN_DIVIDE = 285,
     ASSIGN_MODULUS = 286,
     ASSIGN_LSH = 287,
     ASSIGN_RSH = 288,
     ASSIGN_AND = 289,
     ASSIGN_OR = 290,
     ASSIGN_XOR = 291,
     INCREMENT = 292,
     DECREMENT = 293,
     POSTINCREMENT = 294,
     POSTDECREMENT = 295,
     INDFOFFSET = 296,
     TBL_NO_CHANGE = 297,
     TBL_POST_INC = 298,
     TBL_POST_DEC = 299,
     TBL_PRE_INC = 300
   };
#endif
/* Tokens.  */
#define LABEL 258
#define IDENTIFIER 259
#define IDENT_BRACKET 260
#define CBLOCK 261
#define DEBUG_LINE 262
#define ENDC 263
#define ERRORLEVEL 264
#define FILL 265
#define LIST 266
#define NUMBER 267
#define PROCESSOR 268
#define STRING 269
#define DEFINE 270
#define UPPER 271
#define HIGH 272
#define LOW 273
#define LSH 274
#define RSH 275
#define GREATER_EQUAL 276
#define LESS_EQUAL 277
#define EQUAL 278
#define NOT_EQUAL 279
#define LOGICAL_AND 280
#define LOGICAL_OR 281
#define ASSIGN_PLUS 282
#define ASSIGN_MINUS 283
#define ASSIGN_MULTIPLY 284
#define ASSIGN_DIVIDE 285
#define ASSIGN_MODULUS 286
#define ASSIGN_LSH 287
#define ASSIGN_RSH 288
#define ASSIGN_AND 289
#define ASSIGN_OR 290
#define ASSIGN_XOR 291
#define INCREMENT 292
#define DECREMENT 293
#define POSTINCREMENT 294
#define POSTDECREMENT 295
#define INDFOFFSET 296
#define TBL_NO_CHANGE 297
#define TBL_POST_INC 298
#define TBL_POST_DEC 299
#define TBL_PRE_INC 300




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 301 "parse.y"

  gpasmVal i;
  char *s;
  struct pnode *p;



/* Line 293 of yacc.c  */
#line 504 "parse.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 516 "parse.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   445

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  67
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  42
/* YYNRULES -- Number of rules.  */
#define YYNRULES  130
/* YYNRULES -- Number of states.  */
#define YYNSTATES  200

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   300

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      61,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    59,     2,     2,    65,    58,    27,     2,
      66,    62,    56,    54,    63,    55,     2,    57,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    64,     2,
      25,    32,    26,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    52,     2,    53,    29,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    28,     2,    60,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      30,    31,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     4,     5,     9,    13,    18,    23,    27,
      31,    34,    36,    38,    40,    42,    43,    48,    51,    52,
      57,    58,    63,    68,    75,    81,    85,    88,    91,    95,
     102,   110,   111,   119,   120,   127,   132,   133,   136,   138,
     141,   144,   148,   149,   152,   156,   158,   162,   164,   166,
     168,   170,   172,   174,   176,   178,   180,   182,   187,   189,
     192,   196,   199,   201,   204,   207,   210,   213,   215,   219,
     221,   223,   227,   229,   231,   235,   237,   239,   243,   245,
     247,   249,   251,   255,   257,   259,   261,   263,   265,   267,
     269,   273,   275,   277,   279,   283,   285,   287,   289,   293,
     295,   297,   299,   301,   304,   306,   308,   310,   312,   314,
     316,   318,   320,   322,   324,   326,   330,   334,   336,   338,
     340,   342,   344,   346,   348,   350,   354,   355,   360,   362,
     364
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      68,     0,    -1,    -1,    -1,    68,    69,    70,    -1,    68,
       1,    61,    -1,     3,    83,    85,    61,    -1,     3,    32,
      85,    61,    -1,     3,    44,    61,    -1,     3,    43,    61,
      -1,     3,    72,    -1,    72,    -1,     9,    -1,     7,    -1,
      61,    -1,    -1,    13,    73,     4,    61,    -1,    11,    61,
      -1,    -1,    11,    74,   105,    61,    -1,    -1,    71,    75,
      84,    61,    -1,    15,     4,    14,    61,    -1,    15,     5,
     108,    62,    14,    61,    -1,    15,     5,    62,    14,    61,
      -1,    15,     4,    61,    -1,    15,    61,    -1,     4,    61,
      -1,     4,    84,    61,    -1,    10,     4,    62,    63,    85,
      61,    -1,    10,     4,    84,    62,    63,    85,    61,    -1,
      -1,     6,    85,    61,    76,    78,     8,    61,    -1,    -1,
       6,    61,    77,    78,     8,    61,    -1,     6,     1,     8,
      61,    -1,    -1,    78,    79,    -1,    61,    -1,    80,    61,
      -1,     3,    61,    -1,     3,    85,    61,    -1,    -1,    81,
      82,    -1,    80,    63,    82,    -1,   104,    -1,   104,    64,
      85,    -1,    33,    -1,    34,    -1,    35,    -1,    36,    -1,
      37,    -1,    38,    -1,    39,    -1,    40,    -1,    41,    -1,
      42,    -1,    85,    52,    85,    53,    -1,    85,    -1,    85,
      63,    -1,    85,    63,    84,    -1,    63,    84,    -1,    63,
      -1,    43,    84,    -1,    44,    84,    -1,    84,    43,    -1,
      84,    44,    -1,    87,    -1,    85,    86,    87,    -1,    32,
      -1,    89,    -1,    87,    88,    89,    -1,    31,    -1,    91,
      -1,    89,    90,    91,    -1,    30,    -1,    93,    -1,    91,
      92,    93,    -1,    27,    -1,    28,    -1,    29,    -1,    95,
      -1,    93,    94,    95,    -1,    25,    -1,    26,    -1,    23,
      -1,    24,    -1,    21,    -1,    22,    -1,    97,    -1,    95,
      96,    97,    -1,    19,    -1,    20,    -1,    99,    -1,    97,
      98,    99,    -1,    54,    -1,    55,    -1,   101,    -1,    99,
     100,   101,    -1,    56,    -1,    57,    -1,    58,    -1,   103,
      -1,   102,   103,    -1,    16,    -1,    17,    -1,    18,    -1,
      55,    -1,    59,    -1,    60,    -1,    54,    -1,   104,    -1,
      12,    -1,    65,    -1,    14,    -1,    66,    85,    62,    -1,
      52,    85,    53,    -1,    56,    -1,    49,    -1,    50,    -1,
      51,    -1,    43,    -1,    44,    -1,     4,    -1,   106,    -1,
     106,    63,   105,    -1,    -1,     4,   107,    86,    87,    -1,
      87,    -1,     4,    -1,     4,    63,   108,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   398,   398,   402,   401,   407,   423,   435,   444,   453,
     462,   543,   586,   586,   589,   602,   602,   609,   614,   614,
     621,   621,   628,   634,   640,   646,   651,   656,   661,   666,
     682,   699,   698,   718,   717,   736,   743,   745,   753,   755,
     762,   772,   784,   784,   789,   793,   800,   808,   808,   808,
     809,   809,   809,   809,   810,   810,   810,   813,   819,   824,
     829,   834,   839,   844,   849,   854,   859,   866,   868,   876,
     879,   881,   889,   892,   894,   902,   905,   907,   915,   915,
     915,   918,   920,   928,   928,   928,   928,   928,   928,   931,
     933,   941,   941,   944,   946,   954,   954,   957,   959,   967,
     967,   967,   970,   972,   979,   979,   979,   979,   979,   979,
     979,   982,   987,   992,   997,  1002,  1007,  1012,  1017,  1022,
    1027,  1032,  1037,  1044,  1051,  1056,  1064,  1063,  1075,  1082,
    1087
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LABEL", "IDENTIFIER", "IDENT_BRACKET",
  "CBLOCK", "DEBUG_LINE", "ENDC", "ERRORLEVEL", "FILL", "LIST", "NUMBER",
  "PROCESSOR", "STRING", "DEFINE", "UPPER", "HIGH", "LOW", "LSH", "RSH",
  "GREATER_EQUAL", "LESS_EQUAL", "EQUAL", "NOT_EQUAL", "'<'", "'>'", "'&'",
  "'|'", "'^'", "LOGICAL_AND", "LOGICAL_OR", "'='", "ASSIGN_PLUS",
  "ASSIGN_MINUS", "ASSIGN_MULTIPLY", "ASSIGN_DIVIDE", "ASSIGN_MODULUS",
  "ASSIGN_LSH", "ASSIGN_RSH", "ASSIGN_AND", "ASSIGN_OR", "ASSIGN_XOR",
  "INCREMENT", "DECREMENT", "POSTINCREMENT", "POSTDECREMENT", "INDFOFFSET",
  "TBL_NO_CHANGE", "TBL_POST_INC", "TBL_POST_DEC", "TBL_PRE_INC", "'['",
  "']'", "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'\\n'", "')'",
  "','", "':'", "'$'", "'('", "$accept", "program", "$@1", "line",
  "decimal_ops", "statement", "$@2", "$@3", "$@4", "$@5", "$@6",
  "const_block", "const_line", "const_def_list", "$@7", "const_def",
  "assign_equal_ops", "parameter_list", "expr", "e9op", "e8", "e8op", "e7",
  "e7op", "e6", "e6op", "e5", "e5op", "e4", "e4op", "e3", "e3op", "e2",
  "e2op", "e1", "e1op", "e0", "cidentifier", "list_block", "list_expr",
  "$@8", "list_args", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,    60,    62,    38,   124,    94,
     280,   281,    61,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    91,    93,    43,    45,    42,    47,    37,    33,
     126,    10,    41,    44,    58,    36,    40
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    67,    68,    69,    68,    68,    70,    70,    70,    70,
      70,    70,    71,    71,    72,    73,    72,    72,    74,    72,
      75,    72,    72,    72,    72,    72,    72,    72,    72,    72,
      72,    76,    72,    77,    72,    72,    78,    78,    79,    79,
      79,    79,    81,    80,    80,    82,    82,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    84,    84,    84,
      84,    84,    84,    84,    84,    84,    84,    85,    85,    86,
      87,    87,    88,    89,    89,    90,    91,    91,    92,    92,
      92,    93,    93,    94,    94,    94,    94,    94,    94,    95,
      95,    96,    96,    97,    97,    98,    98,    99,    99,   100,
     100,   100,   101,   101,   102,   102,   102,   102,   102,   102,
     102,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   104,   105,   105,   107,   106,   106,   108,
     108
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     0,     3,     3,     4,     4,     3,     3,
       2,     1,     1,     1,     1,     0,     4,     2,     0,     4,
       0,     4,     4,     6,     5,     3,     2,     2,     3,     6,
       7,     0,     7,     0,     6,     4,     0,     2,     1,     2,
       2,     3,     0,     2,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     2,
       3,     2,     1,     2,     2,     2,     2,     1,     3,     1,
       1,     3,     1,     1,     3,     1,     1,     3,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     4,     1,     1,
       3
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,     0,     1,     0,     0,     5,     0,     0,     0,    13,
      12,     0,    18,    15,     0,    14,     4,    20,    11,     0,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
       0,     0,    10,     0,   123,   112,   114,   104,   105,   106,
     121,   122,   118,   119,   120,     0,   110,   107,   117,   108,
     109,    27,    62,   113,     0,     0,    58,    67,    70,    73,
      76,    81,    89,    93,    97,     0,   102,   111,     0,   121,
     122,    33,     0,     0,    17,     0,     0,     0,     0,    26,
       0,     0,     9,     8,     0,    63,    64,     0,    61,     0,
      65,    66,    28,    69,     0,    59,     0,    72,     0,    75,
       0,    78,    79,    80,     0,    87,    88,    85,    86,    83,
      84,     0,    91,    92,     0,    95,    96,     0,    99,   100,
     101,     0,   103,     0,    36,    31,     0,     0,   123,   128,
       0,   124,     0,     0,    25,   129,     0,     0,     0,     7,
       6,   116,   115,     0,    60,    68,    71,    74,    77,    82,
      90,    94,    98,    35,    42,    36,     0,     0,     0,    19,
       0,    16,    22,     0,     0,     0,    21,    57,     0,     0,
      38,    37,     0,     0,    42,     0,     0,     0,   125,   130,
      24,     0,    40,     0,    34,    39,     0,    43,    45,     0,
      29,     0,   127,    23,    41,    44,     0,    32,    30,    46
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     4,    16,    17,    18,    76,    75,    80,   155,
     124,   154,   171,   172,   173,   187,    33,    55,    56,    96,
      57,    98,    58,   100,    59,   104,    60,   111,    61,   114,
      62,   117,    63,   121,    64,    65,    66,    67,   130,   131,
     158,   137
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -93
static const yytype_int16 yypact[] =
{
     -93,   140,   -93,   -48,    23,   -93,   384,    58,     0,   -93,
     -93,    27,   -16,   -93,     3,   -93,   -93,   -93,   -93,   254,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -14,    22,   -93,   254,   -93,   -93,   -93,   -93,   -93,   -93,
     178,   178,   -93,   -93,   -93,   254,   -93,   -93,   -93,   -93,
     -93,   -93,   178,   -93,   254,    84,   -10,    54,    69,    68,
      67,    96,   104,    73,   -93,   321,   -93,   -93,    95,   -93,
     -93,   -93,   -26,   121,   -93,   272,   101,     7,     5,   -93,
     178,   -13,   -93,   -93,     8,   118,   118,   -29,   118,    -4,
     -93,   -93,   -93,   -93,   254,   178,   254,   -93,   254,   -93,
     254,   -93,   -93,   -93,   254,   -93,   -93,   -93,   -93,   -93,
     -93,   254,   -93,   -93,   254,   -93,   -93,   254,   -93,   -93,
     -93,   254,   -93,    59,   -93,   -93,    63,    36,    90,    54,
      71,    79,    75,    91,   -93,   100,   120,    92,   113,   -93,
     -93,   -93,   -93,    25,   118,    54,    69,    68,    67,    96,
     104,    73,   -93,   -93,     2,   -93,   254,   103,   135,   -93,
     272,   -93,   -93,   165,   117,   171,   -93,   -93,   196,   128,
     -93,   -93,   -22,   175,    12,    39,   254,   254,   -93,   -93,
     -93,   130,   -93,    45,   -93,   -93,   175,   -93,   129,   136,
     -93,    50,    54,   -93,   -93,   -93,   254,   -93,   -93,   135
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -93,   -93,   -93,   -93,   -93,   192,   -93,   -93,   -93,   -93,
     -93,    44,   -93,   -93,   -93,    16,   -93,   289,    -8,    46,
     -73,   -93,   105,   -93,   106,   -93,   107,   -93,    94,   -93,
      93,   -93,    98,   -93,    88,   -93,   151,   -92,    57,   -93,
     -93,    55
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -127
static const yytype_int16 yytable[] =
{
      72,    68,   129,    93,    34,   168,    93,    77,    78,   135,
     169,    81,    35,     5,    36,   168,    37,    38,    39,    93,
     189,   133,    93,   145,   141,    84,     6,     7,    93,     8,
       9,    73,    10,    11,    12,   125,    13,    87,    14,   185,
      93,   186,    94,    69,    70,    74,    89,    82,   139,    42,
      43,    44,    45,    95,    46,    47,    48,    93,   142,    49,
      50,    71,    34,   170,    79,    53,    54,   136,   134,   140,
      35,    93,    36,   170,    37,    38,    39,    93,   167,    90,
      91,   188,    93,    83,    15,    97,   143,   129,   105,   106,
     107,   108,   109,   110,   188,   101,   102,   103,   157,    99,
     190,    40,    41,   123,   192,   132,   194,    42,    43,    44,
      45,   198,    46,    47,    48,   112,   113,    49,    50,    51,
     153,    52,  -126,    53,    54,    34,   156,    90,    91,   118,
     119,   120,   159,    35,   164,    36,   161,    37,    38,    39,
       2,     3,   160,    -3,    -3,    92,    -3,    -3,   175,    -3,
      -3,    -3,   162,    -3,   165,    -3,    90,    91,   115,   116,
     183,    90,    91,   163,    40,    41,   176,    93,   191,   135,
      42,    43,    44,    45,   166,    46,    47,    48,   180,    34,
      49,    50,    34,   126,    52,   181,    53,    54,   199,   184,
      35,   193,    36,   196,    37,    38,    39,   197,    32,   174,
      34,    -3,   195,   146,   177,   149,   147,   150,    35,   152,
      36,   148,    37,    38,    39,   151,   122,   178,   179,     0,
       0,    40,    41,     0,     0,     0,     0,    42,    43,    44,
      45,     0,    46,    47,    48,     0,     0,    49,    50,    69,
      70,    52,     0,    53,    54,    42,    43,    44,    45,     0,
      46,    47,    48,     0,     0,    49,    50,   182,    34,     0,
       0,    53,    54,     0,     0,     0,    35,     0,    36,     0,
      37,    38,    39,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,    35,     0,    36,     0,    37,    38,
      39,     0,     0,     0,     0,     0,     0,    69,    70,     0,
       0,     0,     0,    42,    43,    44,    45,     0,    46,    47,
      48,     0,     0,    49,    50,    69,    70,     0,     0,    53,
      54,    42,    43,    44,    45,    34,    46,    47,    48,    85,
      86,    49,    50,    35,     0,    36,     0,    53,    54,     0,
       0,    88,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   127,     0,    69,    70,     0,     0,     0,   138,
      42,    43,    44,    45,     0,     0,     0,    48,     0,     0,
       0,     0,     0,     0,   144,     0,    53,    54,     7,     0,
       8,     9,     0,    10,    11,    12,     0,    13,     0,    14,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    15
};

#define yypact_value_is_default(yystate) \
  ((yystate) == (-93))

#define yytable_value_is_error(yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
       8,     1,    75,    32,     4,     3,    32,     4,     5,     4,
       8,    19,    12,    61,    14,     3,    16,    17,    18,    32,
       8,    14,    32,    96,    53,    33,     3,     4,    32,     6,
       7,     4,     9,    10,    11,    61,    13,    45,    15,    61,
      32,    63,    52,    43,    44,    61,    54,    61,    61,    49,
      50,    51,    52,    63,    54,    55,    56,    32,    62,    59,
      60,    61,     4,    61,    61,    65,    66,    62,    61,    61,
      12,    32,    14,    61,    16,    17,    18,    32,    53,    43,
      44,   173,    32,    61,    61,    31,    94,   160,    21,    22,
      23,    24,    25,    26,   186,    27,    28,    29,    62,    30,
      61,    43,    44,     8,   177,     4,    61,    49,    50,    51,
      52,    61,    54,    55,    56,    19,    20,    59,    60,    61,
      61,    63,    32,    65,    66,     4,    63,    43,    44,    56,
      57,    58,    61,    12,    14,    14,    61,    16,    17,    18,
       0,     1,    63,     3,     4,    61,     6,     7,   156,     9,
      10,    11,    61,    13,    62,    15,    43,    44,    54,    55,
     168,    43,    44,    63,    43,    44,    63,    32,   176,     4,
      49,    50,    51,    52,    61,    54,    55,    56,    61,     4,
      59,    60,     4,    62,    63,    14,    65,    66,   196,    61,
      12,    61,    14,    64,    16,    17,    18,    61,     6,   155,
       4,    61,   186,    98,   158,   111,   100,   114,    12,   121,
      14,   104,    16,    17,    18,   117,    65,   160,   163,    -1,
      -1,    43,    44,    -1,    -1,    -1,    -1,    49,    50,    51,
      52,    -1,    54,    55,    56,    -1,    -1,    59,    60,    43,
      44,    63,    -1,    65,    66,    49,    50,    51,    52,    -1,
      54,    55,    56,    -1,    -1,    59,    60,    61,     4,    -1,
      -1,    65,    66,    -1,    -1,    -1,    12,    -1,    14,    -1,
      16,    17,    18,    -1,    -1,    -1,     4,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    12,    -1,    14,    -1,    16,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    43,    44,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,    -1,    54,    55,
      56,    -1,    -1,    59,    60,    43,    44,    -1,    -1,    65,
      66,    49,    50,    51,    52,     4,    54,    55,    56,    40,
      41,    59,    60,    12,    -1,    14,    -1,    65,    66,    -1,
      -1,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    43,    44,    -1,    -1,    -1,    80,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    65,    66,     4,    -1,
       6,     7,    -1,     9,    10,    11,    -1,    13,    -1,    15,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    68,     0,     1,    69,    61,     3,     4,     6,     7,
       9,    10,    11,    13,    15,    61,    70,    71,    72,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    72,    83,     4,    12,    14,    16,    17,    18,
      43,    44,    49,    50,    51,    52,    54,    55,    56,    59,
      60,    61,    63,    65,    66,    84,    85,    87,    89,    91,
      93,    95,    97,    99,   101,   102,   103,   104,     1,    43,
      44,    61,    85,     4,    61,    74,    73,     4,     5,    61,
      75,    85,    61,    61,    85,    84,    84,    85,    84,    85,
      43,    44,    61,    32,    52,    63,    86,    31,    88,    30,
      90,    27,    28,    29,    92,    21,    22,    23,    24,    25,
      26,    94,    19,    20,    96,    54,    55,    98,    56,    57,
      58,   100,   103,     8,    77,    61,    62,    84,     4,    87,
     105,   106,     4,    14,    61,     4,    62,   108,    84,    61,
      61,    53,    62,    85,    84,    87,    89,    91,    93,    95,
      97,    99,   101,    61,    78,    76,    63,    62,   107,    61,
      63,    61,    61,    63,    14,    62,    61,    53,     3,     8,
      61,    79,    80,    81,    78,    85,    63,    86,   105,   108,
      61,    14,    61,    85,    61,    61,    63,    82,   104,     8,
      61,    85,    87,    61,    61,    82,    64,    61,    61,    85
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* This macro is provided for backward compatibility. */

#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  YYSIZE_T yysize1;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = 0;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                yysize1 = yysize + yytnamerr (0, yytname[yyx]);
                if (! (yysize <= yysize1
                       && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                  return 2;
                yysize = yysize1;
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  yysize1 = yysize + yystrlen (yyformat);
  if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
    return 2;
  yysize = yysize1;

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:

/* Line 1806 of yacc.c  */
#line 402 "parse.y"
    {
          state.lst.line.was_org = state.org;
          state.lst.line.linetype = none;
          state.next_state = state_nochange;
        }
    break;

  case 5:

/* Line 1806 of yacc.c  */
#line 408 "parse.y"
    {
          state.lst.line.was_org = state.org;
          state.lst.line.linetype = none;
          state.next_state = state_nochange;

          yyerrok;  /* generate multiple errors */
          if (IN_MACRO_WHILE_DEFINITION) {
            /* in macro definition: append the macro */
            macro_append();
          }
          next_line(0);
        }
    break;

  case 6:

/* Line 1806 of yacc.c  */
#line 424 "parse.y"
    {
          struct pnode *parms;
          int exp_result;

          exp_result = do_insn("set", mk_list((yyvsp[(3) - (4)].p), NULL));
          parms = mk_list(mk_2op(return_op((yyvsp[(2) - (4)].i)),
                                 mk_symbol((yyvsp[(1) - (4)].s)),
                                 mk_constant(exp_result)), NULL);
          next_line(set_label((yyvsp[(1) - (4)].s), parms));
        }
    break;

  case 7:

/* Line 1806 of yacc.c  */
#line 436 "parse.y"
    {
          struct pnode *parms;

          /* implements i = 6 + 1 */
          parms = mk_list((yyvsp[(3) - (4)].p), NULL);
          next_line(set_label((yyvsp[(1) - (4)].s), parms));
        }
    break;

  case 8:

/* Line 1806 of yacc.c  */
#line 445 "parse.y"
    {
          struct pnode *parms;

          /* implements i-- */
          parms = mk_list(mk_1op(DECREMENT, mk_symbol((yyvsp[(1) - (3)].s))), NULL);
          next_line(set_label((yyvsp[(1) - (3)].s), parms));
        }
    break;

  case 9:

/* Line 1806 of yacc.c  */
#line 454 "parse.y"
    {
          struct pnode *parms;

          /* implements i++ */
          parms = mk_list(mk_1op(INCREMENT, mk_symbol((yyvsp[(1) - (3)].s))), NULL);
          next_line(set_label((yyvsp[(1) - (3)].s), parms));
        }
    break;

  case 10:

/* Line 1806 of yacc.c  */
#line 463 "parse.y"
    {
          if (asm_enabled() && (state.lst.line.linetype == none)) {
            if (IS_RAM_ORG) {
              /* alias to next definition */
              state.lst.line.linetype = res;
            }
            else
              state.lst.line.linetype = insn;
          }

          if (asm_enabled()) {
            if (state.mac_head) {
              /* This is a macro definition.  Set it up */
              struct symbol *mac;
              struct macro_head *h = NULL;

              mac = get_symbol(state.stMacros, (yyvsp[(1) - (2)].s));
              if (mac)
                h = get_symbol_annotation(mac);

              /* It's not an error if macro was defined on pass 1 and
                 we're in pass 2. */
              if (h &&
                  !((h->pass == 1) && (state.pass == 2))) {
                gpverror(GPE_DUPLICATE_MACRO);
              } else {
                if (!mac)
                  mac = add_symbol(state.stMacros, (yyvsp[(1) - (2)].s));
                annotate_symbol(mac, state.mac_head);
                h = state.mac_head;
                h->line_number = state.src->line_number;
                h->file_symbol = state.src->file_symbol;
              }
              h->pass = state.pass;

              /* The macro is defined so allow calls. */
              if (state.pass == 2)
                h->defined = 1;

              state.mac_head = NULL;
            } else if (!IN_MACRO_WHILE_DEFINITION) {
              /* Outside a macro definition, just define the label. */
              switch (state.lst.line.linetype) {
              case sec:
                strncpy(state.obj.new_sec_name, (yyvsp[(1) - (2)].s), 78);
                break;

              case set:
                set_global((yyvsp[(1) - (2)].s), (yyvsp[(2) - (2)].i), TEMPORARY, gvt_constant);
                break;

              case org:
              case equ:
                set_global((yyvsp[(1) - (2)].s), (yyvsp[(2) - (2)].i), PERMANENT, gvt_constant);
                break;

              case insn:
              case data:
              case res:
                if (relocatable == state.mode && !IN_MACRO_WHILE_DEFINITION &&
                  !(SECTION_FLAGS & (STYP_TEXT | STYP_DATA | STYP_BPACK | STYP_BSS)))
                  gpverror(GPE_LABEL_IN_SECTION);
                if (IS_RAM_ORG)
                  set_global((yyvsp[(1) - (2)].s), (yyvsp[(2) - (2)].i), PERMANENT, gvt_static);
                else
                  set_global((yyvsp[(1) - (2)].s), (yyvsp[(2) - (2)].i), PERMANENT, gvt_address);
                break;

              case dir:
                gpverror(GPE_ILLEGAL_LABEL, (yyvsp[(1) - (2)].s));
                break;

              default:
                break;
              }
            }
          }
          next_line((yyvsp[(2) - (2)].i));
        }
    break;

  case 11:

/* Line 1806 of yacc.c  */
#line 544 "parse.y"
    {
          if (state.mac_head) {
            /* This is a macro definition, but the label was missing */
            state.mac_head = NULL;
            gpverror(GPE_NO_MACRO_NAME);
          } else {
            if (state.found_end) {
              switch (state.src->type) {
              case src_while:
                gperror(GPE_EXPECTED, "Expected (ENDW)");
                break;

              case src_macro:
                gperror(GPW_EXPECTED,"Expected (ENDM)");
                /* fall through */

              default:
                break;
              }

              if (state.astack != NULL) {
                struct amode *old;

                while (state.astack) {
                  old = state.astack;
                  state.astack = state.astack->prev;
                  free(old);
                }
                gpwarning(GPW_EXPECTED, "Expected (ENDIF)");
              }
            }

            next_line((yyvsp[(1) - (1)].i));

            if (state.found_end) {
              found_end();
              YYACCEPT;
            }
          }
        }
    break;

  case 14:

/* Line 1806 of yacc.c  */
#line 590 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            if (!IS_RAM_ORG)
              /* We want to have r as the value to assign to label */
              (yyval.i) = gp_processor_byte_to_org(state.device.class, state.org);
            else
              (yyval.i) = state.org;
          } else {
            macro_append();
          }
        }
    break;

  case 15:

/* Line 1806 of yacc.c  */
#line 602 "parse.y"
    {  force_ident = 1; }
    break;

  case 16:

/* Line 1806 of yacc.c  */
#line 604 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (4)].s), mk_list(mk_symbol((yyvsp[(3) - (4)].s)), NULL));
          force_ident = 0;
        }
    break;

  case 17:

/* Line 1806 of yacc.c  */
#line 610 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (2)].s), NULL);
        }
    break;

  case 18:

/* Line 1806 of yacc.c  */
#line 614 "parse.y"
    {  force_decimal = 1; }
    break;

  case 19:

/* Line 1806 of yacc.c  */
#line 616 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (4)].s), (yyvsp[(3) - (4)].p));
          force_decimal = 0;
        }
    break;

  case 20:

/* Line 1806 of yacc.c  */
#line 621 "parse.y"
    {  force_decimal = 1; }
    break;

  case 21:

/* Line 1806 of yacc.c  */
#line 623 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (4)].s), (yyvsp[(3) - (4)].p));
          force_decimal = 0;
        }
    break;

  case 22:

/* Line 1806 of yacc.c  */
#line 629 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (4)].s), mk_list(mk_string((yyvsp[(2) - (4)].s)),
              mk_list(mk_string((yyvsp[(3) - (4)].s)), NULL)));
        }
    break;

  case 23:

/* Line 1806 of yacc.c  */
#line 635 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (6)].s), mk_list(mk_string((yyvsp[(2) - (6)].s)),
              mk_list(mk_string((yyvsp[(5) - (6)].s)), (yyvsp[(3) - (6)].p))));
        }
    break;

  case 24:

/* Line 1806 of yacc.c  */
#line 641 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (5)].s), mk_list(mk_string((yyvsp[(2) - (5)].s)),
              mk_list(mk_string((yyvsp[(4) - (5)].s)), NULL)));
        }
    break;

  case 25:

/* Line 1806 of yacc.c  */
#line 647 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (3)].s), mk_list(mk_string((yyvsp[(2) - (3)].s)), NULL));
        }
    break;

  case 26:

/* Line 1806 of yacc.c  */
#line 652 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (2)].s), NULL);
        }
    break;

  case 27:

/* Line 1806 of yacc.c  */
#line 657 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (2)].s), NULL);
        }
    break;

  case 28:

/* Line 1806 of yacc.c  */
#line 662 "parse.y"
    {
          (yyval.i) = do_or_append_insn((yyvsp[(1) - (3)].s), (yyvsp[(2) - (3)].p));
        }
    break;

  case 29:

/* Line 1806 of yacc.c  */
#line 667 "parse.y"
    {
          int number;
          int i;

          if (!IN_MACRO_WHILE_DEFINITION) {
            number = eval_fill_number((yyvsp[(5) - (6)].p));

            for (i = 0; i < number; i++) {
              (yyval.i) = do_insn((yyvsp[(2) - (6)].s), NULL);
            }
          } else {
            macro_append();
          }
        }
    break;

  case 30:

/* Line 1806 of yacc.c  */
#line 683 "parse.y"
    {
          int number;
          int i;

          if (!IN_MACRO_WHILE_DEFINITION) {
            number = eval_fill_number((yyvsp[(6) - (7)].p));

            for (i = 0; i < number; i++) {
              (yyval.i) = do_insn((yyvsp[(2) - (7)].s), (yyvsp[(3) - (7)].p));
            }
          } else {
            macro_append();
          }
        }
    break;

  case 31:

/* Line 1806 of yacc.c  */
#line 699 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            begin_cblock((yyvsp[(2) - (3)].p));
          } else {
            macro_append();
          }
          next_line(0);
        }
    break;

  case 32:

/* Line 1806 of yacc.c  */
#line 709 "parse.y"
    {
          state.lst.line.linetype = none;
          if (IN_MACRO_WHILE_DEFINITION) {
            macro_append();
          }
          (yyval.i) = 0;
        }
    break;

  case 33:

/* Line 1806 of yacc.c  */
#line 718 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            continue_cblock();
          } else {
            macro_append();
          }
          next_line(0);
        }
    break;

  case 34:

/* Line 1806 of yacc.c  */
#line 728 "parse.y"
    {
          state.lst.line.linetype = none;
          if (IN_MACRO_WHILE_DEFINITION) {
            macro_append();
          }
          (yyval.i) = 0;
        }
    break;

  case 35:

/* Line 1806 of yacc.c  */
#line 737 "parse.y"
    {
          state.lst.line.linetype = none;
          (yyval.i) = 0;
        }
    break;

  case 37:

/* Line 1806 of yacc.c  */
#line 746 "parse.y"
    {
          state.lst.line.linetype = set;
          next_line(state.lst.cblock_lst);
        }
    break;

  case 39:

/* Line 1806 of yacc.c  */
#line 756 "parse.y"
    {
          if (IN_MACRO_WHILE_DEFINITION) {
            macro_append();
          }
        }
    break;

  case 40:

/* Line 1806 of yacc.c  */
#line 763 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            state.lst.cblock_lst = state.cblock;
            cblock_expr(mk_symbol((yyvsp[(1) - (2)].s)));
          } else {
            macro_append();
          }
        }
    break;

  case 41:

/* Line 1806 of yacc.c  */
#line 773 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            state.lst.cblock_lst = state.cblock;
            cblock_expr_incr(mk_symbol((yyvsp[(1) - (3)].s)), (yyvsp[(2) - (3)].p));
          } else {
            macro_append();
          }
        }
    break;

  case 42:

/* Line 1806 of yacc.c  */
#line 784 "parse.y"
    {
          state.lst.cblock_lst = state.cblock;
        }
    break;

  case 45:

/* Line 1806 of yacc.c  */
#line 794 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            cblock_expr((yyvsp[(1) - (1)].p));
          }
        }
    break;

  case 46:

/* Line 1806 of yacc.c  */
#line 801 "parse.y"
    {
          if (!IN_MACRO_WHILE_DEFINITION) {
            cblock_expr_incr((yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
          }
        }
    break;

  case 57:

/* Line 1806 of yacc.c  */
#line 814 "parse.y"
    {
          (yyval.p) = mk_list(mk_constant(INDFOFFSET),
                       mk_list((yyvsp[(3) - (4)].p), (yyvsp[(1) - (4)].p)));
        }
    break;

  case 58:

/* Line 1806 of yacc.c  */
#line 820 "parse.y"
    {
          (yyval.p) = mk_list((yyvsp[(1) - (1)].p), NULL);
        }
    break;

  case 59:

/* Line 1806 of yacc.c  */
#line 825 "parse.y"
    {
          (yyval.p) = mk_list((yyvsp[(1) - (2)].p), mk_list(mk_symbol(""), NULL));
        }
    break;

  case 60:

/* Line 1806 of yacc.c  */
#line 830 "parse.y"
    {
          (yyval.p) = mk_list((yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 61:

/* Line 1806 of yacc.c  */
#line 835 "parse.y"
    {
          (yyval.p) = mk_list(mk_symbol(""), (yyvsp[(2) - (2)].p));
        }
    break;

  case 62:

/* Line 1806 of yacc.c  */
#line 840 "parse.y"
    {
          (yyval.p) = mk_list(mk_symbol(""), mk_list(mk_symbol(""), NULL));
        }
    break;

  case 63:

/* Line 1806 of yacc.c  */
#line 845 "parse.y"
    {
          (yyval.p) = mk_list(mk_constant((yyvsp[(1) - (2)].i)), (yyvsp[(2) - (2)].p));
        }
    break;

  case 64:

/* Line 1806 of yacc.c  */
#line 850 "parse.y"
    {
          (yyval.p) = mk_list(mk_constant((yyvsp[(1) - (2)].i)), (yyvsp[(2) - (2)].p));
        }
    break;

  case 65:

/* Line 1806 of yacc.c  */
#line 855 "parse.y"
    {
          (yyval.p) = mk_list(mk_constant(POSTINCREMENT), (yyvsp[(1) - (2)].p));
        }
    break;

  case 66:

/* Line 1806 of yacc.c  */
#line 860 "parse.y"
    {
          (yyval.p) = mk_list(mk_constant(POSTDECREMENT), (yyvsp[(1) - (2)].p));
        }
    break;

  case 68:

/* Line 1806 of yacc.c  */
#line 869 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 71:

/* Line 1806 of yacc.c  */
#line 882 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 74:

/* Line 1806 of yacc.c  */
#line 895 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 77:

/* Line 1806 of yacc.c  */
#line 908 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 82:

/* Line 1806 of yacc.c  */
#line 921 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 90:

/* Line 1806 of yacc.c  */
#line 934 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 94:

/* Line 1806 of yacc.c  */
#line 947 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 98:

/* Line 1806 of yacc.c  */
#line 960 "parse.y"
    {
          coerce_str1((yyvsp[(1) - (3)].p));
          coerce_str1((yyvsp[(3) - (3)].p));
          (yyval.p) = mk_2op((yyvsp[(2) - (3)].i), (yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 103:

/* Line 1806 of yacc.c  */
#line 973 "parse.y"
    {
          coerce_str1((yyvsp[(2) - (2)].p));
          (yyval.p) = mk_1op((yyvsp[(1) - (2)].i), (yyvsp[(2) - (2)].p));
        }
    break;

  case 111:

/* Line 1806 of yacc.c  */
#line 983 "parse.y"
    {
          (yyval.p) = (yyvsp[(1) - (1)].p);
        }
    break;

  case 112:

/* Line 1806 of yacc.c  */
#line 988 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 113:

/* Line 1806 of yacc.c  */
#line 993 "parse.y"
    {
          (yyval.p) = mk_symbol("$");
        }
    break;

  case 114:

/* Line 1806 of yacc.c  */
#line 998 "parse.y"
    {
          (yyval.p) = mk_string((yyvsp[(1) - (1)].s));
        }
    break;

  case 115:

/* Line 1806 of yacc.c  */
#line 1003 "parse.y"
    {
          (yyval.p) = (yyvsp[(2) - (3)].p);
        }
    break;

  case 116:

/* Line 1806 of yacc.c  */
#line 1008 "parse.y"
    {
          (yyval.p) = mk_offset((yyvsp[(2) - (3)].p));
        }
    break;

  case 117:

/* Line 1806 of yacc.c  */
#line 1013 "parse.y"
    {
          (yyval.p) = mk_constant(TBL_NO_CHANGE);
        }
    break;

  case 118:

/* Line 1806 of yacc.c  */
#line 1018 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 119:

/* Line 1806 of yacc.c  */
#line 1023 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 120:

/* Line 1806 of yacc.c  */
#line 1028 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 121:

/* Line 1806 of yacc.c  */
#line 1033 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 122:

/* Line 1806 of yacc.c  */
#line 1038 "parse.y"
    {
          (yyval.p) = mk_constant((yyvsp[(1) - (1)].i));
        }
    break;

  case 123:

/* Line 1806 of yacc.c  */
#line 1045 "parse.y"
    {
          (yyval.p) = mk_symbol((yyvsp[(1) - (1)].s));
        }
    break;

  case 124:

/* Line 1806 of yacc.c  */
#line 1052 "parse.y"
    {
          (yyval.p) = mk_list((yyvsp[(1) - (1)].p), NULL);
        }
    break;

  case 125:

/* Line 1806 of yacc.c  */
#line 1057 "parse.y"
    {
          (yyval.p) = mk_list((yyvsp[(1) - (3)].p), (yyvsp[(3) - (3)].p));
        }
    break;

  case 126:

/* Line 1806 of yacc.c  */
#line 1064 "parse.y"
    {
          if ((strcasecmp((yyvsp[(1) - (1)].s), "p") == 0) || (strcasecmp((yyvsp[(1) - (1)].s), "pe") == 0)) {
            force_ident = 1;
          }
        }
    break;

  case 127:

/* Line 1806 of yacc.c  */
#line 1070 "parse.y"
    {
          (yyval.p) = mk_2op((yyvsp[(3) - (4)].i), mk_symbol((yyvsp[(1) - (4)].s)), (yyvsp[(4) - (4)].p));
          force_ident = 0;
        }
    break;

  case 128:

/* Line 1806 of yacc.c  */
#line 1076 "parse.y"
    {
          (yyval.p) = (yyvsp[(1) - (1)].p);
        }
    break;

  case 129:

/* Line 1806 of yacc.c  */
#line 1083 "parse.y"
    {
          (yyval.p) = mk_list(mk_symbol((yyvsp[(1) - (1)].s)), NULL);
        }
    break;

  case 130:

/* Line 1806 of yacc.c  */
#line 1088 "parse.y"
    {
          (yyval.p) = mk_list(mk_symbol((yyvsp[(1) - (3)].s)), (yyvsp[(3) - (3)].p));
        }
    break;



/* Line 1806 of yacc.c  */
#line 2906 "parse.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 2067 of yacc.c  */
#line 1092 "parse.y"


int return_op(int operation)
{
  /* returns an operator for the replacement of i+=1 with i=i+1*/
  switch(operation) {
  case ASSIGN_PLUS:     return '+';
  case ASSIGN_MINUS:    return '-';
  case ASSIGN_MULTIPLY: return '*';
  case ASSIGN_DIVIDE:   return '/';
  case ASSIGN_MODULUS:  return '%';
  case ASSIGN_LSH:      return LSH;
  case ASSIGN_RSH:      return RSH;
  case ASSIGN_AND:      return '&';
  case ASSIGN_OR:       return '|';
  case ASSIGN_XOR:      return '^';
  default:
    assert(0); /* Unhandled operator */
  }

  return 0;
}

