/**********************************************************************/
/*                      Main class for J2CPS                          */
/*                                                                    */   
/*                      (c) copyright QUT                             */ 
/**********************************************************************/
package J2CPS;

import java.util.*;
import java.io.*;
/* import CPascal.*; */

public class J2CPS {

  /**
   * Main program. Takes a package name as a parameter, produces the 
   * component pascal symbol file.
   */
  public static void main(String args[]) { 
    boolean anonPack = false;
    J2CPSFiles.GetPaths();
    String filename = null;
    TypeDesc.InitTypes();
    if (args.length == 0) {
      System.err.println("Usage: java J2CPS [options] packagename");
      System.err.println("Options may be in any order.");
      System.err.println("  -d dir  symbol file directory");
      System.err.println("  -u      use unique names");
      System.err.println("  -v      verbose diagnostic messages");
      System.exit(0);
    }
    else {
      int argIx = 0;
      filename = args[argIx];
      while (filename.startsWith("-")) { 
        /* parse options here */
        if (filename.charAt(1) == 'v') { ClassDesc.verbose = true; }
        else if (filename.charAt(1) == 'f') { 
          System.out.println("Class not package");
          anonPack = true; }
        else if (filename.charAt(1) == 'u') { 
          System.out.println("Using unique names");
          ClassDesc.overloadedNames = false; }
        else if (filename.charAt(1) == 'd') {
          filename = args[++argIx];
          J2CPSFiles.SetSymDir(filename); }
        else { System.err.println("Unknown option " + filename); }
        filename = args[++argIx]; 
      }
    }
    try {
      PackageDesc thisPackage = new PackageDesc(filename,anonPack);
      PackageDesc.ReadPackages();
      PackageDesc.WriteSymbolFiles();
    }
    catch (IOException e) {
	System.err.println("IOException occurs while reading input file.");
	System.err.println("Aborting...");
	e.printStackTrace();
	System.exit(1);
    }
  } 


}



