(* ==================================================================== *)
(*									*)
(*  Scanner Module for the Gardens Point Component Pascal Compiler.	*)
(*	Copyright (c) John Gough 1999, 2000.				*)
(*	This module was extensively modified from the scanner		*)
(*	automatically produced by the M2 version of COCO/R, using	*)
(*	the CPascal.atg grammar used for the JVM version of GPCP.	*)
(*									*)
(* ==================================================================== *)

MODULE CPascalS;

(* This is a modified version for Mburg --- it computes column positions *)
(* Scanner generated by Coco/R *)

IMPORT	
	GPCPcopyright,
	RTS,
	Console,
	G := CPascalG,
	GPTextFiles;

CONST
  noSym   = G.NOSYM; (*error token code*)
  (* not only for errors but also for not finished states of scanner analysis *)
  eof     = 0X;
  EOL     = 0AX;
  BlkSize = 32768;
  asciiHT = 9X;
  asciiLF = EOL;

CONST   
  listAlways*  = 2;		(* listing control constants *)
  listErrOnly* = 1;
  listNever*   = 0;

TYPE
  BufBlk     = ARRAY BlkSize OF CHAR;
  Buffer     = ARRAY 32  OF POINTER TO BufBlk;
  StartTable = ARRAY 256 OF INTEGER;

(* ======================== EXPORTS ========================= *)
TYPE
  ErrorHandler* = POINTER TO ABSTRACT RECORD END;
  Token*	= POINTER TO RECORD
		    sym* : INTEGER;
		    lin* : INTEGER;
		    col* : INTEGER;
		    pos* : INTEGER;
		    len* : INTEGER;
		    dlr* : BOOLEAN;
		  END;

(* ====================== END EXPORTS ======================= *)

VAR
  ch:        CHAR;       (*current input character*)
  curLine:   INTEGER;    (*current input line (may be higher than line)*)
  lineStart: INTEGER;    (*start position of current line*)
  apx:       INTEGER;    (*length of appendix (CONTEXT phrase)*)
  oldEols:   INTEGER;    (*number of EOLs in a comment*)
  bp:        INTEGER;    (*current position in buf*)
  bp0:       INTEGER;    (*position of current token)*)
  LBlkSize:  INTEGER;    (*BlkSize*)
  inputLen:  INTEGER;    (*source file size*)
  buf:       Buffer;     (*source buffer for low-level access*)
  start:     StartTable; (*start state for every character*)
  nextLine:  INTEGER;    (*line of lookahead symbol*)
  nextCol:   INTEGER;    (*column of lookahead symbol*)
  nextLen:   INTEGER;    (*length of lookahead symbol*)
  nextPos:   INTEGER;    (*file position of lookahead symbol*)

  spaces:    INTEGER;   (* ############# NEW ############## *)

(* ======================== EXPORTS ========================= *)
VAR
  src*:    GPTextFiles.FILE; (*source file. To be opened by main *)
  lst*:    GPTextFiles.FILE; (*list file. To be opened by main   *)
  line*, col*: INTEGER;      (*line and column of current symbol*)
  len*:        INTEGER;      (*length of current symbol*)
  pos*:        INTEGER;      (*file position of current symbol*)
  errors*:     INTEGER;      (*number of detected errors*)
  warnings*:   INTEGER;      (*number of detected warnings*)
  prevTok*:    Token;
  ParseErr*:   ErrorHandler;
  SemError*:   ErrorHandler;
(* ====================== END EXPORTS ======================= *)

(* ======================== EXPORTS ========================= *)
PROCEDURE (s : ErrorHandler)Report*(num : INTEGER; 
				    lin : INTEGER;
			            col : INTEGER) ,NEW,ABSTRACT;

PROCEDURE (s : ErrorHandler)RepSt1*(num : INTEGER; 
				 IN str : ARRAY OF CHAR;
				    lin : INTEGER;
			            col : INTEGER) ,NEW,ABSTRACT;

PROCEDURE (s : ErrorHandler)RepSt2*(num : INTEGER; 
				 IN st1 : ARRAY OF CHAR;
				 IN st2 : ARRAY OF CHAR;
				    lin : INTEGER;
			            col : INTEGER) ,NEW,ABSTRACT;

PROCEDURE^ get*() : Token;
(* Gets next symbol from source file *)

PROCEDURE^ GetString*(pos: INTEGER; len: INTEGER; OUT name: ARRAY OF CHAR);
(* Retrieves exact string of max length len from position pos in source file *)

PROCEDURE^ charAt*(pos: INTEGER): CHAR;
(* Returns exact character at position pos in source file *)

PROCEDURE^ Reset*;
(* Reads and stores source file internally *)

PROCEDURE^ SkipAndGetLine*(i : INTEGER;		(* indent to skip *)
			   e : INTEGER;		(* end file-pos   *)
		       VAR p : INTEGER;		(* crnt file-pos  *)
		       OUT l : INTEGER;		(* fetched length *)
		       VAR s : ARRAY OF CHAR);	(* output string  *)

(* ==================================================================== *)

  PROCEDURE (t : Token)DiagToken*(),NEW;
    VAR i : INTEGER;
  BEGIN
    Console.Write("l"); Console.WriteInt(t.lin,1); Console.Write(":");
    Console.Write("c"); Console.WriteInt(t.col,1); Console.WriteString(" '");
    FOR i := 0 TO t.len - 1 DO Console.Write(charAt(t.pos+i)) END;
    Console.Write("'"); Console.WriteLn;
  END DiagToken;

  PROCEDURE digitAt(pos : INTEGER) : INTEGER;
    VAR ch : CHAR;
  BEGIN
    ch := charAt(pos);
    IF (ch >= '0') & (ch <= '9') THEN RETURN ORD(ch) - ORD('0');
    ELSE RETURN ORD(ch) + (10 - ORD('A'));
    END;
  END digitAt;

PROCEDURE tokToLong*(t : Token) : LONGINT;
  VAR long : LONGINT;
      indx : INTEGER;
      limt : INTEGER;
      hexD : INTEGER;
      ch   : CHAR;
BEGIN
(* RANGE CHECK HERE *)
  limt := t.pos + t.len - 1;
  long := 0;
  ch := charAt(limt);
  IF (ch = "H") OR (ch = "L") THEN
    DEC(limt);
    FOR indx := t.pos TO limt DO
      hexD := digitAt(indx);
      long := long * 16 + hexD;
    END;
  ELSE
    FOR indx := t.pos TO limt DO
      ch := charAt(indx);
      long := long * 10 + ORD(ch) - ORD('0');
    END;
  END;
  RETURN long;
END tokToLong;

PROCEDURE tokToReal*(t : Token) : REAL;
  VAR str : ARRAY 256 OF CHAR;
      pOk : BOOLEAN;
      num : REAL;
BEGIN
  GetString(t.pos, t.len, str);
  RTS.StrToReal(str$, num, pOk);
  IF ~pOk THEN 
    SemError.Report(45, t.lin, t.col); RETURN 0.0;
  ELSE
    RETURN num;
  END;
END tokToReal;

PROCEDURE tokToChar*(t : Token) : CHAR;
  VAR cOrd : LONGINT;
      indx : INTEGER;
      limt : INTEGER;
      hexD : INTEGER;
      ch   : CHAR;
BEGIN
  limt := t.pos + t.len - 2;
  cOrd := 0;
  FOR indx := t.pos TO limt DO
    hexD := digitAt(indx);
    cOrd := cOrd * 16 + hexD;
  END;
(* RANGE CHECK HERE *)
  RETURN CHR(cOrd);
END tokToChar;

(* ====================== END EXPORTS ======================= *)

  PROCEDURE NextCh;
  (* Return global variable ch *)
  BEGIN
    INC(bp); ch := charAt(bp);
    IF ch = asciiHT THEN 
      INC(spaces,8); DEC(spaces,spaces MOD 8);
    ELSE
      INC(spaces);
    END;
    IF ch = EOL THEN INC(curLine); lineStart := bp; spaces := 0 END
  END NextCh;

(* ==================================================================== *)

  PROCEDURE comment (): BOOLEAN;
  VAR
    level, startLine: INTEGER;
    oldLineStart : INTEGER;
    oldSpaces    : INTEGER;
  BEGIN
    level := 1; startLine := curLine; 
    oldLineStart := lineStart; oldSpaces := spaces;
    IF (ch = "(") THEN
      NextCh;
      IF (ch = "*") THEN
        NextCh;
        LOOP
          IF (ch = "*") THEN
            NextCh;
            IF (ch = ")") THEN
              DEC(level); NextCh;
              IF level = 0 THEN RETURN TRUE END
            END;
          ELSIF (ch = "(") THEN
            NextCh;
            IF (ch = "*") THEN INC(level); NextCh END;
          ELSIF ch = eof THEN RETURN FALSE
          ELSE NextCh END;
        END; (* LOOP *)
      ELSE
        IF ch = EOL THEN DEC(curLine); lineStart := oldLineStart END;
        DEC(bp, 2); NextCh; spaces := oldSpaces; RETURN FALSE
      END;
    END;
    RETURN FALSE;
  END comment;

(* ==================================================================== *)

  PROCEDURE get() : Token;
    VAR
      state: INTEGER;
      sym  : INTEGER;

    PROCEDURE equal (IN s: ARRAY OF CHAR): BOOLEAN;
      VAR
        i: INTEGER;
        q: INTEGER;
      BEGIN
       (* Assert: only called with literals ==> LEN(s$) = LEN(s)-1 *)
        IF nextLen # LEN(s)-1 THEN RETURN FALSE END;
        i := 1; q := bp0; INC(q);
        WHILE i < nextLen DO
          IF charAt(q) # s[i] THEN RETURN FALSE END;
          INC(i); INC(q)
        END;
        RETURN TRUE
      END equal;

    PROCEDURE CheckLiteral(VAR sym : INTEGER);
      BEGIN
        CASE charAt(bp0) OF
          "A": IF equal("ABSTRACT") THEN sym := G.ABSTRACTSym; 
               ELSIF equal("ARRAY") THEN sym := G.ARRAYSym; 
               END
        | "B": IF equal("BEGIN") THEN sym := G.BEGINSym; 
               ELSIF equal("BY") THEN sym := G.BYSym; 
               END
        | "C": IF equal("CASE") THEN sym := G.CASESym; 
               ELSIF equal("CLOSE") THEN sym := G.CLOSESym; 
               ELSIF equal("CONST") THEN sym := G.CONSTSym; 
               END
        | "D": IF equal("DO") THEN sym := G.DOSym; 
	       ELSIF equal("DIV") THEN sym := G.DIVSym; 
               ELSIF equal("DIV0") THEN sym := G.DIV0Sym; 
               END
        | "E": IF equal("ELSE") THEN sym := G.ELSESym; 
               ELSIF equal("ELSIF") THEN sym := G.ELSIFSym; 
               ELSIF equal("EMPTY") THEN sym := G.EMPTYSym; 
               ELSIF equal("END") THEN sym := G.ENDSym; 
               ELSIF equal("EXIT") THEN sym := G.EXITSym; 
               ELSIF equal("EXTENSIBLE") THEN sym := G.EXTENSIBLESym; 
               ELSIF equal("ENUM") THEN sym := G.ENUMSym; 
               ELSIF equal("EVENT") THEN sym := G.EVENTSym; 
               END
        | "F": IF equal("FOR") THEN sym := G.FORSym; 
               END
        | "I": IF equal("IF") THEN sym := G.IFSym; 
               ELSIF equal("IMPORT") THEN sym := G.IMPORTSym; 
               ELSIF equal("IN") THEN sym := G.INSym; 
               ELSIF equal("IS") THEN sym := G.ISSym; 
               ELSIF equal("INTERFACE") THEN sym := G.INTERFACESym; 
               END
        | "L": IF equal("LIMITED") THEN sym := G.LIMITEDSym; 
               ELSIF equal("LOOP") THEN sym := G.LOOPSym; 
               END
        | "M": IF equal("MOD") THEN sym := G.MODSym; 
               ELSIF equal("MODULE") THEN sym := G.MODULESym; 
               END
        | "N": IF equal("NEW") THEN sym := G.NEWSym; 
               ELSIF equal("NIL") THEN sym := G.NILSym; 
               END
        | "O": IF equal("OF") THEN sym := G.OFSym; 
               ELSIF equal("OR") THEN sym := G.ORSym; 
               ELSIF equal("OUT") THEN sym := G.OUTSym; 
               END
        | "P": IF equal("POINTER") THEN sym := G.POINTERSym; 
               ELSIF equal("PROCEDURE") THEN sym := G.PROCEDURESym; 
               END
        | "R": IF equal("RECORD") THEN sym := G.RECORDSym; 
               ELSIF equal("REPEAT") THEN sym := G.REPEATSym; 
               ELSIF equal("RETURN") THEN sym := G.RETURNSym; 
               ELSIF equal("RESCUE") THEN sym := G.RESCUESym; 
               ELSIF equal("REM0")   THEN sym := G.REM0Sym; 
               END
        | "S": IF equal("STATIC") THEN sym := G.STATICSym; 
               END
        | "T": IF equal("THEN") THEN sym := G.THENSym; 
               ELSIF equal("TO") THEN sym := G.TOSym; 
               ELSIF equal("TYPE") THEN sym := G.TYPESym; 
               END
        | "U": IF equal("UNTIL") THEN sym := G.UNTILSym; 
               END
        | "V": IF equal("VAR") THEN sym := G.VARSym; 
               END
        | "W": IF equal("WHILE") THEN sym := G.WHILESym; 
               ELSIF equal("WITH") THEN sym := G.WITHSym; 
               END
        ELSE
        END
      END CheckLiteral;

      PROCEDURE mkToken(kind : INTEGER) : Token;
        VAR new : Token;
      BEGIN
        NEW(new);
	IF kind = G.idVariant THEN kind := G.identSym; new.dlr := TRUE END;
        new.sym := kind; 
        new.lin := nextLine; new.col := nextCol;
        new.len := nextLen;  new.pos := nextPos;
        RETURN new;
      END mkToken;
  
  BEGIN (*get*)
    WHILE (ch=' ') OR
          (ch >= CHR(9)) & (ch <= CHR(10)) OR
          (ch = CHR(13)) DO NextCh END;
    IF ((ch = "(")) & comment() THEN RETURN get() END;
    pos := nextPos;   nextPos := bp;
    col := nextCol;   nextCol := spaces;
    line := nextLine; nextLine := curLine;
    len := nextLen;   nextLen := 0;
    apx := 0; state := start[ORD(ch)]; bp0 := bp;
    LOOP
      NextCh; INC(nextLen);
      CASE state OF
      (* ---------------------------------- *)
         1: (* start of ordinary identifier *)
	    IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "Z") OR
               (ch >= "a") & (ch <= "z") OR
	       (ch = "_")                THEN (* skip *)
	    ELSIF ch = "@" THEN state := 45;
	    ELSIF ch = "$" THEN state := 46; 
            ELSE sym := G.identSym; CheckLiteral(sym); RETURN mkToken(sym);
            END;
      (* ---------------------------------- *)
      | 44:(* start of ` escaped identifier *)
	    IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "Z") OR
               (ch >= "a") & (ch <= "z") OR
	       (ch = "_")                THEN (* skip *)
	    ELSE 
	      SemError.Report(187, nextLine, spaces); 
	      RETURN mkToken(noSym);
	    END;
	    (* throw away the escape char *)
	    INC(nextPos); INC(nextCol); DEC(nextLen);
	    state := 45;
      (* ---------------------------------- *)
      | 45:(* rest of ` escaped identifier  *)
	    IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "Z") OR
               (ch >= "a") & (ch <= "z") OR
	       (ch = "@")                OR 
	       (ch = "_")                THEN (* skip *)
	    ELSIF ch = "$" THEN state := 47; 
            ELSE RETURN mkToken(G.idVariant); (* No check for reserved words *)
            END;
      (* ---------------------------------- *)
      | 46:(* check for $ at end of ident.  *)
	    IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "Z") OR
               (ch >= "a") & (ch <= "z") OR
	       (ch = "_")                THEN state := 45;
            ELSE 
              DEC(bp, 2); DEC(nextLen); NextCh; 
              sym := G.identSym; CheckLiteral(sym); RETURN mkToken(sym);
            END;
      (* ---------------------------------- *)
      | 47:(* check for $ at end of idVar't *)
	    IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "Z") OR
               (ch >= "a") & (ch <= "z") OR
	       (ch = "_")                THEN state := 45;
            ELSE 
              DEC(bp, 2); DEC(nextLen); NextCh; 
              RETURN mkToken(G.idVariant); (* No check for reserved words *)
            END;
      (* ---------------------------------- *)
      |  2: RETURN mkToken(G.integerSym);
      |  3: DEC(bp, apx+1); DEC(nextLen, apx);
	    NextCh; RETURN mkToken(G.integerSym);
      |  4: IF (ch >= "0") & (ch <= "9") THEN 
            ELSIF (ch = "E") THEN state := 5; 
            ELSE RETURN mkToken(G.realSym);
            END;
      |  5: IF (ch >= "0") & (ch <= "9") THEN state := 7; 
            ELSIF (ch = "+") OR
                  (ch = "-") THEN state := 6; 
            ELSE RETURN mkToken(noSym);
            END;
      |  6: IF (ch >= "0") & (ch <= "9") THEN state := 7; 
            ELSE RETURN mkToken(noSym);
            END;
      |  7: IF (ch >= "0") & (ch <= "9") THEN 
            ELSE RETURN mkToken(G.realSym);
            END;
      |  8: RETURN mkToken(G.CharConstantSym);
      |  9: IF (ch <= CHR(9)) OR
               (ch >= CHR(11)) & (ch <= CHR(12)) OR
               (ch >= CHR(14)) & (ch <= "!") OR
               (ch>="#") THEN 
            ELSIF (ch = '"') THEN state := 10; 
            ELSE RETURN mkToken(noSym);
            END;
      | 10: RETURN mkToken(G.stringSym);
      | 11: IF (ch <= CHR(9)) OR
               (ch >= CHR(11)) & (ch <= CHR(12)) OR
               (ch >= CHR(14)) & (ch <= "&") OR
               (ch>="(") THEN 
            ELSIF (ch = "'") THEN state := 10; 
            ELSE RETURN mkToken(noSym);
            END;
      | 12: IF (ch >= "0") & (ch <= "9") THEN 
            ELSIF (ch >= "A") & (ch <= "F") THEN state := 13; 
            ELSIF (ch = "H") OR
                  (ch = "L") THEN state := 2; 
            ELSIF (ch = ".") THEN state := 14; INC(apx) 
            ELSIF (ch = "X") THEN state := 8; 
            ELSE RETURN mkToken(G.integerSym);
            END;
      | 13: IF (ch >= "0") & (ch <= "9") OR
               (ch >= "A") & (ch <= "F") THEN 
            ELSIF (ch = "H") OR
                  (ch = "L") THEN state := 2; 
            ELSIF (ch = "X") THEN state := 8; 
            ELSE RETURN mkToken(noSym);
            END;
      | 14: IF (ch >= "0") & (ch <= "9") THEN state := 4; apx := 0 
            ELSIF (ch = ".") THEN state := 3; INC(apx) 
            ELSIF (ch = "E") THEN state := 5; apx := 0 
            ELSE RETURN mkToken(G.realSym);
            END;
      | 15: RETURN mkToken(G.starSym);
      | 16: RETURN mkToken(G.minusSym);
      | 17: RETURN mkToken(G.bangSym);
      | 18: IF (ch = ".") THEN state := 40; 
            ELSE RETURN mkToken(G.pointSym);
            END;
      | 19: RETURN mkToken(G.equalSym);
      | 20: RETURN mkToken(G.commaSym);
      | 21: RETURN mkToken(G.lparenSym);
      | 22: RETURN mkToken(G.plusSym);
      | 23: RETURN mkToken(G.rparenSym);
      | 24: RETURN mkToken(G.semicolonSym);
      | 25: IF (ch = "=") THEN state := 41; 
            ELSE RETURN mkToken(G.colonSym);
            END;
      | 26: RETURN mkToken(G.lbrackSym);
      | 27: RETURN mkToken(G.rbrackSym);
      | 28: RETURN mkToken(G.uparrowSym);
      | 29: RETURN mkToken(G.dollarSym);
      | 30: RETURN mkToken(G.hashSym);
      | 31: IF (ch = "=") THEN state := 32; 
            ELSE RETURN mkToken(G.lessSym);
            END;
      | 32: RETURN mkToken(G.lessequalSym);
      | 33: IF (ch = "=") THEN state := 34; 
            ELSE RETURN mkToken(G.greaterSym);
            END;
      | 34: RETURN mkToken(G.greaterequalSym);
      | 35: RETURN mkToken(G.slashSym);
      | 36: RETURN mkToken(G.andSym);
      | 37: RETURN mkToken(G.tildeSym);
      | 38: RETURN mkToken(G.lbraceSym);
      | 39: RETURN mkToken(G.rbraceSym);
      | 40: RETURN mkToken(G.pointpointSym);
      | 41: RETURN mkToken(G.colonequalSym);
      | 42: RETURN mkToken(G.barSym);
      | 43: ch := 0X; DEC(bp); RETURN mkToken(G.EOFSYM);
      ELSE  RETURN mkToken(noSym); (*NextCh already done*)
      END
    END
  END get;

(* ==================================================================== *)

  PROCEDURE SkipAndGetLine(i : INTEGER;		(* indent to skip *)
			 e : INTEGER;		(* end file-pos   *)
		     VAR p : INTEGER;		(* crnt file-pos  *)
		     OUT l : INTEGER;		(* fetched length *)
		     VAR s : ARRAY OF CHAR);	(* output string  *)
  VAR 
    ch : CHAR;
    ix : INTEGER;
    sp : INTEGER;
  BEGIN
    sp := 0;
    ch := charAt(p); INC(p);
   (* skip i positions if possible *)
    WHILE (sp < i) & (ch <= " ") & (p <= e) & (ch # asciiLF) DO
      IF ch = asciiHT THEN INC(sp,8); DEC(sp,sp MOD 8) ELSE INC(sp) END;
      ch := charAt(p); INC(p); 
    END;
    ix := 0;
    WHILE sp > i DO
      s[ix] := " "; INC(ix); DEC(sp);
    END;
    WHILE (p <= e) & (ch # asciiLF) DO
      s[ix] := ch; INC(ix);
      ch := charAt(p); INC(p);
    END;
    s[ix] := 0X; l := ix;
  END SkipAndGetLine;

(* ==================================================================== *)

  PROCEDURE GetString (pos: INTEGER; len: INTEGER; OUT name: ARRAY OF CHAR);
  VAR
    i: INTEGER;
    p: INTEGER;
  BEGIN
    IF len >= LEN(name) THEN len := LEN(name)-1 END;
    p := pos; i := 0;
    WHILE i < len DO
      name[i] := charAt(p); INC(i); INC(p)
    END;
    name[len] := 0X;
  END GetString;

(* ==================================================================== *)

  PROCEDURE charAt (pos: INTEGER): CHAR;
  VAR
    ch : CHAR;
  BEGIN
    IF pos >= inputLen THEN RETURN eof END;
    ch := buf[pos DIV LBlkSize][pos MOD LBlkSize];
    IF ch # eof THEN RETURN ch ELSE RETURN eof END
  END charAt;

(* ==================================================================== *)

  PROCEDURE Reset;
  VAR
    len: INTEGER;
    i, read: INTEGER;
  BEGIN (*assert: src has been opened*)
    i := -1;
    inputLen := 0;
    REPEAT
      INC(i);
     (*
      *  Conserve memory by not deallocating the buffer.
      *  Reuse for later compilation, expanding if necessary.
      *)
      IF buf[i] = NIL THEN NEW(buf[i]) END;
      read := GPTextFiles.readNChars(src, buf[i]^, BlkSize);
      INC(inputLen, read);
    UNTIL read < BlkSize;
    GPTextFiles.CloseFile(src);
    buf[i][read] := eof;
    curLine := 1; lineStart := -2; bp := -1;
    oldEols := 0; apx := 0; errors := 0; warnings := 0;
    spaces := 0; (* # new # *)
    NextCh;
  END Reset;

(* ==================================================================== *)

BEGIN
  start[  0] := 43; start[  1] := 46; start[  2] := 46; start[  3] := 46; 
  start[  4] := 46; start[  5] := 46; start[  6] := 46; start[  7] := 46; 
  start[  8] := 46; start[  9] := 46; start[ 10] := 46; start[ 11] := 46; 
  start[ 12] := 46; start[ 13] := 46; start[ 14] := 46; start[ 15] := 46; 
  start[ 16] := 46; start[ 17] := 46; start[ 18] := 46; start[ 19] := 46; 
  start[ 20] := 46; start[ 21] := 46; start[ 22] := 46; start[ 23] := 46; 
  start[ 24] := 46; start[ 25] := 46; start[ 26] := 46; start[ 27] := 46; 
  start[ 28] := 46; start[ 29] := 46; start[ 30] := 46; start[ 31] := 46; 
  start[ 32] := 46; start[ 33] := 17; start[ 34] :=  9; start[ 35] := 30; 
  start[ 36] := 29; start[ 37] := 46; start[ 38] := 36; start[ 39] := 11; 
  start[ 40] := 21; start[ 41] := 23; start[ 42] := 15; start[ 43] := 22; 
  start[ 44] := 20; start[ 45] := 16; start[ 46] := 18; start[ 47] := 35; 
  start[ 48] := 12; start[ 49] := 12; start[ 50] := 12; start[ 51] := 12; 
  start[ 52] := 12; start[ 53] := 12; start[ 54] := 12; start[ 55] := 12; 
  start[ 56] := 12; start[ 57] := 12; start[ 58] := 25; start[ 59] := 24; 
  start[ 60] := 31; start[ 61] := 19; start[ 62] := 33; start[ 63] := 46; 
  start[ 64] := 46; start[ 65] :=  1; start[ 66] :=  1; start[ 67] :=  1; 
  start[ 68] :=  1; start[ 69] :=  1; start[ 70] :=  1; start[ 71] :=  1; 
  start[ 72] :=  1; start[ 73] :=  1; start[ 74] :=  1; start[ 75] :=  1; 
  start[ 76] :=  1; start[ 77] :=  1; start[ 78] :=  1; start[ 79] :=  1; 
  start[ 80] :=  1; start[ 81] :=  1; start[ 82] :=  1; start[ 83] :=  1; 
  start[ 84] :=  1; start[ 85] :=  1; start[ 86] :=  1; start[ 87] :=  1; 
  start[ 88] :=  1; start[ 89] :=  1; start[ 90] :=  1; start[ 91] := 26; 
  start[ 92] := 46; start[ 93] := 27; start[ 94] := 28;
	    (* ------------------------------------------- *)
	    (* Two special-case characters ... "_" and "`" *)
	    (* ------------------------------------------- *)
		    start[ 95] :=  1; start[ 96] := 44;
	    (* ------------------------------------------- *)
		    start[ 97] :=  1; start[ 98] :=  1; start[ 99] :=  1; 
  start[100] :=  1; start[101] :=  1; start[102] :=  1; start[103] :=  1; 
  start[104] :=  1; start[105] :=  1; start[106] :=  1; start[107] :=  1; 
  start[108] :=  1; start[109] :=  1; start[110] :=  1; start[111] :=  1; 
  start[112] :=  1; start[113] :=  1; start[114] :=  1; start[115] :=  1; 
  start[116] :=  1; start[117] :=  1; start[118] :=  1; start[119] :=  1; 
  start[120] :=  1; start[121] :=  1; start[122] :=  1; start[123] := 38; 
  start[124] := 42; start[125] := 39; start[126] := 37; start[127] := 46; 
  start[128] := 46; start[129] := 46; start[130] := 46; start[131] := 46; 
  start[132] := 46; start[133] := 46; start[134] := 46; start[135] := 46; 
  start[136] := 46; start[137] := 46; start[138] := 46; start[139] := 46; 
  start[140] := 46; start[141] := 46; start[142] := 46; start[143] := 46; 
  start[144] := 46; start[145] := 46; start[146] := 46; start[147] := 46; 
  start[148] := 46; start[149] := 46; start[150] := 46; start[151] := 46; 
  start[152] := 46; start[153] := 46; start[154] := 46; start[155] := 46; 
  start[156] := 46; start[157] := 46; start[158] := 46; start[159] := 46; 
  start[160] := 46; start[161] := 46; start[162] := 46; start[163] := 46; 
  start[164] := 46; start[165] := 46; start[166] := 46; start[167] := 46; 
  start[168] := 46; start[169] := 46; start[170] := 46; start[171] := 46; 
  start[172] := 46; start[173] := 46; start[174] := 46; start[175] := 46; 
  start[176] := 46; start[177] := 46; start[178] := 46; start[179] := 46; 
  start[180] := 46; start[181] := 46; start[182] := 46; start[183] := 46; 
  start[184] := 46; start[185] := 46; start[186] := 46; start[187] := 46; 
  start[188] := 46; start[189] := 46; start[190] := 46; start[191] := 46; 
  start[192] := 46; start[193] := 46; start[194] := 46; start[195] := 46; 
  start[196] := 46; start[197] := 46; start[198] := 46; start[199] := 46; 
  start[200] := 46; start[201] := 46; start[202] := 46; start[203] := 46; 
  start[204] := 46; start[205] := 46; start[206] := 46; start[207] := 46; 
  start[208] := 46; start[209] := 46; start[210] := 46; start[211] := 46; 
  start[212] := 46; start[213] := 46; start[214] := 46; start[215] := 46; 
  start[216] := 46; start[217] := 46; start[218] := 46; start[219] := 46; 
  start[220] := 46; start[221] := 46; start[222] := 46; start[223] := 46; 
  start[224] := 46; start[225] := 46; start[226] := 46; start[227] := 46; 
  start[228] := 46; start[229] := 46; start[230] := 46; start[231] := 46; 
  start[232] := 46; start[233] := 46; start[234] := 46; start[235] := 46; 
  start[236] := 46; start[237] := 46; start[238] := 46; start[239] := 46; 
  start[240] := 46; start[241] := 46; start[242] := 46; start[243] := 46; 
  start[244] := 46; start[245] := 46; start[246] := 46; start[247] := 46; 
  start[248] := 46; start[249] := 46; start[250] := 46; start[251] := 46; 
  start[252] := 46; start[253] := 46; start[254] := 46; start[255] := 46; 
  LBlkSize := BlkSize;
END CPascalS.
