
-- ͻ
--        D E S I G N   E N G I N E R I N G              DS        
--             S O F T W A R E                           ͼ        
--                                                                    
--         Package     Os2.PMer                                       
--                                                                    
--         Author :  Leonid Dulman     1995                           
--                                                                    
--              GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS            
--                                                                    
--                PM  error codes                                     
--                                                                    
-- ͼ

package Os2.PMer is
pragma Preelaborate (PMer);

--  Window Manager error codes

 PMERR_INVALID_HWND                  :constant ErrorId:=16#1001#;
 PMERR_INVALID_HMQ                   :constant ErrorId:=16#1002#;
 PMERR_PARAMETER_OUT_OF_RANGE        :constant ErrorId:=16#1003#;
 PMERR_WINDOW_LOCK_UNDERFLOW         :constant ErrorId:=16#1004#;
 PMERR_WINDOW_LOCK_OVERFLOW          :constant ErrorId:=16#1005#;
 PMERR_BAD_WINDOW_LOCK_COUNT         :constant ErrorId:=16#1006#;
 PMERR_WINDOW_NOT_LOCKED             :constant ErrorId:=16#1007#;
 PMERR_INVALID_SELECTOR              :constant ErrorId:=16#1008#;
 PMERR_CALL_FROM_WRONG_THREAD        :constant ErrorId:=16#1009#;
 PMERR_RESOURCE_NOT_FOUND            :constant ErrorId:=16#100A#;
 PMERR_INVALID_STRING_PARM           :constant ErrorId:=16#100B#;
 PMERR_INVALID_HHEAP                 :constant ErrorId:=16#100C#;
 PMERR_INVALID_HEAP_POINTER          :constant ErrorId:=16#100D#;
 PMERR_INVALID_HEAP_SIZE_PARM        :constant ErrorId:=16#100E#;
 PMERR_INVALID_HEAP_SIZE             :constant ErrorId:=16#100F#;
 PMERR_INVALID_HEAP_SIZE_WORD        :constant ErrorId:=16#1010#;
 PMERR_HEAP_OUT_OF_MEMORY            :constant ErrorId:=16#1011#;
 PMERR_HEAP_MAX_SIZE_REACHED         :constant ErrorId:=16#1012#;
 PMERR_INVALID_HATOMTBL              :constant ErrorId:=16#1013#;
 PMERR_INVALID_ATOM                  :constant ErrorId:=16#1014#;
 PMERR_INVALID_ATOM_NAME             :constant ErrorId:=16#1015#;
 PMERR_INVALID_INTEGER_ATOM          :constant ErrorId:=16#1016#;
 PMERR_ATOM_NAME_NOT_FOUND           :constant ErrorId:=16#1017#;
 PMERR_QUEUE_TOO_LARGE               :constant ErrorId:=16#1018#;
 PMERR_INVALID_FLAG                  :constant ErrorId:=16#1019#;
 PMERR_INVALID_HACCEL                :constant ErrorId:=16#101A#;
 PMERR_INVALID_HPTR                  :constant ErrorId:=16#101B#;
 PMERR_INVALID_HENUM                 :constant ErrorId:=16#101C#;
 PMERR_INVALID_SRC_CODEPAGE          :constant ErrorId:=16#101D#;
 PMERR_INVALID_DST_CODEPAGE          :constant ErrorId:=16#101E#;

      -- These are not real error codes, but just used to access special
      -- error message strings used by WinGetErrorInfo to format an error
      -- message.

 PMERR_UNKNOWN_COMPONENT_ID          :constant ErrorId:=16#101f#;
 PMERR_UNKNOWN_ERROR_CODE            :constant ErrorId:=16#1020#;
 PMERR_SEVERITY_LEVELS               :constant ErrorId:=16#1021#;

      -- 1022 - 1033, 1035,104B -104C used elsewhere
PMERR_INVALID_RESOURCE_FORMAT       :constant ErrorId:=16#1034#;
WINDBG_WINDOW_UNLOCK_WAIT           :constant ErrorId:=16#1035#;
PMERR_NO_MSG_QUEUE                  :constant ErrorId:=16#1036#;
PMERR_WIN_DEBUGMSG                  :constant ErrorId:=16#1037#;
PMERR_QUEUE_FULL                    :constant ErrorId:=16#1038#;
PMERR_LIBRARY_LOAD_FAILED           :constant ErrorId:=16#1039#;
PMERR_PROCEDURE_LOAD_FAILED         :constant ErrorId:=16#103A#;
PMERR_LIBRARY_DELETE_FAILED         :constant ErrorId:=16#103B#;
PMERR_PROCEDURE_DELETE_FAILED       :constant ErrorId:=16#103C#;
PMERR_ARRAY_TOO_LARGE               :constant ErrorId:=16#103D#;
PMERR_ARRAY_TOO_SMALL               :constant ErrorId:=16#103E#;
PMERR_DATATYPE_ENTRY_BAD_INDEX      :constant ErrorId:=16#103F#;
PMERR_DATATYPE_ENTRY_CTL_BAD        :constant ErrorId:=16#1040#;
PMERR_DATATYPE_ENTRY_CTL_MISS       :constant ErrorId:=16#1041#;
PMERR_DATATYPE_ENTRY_INVALID        :constant ErrorId:=16#1042#;
PMERR_DATATYPE_ENTRY_NOT_NUM        :constant ErrorId:=16#1043#;
PMERR_DATATYPE_ENTRY_NOT_OFF        :constant ErrorId:=16#1044#;
PMERR_DATATYPE_INVALID              :constant ErrorId:=16#1045#;
PMERR_DATATYPE_NOT_UNIQUE           :constant ErrorId:=16#1046#;
PMERR_DATATYPE_TOO_LONG             :constant ErrorId:=16#1047#;
PMERR_DATATYPE_TOO_SMALL            :constant ErrorId:=16#1048#;
PMERR_DIRECTION_INVALID             :constant ErrorId:=16#1049#;
PMERR_INVALID_HAB                   :constant ErrorId:=16#104A#;
PMERR_INVALID_HSTRUCT               :constant ErrorId:=16#104D#;
PMERR_LENGTH_TOO_SMALL              :constant ErrorId:=16#104E#;
PMERR_MSGID_TOO_SMALL               :constant ErrorId:=16#104F#;
PMERR_NO_HANDLE_ALLOC               :constant ErrorId:=16#1050#;
PMERR_NOT_IN_A_PM_SESSION           :constant ErrorId:=16#1051#;
PMERR_MSG_QUEUE_ALREADY_EXISTS      :constant ErrorId:=16#1052#;
PMERR_OLD_RESOURCE                  :constant ErrorId:=16#1055#;

--           Window Manager error codes
--           2.) PMSHL error codes

PMERR_INVALID_PIB                :constant ErrorId:=16#1101#;
PMERR_INSUFF_SPACE_TO_ADD        :constant ErrorId:=16#1102#;
PMERR_INVALID_GROUP_HANDLE       :constant ErrorId:=16#1103#;
PMERR_DUPLICATE_TITLE            :constant ErrorId:=16#1104#;
PMERR_INVALID_TITLE              :constant ErrorId:=16#1105#;
PMERR_HANDLE_NOT_IN_GROUP        :constant ErrorId:=16#1107#;
PMERR_INVALID_TARGET_HANDLE      :constant ErrorId:=16#1106#;
PMERR_INVALID_PATH_STATEMENT     :constant ErrorId:=16#1108#;
PMERR_NO_PROGRAM_FOUND           :constant ErrorId:=16#1109#;
PMERR_INVALID_BUFFER_SIZE        :constant ErrorId:=16#110A#;
PMERR_BUFFER_TOO_SMALL           :constant ErrorId:=16#110B#;
PMERR_PL_INITIALISATION_FAIL     :constant ErrorId:=16#110C#;
PMERR_CANT_DESTROY_SYS_GROUP     :constant ErrorId:=16#110D#;
PMERR_INVALID_TYPE_CHANGE        :constant ErrorId:=16#110E#;
PMERR_INVALID_PROGRAM_HANDLE     :constant ErrorId:=16#110F#;
PMERR_NOT_CURRENT_PL_VERSION     :constant ErrorId:=16#1110#;
PMERR_INVALID_CIRCULAR_REF       :constant ErrorId:=16#1111#;
PMERR_MEMORY_ALLOCATION_ERR      :constant ErrorId:=16#1112#;
PMERR_MEMORY_DEALLOCATION_ERR    :constant ErrorId:=16#1113#;
PMERR_TASK_HEADER_TOO_BIG        :constant ErrorId:=16#1114#;
PMERR_INVALID_INI_FILE_HANDLE    :constant ErrorId:=16#1115#;
PMERR_MEMORY_SHARE               :constant ErrorId:=16#1116#;
PMERR_OPEN_QUEUE                 :constant ErrorId:=16#1117#;
PMERR_CREATE_QUEUE               :constant ErrorId:=16#1118#;
PMERR_WRITE_QUEUE                :constant ErrorId:=16#1119#;
PMERR_READ_QUEUE                 :constant ErrorId:=16#111A#;
PMERR_CALL_NOT_EXECUTED          :constant ErrorId:=16#111B#;
PMERR_UNKNOWN_APIPKT             :constant ErrorId:=16#111C#;
PMERR_INITHREAD_EXISTS           :constant ErrorId:=16#111D#;
PMERR_CREATE_THREAD              :constant ErrorId:=16#111E#;
PMERR_NO_HK_PROFILE_INSTALLED    :constant ErrorId:=16#111F#;
PMERR_INVALID_DIRECTORY          :constant ErrorId:=16#1120#;
PMERR_WILDCARD_IN_FILENAME       :constant ErrorId:=16#1121#;
PMERR_FILENAME_BUFFER_FULL       :constant ErrorId:=16#1122#;
PMERR_FILENAME_TOO_LONG          :constant ErrorId:=16#1123#;
PMERR_INI_FILE_IS_SYS_OR_USER    :constant ErrorId:=16#1124#;
PMERR_BROADCAST_PLMSG            :constant ErrorId:=16#1125#;
PMERR_190_INIT_DONE              :constant ErrorId:=16#1126#;
PMERR_HMOD_FOR_PMSHAPI           :constant ErrorId:=16#1127#;
PMERR_SET_HK_PROFILE             :constant ErrorId:=16#1128#;
PMERR_API_NOT_ALLOWED            :constant ErrorId:=16#1129#;
PMERR_INI_STILL_OPEN             :constant ErrorId:=16#112A#;
PMERR_PROGDETAILS_NOT_IN_INI     :constant ErrorId:=16#112B#;
PMERR_PIBSTRUCT_NOT_IN_INI       :constant ErrorId:=16#112C#;
PMERR_INVALID_DISKPROGDETAILS    :constant ErrorId:=16#112D#;
PMERR_PROGDETAILS_READ_FAILURE   :constant ErrorId:=16#112E#;
PMERR_PROGDETAILS_WRITE_FAILURE  :constant ErrorId:=16#112F#;
PMERR_PROGDETAILS_QSIZE_FAILURE  :constant ErrorId:=16#1130#;
PMERR_INVALID_PROGDETAILS        :constant ErrorId:=16#1131#;
PMERR_SHEPROFILEHOOK_NOT_FOUND   :constant ErrorId:=16#1132#;
PMERR_190PLCONVERTED             :constant ErrorId:=16#1133#;
PMERR_FAILED_TO_CONVERT_INI_PL   :constant ErrorId:=16#1134#;
PMERR_PMSHAPI_NOT_INITIALISED    :constant ErrorId:=16#1135#;
PMERR_INVALID_SHELL_API_HOOK_ID  :constant ErrorId:=16#1136#;
PMERR_DOS_ERROR                  :constant ErrorId:=16#1200#;
PMERR_NO_SPACE                   :constant ErrorId:=16#1201#;
PMERR_INVALID_SWITCH_HANDLE      :constant ErrorId:=16#1202#;
PMERR_NO_HANDLE                  :constant ErrorId:=16#1203#;
PMERR_INVALID_PROCESS_ID         :constant ErrorId:=16#1204#;
PMERR_NOT_SHELL                  :constant ErrorId:=16#1205#;
PMERR_INVALID_WINDOW             :constant ErrorId:=16#1206#;
PMERR_INVALID_POST_MSG           :constant ErrorId:=16#1207#;
PMERR_INVALID_PARAMETERS         :constant ErrorId:=16#1208#;
PMERR_INVALID_PROGRAM_TYPE       :constant ErrorId:=16#1209#;
PMERR_NOT_EXTENDED_FOCUS         :constant ErrorId:=16#120A#;
PMERR_INVALID_SESSION_ID         :constant ErrorId:=16#120B#;
PMERR_SMG_INVALID_ICON_FILE      :constant ErrorId:=16#120C#;
PMERR_SMG_ICON_NOT_CREATED       :constant ErrorId:=16#120D#;
PMERR_SHL_DEBUG                  :constant ErrorId:=16#120E#;
PMERR_OPENING_INI_FILE           :constant ErrorId:=16#1301#;
PMERR_INI_FILE_CORRUPT           :constant ErrorId:=16#1302#;
PMERR_INVALID_PARM               :constant ErrorId:=16#1303#;
PMERR_NOT_IN_IDX                 :constant ErrorId:=16#1304#;
PMERR_NO_ENTRIES_IN_GROUP        :constant ErrorId:=16#1305#;
PMERR_INI_WRITE_FAIL             :constant ErrorId:=16#1306#;
PMERR_IDX_FULL                   :constant ErrorId:=16#1307#;
PMERR_INI_PROTECTED              :constant ErrorId:=16#1308#;
PMERR_MEMORY_ALLOC               :constant ErrorId:=16#1309#;
PMERR_INI_INIT_ALREADY_DONE      :constant ErrorId:=16#130A#;
PMERR_INVALID_INTEGER            :constant ErrorId:=16#130B#;
PMERR_INVALID_ASCIIZ             :constant ErrorId:=16#130C#;
PMERR_CAN_NOT_CALL_SPOOLER       :constant ErrorId:=16#130D#;
PMERR_VALIDATION_REJECTED        :constant ErrorId:=16#130D#;
PMERR_WARNING_WINDOW_NOT_KILLED  :constant ErrorId:=16#1401#;
PMERR_ERROR_INVALID_WINDOW       :constant ErrorId:=16#1402#;
PMERR_ALREADY_INITIALIZED        :constant ErrorId:=16#1403#;
PMERR_MSG_PROG_NO_MOU            :constant ErrorId:=16#1405#;
PMERR_MSG_PROG_NON_RECOV         :constant ErrorId:=16#1406#;
PMERR_WINCONV_INVALID_PATH       :constant ErrorId:=16#1407#;
PMERR_PI_NOT_INITIALISED         :constant ErrorId:=16#1408#;
PMERR_PL_NOT_INITIALISED         :constant ErrorId:=16#1409#;
PMERR_NO_TASK_MANAGER            :constant ErrorId:=16#140A#;
PMERR_SAVE_NOT_IN_PROGRESS       :constant ErrorId:=16#140B#;
PMERR_NO_STACK_SPACE             :constant ErrorId:=16#140C#;
PMERR_INVALID_COLR_FIELD         :constant ErrorId:=16#140d#;
PMERR_INVALID_COLR_VALUE         :constant ErrorId:=16#140e#;
PMERR_COLR_WRITE                 :constant ErrorId:=16#140f#;
PMERR_TARGET_FILE_EXISTS         :constant ErrorId:=16#1501#;
PMERR_SOURCE_SAME_AS_TARGET      :constant ErrorId:=16#1502#;
PMERR_SOURCE_FILE_NOT_FOUND      :constant ErrorId:=16#1503#;
PMERR_INVALID_NEW_PATH           :constant ErrorId:=16#1504#;
PMERR_TARGET_FILE_NOT_FOUND      :constant ErrorId:=16#1505#;
PMERR_INVALID_DRIVE_NUMBER       :constant ErrorId:=16#1506#;
PMERR_NAME_TOO_LONG              :constant ErrorId:=16#1507#;
PMERR_NOT_ENOUGH_ROOM_ON_DISK    :constant ErrorId:=16#1508#;
PMERR_NOT_ENOUGH_MEM             :constant ErrorId:=16#1509#;
PMERR_LOG_DRV_DOES_NOT_EXIST     :constant ErrorId:=16#150B#;
PMERR_INVALID_DRIVE              :constant ErrorId:=16#150C#;
PMERR_ACCESS_DENIED              :constant ErrorId:=16#150D#;
PMERR_NO_FIRST_SLASH             :constant ErrorId:=16#150E#;
PMERR_READ_ONLY_FILE             :constant ErrorId:=16#150F#;
PMERR_GROUP_PROTECTED            :constant ErrorId:=16#151F#;
PMERR_INVALID_PROGRAM_CATEGORY   :constant ErrorId:=16#152F#;
PMERR_INVALID_APPL               :constant ErrorId:=16#1530#;
PMERR_CANNOT_START               :constant ErrorId:=16#1531#;
PMERR_STARTED_IN_BACKGROUND      :constant ErrorId:=16#1532#;
PMERR_INVALID_HAPP               :constant ErrorId:=16#1533#;
PMERR_CANNOT_STOP                :constant ErrorId:=16#1534#;

--    * Errors generated by Language Bindings layer.
--    *
--    * (Range :1600 thru 16FF reserved for Bindings)
--         SEVERITY_UNRECOVERABLE
PMERR_INTERNAL_ERROR_1           :constant ErrorId:=16#1601#;
PMERR_INTERNAL_ERROR_2           :constant ErrorId:=16#1602#;
PMERR_INTERNAL_ERROR_3           :constant ErrorId:=16#1603#;
PMERR_INTERNAL_ERROR_4           :constant ErrorId:=16#1604#;
PMERR_INTERNAL_ERROR_5           :constant ErrorId:=16#1605#;
PMERR_INTERNAL_ERROR_6           :constant ErrorId:=16#1606#;
PMERR_INTERNAL_ERROR_7           :constant ErrorId:=16#1607#;
PMERR_INTERNAL_ERROR_8           :constant ErrorId:=16#1608#;
PMERR_INTERNAL_ERROR_9           :constant ErrorId:=16#1609#;
PMERR_INTERNAL_ERROR_10          :constant ErrorId:=16#160A#;
PMERR_INTERNAL_ERROR_11          :constant ErrorId:=16#160B#;
PMERR_INTERNAL_ERROR_12          :constant ErrorId:=16#160C#;
PMERR_INTERNAL_ERROR_13          :constant ErrorId:=16#160D#;
PMERR_INTERNAL_ERROR_14          :constant ErrorId:=16#160E#;
PMERR_INTERNAL_ERROR_15          :constant ErrorId:=16#160F#;
PMERR_INTERNAL_ERROR_16          :constant ErrorId:=16#1610#;
PMERR_INTERNAL_ERROR_17          :constant ErrorId:=16#1611#;
PMERR_INTERNAL_ERROR_18          :constant ErrorId:=16#1612#;
PMERR_INTERNAL_ERROR_19          :constant ErrorId:=16#1613#;
PMERR_INTERNAL_ERROR_20          :constant ErrorId:=16#1614#;
PMERR_INTERNAL_ERROR_21          :constant ErrorId:=16#1615#;
PMERR_INTERNAL_ERROR_22          :constant ErrorId:=16#1616#;
PMERR_INTERNAL_ERROR_23          :constant ErrorId:=16#1617#;
PMERR_INTERNAL_ERROR_24          :constant ErrorId:=16#1618#;
PMERR_INTERNAL_ERROR_25          :constant ErrorId:=16#1619#;
PMERR_INTERNAL_ERROR_26          :constant ErrorId:=16#161A#;
PMERR_INTERNAL_ERROR_27          :constant ErrorId:=16#161B#;
PMERR_INTERNAL_ERROR_28          :constant ErrorId:=16#161C#;
PMERR_INTERNAL_ERROR_29          :constant ErrorId:=16#161D#;

      --** SEVERITY_WARNING **
PMERR_INVALID_FREE_MESSAGE_ID    :constant ErrorId:=16#1630#;

      --** SEVERITY_ERROR **

PMERR_FUNCTION_NOT_SUPPORTED     :constant ErrorId:=16#1641#;
PMERR_INVALID_ARRAY_COUNT        :constant ErrorId:=16#1642#;
PMERR_INVALID_LENGTH             :constant ErrorId:=16#1643#;
PMERR_INVALID_BUNDLE_TYPE        :constant ErrorId:=16#1644#;
PMERR_INVALID_PARAMETER          :constant ErrorId:=16#1645#;
PMERR_INVALID_NUMBER_OF_PARMS    :constant ErrorId:=16#1646#;
PMERR_GREATER_THAN_64K           :constant ErrorId:=16#1647#;
PMERR_INVALID_PARAMETER_TYPE     :constant ErrorId:=16#1648#;
PMERR_NEGATIVE_STRCOND_DIM       :constant ErrorId:=16#1649#;
PMERR_INVALID_NUMBER_OF_TYPES    :constant ErrorId:=16#164A#;
PMERR_INCORRECT_HSTRUCT          :constant ErrorId:=16#164B#;
PMERR_INVALID_ARRAY_SIZE         :constant ErrorId:=16#164C#;
PMERR_INVALID_CONTROL_DATATYPE   :constant ErrorId:=16#164D#;
PMERR_INCOMPLETE_CONTROL_SEQU    :constant ErrorId:=16#164E#;
PMERR_INVALID_DATATYPE           :constant ErrorId:=16#164F#;
PMERR_INCORRECT_DATATYPE         :constant ErrorId:=16#1650#;
PMERR_NOT_SELF_DESCRIBING_DTYP   :constant ErrorId:=16#1651#;
PMERR_INVALID_CTRL_SEQ_INDEX     :constant ErrorId:=16#1652#;
PMERR_INVALID_TYPE_FOR_LENGTH    :constant ErrorId:=16#1653#;
PMERR_INVALID_TYPE_FOR_OFFSET    :constant ErrorId:=16#1654#;
PMERR_INVALID_TYPE_FOR_MPARAM    :constant ErrorId:=16#1655#;
PMERR_INVALID_MESSAGE_ID         :constant ErrorId:=16#1656#;
PMERR_C_LENGTH_TOO_SMALL         :constant ErrorId:=16#1657#;
PMERR_APPL_STRUCTURE_TOO_SMALL   :constant ErrorId:=16#1658#;
PMERR_INVALID_ERRORINFO_HANDLE   :constant ErrorId:=16#1659#;
PMERR_INVALID_CHARACTER_INDEX    :constant ErrorId:=16#165A#;

--    * End of Errors generated by Language Bindings layer.
--    * (Range 16#1600 thru 16#16FF reserved for Bindings)

--           Workplace Shell error codes
--                 PMWP error codes

WPERR_PROTECTED_CLASS            :constant ErrorId:=16#1700#;
WPERR_INVALID_CLASS              :constant ErrorId:=16#1701#;
WPERR_INVALID_SUPERCLASS         :constant ErrorId:=16#1702#;
WPERR_NO_MEMORY                  :constant ErrorId:=16#1703#;
WPERR_SEMAPHORE_ERROR            :constant ErrorId:=16#1704#;
WPERR_BUFFER_TOO_SMALL           :constant ErrorId:=16#1705#;
WPERR_CLSLOADMOD_FAILED          :constant ErrorId:=16#1706#;
WPERR_CLSPROCADDR_FAILED         :constant ErrorId:=16#1707#;
WPERR_OBJWORD_LOCATION           :constant ErrorId:=16#1708#;
WPERR_INVALID_OBJECT             :constant ErrorId:=16#1709#;
WPERR_MEMORY_CLEANUP             :constant ErrorId:=16#170A#;
WPERR_INVALID_MODULE             :constant ErrorId:=16#170B#;
WPERR_INVALID_OLDCLASS           :constant ErrorId:=16#170C#;
WPERR_INVALID_NEWCLASS           :constant ErrorId:=16#170D#;
WPERR_NOT_IMMEDIATE_CHILD        :constant ErrorId:=16#170E#;
WPERR_NOT_WORKPLACE_CLASS        :constant ErrorId:=16#170F#;
WPERR_CANT_REPLACE_METACLS       :constant ErrorId:=16#1710#;
WPERR_INI_FILE_WRITE             :constant ErrorId:=16#1711#;
WPERR_INVALID_FOLDER             :constant ErrorId:=16#1712#;
WPERR_BUFFER_OVERFLOW            :constant ErrorId:=16#1713#;
WPERR_OBJECT_NOT_FOUND           :constant ErrorId:=16#1714#;
WPERR_INVALID_HFIND              :constant ErrorId:=16#1715#;
WPERR_INVALID_COUNT              :constant ErrorId:=16#1716#;
WPERR_INVALID_BUFFER             :constant ErrorId:=16#1717#;
WPERR_ALREADY_EXISTS             :constant ErrorId:=16#1718#;
WPERR_INVALID_FLAGS              :constant ErrorId:=16#1719#;
WPERR_INVALID_OBJECTID           :constant ErrorId:=16#1720#;

--                     GPI error codes
--                AAB error codes for the GPI
PMERR_OK                           :constant ErrorId:=16#0000#;
PMERR_ALREADY_IN_AREA              :constant ErrorId:=16#2001#;
PMERR_ALREADY_IN_ELEMENT           :constant ErrorId:=16#2002#;
PMERR_ALREADY_IN_PATH              :constant ErrorId:=16#2003#;
PMERR_ALREADY_IN_SEG               :constant ErrorId:=16#2004#;
PMERR_AREA_INCOMPLETE              :constant ErrorId:=16#2005#;
PMERR_BASE_ERROR                   :constant ErrorId:=16#2006#;
PMERR_BITBLT_LENGTH_EXCEEDED       :constant ErrorId:=16#2007#;
PMERR_BITMAP_IN_USE                :constant ErrorId:=16#2008#;
PMERR_BITMAP_IS_SELECTED           :constant ErrorId:=16#2009#;
PMERR_BITMAP_NOT_FOUND             :constant ErrorId:=16#200A#;
PMERR_BITMAP_NOT_SELECTED          :constant ErrorId:=16#200B#;
PMERR_BOUNDS_OVERFLOW              :constant ErrorId:=16#200C#;
PMERR_CALLED_SEG_IS_CHAINED        :constant ErrorId:=16#200D#;
PMERR_CALLED_SEG_IS_CURRENT        :constant ErrorId:=16#200E#;
PMERR_CALLED_SEG_NOT_FOUND         :constant ErrorId:=16#200F#;
PMERR_CANNOT_DELETE_ALL_DATA       :constant ErrorId:=16#2010#;
PMERR_CANNOT_REPLACE_ELEMENT_0     :constant ErrorId:=16#2011#;
PMERR_COL_TABLE_NOT_REALIZABLE     :constant ErrorId:=16#2012#;
PMERR_COL_TABLE_NOT_REALIZED       :constant ErrorId:=16#2013#;
PMERR_COORDINATE_OVERFLOW          :constant ErrorId:=16#2014#;
PMERR_CORR_FORMAT_MISMATCH         :constant ErrorId:=16#2015#;
PMERR_DATA_TOO_LONG                :constant ErrorId:=16#2016#;
PMERR_DC_IS_ASSOCIATED             :constant ErrorId:=16#2017#;
PMERR_DESC_STRING_TRUNCATED        :constant ErrorId:=16#2018#;
PMERR_DEVICE_DRIVER_ERROR_1        :constant ErrorId:=16#2019#;
PMERR_DEVICE_DRIVER_ERROR_2        :constant ErrorId:=16#201A#;
PMERR_DEVICE_DRIVER_ERROR_3        :constant ErrorId:=16#201B#;
PMERR_DEVICE_DRIVER_ERROR_4        :constant ErrorId:=16#201C#;
PMERR_DEVICE_DRIVER_ERROR_5        :constant ErrorId:=16#201D#;
PMERR_DEVICE_DRIVER_ERROR_6        :constant ErrorId:=16#201E#;
PMERR_DEVICE_DRIVER_ERROR_7        :constant ErrorId:=16#201F#;
PMERR_DEVICE_DRIVER_ERROR_8        :constant ErrorId:=16#2020#;
PMERR_DEVICE_DRIVER_ERROR_9        :constant ErrorId:=16#2021#;
PMERR_DEVICE_DRIVER_ERROR_10       :constant ErrorId:=16#2022#;
PMERR_DEV_FUNC_NOT_INSTALLED       :constant ErrorId:=16#2023#;
PMERR_DOSOPEN_FAILURE              :constant ErrorId:=16#2024#;
PMERR_DOSREAD_FAILURE              :constant ErrorId:=16#2025#;
PMERR_DRIVER_NOT_FOUND             :constant ErrorId:=16#2026#;
PMERR_DUP_SEG                      :constant ErrorId:=16#2027#;
PMERR_DYNAMIC_SEG_SEQ_ERROR        :constant ErrorId:=16#2028#;
PMERR_DYNAMIC_SEG_ZERO_INV         :constant ErrorId:=16#2029#;
PMERR_ELEMENT_INCOMPLETE           :constant ErrorId:=16#202A#;
PMERR_ESC_CODE_NOT_SUPPORTED       :constant ErrorId:=16#202B#;
PMERR_EXCEEDS_MAX_SEG_LENGTH       :constant ErrorId:=16#202C#;
PMERR_FONT_AND_MODE_MISMATCH       :constant ErrorId:=16#202D#;
PMERR_FONT_FILE_NOT_LOADED         :constant ErrorId:=16#202E#;
PMERR_FONT_NOT_LOADED              :constant ErrorId:=16#202F#;
PMERR_FONT_TOO_BIG                 :constant ErrorId:=16#2030#;
PMERR_HARDWARE_INIT_FAILURE        :constant ErrorId:=16#2031#;
PMERR_HBITMAP_BUSY                 :constant ErrorId:=16#2032#;
PMERR_HDC_BUSY                     :constant ErrorId:=16#2033#;
PMERR_HRGN_BUSY                    :constant ErrorId:=16#2034#;
PMERR_HUGE_FONTS_NOT_SUPPORTED     :constant ErrorId:=16#2035#;
PMERR_ID_HAS_NO_BITMAP             :constant ErrorId:=16#2036#;
PMERR_IMAGE_INCOMPLETE             :constant ErrorId:=16#2037#;
PMERR_INCOMPAT_COLOR_FORMAT        :constant ErrorId:=16#2038#;
PMERR_INCOMPAT_COLOR_OPTIONS       :constant ErrorId:=16#2039#;
PMERR_INCOMPATIBLE_BITMAP          :constant ErrorId:=16#203A#;
PMERR_INCOMPATIBLE_METAFILE        :constant ErrorId:=16#203B#;
PMERR_INCORRECT_DC_TYPE            :constant ErrorId:=16#203C#;
PMERR_INSUFFICIENT_DISK_SPACE      :constant ErrorId:=16#203D#;
PMERR_INSUFFICIENT_MEMORY          :constant ErrorId:=16#203E#;
PMERR_INV_ANGLE_PARM               :constant ErrorId:=16#203F#;
PMERR_INV_ARC_CONTROL              :constant ErrorId:=16#2040#;
PMERR_INV_AREA_CONTROL             :constant ErrorId:=16#2041#;
PMERR_INV_ARC_POINTS               :constant ErrorId:=16#2042#;
PMERR_INV_ATTR_MODE                :constant ErrorId:=16#2043#;
PMERR_INV_BACKGROUND_COL_ATTR      :constant ErrorId:=16#2044#;
PMERR_INV_BACKGROUND_MIX_ATTR      :constant ErrorId:=16#2045#;
PMERR_INV_BITBLT_MIX               :constant ErrorId:=16#2046#;
PMERR_INV_BITBLT_STYLE             :constant ErrorId:=16#2047#;
PMERR_INV_BITMAP_DIMENSION         :constant ErrorId:=16#2048#;
PMERR_INV_BOX_CONTROL              :constant ErrorId:=16#2049#;
PMERR_INV_BOX_ROUNDING_PARM        :constant ErrorId:=16#204A#;
PMERR_INV_CHAR_ANGLE_ATTR          :constant ErrorId:=16#204B#;
PMERR_INV_CHAR_DIRECTION_ATTR      :constant ErrorId:=16#204C#;
PMERR_INV_CHAR_MODE_ATTR           :constant ErrorId:=16#204D#;
PMERR_INV_CHAR_POS_OPTIONS         :constant ErrorId:=16#204E#;
PMERR_INV_CHAR_SET_ATTR            :constant ErrorId:=16#204F#;
PMERR_INV_CHAR_SHEAR_ATTR          :constant ErrorId:=16#2050#;
PMERR_INV_CLIP_PATH_OPTIONS        :constant ErrorId:=16#2051#;
PMERR_INV_CODEPAGE                 :constant ErrorId:=16#2052#;
PMERR_INV_COLOR_ATTR               :constant ErrorId:=16#2053#;
PMERR_INV_COLOR_DATA               :constant ErrorId:=16#2054#;
PMERR_INV_COLOR_FORMAT             :constant ErrorId:=16#2055#;
PMERR_INV_COLOR_INDEX              :constant ErrorId:=16#2056#;
PMERR_INV_COLOR_OPTIONS            :constant ErrorId:=16#2057#;
PMERR_INV_COLOR_START_INDEX        :constant ErrorId:=16#2058#;
PMERR_INV_COORD_OFFSET             :constant ErrorId:=16#2059#;
PMERR_INV_COORD_SPACE              :constant ErrorId:=16#205A#;
PMERR_INV_COORDINATE               :constant ErrorId:=16#205B#;
PMERR_INV_CORRELATE_DEPTH          :constant ErrorId:=16#205C#;
PMERR_INV_CORRELATE_TYPE           :constant ErrorId:=16#205D#;
PMERR_INV_CURSOR_BITMAP            :constant ErrorId:=16#205E#;
PMERR_INV_DC_DATA                  :constant ErrorId:=16#205F#;
PMERR_INV_DC_TYPE                  :constant ErrorId:=16#2060#;
PMERR_INV_DEVICE_NAME              :constant ErrorId:=16#2061#;
PMERR_INV_DEV_MODES_OPTIONS        :constant ErrorId:=16#2062#;
PMERR_INV_DRAW_CONTROL             :constant ErrorId:=16#2063#;
PMERR_INV_DRAW_VALUE               :constant ErrorId:=16#2064#;
PMERR_INV_DRAWING_MODE             :constant ErrorId:=16#2065#;
PMERR_INV_DRIVER_DATA              :constant ErrorId:=16#2066#;
PMERR_INV_DRIVER_NAME              :constant ErrorId:=16#2067#;
PMERR_INV_DRAW_BORDER_OPTION       :constant ErrorId:=16#2068#;
PMERR_INV_EDIT_MODE                :constant ErrorId:=16#2069#;
PMERR_INV_ELEMENT_OFFSET           :constant ErrorId:=16#206A#;
PMERR_INV_ELEMENT_POINTER          :constant ErrorId:=16#206B#;
PMERR_INV_END_PATH_OPTIONS         :constant ErrorId:=16#206C#;
PMERR_INV_ESC_CODE                 :constant ErrorId:=16#206D#;
PMERR_INV_ESCAPE_DATA              :constant ErrorId:=16#206E#;
PMERR_INV_EXTENDED_LCID            :constant ErrorId:=16#206F#;
PMERR_INV_FILL_PATH_OPTIONS        :constant ErrorId:=16#2070#;
PMERR_INV_FIRST_CHAR               :constant ErrorId:=16#2071#;
PMERR_INV_FONT_ATTRS               :constant ErrorId:=16#2072#;
PMERR_INV_FONT_FILE_DATA           :constant ErrorId:=16#2073#;
PMERR_INV_FOR_THIS_DC_TYPE         :constant ErrorId:=16#2074#;
PMERR_INV_FORMAT_CONTROL           :constant ErrorId:=16#2075#;
PMERR_INV_FORMS_CODE               :constant ErrorId:=16#2076#;
PMERR_INV_FONTDEF                  :constant ErrorId:=16#2077#;
PMERR_INV_GEOM_LINE_WIDTH_ATTR     :constant ErrorId:=16#2078#;
PMERR_INV_GETDATA_CONTROL          :constant ErrorId:=16#2079#;
PMERR_INV_GRAPHICS_FIELD           :constant ErrorId:=16#207A#;
PMERR_INV_HBITMAP                  :constant ErrorId:=16#207B#;
PMERR_INV_HDC                      :constant ErrorId:=16#207C#;
PMERR_INV_HJOURNAL                 :constant ErrorId:=16#207D#;
PMERR_INV_HMF                      :constant ErrorId:=16#207E#;
PMERR_INV_HPS                      :constant ErrorId:=16#207F#;
PMERR_INV_HRGN                     :constant ErrorId:=16#2080#;
PMERR_INV_ID                       :constant ErrorId:=16#2081#;
PMERR_INV_IMAGE_DATA_LENGTH        :constant ErrorId:=16#2082#;
PMERR_INV_IMAGE_DIMENSION          :constant ErrorId:=16#2083#;
PMERR_INV_IMAGE_FORMAT             :constant ErrorId:=16#2084#;
PMERR_INV_IN_AREA                  :constant ErrorId:=16#2085#;
PMERR_INV_IN_CALLED_SEG            :constant ErrorId:=16#2086#;
PMERR_INV_IN_CURRENT_EDIT_MODE     :constant ErrorId:=16#2087#;
PMERR_INV_IN_DRAW_MODE             :constant ErrorId:=16#2088#;
PMERR_INV_IN_ELEMENT               :constant ErrorId:=16#2089#;
PMERR_INV_IN_IMAGE                 :constant ErrorId:=16#208A#;
PMERR_INV_IN_PATH                  :constant ErrorId:=16#208B#;
PMERR_INV_IN_RETAIN_MODE           :constant ErrorId:=16#208C#;
PMERR_INV_IN_SEG                   :constant ErrorId:=16#208D#;
PMERR_INV_IN_VECTOR_SYMBOL         :constant ErrorId:=16#208E#;
PMERR_INV_INFO_TABLE               :constant ErrorId:=16#208F#;
PMERR_INV_JOURNAL_OPTION           :constant ErrorId:=16#2090#;
PMERR_INV_KERNING_FLAGS            :constant ErrorId:=16#2091#;
PMERR_INV_LENGTH_OR_COUNT          :constant ErrorId:=16#2092#;
PMERR_INV_LINE_END_ATTR            :constant ErrorId:=16#2093#;
PMERR_INV_LINE_JOIN_ATTR           :constant ErrorId:=16#2094#;
PMERR_INV_LINE_TYPE_ATTR           :constant ErrorId:=16#2095#;
PMERR_INV_LINE_WIDTH_ATTR          :constant ErrorId:=16#2096#;
PMERR_INV_LOGICAL_ADDRESS          :constant ErrorId:=16#2097#;
PMERR_INV_MARKER_BOX_ATTR          :constant ErrorId:=16#2098#;
PMERR_INV_MARKER_SET_ATTR          :constant ErrorId:=16#2099#;
PMERR_INV_MARKER_SYMBOL_ATTR       :constant ErrorId:=16#209A#;
PMERR_INV_MATRIX_ELEMENT           :constant ErrorId:=16#209B#;
PMERR_INV_MAX_HITS                 :constant ErrorId:=16#209C#;
PMERR_INV_METAFILE                 :constant ErrorId:=16#209D#;
PMERR_INV_METAFILE_LENGTH          :constant ErrorId:=16#209E#;
PMERR_INV_METAFILE_OFFSET          :constant ErrorId:=16#209F#;
PMERR_INV_MICROPS_DRAW_CONTROL     :constant ErrorId:=16#20A0#;
PMERR_INV_MICROPS_FUNCTION         :constant ErrorId:=16#20A1#;
PMERR_INV_MICROPS_ORDER            :constant ErrorId:=16#20A2#;
PMERR_INV_MIX_ATTR                 :constant ErrorId:=16#20A3#;
PMERR_INV_MODE_FOR_OPEN_DYN        :constant ErrorId:=16#20A4#;
PMERR_INV_MODE_FOR_REOPEN_SEG      :constant ErrorId:=16#20A5#;
PMERR_INV_MODIFY_PATH_MODE         :constant ErrorId:=16#20A6#;
PMERR_INV_MULTIPLIER               :constant ErrorId:=16#20A7#;
PMERR_INV_NESTED_FIGURES           :constant ErrorId:=16#20A8#;
PMERR_INV_OR_INCOMPAT_OPTIONS      :constant ErrorId:=16#20A9#;
PMERR_INV_ORDER_LENGTH             :constant ErrorId:=16#20AA#;
PMERR_INV_ORDERING_PARM            :constant ErrorId:=16#20AB#;
PMERR_INV_OUTSIDE_DRAW_MODE        :constant ErrorId:=16#20AC#;
PMERR_INV_PAGE_VIEWPORT            :constant ErrorId:=16#20AD#;
PMERR_INV_PATH_ID                  :constant ErrorId:=16#20AE#;
PMERR_INV_PATH_MODE                :constant ErrorId:=16#20AF#;
PMERR_INV_PATTERN_ATTR             :constant ErrorId:=16#20B0#;
PMERR_INV_PATTERN_REF_PT_ATTR      :constant ErrorId:=16#20B1#;
PMERR_INV_PATTERN_SET_ATTR         :constant ErrorId:=16#20B2#;
PMERR_INV_PATTERN_SET_FONT         :constant ErrorId:=16#20B3#;
PMERR_INV_PICK_APERTURE_OPTION     :constant ErrorId:=16#20B4#;
PMERR_INV_PICK_APERTURE_POSN       :constant ErrorId:=16#20B5#;
PMERR_INV_PICK_APERTURE_SIZE       :constant ErrorId:=16#20B6#;
PMERR_INV_PICK_NUMBER              :constant ErrorId:=16#20B7#;
PMERR_INV_PLAY_METAFILE_OPTION     :constant ErrorId:=16#20B8#;
PMERR_INV_PRIMITIVE_TYPE           :constant ErrorId:=16#20B9#;
PMERR_INV_PS_SIZE                  :constant ErrorId:=16#20BA#;
PMERR_INV_PUTDATA_FORMAT           :constant ErrorId:=16#20BB#;
PMERR_INV_QUERY_ELEMENT_NO         :constant ErrorId:=16#20BC#;
PMERR_INV_RECT                     :constant ErrorId:=16#20BD#;
PMERR_INV_REGION_CONTROL           :constant ErrorId:=16#20BE#;
PMERR_INV_REGION_MIX_MODE          :constant ErrorId:=16#20BF#;
PMERR_INV_REPLACE_MODE_FUNC        :constant ErrorId:=16#20C0#;
PMERR_INV_RESERVED_FIELD           :constant ErrorId:=16#20C1#;
PMERR_INV_RESET_OPTIONS            :constant ErrorId:=16#20C2#;
PMERR_INV_RGBCOLOR                 :constant ErrorId:=16#20C3#;
PMERR_INV_SCAN_START               :constant ErrorId:=16#20C4#;
PMERR_INV_SEG_ATTR                 :constant ErrorId:=16#20C5#;
PMERR_INV_SEG_ATTR_VALUE           :constant ErrorId:=16#20C6#;
PMERR_INV_SEG_CH_LENGTH            :constant ErrorId:=16#20C7#;
PMERR_INV_SEG_NAME                 :constant ErrorId:=16#20C8#;
PMERR_INV_SEG_OFFSET               :constant ErrorId:=16#20C9#;
PMERR_INV_SETID                    :constant ErrorId:=16#20CA#;
PMERR_INV_SETID_TYPE               :constant ErrorId:=16#20CB#;
PMERR_INV_SET_VIEWPORT_OPTION      :constant ErrorId:=16#20CC#;
PMERR_INV_SHARPNESS_PARM           :constant ErrorId:=16#20CD#;
PMERR_INV_SOURCE_OFFSET            :constant ErrorId:=16#20CE#;
PMERR_INV_STOP_DRAW_VALUE          :constant ErrorId:=16#20CF#;
PMERR_INV_TRANSFORM_TYPE           :constant ErrorId:=16#20D0#;
PMERR_INV_USAGE_PARM               :constant ErrorId:=16#20D1#;
PMERR_INV_VIEWING_LIMITS           :constant ErrorId:=16#20D2#;
PMERR_JFILE_BUSY                   :constant ErrorId:=16#20D3#;
PMERR_JNL_FUNC_DATA_TOO_LONG       :constant ErrorId:=16#20D4#;
PMERR_KERNING_NOT_SUPPORTED        :constant ErrorId:=16#20D5#;
PMERR_LABEL_NOT_FOUND              :constant ErrorId:=16#20D6#;
PMERR_MATRIX_OVERFLOW              :constant ErrorId:=16#20D7#;
PMERR_METAFILE_INTERNAL_ERROR      :constant ErrorId:=16#20D8#;
PMERR_METAFILE_IN_USE              :constant ErrorId:=16#20D9#;
PMERR_METAFILE_LIMIT_EXCEEDED      :constant ErrorId:=16#20DA#;
PMERR_NAME_STACK_FULL              :constant ErrorId:=16#20DB#;
PMERR_NOT_CREATED_BY_DEVOPENDC     :constant ErrorId:=16#20DC#;
PMERR_NOT_IN_AREA                  :constant ErrorId:=16#20DD#;
PMERR_NOT_IN_DRAW_MODE             :constant ErrorId:=16#20DE#;
PMERR_NOT_IN_ELEMENT               :constant ErrorId:=16#20DF#;
PMERR_NOT_IN_IMAGE                 :constant ErrorId:=16#20E0#;
PMERR_NOT_IN_PATH                  :constant ErrorId:=16#20E1#;
PMERR_NOT_IN_RETAIN_MODE           :constant ErrorId:=16#20E2#;
PMERR_NOT_IN_SEG                   :constant ErrorId:=16#20E3#;
PMERR_NO_BITMAP_SELECTED           :constant ErrorId:=16#20E4#;
PMERR_NO_CURRENT_ELEMENT           :constant ErrorId:=16#20E5#;
PMERR_NO_CURRENT_SEG               :constant ErrorId:=16#20E6#;
PMERR_NO_METAFILE_RECORD_HANDLE    :constant ErrorId:=16#20E7#;
PMERR_ORDER_TOO_BIG                :constant ErrorId:=16#20E8#;
PMERR_OTHER_SET_ID_REFS            :constant ErrorId:=16#20E9#;
PMERR_OVERRAN_SEG                  :constant ErrorId:=16#20EA#;
PMERR_OWN_SET_ID_REFS              :constant ErrorId:=16#20EB#;
PMERR_PATH_INCOMPLETE              :constant ErrorId:=16#20EC#;
PMERR_PATH_LIMIT_EXCEEDED          :constant ErrorId:=16#20ED#;
PMERR_PATH_UNKNOWN                 :constant ErrorId:=16#20EE#;
PMERR_PEL_IS_CLIPPED               :constant ErrorId:=16#20EF#;
PMERR_PEL_NOT_AVAILABLE            :constant ErrorId:=16#20F0#;
PMERR_PRIMITIVE_STACK_EMPTY        :constant ErrorId:=16#20F1#;
PMERR_PROLOG_ERROR                 :constant ErrorId:=16#20F2#;
PMERR_PROLOG_SEG_ATTR_NOT_SET      :constant ErrorId:=16#20F3#;
PMERR_PS_BUSY                      :constant ErrorId:=16#20F4#;
PMERR_PS_IS_ASSOCIATED             :constant ErrorId:=16#20F5#;
PMERR_RAM_JNL_FILE_TOO_SMALL       :constant ErrorId:=16#20F6#;
PMERR_REALIZE_NOT_SUPPORTED        :constant ErrorId:=16#20F7#;
PMERR_REGION_IS_CLIP_REGION        :constant ErrorId:=16#20F8#;
PMERR_RESOURCE_DEPLETION           :constant ErrorId:=16#20F9#;
PMERR_SEG_AND_REFSEG_ARE_SAME      :constant ErrorId:=16#20FA#;
PMERR_SEG_CALL_RECURSIVE           :constant ErrorId:=16#20FB#;
PMERR_SEG_CALL_STACK_EMPTY         :constant ErrorId:=16#20FC#;
PMERR_SEG_CALL_STACK_FULL          :constant ErrorId:=16#20FD#;
PMERR_SEG_IS_CURRENT               :constant ErrorId:=16#20FE#;
PMERR_SEG_NOT_CHAINED              :constant ErrorId:=16#20FF#;
PMERR_SEG_NOT_FOUND                :constant ErrorId:=16#2100#;
PMERR_SEG_STORE_LIMIT_EXCEEDED     :constant ErrorId:=16#2101#;
PMERR_SETID_IN_USE                 :constant ErrorId:=16#2102#;
PMERR_SETID_NOT_FOUND              :constant ErrorId:=16#2103#;
PMERR_STARTDOC_NOT_ISSUED          :constant ErrorId:=16#2104#;
PMERR_STOP_DRAW_OCCURRED           :constant ErrorId:=16#2105#;
PMERR_TOO_MANY_METAFILES_IN_USE    :constant ErrorId:=16#2106#;
PMERR_TRUNCATED_ORDER              :constant ErrorId:=16#2107#;
PMERR_UNCHAINED_SEG_ZERO_INV       :constant ErrorId:=16#2108#;
PMERR_UNSUPPORTED_ATTR             :constant ErrorId:=16#2109#;
PMERR_UNSUPPORTED_ATTR_VALUE       :constant ErrorId:=16#210A#;
PMERR_ENDDOC_NOT_ISSUED            :constant ErrorId:=16#210B#;
PMERR_PS_NOT_ASSOCIATED            :constant ErrorId:=16#210C#;
PMERR_INV_FLOOD_FILL_OPTIONS       :constant ErrorId:=16#210D#;
PMERR_INV_FACENAME                 :constant ErrorId:=16#210E#;
PMERR_PALETTE_SELECTED             :constant ErrorId:=16#210F#;
PMERR_NO_PALETTE_SELECTED          :constant ErrorId:=16#2110#;
PMERR_INV_HPAL                     :constant ErrorId:=16#2111#;
PMERR_PALETTE_BUSY                 :constant ErrorId:=16#2112#;
PMERR_START_POINT_CLIPPED          :constant ErrorId:=16#2113#;
PMERR_NO_FILL                      :constant ErrorId:=16#2114#;
PMERR_INV_FACENAMEDESC             :constant ErrorId:=16#2115#;
PMERR_INV_BITMAP_DATA              :constant ErrorId:=16#2116#;
PMERR_INV_CHAR_ALIGN_ATTR          :constant ErrorId:=16#2117#;
PMERR_INV_HFONT                    :constant ErrorId:=16#2118#;
PMERR_HFONT_IS_SELECTED            :constant ErrorId:=16#2119#;
PMERR_DRVR_NOT_SUPPORTED           :constant ErrorId:=16#2120#;

--                          Device Manager error codes
--                                  None yet

--                             Spooler error codes

PMERR_SPL_DRIVER_ERROR             :constant ErrorId:=16#4001#;
PMERR_SPL_DEVICE_ERROR             :constant ErrorId:=16#4002#;
PMERR_SPL_DEVICE_NOT_INSTALLED     :constant ErrorId:=16#4003#;
PMERR_SPL_QUEUE_ERROR              :constant ErrorId:=16#4004#;
PMERR_SPL_INV_HSPL                 :constant ErrorId:=16#4005#;
PMERR_SPL_NO_DISK_SPACE            :constant ErrorId:=16#4006#;
PMERR_SPL_NO_MEMORY                :constant ErrorId:=16#4007#;
PMERR_SPL_PRINT_ABORT              :constant ErrorId:=16#4008#;
PMERR_SPL_SPOOLER_NOT_INSTALLED    :constant ErrorId:=16#4009#;
PMERR_SPL_INV_FORMS_CODE           :constant ErrorId:=16#400A#;
PMERR_SPL_INV_PRIORITY             :constant ErrorId:=16#400B#;
PMERR_SPL_NO_FREE_JOB_ID           :constant ErrorId:=16#400C#;
PMERR_SPL_NO_DATA                  :constant ErrorId:=16#400D#;
PMERR_SPL_INV_TOKEN                :constant ErrorId:=16#400E#;
PMERR_SPL_INV_DATATYPE             :constant ErrorId:=16#400F#;
PMERR_SPL_PROCESSOR_ERROR          :constant ErrorId:=16#4010#;
PMERR_SPL_INV_JOB_ID               :constant ErrorId:=16#4011#;
PMERR_SPL_JOB_NOT_PRINTING         :constant ErrorId:=16#4012#;
PMERR_SPL_JOB_PRINTING             :constant ErrorId:=16#4013#;
PMERR_SPL_QUEUE_ALREADY_EXISTS     :constant ErrorId:=16#4014#;
PMERR_SPL_INV_QUEUE_NAME           :constant ErrorId:=16#4015#;
PMERR_SPL_QUEUE_NOT_EMPTY          :constant ErrorId:=16#4016#;
PMERR_SPL_DEVICE_ALREADY_EXISTS    :constant ErrorId:=16#4017#;
PMERR_SPL_DEVICE_LIMIT_REACHED     :constant ErrorId:=16#4018#;
PMERR_SPL_STATUS_STRING_TRUNC      :constant ErrorId:=16#4019#;
PMERR_SPL_INV_LENGTH_OR_COUNT      :constant ErrorId:=16#401A#;
PMERR_SPL_FILE_NOT_FOUND           :constant ErrorId:=16#401B#;
PMERR_SPL_CANNOT_OPEN_FILE         :constant ErrorId:=16#401C#;
PMERR_SPL_DRIVER_NOT_INSTALLED     :constant ErrorId:=16#401D#;
PMERR_SPL_INV_PROCESSOR_DATTYPE    :constant ErrorId:=16#401E#;
PMERR_SPL_INV_DRIVER_DATATYPE      :constant ErrorId:=16#401F#;
PMERR_SPL_PROCESSOR_NOT_INST       :constant ErrorId:=16#4020#;
PMERR_SPL_NO_SUCH_LOG_ADDRESS      :constant ErrorId:=16#4021#;
PMERR_SPL_PRINTER_NOT_FOUND        :constant ErrorId:=16#4022#;
PMERR_SPL_DD_NOT_FOUND             :constant ErrorId:=16#4023#;
PMERR_SPL_QUEUE_NOT_FOUND          :constant ErrorId:=16#4024#;
PMERR_SPL_MANY_QUEUES_ASSOC        :constant ErrorId:=16#4025#;
PMERR_SPL_NO_QUEUES_ASSOCIATED     :constant ErrorId:=16#4026#;
PMERR_SPL_INI_FILE_ERROR           :constant ErrorId:=16#4027#;
PMERR_SPL_NO_DEFAULT_QUEUE         :constant ErrorId:=16#4028#;
PMERR_SPL_NO_CURRENT_FORMS_CODE    :constant ErrorId:=16#4029#;
PMERR_SPL_NOT_AUTHORISED           :constant ErrorId:=16#402A#;
PMERR_SPL_TEMP_NETWORK_ERROR       :constant ErrorId:=16#402B#;
PMERR_SPL_HARD_NETWORK_ERROR       :constant ErrorId:=16#402C#;
PMERR_DEL_NOT_ALLOWED              :constant ErrorId:=16#402D#;
PMERR_CANNOT_DEL_QP_REF            :constant ErrorId:=16#402E#;
PMERR_CANNOT_DEL_QNAME_REF         :constant ErrorId:=16#402F#;
PMERR_CANNOT_DEL_PRINTER_DD_REF    :constant ErrorId:=16#4030#;
PMERR_CANNOT_DEL_PRN_NAME_REF      :constant ErrorId:=16#4031#;
PMERR_CANNOT_DEL_PRN_ADDR_REF      :constant ErrorId:=16#4032#;
PMERR_SPOOLER_QP_NOT_DEFINED       :constant ErrorId:=16#4033#;
PMERR_PRN_NAME_NOT_DEFINED         :constant ErrorId:=16#4034#;
PMERR_PRN_ADDR_NOT_DEFINED         :constant ErrorId:=16#4035#;
PMERR_PRINTER_DD_NOT_DEFINED       :constant ErrorId:=16#4036#;
PMERR_PRINTER_QUEUE_NOT_DEFINED    :constant ErrorId:=16#4037#;
PMERR_PRN_ADDR_IN_USE              :constant ErrorId:=16#4038#;
PMERR_SPL_TOO_MANY_OPEN_FILES      :constant ErrorId:=16#4039#;
PMERR_SPL_CP_NOT_REQD              :constant ErrorId:=16#403A#;
PMERR_UNABLE_TO_CLOSE_DEVICE       :constant ErrorId:=16#4040#;

SPLERR_BASE                      :constant ErrorId:=0; -- Maybe no !!!
PMERR_SPL_ERROR_1                :constant ErrorId:=SPLERR_BASE + 16#4001#;
PMERR_SPL_ERROR_2                :constant ErrorId:=SPLERR_BASE + 16#4002#;
PMERR_SPL_ERROR_3                :constant ErrorId:=SPLERR_BASE + 16#4003#;
PMERR_SPL_ERROR_4                :constant ErrorId:=SPLERR_BASE + 16#4004#;
PMERR_SPL_ERROR_5                :constant ErrorId:=SPLERR_BASE + 16#4005#;
PMERR_SPL_ERROR_6                :constant ErrorId:=SPLERR_BASE + 16#4006#;
PMERR_SPL_ERROR_7                :constant ErrorId:=SPLERR_BASE + 16#4007#;
PMERR_SPL_ERROR_8                :constant ErrorId:=SPLERR_BASE + 16#4008#;
PMERR_SPL_ERROR_9                :constant ErrorId:=SPLERR_BASE + 16#4009#;
PMERR_SPL_ERROR_10               :constant ErrorId:=SPLERR_BASE + 16#4010#;
PMERR_SPL_ERROR_11               :constant ErrorId:=SPLERR_BASE + 16#4011#;
PMERR_SPL_ERROR_12               :constant ErrorId:=SPLERR_BASE + 16#4012#;
PMERR_SPL_ERROR_13               :constant ErrorId:=SPLERR_BASE + 16#4013#;
PMERR_SPL_ERROR_14               :constant ErrorId:=SPLERR_BASE + 16#4014#;
PMERR_SPL_ERROR_15               :constant ErrorId:=SPLERR_BASE + 16#4015#;
PMERR_SPL_ERROR_16               :constant ErrorId:=SPLERR_BASE + 16#4016#;
PMERR_SPL_ERROR_17               :constant ErrorId:=SPLERR_BASE + 16#4017#;
PMERR_SPL_ERROR_18               :constant ErrorId:=SPLERR_BASE + 16#4018#;
PMERR_SPL_ERROR_19               :constant ErrorId:=SPLERR_BASE + 16#4019#;
PMERR_SPL_ERROR_20               :constant ErrorId:=SPLERR_BASE + 16#4020#;
PMERR_SPL_ERROR_21               :constant ErrorId:=SPLERR_BASE + 16#4021#;
PMERR_SPL_ERROR_22               :constant ErrorId:=SPLERR_BASE + 16#4022#;
PMERR_SPL_ERROR_23               :constant ErrorId:=SPLERR_BASE + 16#4023#;
PMERR_SPL_ERROR_24               :constant ErrorId:=SPLERR_BASE + 16#4024#;
PMERR_SPL_ERROR_25               :constant ErrorId:=SPLERR_BASE + 16#4025#;
PMERR_SPL_ERROR_26               :constant ErrorId:=SPLERR_BASE + 16#4026#;
PMERR_SPL_ERROR_27               :constant ErrorId:=SPLERR_BASE + 16#4027#;
PMERR_SPL_ERROR_28               :constant ErrorId:=SPLERR_BASE + 16#4028#;
PMERR_SPL_ERROR_29               :constant ErrorId:=SPLERR_BASE + 16#4029#;
PMERR_SPL_ERROR_30               :constant ErrorId:=SPLERR_BASE + 16#4030#;
PMERR_SPL_ERROR_31               :constant ErrorId:=SPLERR_BASE + 16#4031#;
PMERR_SPL_ERROR_32               :constant ErrorId:=SPLERR_BASE + 16#4032#;
PMERR_SPL_ERROR_33               :constant ErrorId:=SPLERR_BASE + 16#4033#;
PMERR_SPL_ERROR_34               :constant ErrorId:=SPLERR_BASE + 16#4034#;
PMERR_SPL_ERROR_35               :constant ErrorId:=SPLERR_BASE + 16#4035#;
PMERR_SPL_ERROR_36               :constant ErrorId:=SPLERR_BASE + 16#4036#;
PMERR_SPL_ERROR_37               :constant ErrorId:=SPLERR_BASE + 16#4037#;
PMERR_SPL_ERROR_38               :constant ErrorId:=SPLERR_BASE + 16#4038#;
PMERR_SPL_ERROR_39               :constant ErrorId:=SPLERR_BASE + 16#4039#;
PMERR_SPL_ERROR_40               :constant ErrorId:=SPLERR_BASE + 16#4040#;
PMERR_SPLMSGBOX_INFO_CAPTION     :constant ErrorId:=SPLERR_BASE + 16#4041#;
PMERR_SPLMSGBOX_WARNING_CAPTION  :constant ErrorId:=SPLERR_BASE + 16#4042#;
PMERR_SPLMSGBOX_ERROR_CAPTION    :constant ErrorId:=SPLERR_BASE + 16#4043#;
PMERR_SPLMSGBOX_SEVERE_CAPTION   :constant ErrorId:=SPLERR_BASE + 16#4044#;
PMERR_SPLMSGBOX_JOB_DETAILS      :constant ErrorId:=SPLERR_BASE + 16#4045#;
PMERR_SPLMSGBOX_ERROR_ACTION     :constant ErrorId:=SPLERR_BASE + 16#4046#;
PMERR_SPLMSGBOX_SEVERE_ACTION    :constant ErrorId:=SPLERR_BASE + 16#4047#;
PMERR_SPLMSGBOX_BIT_0_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4048#;
PMERR_SPLMSGBOX_BIT_1_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4049#;
PMERR_SPLMSGBOX_BIT_2_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4050#;
PMERR_SPLMSGBOX_BIT_3_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4051#;
PMERR_SPLMSGBOX_BIT_4_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4052#;
PMERR_SPLMSGBOX_BIT_5_TEXT       :constant ErrorId:=SPLERR_BASE + 16#4053#;
PMERR_SPLMSGBOX_BIT_15_TEXT      :constant ErrorId:=SPLERR_BASE + 16#4054#;
PMERR_SPL_NOPATHBUFFER           :constant ErrorId:=SPLERR_BASE + 16#4055#;
PMERR_SPL_ALREADY_INITIALISED    :constant ErrorId:=SPLERR_BASE + 16#4093#;
PMERR_SPL_ERROR                  :constant ErrorId:=SPLERR_BASE + 16#4095#;

NERR_BASE       :constant ErrorId:=2100;
NERR_NetNotStarted      :constant ErrorId:=NERR_BASE+2;   -- The NETWKSTA.SYS workstation driver isn't installed.
NERR_RedirectedPath     :constant ErrorId:=NERR_BASE+17;  -- The operation is invalid on a redirected resource.
NERR_BufTooSmall        :constant ErrorId:=NERR_BASE+23;  -- The API return buffer is too small.
NERR_InvalidAPI         :constant ErrorId:=NERR_BASE+42;  -- The requested API isn't supported on the remote server.
NERR_QNotFound          :constant ErrorId:=NERR_BASE+50;  -- The printer queue does not exist.
NERR_JobNotFound        :constant ErrorId:=NERR_BASE+51;  -- The print job does not exist.
NERR_DestNotFound       :constant ErrorId:=NERR_BASE+52;  -- The printer destination cannot be found.
NERR_DestExists         :constant ErrorId:=NERR_BASE+53;  -- The printer destination already exists.
NERR_QExists            :constant ErrorId:=NERR_BASE+54;  -- The printer queue already exists.
NERR_QNoRoom            :constant ErrorId:=NERR_BASE+55;  -- No more printer queues can be added.
NERR_JobNoRoom          :constant ErrorId:=NERR_BASE+56;  -- No more print jobs can be added.
NERR_DestNoRoom         :constant ErrorId:=NERR_BASE+57;  -- No more printer destinations can be added.
NERR_DestIdle           :constant ErrorId:=NERR_BASE+58;  -- This printer destination is idle and cannot accept control operations.
NERR_DestInvalidOp      :constant ErrorId:=NERR_BASE+59;  -- This printer destination request contains an invalid control function.
NERR_SpoolerNotLoaded   :constant ErrorId:=NERR_BASE+61;  -- The spooler is not running.
NERR_DestInvalidState   :constant ErrorId:=NERR_BASE+62;  -- This operation cannot be performed on the print destination in its current state.
NERR_JobInvalidState    :constant ErrorId:=NERR_BASE+64;  -- This operation cannot be performed on the print job in its current state.
NERR_SpoolNoMemory      :constant ErrorId:=NERR_BASE+65;  -- A spooler memory allocation failure occurred.
NERR_DriverNotFound     :constant ErrorId:=NERR_BASE+66;  -- The device driver does not exist.
NERR_DataTypeInvalid    :constant ErrorId:=NERR_BASE+67;  -- The datatype is not supported by the processor.
NERR_ProcNotFound       :constant ErrorId:=NERR_BASE+68;  -- The print processor is not installed.
NERR_BadDev             :constant ErrorId:=NERR_BASE+241; -- The requested device is invalid.
NERR_CommDevInUse       :constant ErrorId:=NERR_BASE+243; -- This device is already in use as a communications device.
NERR_InvalidComputer   :constant ErrorId:=NERR_BASE+251; -- This computername is invalid.
NERR_OpenFiles          :constant ErrorId:=NERR_BASE+301; -- There are open files on the connection.
NERR_LocalDrive         :constant ErrorId:=NERR_BASE+305; -- The drive letter is in use locally.

--                     Picture Utilities error codes

PMERR_INV_TYPE         :constant ErrorId:=16#5001#;
PMERR_INV_CONV         :constant ErrorId:=16#5002#;
PMERR_INV_SEGLEN       :constant ErrorId:=16#5003#;
PMERR_DUP_SEGNAME      :constant ErrorId:=16#5004#;
PMERR_INV_XFORM        :constant ErrorId:=16#5005#;
PMERR_INV_VIEWLIM      :constant ErrorId:=16#5006#;
PMERR_INV_3DCOORD      :constant ErrorId:=16#5007#;
PMERR_SMB_OVFLOW       :constant ErrorId:=16#5008#;
PMERR_SEG_OVFLOW       :constant ErrorId:=16#5009#;
PMERR_PIC_DUP_FILENAME :constant ErrorId:=16#5010#;

--       numbers from 5100  to 5fff are reserved.

end Os2.PMer;
