/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.impl.core.layers.layer3.engine.Dummy;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.xml.tool.XMLGenerator;
import org.neodatis.odb.xml.tool.XMLNode;
import org.neodatis.tool.ILogger;

public class XMLExporter {
    private IStorageEngine storageEngine;
    private ILogger externalLogger;

    public XMLExporter(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
    }

    public XMLExporter(ODB odb) {
        this.storageEngine = Dummy.getEngine(odb);
    }

    public void export(String directory, String filename) throws Exception {
        if (!this.storageEngine.isLocal()) {
            throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("Export in Client Server mode"));
        }
        String baseName = this.storageEngine.getBaseIdentification().getIdentification();
        String completeFileName = directory + "/" + filename;
        XMLGenerator.setIncrementalWriteOn(completeFileName);
        this.info("Exporting database ODB database " + baseName + " to " + completeFileName);
        XMLNode root = XMLGenerator.createRoot("odb");
        root.addAttribute("name", this.format(baseName));
        root.addAttribute("export-date-time", this.format(new Date()));
        root.addAttribute("max-oid", String.valueOf(this.storageEngine.getMaxOid().getObjectId()));
        root.addAttribute("file-format-version", String.valueOf(9));
        root.endHeader();
        this.buildMetaModelXml(root);
        this.buildObjectsXml(root);
        root.end();
        XMLGenerator.close();
        this.info("End of Export");
    }

    private void buildObjectsXml(XMLNode root) throws Exception {
        XMLNode objectsXml = root.createNode("objects");
        objectsXml.endHeader();
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        this.info("Exporting Objects of " + metaModel.getNumberOfUserClasses() + " classes");
        for (ClassInfo ci : metaModel.getUserClasses()) {
            this.buildObjectsOfClassXml(objectsXml, ci);
        }
        objectsXml.end();
        this.info("Exporting Objects done.");
    }

    private void buildObjectsOfClassXml(XMLNode objectsXml, ClassInfo ci) throws Exception {
        this.info(". Exporting Objects of " + ci.getFullClassName() + " (" + ci.getNumberOfObjects() + ")");
        Objects objects = this.storageEngine.getObjectInfos(new CriteriaQuery(ci.getFullClassName()), false, -1, -1, false);
        int i = 0;
        while (objects.hasNext()) {
            Object o = objects.next();
            AbstractObjectInfo aoi = (AbstractObjectInfo)o;
            this.buildOneObjectXml(objectsXml, ci, (NonNativeObjectInfo)aoi);
            if (++i % 10000 != 0) continue;
            this.info(". " + i + " objects");
        }
        this.info(". Done." + i + " objects");
        objects.clear();
        objects = null;
        this.storageEngine.getSession(true).clearCache();
    }

    private void buildOneObjectXml(XMLNode node, ClassInfo ci, NonNativeObjectInfo nnoi) throws UnsupportedEncodingException {
        XMLNode objectXml = node.createNode("object");
        objectXml.addAttribute("oid", String.valueOf(nnoi.getOid()));
        objectXml.addAttribute("class-id", String.valueOf(ci.getId()));
        objectXml.endHeader();
        int attributeId = -1;
        AbstractObjectInfo aoi = null;
        int maxId = ci.getMaxAttributeId();
        for (int id = 1; id <= maxId; ++id) {
            XMLNode attributeXml = objectXml.createNode("attribute");
            ClassAttributeInfo cai = ci.getAttributeInfoFromId(id);
            if (cai == null) continue;
            attributeId = cai.getId();
            aoi = nnoi.getAttributeValueFromId(attributeId);
            attributeXml.addAttribute("id", String.valueOf(id));
            attributeXml.addAttribute("name", cai.getName());
            if (aoi.isNative()) {
                if (aoi.isNull()) {
                    attributeXml.addAttribute("is-null", "true");
                } else if (cai.getAttributeType().isCollection()) {
                    CollectionObjectInfo coi = (CollectionObjectInfo)aoi;
                    attributeXml.addAttribute("type", "collection");
                    attributeXml.endHeader();
                    this.buildListXml(attributeXml, coi);
                } else if (cai.getAttributeType().isMap()) {
                    MapObjectInfo moi = (MapObjectInfo)aoi;
                    attributeXml.addAttribute("type", "map");
                    attributeXml.endHeader();
                    this.buildMapXml(attributeXml, moi);
                } else if (cai.getAttributeType().isArray()) {
                    ArrayObjectInfo aroi = (ArrayObjectInfo)aoi;
                    attributeXml.addAttribute("type", "array");
                    attributeXml.endHeader();
                    this.buildArrayXml(attributeXml, aroi);
                } else if (nnoi.getAttributeValueFromId(id) != null) {
                    attributeXml.addAttribute("value", this.format(aoi));
                } else {
                    attributeXml.addAttribute("is-null", "true");
                }
            } else if (nnoi.getAttributeValueFromId(id) instanceof NonNativeNullObjectInfo) {
                attributeXml.addAttribute("is-null", "true");
            } else if (nnoi.getAttributeValueFromId(id).isDeletedObject()) {
                attributeXml.addAttribute("is-deleted", "true");
            } else {
                attributeXml.addAttribute("ref-oid", String.valueOf(((NonNativeObjectInfo)aoi).getOid()));
            }
            attributeXml.end();
        }
        objectXml.end();
    }

    private String format(Object object) throws UnsupportedEncodingException {
        if (object instanceof Date) {
            Date date = (Date)object;
            return String.valueOf(date.getTime());
        }
        if (object instanceof AtomicNativeObjectInfo) {
            AtomicNativeObjectInfo an = (AtomicNativeObjectInfo)object;
            if (an.getObject() instanceof Date) {
                Date date = (Date)an.getObject();
                return String.valueOf(date.getTime());
            }
            if (an.getObject() instanceof String) {
                String s = (String)an.getObject();
                String encoding = OdbConfiguration.getDatabaseCharacterEncoding();
                if (encoding == null || encoding.equals("no-encoding")) {
                    return URLEncoder.encode(s);
                }
                return URLEncoder.encode(s, encoding);
            }
        }
        return URLEncoder.encode(object.toString());
    }

    private void buildListXml(XMLNode node, CollectionObjectInfo coi) {
        if (coi.isNull()) {
            node.createNode("null-collection").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("collection");
        listXml.addAttribute("native-class-name", coi.getRealCollectionClassName());
        listXml.addAttribute("size", "" + coi.getCollection().size());
        listXml.endHeader();
        for (AbstractObjectInfo aoi : coi.getCollection()) {
            element = listXml.createNode("element");
            if (aoi.isNative()) {
                NativeObjectInfo noi = (NativeObjectInfo)aoi;
                element.addAttribute("value", String.valueOf(noi.getObject()));
                element.addAttribute("type", ODBType.getNameFromId(aoi.getOdbTypeId()));
            } else {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildArrayXml(XMLNode node, ArrayObjectInfo aoi) throws UnsupportedEncodingException {
        if (aoi.isNull()) {
            node.createNode("null-array").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("array");
        listXml.addAttribute("array-of", aoi.getRealArrayComponentClassName());
        listXml.addAttribute("size", "" + aoi.getArrayLength());
        listXml.endHeader();
        for (int i = 0; i < aoi.getArrayLength(); ++i) {
            AbstractObjectInfo aboi = (AbstractObjectInfo)aoi.getArray()[i];
            element = listXml.createNode("element");
            if (aboi.isNative()) {
                if (aboi.isNull()) {
                    element.addAttribute("is-null", "true");
                } else {
                    NativeObjectInfo noi = (NativeObjectInfo)aboi;
                    element.addAttribute("value", this.format(noi.getObject().toString()));
                }
            } else if (aboi.isNull()) {
                element.addAttribute("is-null", "true");
            } else {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aboi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildMapXml(XMLNode node, MapObjectInfo moi) throws UnsupportedEncodingException {
        if (moi.isNull()) {
            node.createNode("null-map").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("map");
        listXml.addAttribute("native-class-name", moi.getRealMapClassName());
        listXml.addAttribute("size", "" + moi.getMap().size());
        listXml.endHeader();
        Iterator<AbstractObjectInfo> iterator = moi.getMap().keySet().iterator();
        while (iterator.hasNext()) {
            NonNativeObjectInfo nnoi;
            NativeObjectInfo noi;
            AbstractObjectInfo o;
            AbstractObjectInfo aoi = o = iterator.next();
            element = listXml.createNode("element");
            if (aoi.isNative()) {
                noi = (NativeObjectInfo)aoi;
                element.addAttribute("key", this.format(String.valueOf(noi.getObject())));
                element.addAttribute("key-type", ODBType.getNameFromId(aoi.getOdbTypeId()));
                if (noi.isEnumObject()) {
                    EnumNativeObjectInfo enoi = (EnumNativeObjectInfo)noi;
                    element.addAttribute("enum-class-oid", String.valueOf(enoi.getEnumClassInfo().getId().getObjectId()));
                }
            } else {
                nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("key-id", String.valueOf(nnoi.getOid()));
            }
            aoi = moi.getMap().get(aoi);
            if (aoi.isNative()) {
                noi = (NativeObjectInfo)aoi;
                element.addAttribute("value", this.format(String.valueOf(noi.getObject())));
                element.addAttribute("value-type", ODBType.getNameFromId(aoi.getOdbTypeId()));
            } else {
                nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildMetaModelXml(XMLNode root) throws Exception {
        XMLNode metaModelXml = root.createNode("meta-model");
        metaModelXml.endHeader();
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        this.info("Exporting MetaModel : " + metaModel.getNumberOfClasses() + " classes");
        for (ClassInfo ci : metaModel.getAllClasses()) {
            this.buildClassInfoXml(metaModelXml, ci);
        }
        this.info("Exporting MetaModel done");
    }

    private void buildClassInfoXml(XMLNode node, ClassInfo ci) {
        XMLNode classXml = node.createNode("class");
        classXml.addAttribute("id", String.valueOf(ci.getId()));
        classXml.addAttribute("name", ci.getFullClassName());
        classXml.endHeader();
        this.info(". Class " + ci.getFullClassName());
        for (int i = 0; i < ci.getAttributes().size(); ++i) {
            ClassAttributeInfo cai = ci.getAttributeInfo(i);
            this.buildClassAttributeXml(classXml, cai, i + 1);
        }
        classXml.end();
    }

    private void buildClassAttributeXml(XMLNode node, ClassAttributeInfo cai, int index) {
        XMLNode classAttributeXml = node.createNode("attribute");
        classAttributeXml.addAttribute("id", String.valueOf(cai.getId()));
        classAttributeXml.addAttribute("name", cai.getName());
        classAttributeXml.addAttribute("type", cai.getAttributeType().getName());
        if (cai.getAttributeType().isArray()) {
            classAttributeXml.addAttribute("array-of", cai.getAttributeType().getSubType().getName());
        }
        if (cai.getAttributeType().isEnum()) {
            classAttributeXml.addAttribute("is-enum", "true");
        }
        classAttributeXml.end();
    }

    public void setExternalLogger(ILogger logger) {
        this.externalLogger = logger;
    }

    protected void info(Object o) {
        if (this.externalLogger != null) {
            this.externalLogger.info(o);
        }
    }
}

