/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.main;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.ClassRepresentation;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBExt;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.mutex.Mutex;
import org.neodatis.tool.mutex.MutexFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSafeLocalODB
implements ODB {
    protected ODB localOdb;
    protected static final String THREAD_MUTEX_PREFIX = "thread-safe-mutex-";
    protected Mutex mutex;
    private Map<String, Boolean> holdsTheMutex;
    protected boolean multiThreadExclusive;

    public ThreadSafeLocalODB(ODB odb) {
        this.localOdb = odb;
        this.mutex = MutexFactory.get(THREAD_MUTEX_PREFIX + odb.getName());
        this.holdsTheMutex = new HashMap<String, Boolean>();
        this.multiThreadExclusive = OdbConfiguration.multiThreadExclusive();
    }

    public ODB getNonThreadSafeOdb() {
        return this.localOdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean holdsTheMutex(String threadName) {
        Map<String, Boolean> map = this.holdsTheMutex;
        synchronized (map) {
            Boolean b = this.holdsTheMutex.get(threadName);
            if (b == null) {
                return false;
            }
            return b;
        }
    }

    protected void acquireMutex() {
        String threadName = Thread.currentThread().getName();
        if (this.holdsTheMutex(threadName)) {
            return;
        }
        Boolean b = null;
        try {
            b = this.mutex.attempt(OdbConfiguration.getTimeoutToAcquireMutexInMultiThread());
            this.holdsTheMutex.put(threadName, b);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_ACQUIRING_MUTEX.addParameter(THREAD_MUTEX_PREFIX + this.localOdb.getName()), (Throwable)e);
        }
        if (!b.booleanValue()) {
            e = new Exception("Timeout acquiring mutex ");
            e.printStackTrace();
            throw new ODBRuntimeException(NeoDatisError.TIMEOUT_WHILE_ACQUIRING_MUTEX.addParameter(THREAD_MUTEX_PREFIX + this.localOdb.getName()), (Throwable)e);
        }
    }

    protected void releaseMutex() {
        String threadName = Thread.currentThread().getName();
        if (this.holdsTheMutex(threadName)) {
            this.mutex.release(this.localOdb.getName());
            this.holdsTheMutex.put(threadName, Boolean.FALSE);
        }
    }

    @Override
    public void addDeleteTrigger(Class clazz, DeleteTrigger trigger) {
        this.acquireMutex();
        this.localOdb.addDeleteTrigger(clazz, trigger);
    }

    @Override
    public void addInsertTrigger(Class clazz, InsertTrigger trigger) {
        this.acquireMutex();
        this.localOdb.addInsertTrigger(clazz, trigger);
    }

    @Override
    public void addSelectTrigger(Class clazz, SelectTrigger trigger) {
        this.acquireMutex();
        this.localOdb.addSelectTrigger(clazz, trigger);
    }

    @Override
    public void addUpdateTrigger(Class clazz, UpdateTrigger trigger) {
        this.acquireMutex();
        this.localOdb.addUpdateTrigger(clazz, trigger);
    }

    @Override
    public void close() {
        this.acquireMutex();
        this.localOdb.close();
        this.releaseMutex();
    }

    @Override
    public void commit() {
        this.acquireMutex();
        this.localOdb.commit();
        this.releaseMutex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger count(CriteriaQuery query) {
        try {
            this.acquireMutex();
            BigInteger bigInteger = this.localOdb.count(query);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return bigInteger;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CriteriaQuery criteriaQuery(Class clazz, ICriterion criterio) {
        try {
            this.acquireMutex();
            CriteriaQuery criteriaQuery = this.localOdb.criteriaQuery(clazz, criterio);
            Object var5_4 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return criteriaQuery;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CriteriaQuery criteriaQuery(Class clazz) {
        try {
            this.acquireMutex();
            CriteriaQuery criteriaQuery = this.localOdb.criteriaQuery(clazz);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return criteriaQuery;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    @Override
    public void defragmentTo(String newFileName) {
        this.acquireMutex();
        this.localOdb.defragmentTo(newFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OID delete(Object object) {
        try {
            this.acquireMutex();
            OID oID = this.localOdb.delete(object);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return oID;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OID deleteCascade(Object object) {
        try {
            this.acquireMutex();
            OID oID = this.localOdb.deleteCascade(object);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return oID;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectWithId(OID oid) {
        try {
            this.acquireMutex();
            this.localOdb.deleteObjectWithId(oid);
            Object var3_2 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    @Override
    public void disconnect(Object object) {
        this.acquireMutex();
        this.localOdb.disconnect(object);
    }

    @Override
    public ODBExt ext() {
        this.acquireMutex();
        return this.localOdb.ext();
    }

    @Override
    public ClassRepresentation getClassRepresentation(Class clazz) {
        this.acquireMutex();
        return this.localOdb.getClassRepresentation(clazz);
    }

    @Override
    public ClassRepresentation getClassRepresentation(String fullClassName) {
        this.acquireMutex();
        return this.localOdb.getClassRepresentation(fullClassName);
    }

    @Override
    public ClassRepresentation getClassRepresentation(String fullClassName, boolean laodClass) {
        this.acquireMutex();
        return this.localOdb.getClassRepresentation(fullClassName, laodClass);
    }

    @Override
    public String getName() {
        return this.localOdb.getName();
    }

    @Override
    public Object getObjectFromId(OID id) {
        this.acquireMutex();
        return this.localOdb.getObjectFromId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OID getObjectId(Object object) {
        try {
            this.acquireMutex();
            OID oID = this.localOdb.getObjectId(object);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return oID;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(clazz, inMemory, startIndex, endIndex);
            Object var7_6 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(clazz, inMemory);
            Object var5_4 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(Class clazz) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(clazz);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(query, inMemory, startIndex, endIndex);
            Object var7_6 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(query, inMemory);
            Object var5_4 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> getObjects(IQuery query) {
        try {
            this.acquireMutex();
            Objects objects = this.localOdb.getObjects(query);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return objects;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    @Override
    public IRefactorManager getRefactorManager() {
        this.acquireMutex();
        return this.localOdb.getRefactorManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Values getValues(IValuesQuery query) {
        try {
            this.acquireMutex();
            Values values = this.localOdb.getValues(query);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return values;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }

    @Override
    public boolean isClosed() {
        return this.localOdb.isClosed();
    }

    @Override
    public void reconnect(Object object) {
        this.acquireMutex();
        this.localOdb.reconnect(object);
    }

    @Override
    public void rollback() {
        this.acquireMutex();
        this.localOdb.rollback();
        this.releaseMutex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OID store(Object object) {
        try {
            this.acquireMutex();
            OID oID = this.localOdb.store(object);
            Object var4_3 = null;
            if (!this.multiThreadExclusive) {
                this.releaseMutex();
            }
            return oID;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (this.multiThreadExclusive) break block3;
                this.releaseMutex();
            }
            throw throwable;
        }
    }
}

